/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.coordination.BatchOutputCollectorImpl;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.task.IOutputCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.ReportedFailedException;
import org.apache.storm.trident.spout.IBatchID;
import org.apache.storm.trident.topology.BatchInfo;
import org.apache.storm.trident.topology.ITridentBatchBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.TupleUtils;
import org.apache.storm.utils.Utils;

public class TridentBoltExecutor
implements IRichBolt {
    public static final String COORD_STREAM_PREFIX = "$coord-";
    Map<GlobalStreamId, String> batchGroupIds;
    Map<String, CoordSpec> coordSpecs;
    Map<String, CoordCondition> coordConditions;
    ITridentBatchBolt bolt;
    long messageTimeoutMs;
    long lastRotate;
    RotatingMap<Object, TrackedBatch> batches;
    OutputCollector collector;
    CoordinatedOutputCollector coordCollector;
    BatchOutputCollector coordOutputCollector;
    TopologyContext context;

    public TridentBoltExecutor(ITridentBatchBolt bolt, Map<GlobalStreamId, String> batchGroupIds, Map<String, CoordSpec> coordinationSpecs) {
        this.batchGroupIds = batchGroupIds;
        this.coordSpecs = coordinationSpecs;
        this.bolt = bolt;
    }

    public static String coordStream(String batch) {
        return COORD_STREAM_PREFIX + batch;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, OutputCollector collector) {
        this.messageTimeoutMs = (long)context.maxTopologyMessageTimeout() * 1000L;
        this.lastRotate = System.currentTimeMillis();
        this.batches = new RotatingMap(2);
        this.context = context;
        this.collector = collector;
        this.coordCollector = new CoordinatedOutputCollector(collector);
        this.coordOutputCollector = new BatchOutputCollectorImpl(new OutputCollector(this.coordCollector));
        this.coordConditions = (Map)context.getExecutorData("__coordConditions");
        if (this.coordConditions == null) {
            this.coordConditions = new HashMap<String, CoordCondition>();
            for (String batchGroup : this.coordSpecs.keySet()) {
                CoordSpec spec = this.coordSpecs.get(batchGroup);
                CoordCondition cond = new CoordCondition();
                cond.commitStream = spec.commitStream;
                cond.expectedTaskReports = 0;
                for (String comp : spec.coords.keySet()) {
                    CoordType ct = spec.coords.get(comp);
                    if (ct.equals(CoordType.single())) {
                        ++cond.expectedTaskReports;
                        continue;
                    }
                    cond.expectedTaskReports += context.getComponentTasks(comp).size();
                }
                cond.targetTasks = new HashSet<Integer>();
                for (String component : ((Map)Utils.get(context.getThisTargets(), TridentBoltExecutor.coordStream(batchGroup), new HashMap())).keySet()) {
                    cond.targetTasks.addAll(context.getComponentTasks(component));
                }
                this.coordConditions.put(batchGroup, cond);
            }
            context.setExecutorData("coordConditions", this.coordConditions);
        }
        this.bolt.prepare(conf, context, this.coordOutputCollector);
    }

    private void failBatch(TrackedBatch tracked, FailedException e) {
        if (e != null && e instanceof ReportedFailedException) {
            this.collector.reportError(e);
        }
        tracked.failed = true;
        if (tracked.delayedAck != null) {
            this.collector.fail(tracked.delayedAck);
            tracked.delayedAck = null;
        }
    }

    private void failBatch(TrackedBatch tracked) {
        this.failBatch(tracked, null);
    }

    private boolean finishBatch(TrackedBatch tracked, Tuple finishTuple) {
        boolean success = true;
        try {
            this.bolt.finishBatch(tracked.info);
            String stream = TridentBoltExecutor.coordStream(tracked.info.batchGroup);
            for (Integer task : tracked.condition.targetTasks) {
                this.collector.emitDirect((int)task, stream, finishTuple, (List<Object>)new Values(tracked.info.batchId, Utils.get(tracked.taskEmittedTuples, task, 0)));
            }
            if (tracked.delayedAck != null) {
                this.collector.ack(tracked.delayedAck);
                tracked.delayedAck = null;
            }
        }
        catch (FailedException e) {
            this.failBatch(tracked, e);
            success = false;
        }
        this.batches.remove(tracked.info.batchId.getId());
        return success;
    }

    private void checkFinish(TrackedBatch tracked, Tuple tuple, TupleType type) {
        boolean delayed;
        if (tracked.failed) {
            this.failBatch(tracked);
            this.collector.fail(tuple);
            return;
        }
        CoordCondition cond = tracked.condition;
        boolean bl = delayed = tracked.delayedAck == null && (cond.commitStream != null && type == TupleType.COMMIT || cond.commitStream == null);
        if (delayed) {
            tracked.delayedAck = tuple;
        }
        boolean failed = false;
        if (tracked.receivedCommit && tracked.reportedTasks == cond.expectedTaskReports) {
            if (tracked.receivedTuples == tracked.expectedTupleCount) {
                this.finishBatch(tracked, tuple);
            } else {
                this.failBatch(tracked);
                this.collector.fail(tuple);
                failed = true;
            }
        }
        if (!delayed && !failed) {
            this.collector.ack(tuple);
        }
    }

    @Override
    public void execute(Tuple tuple) {
        if (TupleUtils.isTick(tuple)) {
            long now = System.currentTimeMillis();
            if (now - this.lastRotate > this.messageTimeoutMs) {
                this.batches.rotate();
                this.lastRotate = now;
            }
            return;
        }
        String batchGroup = this.batchGroupIds.get(tuple.getSourceGlobalStreamId());
        if (batchGroup == null) {
            this.coordCollector.setCurrBatch(null);
            this.bolt.execute(null, tuple);
            this.collector.ack(tuple);
            return;
        }
        IBatchID id = (IBatchID)tuple.getValue(0);
        TrackedBatch tracked = this.batches.get(id.getId());
        if (tracked != null) {
            if (id.getAttemptId() > tracked.attemptId) {
                this.batches.remove(id.getId());
                tracked = null;
            } else if (id.getAttemptId() < tracked.attemptId) {
                return;
            }
        }
        if (tracked == null) {
            tracked = new TrackedBatch(new BatchInfo(batchGroup, id, this.bolt.initBatchState(batchGroup, id)), this.coordConditions.get(batchGroup), id.getAttemptId());
            this.batches.put(id.getId(), tracked);
        }
        this.coordCollector.setCurrBatch(tracked);
        TupleType t = this.getTupleType(tuple, tracked);
        if (t == TupleType.COMMIT) {
            tracked.receivedCommit = true;
            this.checkFinish(tracked, tuple, t);
        } else if (t == TupleType.COORD) {
            int count = tuple.getInteger(1);
            ++tracked.reportedTasks;
            tracked.expectedTupleCount += count;
            this.checkFinish(tracked, tuple, t);
        } else {
            ++tracked.receivedTuples;
            boolean success = true;
            try {
                this.bolt.execute(tracked.info, tuple);
                if (tracked.condition.expectedTaskReports == 0) {
                    success = this.finishBatch(tracked, tuple);
                }
            }
            catch (FailedException e) {
                this.failBatch(tracked, e);
            }
            if (success) {
                this.collector.ack(tuple);
            } else {
                this.collector.fail(tuple);
            }
        }
        this.coordCollector.setCurrBatch(null);
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.bolt.declareOutputFields(declarer);
        for (String batchGroup : this.coordSpecs.keySet()) {
            declarer.declareStream(TridentBoltExecutor.coordStream(batchGroup), true, new Fields("id", "count"));
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Map<String, Object> ret = this.bolt.getComponentConfiguration();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        ret.put("topology.tick.tuple.freq.secs", 5);
        return ret;
    }

    private TupleType getTupleType(Tuple tuple, TrackedBatch batch) {
        CoordCondition cond = batch.condition;
        if (cond.commitStream != null && tuple.getSourceGlobalStreamId().equals(cond.commitStream)) {
            return TupleType.COMMIT;
        }
        if (cond.expectedTaskReports > 0 && tuple.getSourceStreamId().startsWith(COORD_STREAM_PREFIX)) {
            return TupleType.COORD;
        }
        return TupleType.REGULAR;
    }

    private static class CoordinatedOutputCollector
    implements IOutputCollector {
        IOutputCollector delegate;
        TrackedBatch currBatch = null;

        public CoordinatedOutputCollector(IOutputCollector delegate) {
            this.delegate = delegate;
        }

        public void setCurrBatch(TrackedBatch batch) {
            this.currBatch = batch;
        }

        @Override
        public List<Integer> emit(String stream, Collection<Tuple> anchors, List<Object> tuple) {
            List<Integer> tasks = this.delegate.emit(stream, anchors, tuple);
            this.updateTaskCounts(tasks);
            return tasks;
        }

        @Override
        public void emitDirect(int task, String stream, Collection<Tuple> anchors, List<Object> tuple) {
            this.updateTaskCounts(Arrays.asList(task));
            this.delegate.emitDirect(task, stream, anchors, tuple);
        }

        @Override
        public void ack(Tuple tuple) {
            throw new IllegalStateException("Method should never be called");
        }

        @Override
        public void fail(Tuple tuple) {
            throw new IllegalStateException("Method should never be called");
        }

        @Override
        public void resetTimeout(Tuple tuple) {
            throw new IllegalStateException("Method should never be called");
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }

        @Override
        public void reportError(Throwable error) {
            this.delegate.reportError(error);
        }

        private void updateTaskCounts(List<Integer> tasks) {
            if (this.currBatch != null) {
                Map<Integer, Integer> taskEmittedTuples = this.currBatch.taskEmittedTuples;
                for (Integer task : tasks) {
                    int newCount = Utils.get(taskEmittedTuples, task, 0) + 1;
                    taskEmittedTuples.put(task, newCount);
                }
            }
        }
    }

    public static class TrackedBatch {
        int attemptId;
        BatchInfo info;
        CoordCondition condition;
        int reportedTasks = 0;
        int expectedTupleCount = 0;
        int receivedTuples = 0;
        Map<Integer, Integer> taskEmittedTuples = new HashMap<Integer, Integer>();
        boolean failed = false;
        boolean receivedCommit;
        Tuple delayedAck = null;

        public TrackedBatch(BatchInfo info, CoordCondition condition, int attemptId) {
            this.info = info;
            this.condition = condition;
            this.attemptId = attemptId;
            this.receivedCommit = condition.commitStream == null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class CoordCondition
    implements Serializable {
        public GlobalStreamId commitStream;
        public int expectedTaskReports;
        Set<Integer> targetTasks;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class CoordSpec
    implements Serializable {
        public GlobalStreamId commitStream = null;
        public Map<String, CoordType> coords = new HashMap<String, CoordType>();
    }

    public static class CoordType
    implements Serializable {
        public boolean singleCount;

        protected CoordType(boolean singleCount) {
            this.singleCount = singleCount;
        }

        public static CoordType single() {
            return new CoordType(true);
        }

        public static CoordType all() {
            return new CoordType(false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CoordType)) {
                return false;
            }
            CoordType coordType = (CoordType)o;
            return this.singleCount == coordType.singleCount;
        }

        public int hashCode() {
            return this.singleCount ? 1 : 0;
        }

        public String toString() {
            return "<Single: " + this.singleCount + ">";
        }
    }

    static enum TupleType {
        REGULAR,
        COMMIT,
        COORD;

    }
}

