/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.ICommitterTridentSpout;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.BatchInfo;
import org.apache.storm.trident.topology.ITridentBatchBolt;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.tuple.ConsList;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentSpoutExecutor
implements ITridentBatchBolt {
    public static final String ID_FIELD = "$tx";
    public static final Logger LOG = LoggerFactory.getLogger(TridentSpoutExecutor.class);
    AddIdCollector collector;
    ITridentSpout<Object> spout;
    ITridentSpout.Emitter<Object> emitter;
    String streamName;
    String txStateId;
    TreeMap<Long, TransactionAttempt> activeBatches = new TreeMap();

    public TridentSpoutExecutor(String txStateId, String streamName, ITridentSpout<Object> spout) {
        this.txStateId = txStateId;
        this.spout = spout;
        this.streamName = streamName;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, BatchOutputCollector collector) {
        this.emitter = this.spout.getEmitter(this.txStateId, conf, context);
        this.collector = new AddIdCollector(this.streamName, collector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(BatchInfo info, Tuple input) {
        TransactionAttempt attempt = (TransactionAttempt)input.getValue(0);
        if (input.getSourceStreamId().equals("$commit")) {
            if (!attempt.equals(this.activeBatches.get(attempt.getTransactionId()))) throw new FailedException("Received commit for different transaction attempt");
            ((ICommitterTridentSpout.Emitter)this.emitter).commit(attempt);
            this.activeBatches.remove(attempt.getTransactionId());
            return;
        } else if (input.getSourceStreamId().equals("$success")) {
            this.activeBatches.headMap(attempt.getTransactionId()).clear();
            this.emitter.success(attempt);
            return;
        } else {
            this.collector.setBatch(info.batchId);
            this.emitter.emitBatch(attempt, input.getValue(1), this.collector);
            this.activeBatches.put(attempt.getTransactionId(), attempt);
        }
    }

    @Override
    public void cleanup() {
        this.emitter.close();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        ArrayList<String> fields = new ArrayList<String>(this.spout.getOutputFields().toList());
        fields.add(0, ID_FIELD);
        declarer.declareStream(this.streamName, new Fields(fields));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.spout.getComponentConfiguration();
    }

    @Override
    public void finishBatch(BatchInfo batchInfo) {
    }

    @Override
    public Object initBatchState(String batchGroup, Object batchId) {
        return null;
    }

    private static class AddIdCollector
    implements TridentCollector {
        BatchOutputCollector delegate;
        Object id;
        String stream;

        public AddIdCollector(String stream, BatchOutputCollector c) {
            this.delegate = c;
            this.stream = stream;
        }

        public void setBatch(Object id) {
            this.id = id;
        }

        @Override
        public void emit(List<Object> values) {
            this.delegate.emit(this.stream, new ConsList(this.id, values));
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }

        @Override
        public void reportError(Throwable t) {
            this.delegate.reportError(t);
        }
    }
}

