/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.utils.RegisteredGlobalState;

public class SpoutTracker
extends BaseRichSpout {
    IRichSpout delegate;
    SpoutTrackOutputCollector tracker;
    String trackId;

    public SpoutTracker(IRichSpout delegate, String trackId) {
        this.delegate = delegate;
        this.trackId = trackId;
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this.tracker = new SpoutTrackOutputCollector(collector);
        this.delegate.open(conf, context, new SpoutOutputCollector(this.tracker));
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void nextTuple() {
        this.delegate.nextTuple();
    }

    @Override
    public void ack(Object msgId) {
        this.delegate.ack(msgId);
        Map stats = (Map)RegisteredGlobalState.getState(this.trackId);
        ((AtomicInteger)stats.get("processed")).incrementAndGet();
    }

    @Override
    public void fail(Object msgId) {
        this.delegate.fail(msgId);
        Map stats = (Map)RegisteredGlobalState.getState(this.trackId);
        ((AtomicInteger)stats.get("processed")).incrementAndGet();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    private class SpoutTrackOutputCollector
    implements ISpoutOutputCollector {
        public int transferred = 0;
        public int emitted = 0;
        public SpoutOutputCollector collector;

        public SpoutTrackOutputCollector(SpoutOutputCollector collector) {
            this.collector = collector;
        }

        private void recordSpoutEmit() {
            Map stats = (Map)RegisteredGlobalState.getState(SpoutTracker.this.trackId);
            ((AtomicInteger)stats.get("spout-emitted")).incrementAndGet();
        }

        @Override
        public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
            List<Integer> ret = this.collector.emit(streamId, tuple, messageId);
            this.recordSpoutEmit();
            return ret;
        }

        @Override
        public void emitDirect(int taskId, String streamId, List<Object> tuple, Object messageId) {
            this.collector.emitDirect(taskId, streamId, tuple, messageId);
            this.recordSpoutEmit();
        }

        @Override
        public void flush() {
            this.collector.flush();
        }

        @Override
        public void reportError(Throwable error) {
            this.collector.reportError(error);
        }

        @Override
        public long getPendingCount() {
            return this.collector.getPendingCount();
        }
    }
}

