/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.Fields;

public class WorkerTopologyContext
extends GeneralTopologyContext {
    public static final String SHARED_EXECUTOR = "executor";
    Map<String, Object> userResources;
    Map<String, Object> defaultResources;
    private Integer workerPort;
    private List<Integer> workerTasks;
    private String codeDir;
    private String pidDir;
    private AtomicReference<Map<Integer, NodeInfo>> taskToNodePort;
    private String assignmentId;

    public WorkerTopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources, AtomicReference<Map<Integer, NodeInfo>> taskToNodePort, String assignmentId) {
        super(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId);
        this.codeDir = codeDir;
        this.defaultResources = defaultResources;
        this.userResources = userResources;
        try {
            this.pidDir = pidDir != null ? new File(pidDir).getCanonicalPath() : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get canonical path for " + this.pidDir, e);
        }
        this.workerPort = workerPort;
        this.workerTasks = workerTasks;
        this.taskToNodePort = taskToNodePort;
        this.assignmentId = assignmentId;
    }

    public WorkerTopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources) {
        this(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId, codeDir, pidDir, workerPort, workerTasks, defaultResources, userResources, null, null);
    }

    public List<Integer> getThisWorkerTasks() {
        return this.workerTasks;
    }

    public Integer getThisWorkerPort() {
        return this.workerPort;
    }

    public String getThisWorkerHost() {
        return this.assignmentId;
    }

    public AtomicReference<Map<Integer, NodeInfo>> getTaskToNodePort() {
        return this.taskToNodePort;
    }

    public String getCodeDir() {
        return this.codeDir;
    }

    public String getPIDDir() {
        return this.pidDir;
    }

    public Object getResource(String name) {
        return this.userResources.get(name);
    }

    public ExecutorService getSharedExecutor() {
        return (ExecutorService)this.defaultResources.get(SHARED_EXECUTOR);
    }
}

