/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.storm.annotation.InterfaceStability;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.storm.shade.com.google.common.collect.HashBasedTable;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.shade.com.google.common.collect.Table;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.EdgeFactory;
import org.apache.storm.shade.org.jgrapht.graph.DefaultDirectedGraph;
import org.apache.storm.shade.org.jgrapht.traverse.TopologicalOrderIterator;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.GroupingInfo;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.PairStream;
import org.apache.storm.streams.PartitionNode;
import org.apache.storm.streams.ProcessorBolt;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.SinkNode;
import org.apache.storm.streams.SpoutNode;
import org.apache.storm.streams.StatefulProcessorBolt;
import org.apache.storm.streams.Stream;
import org.apache.storm.streams.StreamBolt;
import org.apache.storm.streams.StreamUtil;
import org.apache.storm.streams.StreamsEdgeFactory;
import org.apache.storm.streams.UniqueIdGen;
import org.apache.storm.streams.WindowNode;
import org.apache.storm.streams.WindowedProcessorBolt;
import org.apache.storm.streams.operations.IdentityFunction;
import org.apache.storm.streams.operations.mappers.PairValueMapper;
import org.apache.storm.streams.operations.mappers.TupleValueMapper;
import org.apache.storm.streams.processors.MapProcessor;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.StateQueryProcessor;
import org.apache.storm.streams.processors.StatefulProcessor;
import org.apache.storm.streams.processors.UpdateStateByKeyProcessor;
import org.apache.storm.streams.windowing.Window;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IComponent;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class StreamBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StreamBuilder.class);
    private final DefaultDirectedGraph<Node, Edge> graph;
    private final Table<Node, String, GroupingInfo> nodeGroupingInfo = HashBasedTable.create();
    private final Map<Node, WindowNode> windowInfo = new HashMap<Node, WindowNode>();
    private final List<ProcessorNode> curGroup = new ArrayList<ProcessorNode>();
    private final Map<StreamBolt, BoltDeclarer> streamBolts = new HashMap<StreamBolt, BoltDeclarer>();
    private int statefulProcessorCount = 0;
    private String timestampFieldName = null;

    public StreamBuilder() {
        this.graph = new DefaultDirectedGraph((EdgeFactory)new StreamsEdgeFactory());
    }

    public Stream<Tuple> newStream(IRichSpout spout) {
        return this.newStream(spout, 1);
    }

    public Stream<Tuple> newStream(IRichSpout spout, int parallelism) {
        SpoutNode spoutNode = new SpoutNode(spout);
        String spoutId = UniqueIdGen.getInstance().getUniqueSpoutId();
        spoutNode.setComponentId(spoutId);
        spoutNode.setParallelism(parallelism);
        this.graph.addVertex((Object)spoutNode);
        return new Stream<Tuple>(this, spoutNode);
    }

    public <T> Stream<T> newStream(IRichSpout spout, TupleValueMapper<T> valueMapper) {
        return this.newStream(spout).map(valueMapper);
    }

    public <T> Stream<T> newStream(IRichSpout spout, TupleValueMapper<T> valueMapper, int parallelism) {
        return this.newStream(spout, parallelism).map(valueMapper);
    }

    public <K, V> PairStream<K, V> newStream(IRichSpout spout, PairValueMapper<K, V> pairValueMapper) {
        return this.newStream(spout).mapToPair(pairValueMapper);
    }

    public <K, V> PairStream<K, V> newStream(IRichSpout spout, PairValueMapper<K, V> pairValueMapper, int parallelism) {
        return this.newStream(spout, parallelism).mapToPair(pairValueMapper);
    }

    public StormTopology build() {
        this.nodeGroupingInfo.clear();
        this.windowInfo.clear();
        this.curGroup.clear();
        TopologicalOrderIterator iterator = new TopologicalOrderIterator(this.graph, this.queue());
        TopologyBuilder topologyBuilder = new TopologyBuilder();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node instanceof SpoutNode) {
                this.addSpout(topologyBuilder, (SpoutNode)node);
                continue;
            }
            if (node instanceof ProcessorNode) {
                this.handleProcessorNode((ProcessorNode)node, topologyBuilder);
                continue;
            }
            if (node instanceof PartitionNode) {
                this.updateNodeGroupingInfo((PartitionNode)node);
                this.processCurGroup(topologyBuilder);
                continue;
            }
            if (node instanceof WindowNode) {
                this.updateWindowInfo((WindowNode)node);
                this.processCurGroup(topologyBuilder);
                continue;
            }
            if (!(node instanceof SinkNode)) continue;
            this.processCurGroup(topologyBuilder);
            this.addSink(topologyBuilder, (SinkNode)node);
        }
        this.processCurGroup(topologyBuilder);
        this.mayBeAddTsField();
        return topologyBuilder.createTopology();
    }

    Node addNode(Node parent, Node child) {
        return this.addNode(parent, child, parent.getOutputStreams().iterator().next(), parent.getParallelism());
    }

    Node addNode(Node parent, Node child, int parallelism) {
        return this.addNode(parent, child, parent.getOutputStreams().iterator().next(), parallelism);
    }

    Node addNode(Node parent, Node child, String parentStreamId) {
        return this.addNode(parent, child, parentStreamId, parent.getParallelism());
    }

    Node addNode(Node parent, Node child, String parentStreamId, int parallelism) {
        this.graph.addVertex((Object)child);
        this.graph.addEdge((Object)parent, (Object)child);
        child.setParallelism(parallelism);
        if (parent instanceof WindowNode || parent instanceof PartitionNode) {
            child.addParentStream(this.parentNode(parent), parentStreamId);
        } else {
            child.addParentStream(parent, parentStreamId);
        }
        if (!(child instanceof PartitionNode)) {
            if (child.getGroupingInfo() != null) {
                if (!child.getGroupingInfo().equals(parent.getGroupingInfo())) {
                    throw new IllegalStateException("Trying to assign grouping info for node with current grouping info: " + child.getGroupingInfo() + " to: " + parent.getGroupingInfo() + " Node: " + child);
                }
            } else {
                child.setGroupingInfo(parent.getGroupingInfo());
            }
        }
        if (!(child instanceof WindowNode) && !child.isWindowed()) {
            child.setWindowed(parent.isWindowed());
        }
        return child;
    }

    Node insert(Node parent, Node child) {
        Node newChild = this.addNode(parent, child);
        for (Edge edge : this.graph.outgoingEdgesOf((Object)parent)) {
            Node oldChild = edge.getTarget();
            this.graph.removeEdge((Object)parent, (Object)oldChild);
            oldChild.removeParentStreams(parent);
            this.addNode(newChild, oldChild);
        }
        return newChild;
    }

    private PriorityQueue<Node> queue() {
        return new PriorityQueue<Node>(new Comparator<Node>(){
            Map<Class<?>, Integer> map = new HashMap();
            {
                this.map.put(SpoutNode.class, 0);
                this.map.put(UpdateStateByKeyProcessor.class, 1);
                this.map.put(ProcessorNode.class, 2);
                this.map.put(PartitionNode.class, 3);
                this.map.put(WindowNode.class, 4);
                this.map.put(StateQueryProcessor.class, 5);
                this.map.put(SinkNode.class, 6);
            }

            @Override
            public int compare(Node n1, Node n2) {
                return this.getPriority(n1) - this.getPriority(n2);
            }

            private int getPriority(Node node) {
                Processor<?> processor;
                Integer priority;
                if (node instanceof ProcessorNode && (priority = this.map.get((processor = ((ProcessorNode)node).getProcessor()).getClass())) != null) {
                    return priority;
                }
                priority = this.map.get(node.getClass());
                if (priority != null) {
                    return priority;
                }
                return Integer.MAX_VALUE;
            }
        });
    }

    private void handleProcessorNode(ProcessorNode processorNode, TopologyBuilder topologyBuilder) {
        if (processorNode.getProcessor() instanceof StatefulProcessor) {
            ++this.statefulProcessorCount;
            Set<ProcessorNode> initialNodes = this.initialProcessors(this.curGroup.isEmpty() ? Collections.singletonList(processorNode) : this.curGroup);
            Set<Window<?, ?>> windows = this.getWindowParams(initialNodes);
            if (this.statefulProcessorCount > 1 || !windows.isEmpty()) {
                if (!this.curGroup.isEmpty()) {
                    this.processCurGroup(topologyBuilder);
                } else if (!windows.isEmpty()) {
                    this.splitStatefulProcessor(processorNode, topologyBuilder);
                }
                this.statefulProcessorCount = 1;
            }
        }
        this.curGroup.add(processorNode);
    }

    private void splitStatefulProcessor(ProcessorNode processorNode, TopologyBuilder topologyBuilder) {
        for (Node parent : StreamUtil.getParents(this.graph, processorNode)) {
            ProcessorNode identity = new ProcessorNode(new MapProcessor(new IdentityFunction()), UniqueIdGen.getInstance().getUniqueStreamId(), parent.getOutputFields());
            this.addNode(parent, identity);
            this.graph.removeEdge((Object)parent, (Object)processorNode);
            processorNode.removeParentStreams(parent);
            this.addNode(identity, processorNode);
            this.curGroup.add(identity);
        }
        this.processCurGroup(topologyBuilder);
    }

    private void mayBeAddTsField() {
        if (this.timestampFieldName != null) {
            for (StreamBolt streamBolt : this.streamBolts.keySet()) {
                streamBolt.setTimestampField(this.timestampFieldName);
            }
        }
    }

    private void updateNodeGroupingInfo(PartitionNode partitionNode) {
        if (partitionNode.getGroupingInfo() != null) {
            for (Node parent : this.parentNodes(partitionNode)) {
                for (String parentStream : partitionNode.getParentStreams(parent)) {
                    this.nodeGroupingInfo.put((Object)parent, (Object)parentStream, (Object)partitionNode.getGroupingInfo());
                }
            }
        }
    }

    private void updateWindowInfo(WindowNode windowNode) {
        for (Node parent : this.parentNodes(windowNode)) {
            this.windowInfo.put(parent, windowNode);
        }
        String tsField = windowNode.getWindowParams().getTimestampField();
        if (tsField != null) {
            if (this.timestampFieldName != null && !tsField.equals(this.timestampFieldName)) {
                throw new IllegalArgumentException("Cannot set different timestamp field names");
            }
            this.timestampFieldName = tsField;
        }
    }

    Node parentNode(Node curNode) {
        Set<Node> parentNode = this.parentNodes(curNode);
        if (parentNode.size() > 1) {
            throw new IllegalArgumentException("Node " + curNode + " has more than one parent node.");
        }
        if (parentNode.isEmpty()) {
            throw new IllegalArgumentException("Node " + curNode + " has no parent.");
        }
        return parentNode.iterator().next();
    }

    private Set<Node> parentNodes(Node curNode) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Node parent : StreamUtil.getParents(this.graph, curNode)) {
            if (parent instanceof ProcessorNode || parent instanceof SpoutNode) {
                nodes.add(parent);
                continue;
            }
            nodes.addAll(this.parentNodes(parent));
        }
        return nodes;
    }

    private Collection<List<ProcessorNode>> parallelismGroups(List<ProcessorNode> processorNodes) {
        return processorNodes.stream().collect(Collectors.groupingBy(Node::getParallelism)).values();
    }

    private void processCurGroup(TopologyBuilder topologyBuilder) {
        if (!this.curGroup.isEmpty()) {
            this.parallelismGroups(this.curGroup).forEach(g -> this.doProcessCurGroup(topologyBuilder, (List<ProcessorNode>)g));
            this.curGroup.clear();
        }
    }

    private void doProcessCurGroup(TopologyBuilder topologyBuilder, List<ProcessorNode> group) {
        String boltId = UniqueIdGen.getInstance().getUniqueBoltId();
        for (ProcessorNode processorNode : group) {
            processorNode.setComponentId(boltId);
            processorNode.setWindowedParentStreams(this.getWindowedParentStreams(processorNode));
        }
        Set<ProcessorNode> initialProcessors = this.initialProcessors(group);
        Set<Window<?, ?>> windowParams = this.getWindowParams(initialProcessors);
        if (windowParams.isEmpty()) {
            if (this.hasStatefulProcessor(group)) {
                this.addStatefulBolt(topologyBuilder, boltId, initialProcessors, group);
            } else {
                this.addBolt(topologyBuilder, boltId, initialProcessors, group);
            }
        } else if (windowParams.size() == 1) {
            this.addWindowedBolt(topologyBuilder, boltId, initialProcessors, windowParams.iterator().next(), group);
        } else {
            throw new IllegalStateException("More than one window config for current group " + group);
        }
    }

    private boolean hasStatefulProcessor(List<ProcessorNode> processorNodes) {
        for (ProcessorNode node : processorNodes) {
            if (!(node.getProcessor() instanceof StatefulProcessor)) continue;
            return true;
        }
        return false;
    }

    private int getParallelism(List<ProcessorNode> group) {
        Set parallelisms = group.stream().map(Node::getParallelism).collect(Collectors.toSet());
        if (parallelisms.size() > 1) {
            throw new IllegalStateException("Current group does not have same parallelism " + group);
        }
        return parallelisms.isEmpty() ? 1 : (Integer)parallelisms.iterator().next();
    }

    private Set<Window<?, ?>> getWindowParams(Set<ProcessorNode> initialProcessors) {
        HashSet<WindowNode> windowNodes = new HashSet<WindowNode>();
        for (ProcessorNode processorNode : initialProcessors) {
            Set<Node> parents = this.parentNodes(processorNode);
            for (Node node : parents) {
                if (!this.windowInfo.containsKey(node)) continue;
                windowNodes.add(this.windowInfo.get(node));
            }
        }
        return windowNodes.stream().map(WindowNode::getWindowParams).collect(Collectors.toSet());
    }

    private void addSpout(TopologyBuilder topologyBuilder, SpoutNode spout) {
        topologyBuilder.setSpout(spout.getComponentId(), spout.getSpout(), (Number)spout.getParallelism());
    }

    private void addSink(TopologyBuilder topologyBuilder, SinkNode sinkNode) {
        BoltDeclarer boltDeclarer;
        IComponent bolt = sinkNode.getBolt();
        if (bolt instanceof IRichBolt) {
            boltDeclarer = topologyBuilder.setBolt(sinkNode.getComponentId(), (IRichBolt)bolt, (Number)sinkNode.getParallelism());
        } else if (bolt instanceof IBasicBolt) {
            boltDeclarer = topologyBuilder.setBolt(sinkNode.getComponentId(), (IBasicBolt)bolt, (Number)sinkNode.getParallelism());
        } else {
            throw new IllegalArgumentException("Expect IRichBolt or IBasicBolt in addBolt");
        }
        for (Node parent : this.parentNodes(sinkNode)) {
            for (String stream : sinkNode.getParentStreams(parent)) {
                this.declareGrouping(boltDeclarer, parent, stream, (GroupingInfo)this.nodeGroupingInfo.get((Object)parent, (Object)stream));
            }
        }
    }

    private StreamBolt addBolt(TopologyBuilder topologyBuilder, String boltId, Set<ProcessorNode> initialProcessors, List<ProcessorNode> group) {
        ProcessorBolt bolt = new ProcessorBolt(boltId, (DirectedGraph<Node, Edge>)this.graph, group);
        BoltDeclarer boltDeclarer = topologyBuilder.setBolt(boltId, bolt, (Number)this.getParallelism(group));
        bolt.setStreamToInitialProcessors(this.wireBolt(group, boltDeclarer, initialProcessors));
        this.streamBolts.put(bolt, boltDeclarer);
        return bolt;
    }

    private StreamBolt addStatefulBolt(TopologyBuilder topologyBuilder, String boltId, Set<ProcessorNode> initialProcessors, List<ProcessorNode> group) {
        StatefulProcessorBolt<Object, Object> bolt;
        StateQueryProcessor<?, ?> stateQueryProcessor = this.getStateQueryProcessor(group);
        if (stateQueryProcessor == null) {
            bolt = new StatefulProcessorBolt(boltId, (DirectedGraph<Node, Edge>)this.graph, group);
            BoltDeclarer boltDeclarer = topologyBuilder.setBolt(boltId, bolt, (Number)this.getParallelism(group));
            bolt.setStreamToInitialProcessors(this.wireBolt(group, boltDeclarer, initialProcessors));
            this.streamBolts.put(bolt, boltDeclarer);
        } else {
            ProcessorNode updateStateNode = stateQueryProcessor.getStreamState().getUpdateStateNode();
            bolt = this.findStatefulProcessorBolt(updateStateNode);
            for (ProcessorNode node : group) {
                node.setComponentId(bolt.getId());
            }
            bolt.addNodes(group);
            bolt.addStreamToInitialProcessors(this.wireBolt(bolt.getNodes(), this.streamBolts.get(bolt), initialProcessors));
        }
        return bolt;
    }

    private StateQueryProcessor<?, ?> getStateQueryProcessor(List<ProcessorNode> group) {
        for (ProcessorNode node : group) {
            if (!(node.getProcessor() instanceof StateQueryProcessor)) continue;
            return (StateQueryProcessor)node.getProcessor();
        }
        return null;
    }

    private StreamBolt addWindowedBolt(TopologyBuilder topologyBuilder, String boltId, Set<ProcessorNode> initialProcessors, Window<?, ?> windowParam, List<ProcessorNode> group) {
        WindowedProcessorBolt bolt = new WindowedProcessorBolt(boltId, (DirectedGraph<Node, Edge>)this.graph, group, windowParam);
        BoltDeclarer boltDeclarer = topologyBuilder.setBolt(boltId, bolt, (Number)this.getParallelism(group));
        bolt.setStreamToInitialProcessors(this.wireBolt(group, boltDeclarer, initialProcessors));
        this.streamBolts.put(bolt, boltDeclarer);
        return bolt;
    }

    private StatefulProcessorBolt<?, ?> findStatefulProcessorBolt(ProcessorNode updateStateNode) {
        for (StreamBolt bolt : this.streamBolts.keySet()) {
            StatefulProcessorBolt statefulProcessorBolt;
            if (!(bolt instanceof StatefulProcessorBolt) || !(statefulProcessorBolt = (StatefulProcessorBolt)bolt).getNodes().contains(updateStateNode)) continue;
            return statefulProcessorBolt;
        }
        throw new IllegalArgumentException("Could not find Stateful bolt for node " + updateStateNode);
    }

    private Set<String> getWindowedParentStreams(ProcessorNode processorNode) {
        HashSet<String> res = new HashSet<String>();
        for (Node parent : this.parentNodes(processorNode)) {
            if (!(parent instanceof ProcessorNode) || !parent.isWindowed()) continue;
            res.addAll(parent.getOutputStreams());
        }
        return res;
    }

    private Multimap<String, ProcessorNode> wireBolt(List<ProcessorNode> group, BoltDeclarer boltDeclarer, Set<ProcessorNode> initialProcessors) {
        LOG.debug("Wiring bolt with boltDeclarer {}, group {}, initialProcessors {}, nodeGroupingInfo {}", new Object[]{boltDeclarer, group, initialProcessors, this.nodeGroupingInfo});
        ArrayListMultimap streamToInitialProcessor = ArrayListMultimap.create();
        HashSet<ProcessorNode> curSet = new HashSet<ProcessorNode>(group);
        for (ProcessorNode curNode : initialProcessors) {
            for (Node parent : this.parentNodes(curNode)) {
                if (curSet.contains(parent)) {
                    LOG.debug("Parent {} of curNode {} is in group {}", new Object[]{parent, curNode, group});
                    continue;
                }
                for (String stream : curNode.getParentStreams(parent)) {
                    this.declareGrouping(boltDeclarer, parent, stream, (GroupingInfo)this.nodeGroupingInfo.get((Object)parent, (Object)stream));
                    if (parent.getComponentId().startsWith("spout")) {
                        stream = parent.getComponentId() + stream;
                    } else {
                        String punctuationStream = StreamUtil.getPunctuationStream(stream);
                        this.declareGrouping(boltDeclarer, parent, punctuationStream, GroupingInfo.all());
                    }
                    streamToInitialProcessor.put((Object)stream, (Object)curNode);
                }
            }
        }
        return streamToInitialProcessor;
    }

    private void declareGrouping(BoltDeclarer boltDeclarer, Node parent, String streamId, GroupingInfo grouping) {
        if (grouping == null) {
            boltDeclarer.shuffleGrouping(parent.getComponentId(), streamId);
        } else {
            grouping.declareGrouping(boltDeclarer, parent.getComponentId(), streamId, grouping.getFields());
        }
    }

    private Set<ProcessorNode> initialProcessors(List<ProcessorNode> group) {
        HashSet<ProcessorNode> nodes = new HashSet<ProcessorNode>();
        HashSet<ProcessorNode> curSet = new HashSet<ProcessorNode>(group);
        for (ProcessorNode node : group) {
            for (Node parent : this.parentNodes(node)) {
                if (parent instanceof ProcessorNode && curSet.contains(parent)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }
}

