/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.sasl;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.sasl.SaslServer;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.kerberos.NoOpTTrasport;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TProcessor;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolFactory;
import org.apache.storm.thrift.server.TServer;
import org.apache.storm.thrift.server.TThreadPoolServer;
import org.apache.storm.thrift.transport.TSaslServerTransport;
import org.apache.storm.thrift.transport.TServerSocket;
import org.apache.storm.thrift.transport.TServerTransport;
import org.apache.storm.thrift.transport.TSocket;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.thrift.transport.TTransportFactory;
import org.apache.storm.utils.ExtendedThreadPoolExecutor;

public abstract class SaslTransportPlugin
implements ITransportPlugin,
Closeable {
    protected ThriftConnectionType type;
    protected Map<String, Object> conf;
    protected Configuration loginConf;
    private int port;

    @Override
    public void prepare(ThriftConnectionType type, Map<String, Object> conf, Configuration loginConf) {
        this.type = type;
        this.conf = conf;
        this.loginConf = loginConf;
    }

    @Override
    public TServer getServer(TProcessor processor) throws IOException, TTransportException {
        int configuredPort = this.type.getPort(this.conf);
        Integer socketTimeout = this.type.getSocketTimeOut(this.conf);
        TTransportFactory serverTransportFactory = this.getServerTransportFactory(this.type.isImpersonationAllowed());
        TServerSocket serverTransport = null;
        serverTransport = socketTimeout != null ? new TServerSocket(configuredPort, socketTimeout.intValue()) : new TServerSocket(configuredPort);
        this.port = serverTransport.getServerSocket().getLocalPort();
        int numWorkerThreads = this.type.getNumThreads(this.conf);
        Integer queueSize = this.type.getQueueSize(this.conf);
        TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)new TUGIWrapProcessor(processor))).minWorkerThreads(numWorkerThreads).maxWorkerThreads(numWorkerThreads).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(false, true));
        if (serverTransportFactory != null) {
            serverArgs.transportFactory(serverTransportFactory);
        }
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue();
        if (queueSize != null) {
            workQueue = new ArrayBlockingQueue(queueSize);
        }
        ExtendedThreadPoolExecutor executorService = new ExtendedThreadPoolExecutor(numWorkerThreads, numWorkerThreads, 60L, TimeUnit.SECONDS, workQueue);
        serverArgs.executorService((ExecutorService)executorService);
        return new TThreadPoolServer(serverArgs);
    }

    @Override
    public void close() {
    }

    protected abstract TTransportFactory getServerTransportFactory(boolean var1) throws IOException;

    @Override
    public int getPort() {
        return this.port;
    }

    public static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && this.name.equals(((User)o).name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class TUGIWrapProcessor
    implements TProcessor {
        final TProcessor wrapped;

        TUGIWrapProcessor(TProcessor wrapped) {
            this.wrapped = wrapped;
        }

        public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
            ReqContext reqContext = ReqContext.context();
            TTransport trans = inProt.getTransport();
            TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
            if (trans instanceof NoOpTTrasport) {
                return false;
            }
            TSocket tsocket = (TSocket)saslTrans.getUnderlyingTransport();
            Socket socket = tsocket.getSocket();
            reqContext.setRemoteAddress(socket.getInetAddress());
            SaslServer saslServer = saslTrans.getSaslServer();
            String authId = saslServer.getAuthorizationID();
            Subject remoteUser = new Subject();
            remoteUser.getPrincipals().add(new User(authId));
            reqContext.setSubject(remoteUser);
            return this.wrapped.process(inProt, outProt);
        }
    }
}

