/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringStyle;
import org.apache.storm.utils.JCQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPressureTracker {
    static final Logger LOG = LoggerFactory.getLogger(BackPressureTracker.class);
    private final Map<Integer, BackpressureState> tasks;
    private final String workerId;

    public BackPressureTracker(String workerId, Map<Integer, JCQueue> localTasksToQueues) {
        this.workerId = workerId;
        this.tasks = localTasksToQueues.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> new BackpressureState((JCQueue)entry.getValue())));
    }

    private void recordNoBackPressure(Integer taskId) {
        this.tasks.get(taskId).backpressure.set(false);
    }

    public boolean recordBackPressure(Integer taskId) {
        return !this.tasks.get(taskId).backpressure.getAndSet(true);
    }

    public boolean refreshBpTaskList() {
        boolean changed = false;
        LOG.debug("Running Back Pressure status change check");
        for (Map.Entry<Integer, BackpressureState> entry : this.tasks.entrySet()) {
            BackpressureState state = entry.getValue();
            if (!state.backpressure.get() || !state.queue.isEmptyOverflow()) continue;
            this.recordNoBackPressure(entry.getKey());
            changed = true;
        }
        return changed;
    }

    public BackPressureStatus getCurrStatus() {
        ArrayList<Integer> bpTasks = new ArrayList<Integer>(this.tasks.size());
        ArrayList<Integer> nonBpTasks = new ArrayList<Integer>(this.tasks.size());
        for (Map.Entry<Integer, BackpressureState> entry : this.tasks.entrySet()) {
            if (entry.getKey() < 0) continue;
            boolean backpressure = entry.getValue().backpressure.get();
            if (backpressure) {
                bpTasks.add(entry.getKey());
                continue;
            }
            nonBpTasks.add(entry.getKey());
        }
        return new BackPressureStatus(this.workerId, bpTasks, nonBpTasks);
    }

    private static class BackpressureState {
        private final JCQueue queue;
        private final AtomicBoolean backpressure = new AtomicBoolean(false);

        public BackpressureState(JCQueue queue) {
            this.queue = queue;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.queue).append((Object)this.backpressure).toString();
        }
    }
}

