/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.utils.ObjectReader;

public class ClientMetricsUtils {
    public static TimeUnit getMetricsRateUnit(Map<String, Object> topoConf) {
        return ClientMetricsUtils.getTimeUnitForCofig(topoConf, "storm.daemon.metrics.reporter.plugin.rate.unit");
    }

    public static TimeUnit getMetricsDurationUnit(Map<String, Object> topoConf) {
        return ClientMetricsUtils.getTimeUnitForCofig(topoConf, "storm.daemon.metrics.reporter.plugin.duration.unit");
    }

    public static Locale getMetricsReporterLocale(Map<String, Object> topoConf) {
        String languageTag = ObjectReader.getString(topoConf.get("storm.daemon.metrics.reporter.plugin.locale"), null);
        if (languageTag != null) {
            return Locale.forLanguageTag(languageTag);
        }
        return null;
    }

    private static TimeUnit getTimeUnitForCofig(Map<String, Object> topoConf, String configName) {
        String rateUnitString = ObjectReader.getString(topoConf.get(configName), null);
        if (rateUnitString != null) {
            return TimeUnit.valueOf(rateUnitString);
        }
        return null;
    }
}

