/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.esotericsoftware.kryo.Serializer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.assignments.ILocalAssignmentsBackend;
import org.apache.storm.metric.IEventLogger;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.serialization.IKryoDecorator;
import org.apache.storm.serialization.IKryoFactory;
import org.apache.storm.utils.Utils;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.validation.ConfigValidationAnnotations;

public class Config
extends HashMap<String, Object> {
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_TUPLE_SERIALIZER = "topology.tuple.serializer";
    @ConfigValidationAnnotations.IsBoolean
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_DISABLE_LOADAWARE_MESSAGING = "topology.disable.loadaware.messaging";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_LOCALITYAWARE_HIGHER_BOUND = "topology.localityaware.higher.bound";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_LOCALITYAWARE_LOWER_BOUND = "topology.localityaware.lower.bound";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_TESTING_ALWAYS_TRY_SERIALIZE = "topology.testing.always.try.serialize";
    @ConfigValidationAnnotations.CustomValidator(validatorClass=ConfigValidation.MapOfStringToMapOfStringToObjectValidator.class)
    public static final String TOPOLOGY_BLOBSTORE_MAP = "topology.blobstore.map";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String WORKER_LOG_LEVEL_RESET_POLL_SECS = "worker.log.level.reset.poll.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TASK_CREDENTIALS_POLL_SECS = "task.credentials.poll.secs";
    @Deprecated
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_BACKPRESSURE_ENABLE = "topology.backpressure.enable";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_USERS = "topology.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_GROUPS = "topology.groups";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_READONLY_USERS = "topology.readonly.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_READONLY_GROUPS = "topology.readonly.groups";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS = "topology.enable.message.timeouts";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_DEBUG = "topology.debug";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_VERSION = "topology.version";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_MULTILANG_LOG_HANDLER = "topology.multilang.log.handler";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_MULTILANG_SERIALIZER = "topology.multilang.serializer";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_WORKERS = "topology.workers";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_TASKS = "topology.tasks";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=Number.class)
    public static final String TOPOLOGY_COMPONENT_RESOURCES_MAP = "topology.component.resources.map";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_RESOURCES_ONHEAP_MEMORY_MB = "topology.component.resources.onheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_RESOURCES_OFFHEAP_MEMORY_MB = "topology.component.resources.offheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_CPU_PCORE_PERCENT = "topology.component.cpu.pcore.percent";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_ACKER_RESOURCES_ONHEAP_MEMORY_MB = "topology.acker.resources.onheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_ACKER_RESOURCES_OFFHEAP_MEMORY_MB = "topology.acker.resources.offheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_ACKER_CPU_PCORE_PERCENT = "topology.acker.cpu.pcore.percent";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_METRICS_CONSUMER_RESOURCES_ONHEAP_MEMORY_MB = "topology.metrics.consumer.resources.onheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_METRICS_CONSUMER_RESOURCES_OFFHEAP_MEMORY_MB = "topology.metrics.consumer.resources.offheap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_METRICS_CONSUMER_CPU_PCORE_PERCENT = "topology.metrics.consumer.cpu.pcore.percent";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_STATE_PROVIDER = "topology.state.provider";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_STATE_PROVIDER_CONFIG = "topology.state.provider.config";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_STATE_CHECKPOINT_INTERVAL = "topology.state.checkpoint.interval.ms";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB = "topology.worker.max.heap.size.mb";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_SCHEDULER_STRATEGY = "topology.scheduler.strategy";
    @ConfigValidationAnnotations.CustomValidator(validatorClass=ConfigValidation.ListOfListOfStringValidator.class)
    public static final String TOPOLOGY_RAS_CONSTRAINTS = "topology.ras.constraints";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_SPREAD_COMPONENTS = "topology.spread.components";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_RAS_CONSTRAINT_MAX_STATE_SEARCH = "topology.ras.constraint.max.state.search";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_RAS_CONSTRAINT_MAX_TIME_SECS = "topology.ras.constraint.max.time.secs";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_SCHEDULER_FAVORED_NODES = "topology.scheduler.favored.nodes";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_SCHEDULER_UNFAVORED_NODES = "topology.scheduler.unfavored.nodes";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_ACKER_EXECUTORS = "topology.acker.executors";
    @ConfigValidationAnnotations.IsListEntryCustom(entryValidatorClasses={ConfigValidation.EventLoggerRegistryValidator.class})
    public static final String TOPOLOGY_EVENT_LOGGER_REGISTER = "topology.event.logger.register";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_EVENTLOGGER_EXECUTORS = "topology.eventlogger.executors";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_MESSAGE_TIMEOUT_SECS = "topology.message.timeout.secs";
    @ConfigValidationAnnotations.IsKryoReg
    public static final String TOPOLOGY_KRYO_REGISTER = "topology.kryo.register";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_KRYO_DECORATORS = "topology.kryo.decorators";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_KRYO_FACTORY = "topology.kryo.factory";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS = "topology.skip.missing.kryo.registrations";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_STATE_KRYO_REGISTER = "topology.state.kryo.register";
    @ConfigValidationAnnotations.IsListEntryCustom(entryValidatorClasses={ConfigValidation.MetricRegistryValidator.class})
    public static final String TOPOLOGY_METRICS_CONSUMER_REGISTER = "topology.metrics.consumer.register";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_SERIALIZED_MESSAGE_SIZE_METRICS = "topology.serialized.message.size.metrics";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String TOPOLOGY_WORKER_METRICS = "topology.worker.metrics";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String WORKER_METRICS = "worker.metrics";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_MAX_TASK_PARALLELISM = "topology.max.task.parallelism";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_MAX_SPOUT_PENDING = "topology.max.spout.pending";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SLEEP_SPOUT_WAIT_STRATEGY_TIME_MS = "topology.sleep.spout.wait.strategy.time.ms";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_STATE_SYNCHRONIZATION_TIMEOUT_SECS = "topology.state.synchronization.timeout.secs";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_STATS_SAMPLE_RATE = "topology.stats.sample.rate";
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_BUILTIN_METRICS_BUCKET_SIZE_SECS = "topology.builtin.metrics.bucket.size.secs";
    @ConfigValidationAnnotations.IsBoolean
    public static final String TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION = "topology.fall.back.on.java.serialization";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String TOPOLOGY_WORKER_CHILDOPTS = "topology.worker.childopts";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String TOPOLOGY_WORKER_GC_CHILDOPTS = "topology.worker.gc.childopts";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String TOPOLOGY_WORKER_LOGWRITER_CHILDOPTS = "topology.worker.logwriter.childopts";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String TOPOLOGY_CLASSPATH = "topology.classpath";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String TOPOLOGY_CLASSPATH_BEGINNING = "topology.classpath.beginning";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String TOPOLOGY_ENVIRONMENT = "topology.environment";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_COUNT = "topology.bolts.window.length.count";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_DURATION_MS = "topology.bolts.window.length.duration.ms";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_COUNT = "topology.bolts.window.sliding.interval.count";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_DURATION_MS = "topology.bolts.window.sliding.interval.duration.ms";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_BOLTS_LATE_TUPLE_STREAM = "topology.bolts.late.tuple.stream";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_TUPLE_TIMESTAMP_MAX_LAG_MS = "topology.bolts.tuple.timestamp.max.lag.ms";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_BOLTS_WATERMARK_EVENT_INTERVAL_MS = "topology.bolts.watermark.event.interval.ms";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_BOLTS_MESSAGE_ID_FIELD_NAME = "topology.bolts.message.id.field.name";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_TRANSACTIONAL_ID = "topology.transactional.id";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_AUTO_TASK_HOOKS = "topology.auto.task.hooks";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_EXECUTOR_RECEIVE_BUFFER_SIZE = "topology.executor.receive.buffer.size";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_TRANSFER_BUFFER_SIZE = "topology.transfer.buffer.size";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_TRANSFER_BATCH_SIZE = "topology.transfer.batch.size";
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_TICK_TUPLE_FREQ_SECS = "topology.tick.tuple.freq.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_PRODUCER_BATCH_SIZE = "topology.producer.batch.size";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_EXECUTOR_OVERFLOW_LIMIT = "topology.executor.overflow.limit";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_BACKPRESSURE_CHECK_MILLIS = "topology.backpressure.check.millis";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_BATCH_FLUSH_INTERVAL_MILLIS = "topology.batch.flush.interval.millis";
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_WORKER_SHARED_THREAD_POOL_SIZE = "topology.worker.shared.thread.pool.size";
    @ConfigValidationAnnotations.IsInteger
    public static final String TOPOLOGY_ERROR_THROTTLE_INTERVAL_SECS = "topology.error.throttle.interval.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_MAX_ERROR_REPORT_PER_INTERVAL = "topology.max.error.report.per.interval";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_TRIDENT_BATCH_EMIT_INTERVAL_MILLIS = "topology.trident.batch.emit.interval.millis";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_TRIDENT_WINDOWING_INMEMORY_CACHE_LIMIT = "topology.trident.windowing.cache.tuple.limit";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ID = "storm.id";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_NAME = "topology.name";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_SUBMITTER_PRINCIPAL = "topology.submitter.principal";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_SUBMITTER_USER = "topology.submitter.user";
    @ConfigValidationAnnotations.IsStringList
    public static final String TOPOLOGY_AUTO_CREDENTIALS = "topology.auto-credentials";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_SHELLBOLT_MAX_PENDING = "topology.shellbolt.max.pending";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_SUBPROCESS_TIMEOUT_SECS = "topology.subprocess.timeout.secs";
    @ConfigValidationAnnotations.IsString(acceptedValues={"S0", "S1", "S2", "S3"})
    public static final String TOPOLOGY_LOGGING_SENSITIVITY = "topology.logging.sensitivity";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_LOGGING_CONFIG_FILE = "topology.logging.config";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_PRIORITY = "topology.priority";
    @ConfigValidationAnnotations.IsString
    public static final String TRANSACTIONAL_ZOOKEEPER_ROOT = "transactional.zookeeper.root";
    @ConfigValidationAnnotations.IsStringList
    public static final String TRANSACTIONAL_ZOOKEEPER_SERVERS = "transactional.zookeeper.servers";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TRANSACTIONAL_ZOOKEEPER_PORT = "transactional.zookeeper.port";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DO_AS_USER = "storm.doAsUser";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TOPOLOGY_ISOLATED_MACHINES = "topology.isolate.machines";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_SPOUT_WAIT_STRATEGY = "topology.spout.wait.strategy";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SPOUT_WAIT_PARK_MICROSEC = "topology.spout.wait.park.microsec";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SPOUT_WAIT_PROGRESSIVE_LEVEL1_COUNT = "topology.spout.wait.progressive.level1.count";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SPOUT_WAIT_PROGRESSIVE_LEVEL2_COUNT = "topology.spout.wait.progressive.level2.count";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SPOUT_WAIT_PROGRESSIVE_LEVEL3_SLEEP_MILLIS = "topology.spout.wait.progressive.level3.sleep.millis";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_BOLT_WAIT_STRATEGY = "topology.bolt.wait.strategy";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BOLT_WAIT_PARK_MICROSEC = "topology.bolt.wait.park.microsec";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BOLT_WAIT_PROGRESSIVE_LEVEL1_COUNT = "topology.bolt.wait.progressive.level1.count";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BOLT_WAIT_PROGRESSIVE_LEVEL2_COUNT = "topology.bolt.wait.progressive.level2.count";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BOLT_WAIT_PROGRESSIVE_LEVEL3_SLEEP_MILLIS = "topology.bolt.wait.progressive.level3.sleep.millis";
    @ConfigValidationAnnotations.IsString
    public static final String TOPOLOGY_BACKPRESSURE_WAIT_STRATEGY = "topology.backpressure.wait.strategy";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BACKPRESSURE_WAIT_PARK_MICROSEC = "topology.backpressure.wait.park.microsec";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BACKPRESSURE_WAIT_PROGRESSIVE_LEVEL3_SLEEP_MILLIS = "topology.backpressure.wait.progressive.level3.sleep.millis";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BACKPRESSURE_WAIT_PROGRESSIVE_LEVEL1_COUNT = "topology.backpressure.wait.progressive.level1.count";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_BACKPRESSURE_WAIT_PROGRESSIVE_LEVEL2_COUNT = "topology.backpressure.wait.progressive.level2.count";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_SPOUT_RECVQ_SKIPS = "topology.spout.recvq.skips";
    @ConfigValidationAnnotations.IsNumber
    public static final String TOPOLOGY_MIN_REPLICATION_COUNT = "topology.min.replication.count";
    @ConfigValidationAnnotations.IsNumber
    public static final String TOPOLOGY_MAX_REPLICATION_WAIT_TIME_SEC = "topology.max.replication.wait.time.sec";
    @ConfigValidationAnnotations.IsStringList
    public static final String PACEMAKER_SERVERS = "pacemaker.servers";
    @ConfigValidationAnnotations.IsNumber
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String PACEMAKER_PORT = "pacemaker.port";
    @ConfigValidationAnnotations.IsNumber
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String PACEMAKER_CLIENT_MAX_THREADS = "pacemaker.client.max.threads";
    @ConfigValidationAnnotations.CustomValidator(validatorClass=ConfigValidation.PacemakerAuthTypeValidator.class)
    public static final String PACEMAKER_AUTH_METHOD = "pacemaker.auth.method";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String PACEMAKER_THRIFT_MESSAGE_SIZE_MAX = "pacemaker.thrift.message.size.max";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_GROUP_MAPPING_SERVICE_CACHE_DURATION_SECS = "storm.group.mapping.service.cache.duration.secs";
    @ConfigValidationAnnotations.IsStringList
    public static final String DRPC_SERVERS = "drpc.servers";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_INVOCATIONS_PORT = "drpc.invocations.port";
    @ConfigValidationAnnotations.IsNumber
    public static final String STORM_NIMBUS_RETRY_TIMES = "storm.nimbus.retry.times";
    @ConfigValidationAnnotations.IsNumber
    public static final String STORM_NIMBUS_RETRY_INTERVAL = "storm.nimbus.retry.interval.millis";
    @ConfigValidationAnnotations.IsNumber
    public static final String STORM_NIMBUS_RETRY_INTERVAL_CEILING = "storm.nimbus.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_THRIFT_TRANSPORT_PLUGIN = "nimbus.thrift.transport";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_THRIFT_PORT = "nimbus.thrift.port";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_QUEUE_SIZE = "nimbus.queue.size";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=ILocalAssignmentsBackend.class)
    public static final String NIMBUS_LOCAL_ASSIGNMENTS_BACKEND_CLASS = "nimbus.local.assignments.backend.class";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_THRIFT_THREADS = "nimbus.thrift.threads";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_THRIFT_MAX_BUFFER_SIZE = "nimbus.thrift.max_buffer_size";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_THRIFT_SOCKET_TIMEOUT_MS = "storm.thrift.socket.timeout.ms";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_THRIFT_TRANSPORT_PLUGIN = "drpc.thrift.transport";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_PORT = "drpc.port";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_QUEUE_SIZE = "drpc.queue.size";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_WORKER_THREADS = "drpc.worker.threads";
    @ConfigValidationAnnotations.IsNumber
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_MAX_BUFFER_SIZE = "drpc.max_buffer_size";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_INVOCATIONS_THRIFT_TRANSPORT_PLUGIN = "drpc.invocations.thrift.transport";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String DRPC_INVOCATIONS_THREADS = "drpc.invocations.threads";
    @ConfigValidationAnnotations.IsType(type=Map.class)
    public static final String STORM_GROUP_MAPPING_SERVICE_PARAMS = "storm.group.mapping.service.params";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_THRIFT_TRANSPORT_PLUGIN = "storm.thrift.transport";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String SUPERVISOR_WORKER_TIMEOUT_SECS = "supervisor.worker.timeout.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_WORKER_SHUTDOWN_SLEEP_SECS = "supervisor.worker.shutdown.sleep.secs";
    @ConfigValidationAnnotations.IsStringList
    public static final String STORM_ZOOKEEPER_SERVERS = "storm.zookeeper.servers";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_ZOOKEEPER_PORT = "storm.zookeeper.port";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_SUPERACL = "storm.zookeeper.superACL";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_DRPC_ACL = "storm.zookeeper.drpcACL";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_TOPOLOGY_AUTH_SCHEME = "storm.zookeeper.topology.auth.scheme";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_META_SERIALIZATION_DELEGATE = "storm.meta.serialization.delegate";
    @ConfigValidationAnnotations.IsListEntryCustom(entryValidatorClasses={ConfigValidation.MetricReportersValidator.class})
    public static final String STORM_METRICS_REPORTERS = "storm.metrics.reporters";
    @ConfigValidationAnnotations.IsString
    public static final String CLIENT_BLOBSTORE = "client.blobstore.class";
    @ConfigValidationAnnotations.IsString
    public static final String BLOBSTORE_DIR = "blobstore.dir";
    @ConfigValidationAnnotations.IsBoolean
    public static final String BLOBSTORE_CLEANUP_ENABLE = "blobstore.cleanup.enable";
    @ConfigValidationAnnotations.IsString
    public static final String BLOBSTORE_HDFS_PRINCIPAL = "blobstore.hdfs.principal";
    @ConfigValidationAnnotations.IsString
    public static final String BLOBSTORE_HDFS_KEYTAB = "blobstore.hdfs.keytab";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_BLOBSTORE_REPLICATION_FACTOR = "storm.blobstore.replication.factor";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_LOCAL_HOSTNAME = "storm.local.hostname";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_SEEDS = "nimbus.seeds";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_USERS = "nimbus.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_GROUPS = "nimbus.groups";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_CLUSTER_MODE = "storm.cluster.mode";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_ROOT = "storm.zookeeper.root";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String STORM_ZOOKEEPER_TOPOLOGY_AUTH_PAYLOAD = "storm.zookeeper.topology.auth.payload";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_AUTH_SCHEME = "storm.zookeeper.auth.scheme";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ZOOKEEPER_AUTH_PAYLOAD = "storm.zookeeper.auth.payload";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=DNSToSwitchMapping.class)
    public static final String STORM_NETWORK_TOPOGRAPHY_PLUGIN = "storm.network.topography.plugin";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String WORKER_GC_CHILDOPTS = "worker.gc.childopts";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String WORKER_CHILDOPTS = "worker.childopts";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String WORKER_HEAP_MEMORY_MB = "worker.heap.memory.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_MEMORY_CAPACITY_MB = "supervisor.memory.capacity.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_CPU_CAPACITY = "supervisor.cpu.capacity";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_THRIFT_PORT = "supervisor.thrift.port";
    @ConfigValidationAnnotations.IsString
    public static final String SUPERVISOR_THRIFT_TRANSPORT_PLUGIN = "supervisor.thrift.transport";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_QUEUE_SIZE = "supervisor.queue.size";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_THRIFT_THREADS = "supervisor.thrift.threads";
    @ConfigValidationAnnotations.IsNumber
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_THRIFT_MAX_BUFFER_SIZE = "supervisor.thrift.max_buffer_size";
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_THRIFT_SOCKET_TIMEOUT_MS = "supervisor.thrift.socket.timeout.ms";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=Number.class)
    public static final String SUPERVISOR_RESOURCES_MAP = "supervisor.resources.map";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_LOCAL_MODE_ZMQ = "storm.local.mode.zmq";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_MESSAGING_TRANSPORT = "storm.messaging.transport";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_MESSAGING_NETTY_AUTHENTICATION = "storm.messaging.netty.authentication";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_MESSAGING_NETTY_BUFFER_SIZE = "storm.messaging.netty.buffer_size";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_MESSAGING_NETTY_BUFFER_HIGH_WATERMARK = "storm.messaging.netty.buffer.high.watermark";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_MESSAGING_NETTY_BUFFER_LOW_WATERMARK = "storm.messaging.netty.buffer.low.watermark";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_MESSAGING_NETTY_SOCKET_BACKLOG = "storm.messaging.netty.socket.backlog";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_SERVER_WORKER_THREADS = "storm.messaging.netty.server_worker_threads";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_NETTY_MESSAGE_BATCH_SIZE = "storm.messaging.netty.transfer.batch.size";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_MIN_SLEEP_MS = "storm.messaging.netty.min_wait_ms";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_MAX_SLEEP_MS = "storm.messaging.netty.max_wait_ms";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_MESSAGING_NETTY_CLIENT_WORKER_THREADS = "storm.messaging.netty.client_worker_threads";
    @ConfigValidationAnnotations.IsBoolean
    public static final String SUPERVISOR_RUN_WORKER_AS_USER = "supervisor.run.worker.as.user";
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_WORKER_HEARTBEATS_MAX_TIMEOUT_SECS = "supervisor.worker.heartbeats.max.timeout.secs";
    @ConfigValidationAnnotations.IsBoolean
    public static final String DISABLE_SYMLINKS = "storm.disable.symlinks";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_PRINCIPAL_TO_LOCAL_PLUGIN = "storm.principal.tolocal";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_GROUP_MAPPING_SERVICE_PROVIDER_PLUGIN = "storm.group.mapping.service";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_CREDENTIAL_RENEWERS = "nimbus.credential.renewers.classes";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_AUTO_CRED_PLUGINS = "nimbus.autocredential.plugins.classes";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_SUPERVISOR_USERS = "nimbus.supervisor.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_DAEMON_USERS = "nimbus.daemon.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_ADMINS = "nimbus.admins";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_ADMINS_GROUPS = "nimbus.admins.groups";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_BLOBSTORE_ACL_VALIDATION_ENABLED = "storm.blobstore.acl.validation.enabled";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_BLOBSTORE_INPUTSTREAM_BUFFER_SIZE_BYTES = "storm.blobstore.inputstream.buffer.size.bytes";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_BLOBSTORE_DEPENDENCY_JAR_UPLOAD_CHUNK_SIZE_BYTES = "storm.blobstore.dependency.jar.upload.chunk.size.bytes";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_TOPOLOGY_SUBMISSION_NOTIFIER_PLUGIN = "storm.topology.submission.notifier.plugin.class";
    @ConfigValidationAnnotations.IsMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.ImpersonationAclUserEntryValidator.class})
    public static final String NIMBUS_IMPERSONATION_ACL = "nimbus.impersonation.acl";
    @ConfigValidationAnnotations.IsStringList
    public static final String NIMBUS_SCHEDULER_STRATEGY_CLASS_WHITELIST = "nimbus.scheduler.strategy.class.whitelist";
    @ConfigValidationAnnotations.IsString
    public static final String SUPERVISOR_WORKER_LAUNCHER = "supervisor.worker.launcher";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String SUPERVISOR_WORKER_VERSION_CLASSPATH_MAP = "supervisor.worker.version.classpath.map";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String SUPERVISOR_WORKER_VERSION_MAIN_MAP = "supervisor.worker.version.main.map";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String SUPERVISOR_WORKER_VERSION_LOGWRITER_MAP = "supervisor.worker.version.logwriter.map";
    @ConfigValidationAnnotations.IsString
    public static final String SUPERVISOR_WORKER_DEFAULT_VERSION = "supervisor.worker.default.version";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_LOCAL_DIR = "storm.local.dir";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_WORKERS_ARTIFACTS_DIR = "storm.workers.artifacts.dir";
    @ConfigValidationAnnotations.IsStringList
    public static final String STORM_EXHIBITOR_SERVERS = "storm.exhibitor.servers";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_EXHIBITOR_PORT = "storm.exhibitor.port";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_EXHIBITOR_URIPATH = "storm.exhibitor.poll.uripath";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_EXHIBITOR_POLL = "storm.exhibitor.poll.millis";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_EXHIBITOR_RETRY_TIMES = "storm.exhibitor.retry.times";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_EXHIBITOR_RETRY_INTERVAL = "storm.exhibitor.retry.interval";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_EXHIBITOR_RETRY_INTERVAL_CEILING = "storm.exhibitor.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ZOOKEEPER_CONNECTION_TIMEOUT = "storm.zookeeper.connection.timeout";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ZOOKEEPER_SESSION_TIMEOUT = "storm.zookeeper.session.timeout";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ZOOKEEPER_RETRY_INTERVAL = "storm.zookeeper.retry.interval";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ZOOKEEPER_RETRY_INTERVAL_CEILING = "storm.zookeeper.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ZOOKEEPER_RETRY_TIMES = "storm.zookeeper.retry.times";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_CLUSTER_STATE_STORE = "storm.cluster.state.store";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String WORKER_HEARTBEAT_FREQUENCY_SECS = "worker.heartbeat.frequency.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String EXECUTOR_METRICS_FREQUENCY_SECS = "executor.metrics.frequency.secs";
    @Deprecated
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TASK_HEARTBEAT_FREQUENCY_SECS = "task.heartbeat.frequency.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String TASK_REFRESH_POLL_SECS = "task.refresh.poll.secs";
    @ConfigValidationAnnotations.IsType(type=Map.class)
    public static final String DRPC_AUTHORIZER_ACL = "drpc.authorizer.acl";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_AUTHORIZER_ACL_FILENAME = "drpc.authorizer.acl.filename";
    @ConfigValidationAnnotations.IsBoolean
    public static final String DRPC_AUTHORIZER_ACL_STRICT = "drpc.authorizer.acl.strict";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_CGROUP_HIERARCHY_DIR = "storm.cgroup.hierarchy.dir";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NUM_STAT_BUCKETS = "num.stat.buckets";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String WORKER_BLOB_UPDATE_POLL_INTERVAL_SECS = "worker.blob.update.poll.interval.secs";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DAEMON_METRICS_REPORTER_PLUGIN_LOCALE = "storm.daemon.metrics.reporter.plugin.locale";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DAEMON_METRICS_REPORTER_PLUGIN_RATE_UNIT = "storm.daemon.metrics.reporter.plugin.rate.unit";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DAEMON_METRICS_REPORTER_PLUGIN_DURATION_UNIT = "storm.daemon.metrics.reporter.plugin.duration.unit";
    private static final long serialVersionUID = -1550278723792864455L;
    private static final String HOSTNAME_PATTERN = "_HOST";

    public static void setClasspath(Map<String, Object> conf, String cp) {
        conf.put(TOPOLOGY_CLASSPATH, cp);
    }

    public static void setEnvironment(Map<String, Object> conf, Map<String, Object> env) {
        conf.put(TOPOLOGY_ENVIRONMENT, env);
    }

    public static void setDebug(Map<String, Object> conf, boolean isOn) {
        conf.put(TOPOLOGY_DEBUG, isOn);
    }

    public static void setTopologyVersion(Map<String, Object> conf, String version) {
        conf.put(TOPOLOGY_VERSION, version);
    }

    public static void setNumWorkers(Map<String, Object> conf, int workers) {
        conf.put(TOPOLOGY_WORKERS, workers);
    }

    public static void setNumAckers(Map<String, Object> conf, int numExecutors) {
        conf.put(TOPOLOGY_ACKER_EXECUTORS, numExecutors);
    }

    public static void setNumEventLoggers(Map<String, Object> conf, int numExecutors) {
        conf.put(TOPOLOGY_EVENTLOGGER_EXECUTORS, numExecutors);
    }

    public static void setMessageTimeoutSecs(Map<String, Object> conf, int secs) {
        conf.put(TOPOLOGY_MESSAGE_TIMEOUT_SECS, secs);
    }

    public static void registerSerialization(Map<String, Object> conf, Class klass) {
        Config.getRegisteredSerializations(conf).add(klass.getName());
    }

    public static void registerSerialization(Map<String, Object> conf, Class klass, Class<? extends Serializer> serializerClass) {
        HashMap<String, String> register = new HashMap<String, String>();
        register.put(klass.getName(), serializerClass.getName());
        Config.getRegisteredSerializations(conf).add(register);
    }

    public static void registerEventLogger(Map<String, Object> conf, Class<? extends IEventLogger> klass, Map<String, Object> argument) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("class", klass.getCanonicalName());
        m.put("arguments", argument);
        ArrayList l = (ArrayList)conf.get(TOPOLOGY_EVENT_LOGGER_REGISTER);
        if (l == null) {
            l = new ArrayList();
        }
        l.add(m);
        conf.put(TOPOLOGY_EVENT_LOGGER_REGISTER, l);
    }

    public static void registerEventLogger(Map<String, Object> conf, Class<? extends IEventLogger> klass) {
        Config.registerEventLogger(conf, klass, null);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass, Object argument, long parallelismHint) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("class", klass.getCanonicalName());
        m.put("parallelism.hint", parallelismHint);
        m.put("argument", argument);
        ArrayList l = (ArrayList)conf.get(TOPOLOGY_METRICS_CONSUMER_REGISTER);
        if (l == null) {
            l = new ArrayList();
        }
        l.add(m);
        conf.put(TOPOLOGY_METRICS_CONSUMER_REGISTER, l);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass, long parallelismHint) {
        Config.registerMetricsConsumer(conf, klass, null, parallelismHint);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass) {
        Config.registerMetricsConsumer(conf, klass, null, 1L);
    }

    public static void registerDecorator(Map<String, Object> conf, Class<? extends IKryoDecorator> klass) {
        Config.getRegisteredDecorators(conf).add(klass.getName());
    }

    public static void setKryoFactory(Map<String, Object> conf, Class<? extends IKryoFactory> klass) {
        conf.put(TOPOLOGY_KRYO_FACTORY, klass.getName());
    }

    public static void setSkipMissingKryoRegistrations(Map<String, Object> conf, boolean skip) {
        conf.put(TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS, skip);
    }

    public static void setMaxTaskParallelism(Map<String, Object> conf, int max) {
        conf.put(TOPOLOGY_MAX_TASK_PARALLELISM, max);
    }

    public static void setMaxSpoutPending(Map<String, Object> conf, int max) {
        conf.put(TOPOLOGY_MAX_SPOUT_PENDING, max);
    }

    public static void setStatsSampleRate(Map<String, Object> conf, double rate) {
        conf.put(TOPOLOGY_STATS_SAMPLE_RATE, rate);
    }

    public static void setFallBackOnJavaSerialization(Map<String, Object> conf, boolean fallback) {
        conf.put(TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION, fallback);
    }

    private static List getRegisteredSerializations(Map<String, Object> conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_REGISTER) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_REGISTER));
        conf.put(TOPOLOGY_KRYO_REGISTER, ret);
        return ret;
    }

    private static List getRegisteredDecorators(Map<String, Object> conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_DECORATORS) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_DECORATORS));
        conf.put(TOPOLOGY_KRYO_DECORATORS, ret);
        return ret;
    }

    public void setClasspath(String cp) {
        Config.setClasspath(this, cp);
    }

    public void setEnvironment(Map<String, Object> env) {
        Config.setEnvironment(this, env);
    }

    public void setDebug(boolean isOn) {
        Config.setDebug(this, isOn);
    }

    public void setTopologyVersion(String version) {
        Config.setTopologyVersion(this, version);
    }

    public void setNumWorkers(int workers) {
        Config.setNumWorkers(this, workers);
    }

    public void setNumAckers(int numExecutors) {
        Config.setNumAckers(this, numExecutors);
    }

    public void setNumEventLoggers(int numExecutors) {
        Config.setNumEventLoggers(this, numExecutors);
    }

    public void setMessageTimeoutSecs(int secs) {
        Config.setMessageTimeoutSecs(this, secs);
    }

    public void registerSerialization(Class klass) {
        Config.registerSerialization(this, klass);
    }

    public void registerSerialization(Class klass, Class<? extends Serializer> serializerClass) {
        Config.registerSerialization(this, klass, serializerClass);
    }

    public void registerEventLogger(Class<? extends IEventLogger> klass, Map<String, Object> argument) {
        Config.registerEventLogger(this, klass, argument);
    }

    public void registerEventLogger(Class<? extends IEventLogger> klass) {
        Config.registerEventLogger(this, klass, null);
    }

    public void registerMetricsConsumer(Class klass, Object argument, long parallelismHint) {
        Config.registerMetricsConsumer(this, klass, argument, parallelismHint);
    }

    public void registerMetricsConsumer(Class klass, long parallelismHint) {
        Config.registerMetricsConsumer(this, klass, parallelismHint);
    }

    public void registerMetricsConsumer(Class klass) {
        Config.registerMetricsConsumer(this, klass);
    }

    public void registerDecorator(Class<? extends IKryoDecorator> klass) {
        Config.registerDecorator(this, klass);
    }

    public void setKryoFactory(Class<? extends IKryoFactory> klass) {
        Config.setKryoFactory(this, klass);
    }

    public void setSkipMissingKryoRegistrations(boolean skip) {
        Config.setSkipMissingKryoRegistrations(this, skip);
    }

    public void setMaxTaskParallelism(int max) {
        Config.setMaxTaskParallelism(this, max);
    }

    public void setMaxSpoutPending(int max) {
        Config.setMaxSpoutPending(this, max);
    }

    public void setStatsSampleRate(double rate) {
        Config.setStatsSampleRate(this, rate);
    }

    public void setFallBackOnJavaSerialization(boolean fallback) {
        Config.setFallBackOnJavaSerialization(this, fallback);
    }

    public void setTopologyWorkerMaxHeapSize(Number size) {
        if (size != null) {
            this.put(TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB, size);
        }
    }

    public void setTopologyComponentWorkerConstraints(String component1, String component2) {
        if (component1 != null && component2 != null) {
            List<String> constraintPair = Arrays.asList(component1, component2);
            List constraints = (List)this.computeIfAbsent(TOPOLOGY_RAS_CONSTRAINTS, k -> new ArrayList(1));
            constraints.add(constraintPair);
        }
    }

    public void setTopologyConstraintsMaxStateSearch(int numStates) {
        this.put(TOPOLOGY_RAS_CONSTRAINT_MAX_STATE_SEARCH, numStates);
    }

    public void setTopologyPriority(int priority) {
        this.put(TOPOLOGY_PRIORITY, priority);
    }

    public void setTopologyStrategy(String strategy) {
        this.put(TOPOLOGY_SCHEDULER_STRATEGY, strategy);
    }

    public static String getBlobstoreHDFSPrincipal(Map conf) throws UnknownHostException {
        String[] components;
        String principal = (String)conf.get(BLOBSTORE_HDFS_PRINCIPAL);
        if (principal != null && (components = principal.split("[/@]")).length == 3 && components[1].equals(HOSTNAME_PATTERN)) {
            principal = components[0] + "/" + Utils.localHostname() + "@" + components[2];
        }
        return principal;
    }
}

