/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionQueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed #BFBFBF";
    static final String Q_OVER = "background:#FFA333";
    static final String Q_UNDER = "background:#5BD75B";
    static final String ACTIVE_USER = "background:#FFFF00";

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'Queue: root') q = '';", "    else {", "      q = q.substr(q.lastIndexOf(':') + 2);", "      q = '^' + q.substr(q.lastIndexOf('.') + 1) + '$';", "    }", "    $('#apps').dataTable().fnFilter(q, 4, true);", "  });", "  $('#cs').show();", "});"})._())._(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return StringUtils.formatPercent((double)f, (int)1);
    }

    static String width(float f) {
        return StringUtils.format((String)"width:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    static String left(float f) {
        return StringUtils.format((String)"left:%.1f%%", (Object[])new Object[]{Float.valueOf(f * 100.0f)});
    }

    public static class HealthBlock
    extends HtmlBlock {
        final CapacityScheduler cs;

        @Inject
        HealthBlock(ResourceManager rm) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
        }

        public void render(HtmlBlock.Block html) {
            SchedulerHealth healthInfo = this.cs.getSchedulerHealth();
            Hamlet.DIV div = html.div("#health");
            div.h4("Aggregate scheduler counts");
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#lastrun").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Total Container Allocations(count)"})._()).th().$class("ui-state-default")._(new Object[]{"Total Container Releases(count)"})._()).th().$class("ui-state-default")._(new Object[]{"Total Fulfilled Reservations(count)"})._()).th().$class("ui-state-default")._(new Object[]{"Total Container Preemptions(count)"})._())._())._()).tbody();
            ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(String.valueOf(this.cs.getRootQueueMetrics().getAggregateAllocatedContainers())).td(String.valueOf(this.cs.getRootQueueMetrics().getAggegatedReleasedContainers())).td(healthInfo.getAggregateFulFilledReservationsCount().toString()).td(healthInfo.getAggregatePreemptionCount().toString())._())._())._();
            div.h4("Last scheduler run");
            tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table("#lastrun").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Time"})._()).th().$class("ui-state-default")._(new Object[]{"Allocations(count - resources)"})._()).th().$class("ui-state-default")._(new Object[]{"Reservations(count - resources)"})._()).th().$class("ui-state-default")._(new Object[]{"Releases(count - resources)"})._())._())._()).tbody();
            ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(Times.format((long)healthInfo.getLastSchedulerRunTime())).td(healthInfo.getAllocationCount().toString() + " - " + healthInfo.getResourcesAllocated().toString()).td(healthInfo.getReservationCount().toString() + " - " + healthInfo.getResourcesReserved().toString()).td(healthInfo.getReleaseCount().toString() + " - " + healthInfo.getResourcesReleased().toString())._())._())._();
            HashMap<String, SchedulerHealth.DetailedInformation> info = new HashMap<String, SchedulerHealth.DetailedInformation>();
            info.put("Allocation", healthInfo.getLastAllocationDetails());
            info.put("Reservation", healthInfo.getLastReservationDetails());
            info.put("Release", healthInfo.getLastReleaseDetails());
            info.put("Preemption", healthInfo.getLastPreemptionDetails());
            for (Map.Entry entry : info.entrySet()) {
                String containerId = "N/A";
                String nodeId = "N/A";
                String queue = "N/A";
                String table = "#" + (String)entry.getKey();
                div.h4("Last " + (String)entry.getKey());
                tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.table(table).thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Time"})._()).th().$class("ui-state-default")._(new Object[]{"Container Id"})._()).th().$class("ui-state-default")._(new Object[]{"Node Id"})._()).th().$class("ui-state-default")._(new Object[]{"Queue"})._())._())._()).tbody();
                SchedulerHealth.DetailedInformation di = (SchedulerHealth.DetailedInformation)entry.getValue();
                if (di.getTimestamp() != 0L) {
                    if (di.getContainerId() != null) {
                        containerId = di.getContainerId().toString();
                    }
                    if (di.getNodeId() != null) {
                        nodeId = di.getNodeId().toString();
                    }
                    queue = di.getQueue();
                }
                ((Hamlet.TABLE)((Hamlet.TBODY)tbody.$class("ui-widget-content").tr().td(Times.format((long)di.getTimestamp())).td(containerId).td(nodeId).td(queue)._())._())._();
            }
            div._();
        }
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final CSQInfo csqinfo;
        private final ResourceManager rm;
        private List<RMNodeLabel> nodeLabelsInfo;

        @Inject
        QueuesBlock(ResourceManager rm, CSQInfo info) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.csqinfo = info;
            this.rm = rm;
            RMNodeLabelsManager nodeLabelManager = rm.getRMContext().getNodeLabelManager();
            this.nodeLabelsInfo = nodeLabelManager.pullRMNodeLabelsInfo();
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            UserGroupInformation callerUGI = this.getCallerUGI();
            boolean isAdmin = false;
            ApplicationACLsManager aclsManager = this.rm.getApplicationACLsManager();
            if (aclsManager.areACLsEnabled()) {
                if (callerUGI != null && aclsManager.isAdmin(callerUGI)) {
                    isAdmin = true;
                }
            } else {
                isAdmin = true;
            }
            if (isAdmin) {
                ((Hamlet.DIV)((Hamlet.SELECT)((Hamlet.SELECT)((Hamlet.SELECT)((Hamlet.DIV)html.div().button().$style("border-style: solid; border-color: #000000; border-width: 1px; cursor: hand; cursor: pointer; border-radius: 4px").$onclick("confirmAction()").b("Dump scheduler logs")._()).select().$id("time").option().$value("60")._(new Object[]{"1 min"})._()).option().$value("300")._(new Object[]{"5 min"})._()).option().$value("600")._(new Object[]{"10 min"})._())._())._();
                StringBuilder script = new StringBuilder();
                script.append("function confirmAction() {").append(" b = confirm(\"Are you sure you wish to generate scheduler logs?\");").append(" if (b == true) {").append(" var timePeriod = $(\"#time\").val();").append(" $.ajax({").append(" type: 'POST',").append(" url: '/ws/v1/cluster/scheduler/logs',").append(" contentType: 'text/plain',").append(" data: 'time=' + timePeriod,").append(" dataType: 'text'").append(" }).done(function(data){").append(" setTimeout(function(){").append(" alert(\"Scheduler log is being generated.\");").append(" }, 1000);").append(" }).fail(function(data){").append(" alert(\"Scheduler log generation failed. Please check the ResourceManager log for more informtion.\");").append(" console.log(data);").append(" });").append(" }").append("}");
                html.script().$type("text/javascript")._(new Object[]{script.toString()})._();
            }
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"Application Queues"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                CapacitySchedulerInfo sinfo;
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold")._(new Object[]{"Legend:"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_GIVEN)._(new Object[]{"Capacity"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_UNDER)._(new Object[]{"Used"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_OVER)._(new Object[]{"Used (over capacity)"})._()).span().$class("qlegend ui-corner-all ui-state-default")._(new Object[]{"Max Capacity"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.ACTIVE_USER)._(new Object[]{"Users Requesting Resources"})._())._();
                float used = 0.0f;
                CSQueue root = this.cs.getRootQueue();
                this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root, this.cs);
                boolean hasAnyLabelLinkedToNM = false;
                if (null != this.nodeLabelsInfo) {
                    for (RMNodeLabel label : this.nodeLabelsInfo) {
                        if (label.getLabelName().length() == 0 || label.getNumActiveNMs() <= 0) continue;
                        hasAnyLabelLinkedToNM = true;
                        break;
                    }
                }
                if (!hasAnyLabelLinkedToNM) {
                    used = sinfo.getUsedCapacity() / 100.0f;
                    ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "Queue: root")._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._();
                } else {
                    for (RMNodeLabel label : this.nodeLabelsInfo) {
                        this.csqinfo.qinfo = null;
                        this.csqinfo.label = label.getLabelName();
                        this.csqinfo.isExclusiveNodeLabel = label.getIsExclusive();
                        String nodeLabelDisplay = this.csqinfo.label.length() == 0 ? "<DEFAULT_PARTITION>" : this.csqinfo.label;
                        PartitionQueueCapacitiesInfo capacities = sinfo.getCapacities().getPartitionQueueCapacitiesInfo(this.csqinfo.label);
                        used = capacities.getUsedCapacity() / 100.0f;
                        String partitionUiTag = "Partition: " + nodeLabelDisplay + " " + label.getResource();
                        ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", partitionUiTag)._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._();
                        Hamlet.UL underLabel = html.ul("#pq");
                        ((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.A)underLabel.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "Queue: root")._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._())._();
                    }
                }
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(RMAppsBlock.class);
            html._(HealthBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final CSQInfo csqinfo;

        @Inject
        QueueBlock(CSQInfo info) {
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            ArrayList<CapacitySchedulerQueueInfo> subQueues = this.csqinfo.qinfo == null ? this.csqinfo.csinfo.getQueues().getQueueInfoList() : this.csqinfo.qinfo.getQueues().getQueueInfoList();
            Hamlet.UL ul = html.ul("#pq");
            for (CapacitySchedulerQueueInfo info : subQueues) {
                String nodeLabel;
                String string = nodeLabel = this.csqinfo.label == null ? "" : this.csqinfo.label;
                if (!nodeLabel.isEmpty() && this.csqinfo.isExclusiveNodeLabel && !info.getNodeLabels().contains("*") && !info.getNodeLabels().contains(nodeLabel)) continue;
                PartitionQueueCapacitiesInfo partitionQueueCapsInfo = info.getCapacities().getPartitionQueueCapacitiesInfo(nodeLabel);
                float used = partitionQueueCapsInfo.getUsedCapacity() / 100.0f;
                float absCap = partitionQueueCapsInfo.getAbsoluteCapacity() / 100.0f;
                float absMaxCap = partitionQueueCapsInfo.getAbsoluteMaxCapacity() / 100.0f;
                float absUsedCap = partitionQueueCapsInfo.getAbsoluteUsedCapacity() / 100.0f;
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(absMaxCap * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"Absolute Capacity:", CapacitySchedulerPage.percent(absCap)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_GIVEN, ";font-size:1px;", CapacitySchedulerPage.width(absCap / absMaxCap)}))._(new Object[]{Character.valueOf('.')})._()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(absUsedCap / absMaxCap), ";font-size:1px;left:0%;", absUsedCap > absCap ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{Character.valueOf('.')})._()).span(".q", "Queue: " + info.getQueuePath().substring(5))._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._();
                this.csqinfo.qinfo = info;
                if (info.getQueues() == null) {
                    ((Hamlet.UL)li.ul("#lq").li()._(LeafQueueInfoBlock.class)._())._();
                    ((Hamlet.UL)li.ul("#lq").li()._(QueueUsersInfoBlock.class)._())._();
                } else {
                    li._(QueueBlock.class);
                }
                li._();
            }
            ul._();
        }
    }

    static class QueueUsersInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;
        private String nodeLabel;

        @Inject
        QueueUsersInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
            this.nodeLabel = info.label;
        }

        protected void render(HtmlBlock.Block html) {
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)html.table("#userinfo").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"User Name"})._()).th().$class("ui-state-default")._(new Object[]{"Max Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Weight"})._()).th().$class("ui-state-default")._(new Object[]{"Used Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Max AM Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Used AM Resource"})._()).th().$class("ui-state-default")._(new Object[]{"Schedulable Apps"})._()).th().$class("ui-state-default")._(new Object[]{"Non-Schedulable Apps"})._())._())._()).tbody();
            PartitionResourcesInfo queueUsageResources = this.lqinfo.getResources().getPartitionResourceUsageInfo(this.nodeLabel == null ? "" : this.nodeLabel);
            ArrayList<UserInfo> users = this.lqinfo.getUsers().getUsersList();
            for (UserInfo userInfo : users) {
                ResourceInfo amUsed;
                ResourceInfo resourcesUsed = userInfo.getResourcesUsed();
                ResourceInfo userAMLimitPerPartition = queueUsageResources.getUserAmLimit();
                if (userAMLimitPerPartition == null) {
                    userAMLimitPerPartition = queueUsageResources.getAMLimit();
                }
                if ((double)userInfo.getUserWeight() != 1.0) {
                    userAMLimitPerPartition = new ResourceInfo(Resources.multiply((Resource)userAMLimitPerPartition.getResource(), (double)userInfo.getUserWeight()));
                }
                if (this.nodeLabel != null) {
                    resourcesUsed = userInfo.getResourceUsageInfo().getPartitionResourceUsageInfo(this.nodeLabel).getUsed();
                }
                if ((amUsed = userInfo.getAMResourcesUsed()) == null) {
                    amUsed = new ResourceInfo(Resources.none());
                }
                String highlightIfAsking = userInfo.getIsActive() ? CapacitySchedulerPage.ACTIVE_USER : null;
                tbody.tr().$style(highlightIfAsking).td(userInfo.getUsername()).td(userInfo.getUserResourceLimit().toString()).td(String.valueOf(userInfo.getUserWeight())).td(resourcesUsed.toString()).td(userAMLimitPerPartition.toString()).td(amUsed.toString()).td(Integer.toString(userInfo.getNumActiveApplications())).td(Integer.toString(userInfo.getNumPendingApplications()))._();
            }
            html.div().$class("usersinfo").h5("Active Users Info")._();
            ((Hamlet.TABLE)tbody._())._();
        }
    }

    static class LeafQueueInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;
        private String nodeLabel;

        @Inject
        LeafQueueInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
            this.nodeLabel = info.label;
        }

        protected void render(HtmlBlock.Block html) {
            if (this.nodeLabel == null) {
                this.renderLeafQueueInfoWithoutParition(html);
            } else {
                this.renderLeafQueueInfoWithPartition(html);
            }
        }

        private void renderLeafQueueInfoWithPartition(HtmlBlock.Block html) {
            String nodeLabelDisplay = this.nodeLabel.length() == 0 ? "<DEFAULT_PARTITION>" : this.nodeLabel;
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status for Partition '" + nodeLabelDisplay + "'");
            this.renderQueueCapacityInfo(ri, this.nodeLabel);
            html._(InfoBlock.class);
            ri.clear();
            ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status")._("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderCommonLeafQueueInfo(ri);
            html._(InfoBlock.class);
            ri.clear();
        }

        private void renderLeafQueueInfoWithoutParition(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status")._("Queue State:", (Object)this.lqinfo.getQueueState());
            this.renderQueueCapacityInfo(ri, "");
            this.renderCommonLeafQueueInfo(ri);
            html._(InfoBlock.class);
            ri.clear();
        }

        private void renderQueueCapacityInfo(ResponseInfo ri, String label) {
            PartitionQueueCapacitiesInfo capacities = this.lqinfo.getCapacities().getPartitionQueueCapacitiesInfo(label);
            PartitionResourcesInfo resourceUsages = this.lqinfo.getResources().getPartitionResourceUsageInfo(label);
            ResourceInfo userAMResourceLimit = null;
            ArrayList<UserInfo> usersList = this.lqinfo.getUsers().getUsersList();
            if (!usersList.isEmpty()) {
                userAMResourceLimit = resourceUsages.getUserAmLimit();
            }
            if (userAMResourceLimit == null) {
                userAMResourceLimit = resourceUsages.getAMLimit();
            }
            ResourceInfo amUsed = resourceUsages.getAmUsed() == null ? new ResourceInfo(Resources.none()) : resourceUsages.getAmUsed();
            ri._("Used Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getUsedCapacity() / 100.0f))._("Configured Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getCapacity() / 100.0f))._("Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getMaxCapacity() / 100.0f))._("Absolute Used Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteUsedCapacity() / 100.0f))._("Absolute Configured Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteCapacity() / 100.0f))._("Absolute Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(capacities.getAbsoluteMaxCapacity() / 100.0f))._("Used Resources:", (Object)resourceUsages.getUsed().toString())._("Configured Max Application Master Limit:", (Object)StringUtils.format((String)"%.1f", (Object[])new Object[]{Float.valueOf(capacities.getMaxAMLimitPercentage())}))._("Max Application Master Resources:", (Object)resourceUsages.getAMLimit().toString())._("Used Application Master Resources:", (Object)amUsed.toString())._("Max Application Master Resources Per User:", (Object)userAMResourceLimit.toString());
        }

        private void renderCommonLeafQueueInfo(ResponseInfo ri) {
            ri._("Num Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumActiveApplications()))._("Num Non-Schedulable Applications:", (Object)Integer.toString(this.lqinfo.getNumPendingApplications()))._("Num Containers:", (Object)Integer.toString(this.lqinfo.getNumContainers()))._("Max Applications:", (Object)Integer.toString(this.lqinfo.getMaxApplications()))._("Max Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxApplicationsPerUser()))._("Configured Minimum User Limit Percent:", (Object)(Integer.toString(this.lqinfo.getUserLimit()) + "%"))._("Configured User Limit Factor:", (Object)Float.valueOf(this.lqinfo.getUserLimitFactor()))._("Accessible Node Labels:", (Object)StringUtils.join((CharSequence)",", this.lqinfo.getNodeLabels()))._("Ordering Policy: ", (Object)this.lqinfo.getOrderingPolicyInfo())._("Preemption:", (Object)(this.lqinfo.getPreemptionDisabled() ? "disabled" : "enabled"))._("Intra-queue Preemption:", (Object)(this.lqinfo.getIntraQueuePreemptionDisabled() ? "disabled" : "enabled"))._("Default Node Label Expression:", (Object)(this.lqinfo.getDefaultNodeLabelExpression() == null ? "<DEFAULT_PARTITION>" : this.lqinfo.getDefaultNodeLabelExpression()))._("Default Application Priority:", (Object)Integer.toString(this.lqinfo.getDefaultApplicationPriority()));
        }
    }

    @RequestScoped
    static class CSQInfo {
        CapacitySchedulerInfo csinfo;
        CapacitySchedulerQueueInfo qinfo;
        String label;
        boolean isExclusiveNodeLabel;

        CSQInfo() {
        }
    }
}

