/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractContainerAllocator {
    private static final Log LOG = LogFactory.getLog(AbstractContainerAllocator.class);
    FiCaSchedulerApp application;
    final ResourceCalculator rc;
    final RMContext rmContext;

    public AbstractContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext) {
        this.application = application;
        this.rc = rc;
        this.rmContext = rmContext;
    }

    protected CSAssignment getCSAssignmentFromAllocateResult(Resource clusterResource, ContainerAllocation result, RMContainer rmContainer) {
        CSAssignment.SkippedType skipped = result.getAllocationState() == AllocationState.APP_SKIPPED ? CSAssignment.SkippedType.OTHER : CSAssignment.SkippedType.NONE;
        CSAssignment assignment = new CSAssignment(skipped);
        assignment.setApplication(this.application);
        assignment.setExcessReservation(result.getContainerToBeUnreserved());
        if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)result.getResourceToBeAllocated(), (Resource)Resources.none())) {
            Resource allocatedResource = result.getResourceToBeAllocated();
            Container updatedContainer = result.getUpdatedContainer();
            assignment.setResource(allocatedResource);
            assignment.setType(result.getContainerNodeType());
            if (result.getAllocationState() == AllocationState.RESERVED) {
                LOG.info((Object)("Reserved container  application=" + this.application.getApplicationId() + " resource=" + allocatedResource + " queue=" + this.toString() + " cluster=" + clusterResource));
                assignment.getAssignmentInformation().addReservationDetails(updatedContainer.getId(), this.application.getCSLeafQueue().getQueuePath());
                assignment.getAssignmentInformation().incrReservations();
                Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)allocatedResource);
            } else if (result.getAllocationState() == AllocationState.ALLOCATED) {
                RMContainer allocatedContainer = this.application.getRMContainer(updatedContainer.getId());
                if (allocatedContainer == null) {
                    LOG.warn((Object)("Allocated container for containerId " + updatedContainer.getId() + " is null."));
                }
                LOG.info((Object)("assignedContainer application attempt=" + this.application.getApplicationAttemptId() + " container=" + updatedContainer.getId() + " queue=" + this + " clusterResource=" + clusterResource + " type=" + (Object)((Object)assignment.getType()) + " requestedPartition=" + (allocatedContainer == null ? "null" : allocatedContainer.getNodeLabelExpression())));
                this.application.getCSLeafQueue().getOrderingPolicy().containerAllocated(this.application, allocatedContainer);
                assignment.getAssignmentInformation().addAllocationDetails(updatedContainer.getId(), this.application.getCSLeafQueue().getQueuePath());
                assignment.getAssignmentInformation().incrAllocations();
                Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)allocatedResource);
                if (rmContainer != null) {
                    assignment.setFulfilledReservation(true);
                }
            }
            assignment.setContainersToKill(result.getToKillContainers());
        } else if (result.getAllocationState() == AllocationState.QUEUE_SKIPPED) {
            assignment.setSkippedType(CSAssignment.SkippedType.QUEUE_LIMIT);
        }
        return assignment;
    }

    public abstract CSAssignment assignContainers(Resource var1, FiCaSchedulerNode var2, SchedulingMode var3, ResourceLimits var4, RMContainer var5);
}

