/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class StageAllocatorLowCostAligned
implements StageAllocator {
    private int smoothnessFactor = 10;

    public StageAllocatorLowCostAligned() {
    }

    public StageAllocatorLowCostAligned(int smoothnessFactor) {
        this.smoothnessFactor = smoothnessFactor;
    }

    @Override
    public Map<ReservationInterval, Resource> computeStageAllocation(Plan plan, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, ReservationRequest rr, long stageEarliestStart, long stageDeadline, String user, ReservationId oldId) {
        int remainingGangs;
        int numGangsToAllocate;
        ResourceCalculator resCalc = plan.getResourceCalculator();
        Resource capacity = plan.getTotalCapacity();
        long step = plan.getStep();
        RLESparseResourceAllocation allocationRequests = new RLESparseResourceAllocation(plan.getResourceCalculator());
        long duration = StageAllocatorLowCostAligned.stepRoundUp(rr.getDuration(), step);
        int windowSizeInDurations = (int)((stageDeadline - stageEarliestStart) / duration);
        int totalGangs = rr.getNumContainers() / rr.getConcurrency();
        int numContainersPerGang = rr.getConcurrency();
        Resource gang = Resources.multiply((Resource)rr.getCapability(), (double)numContainersPerGang);
        int maxGangsPerUnit = (int)Math.max(Math.floor((double)totalGangs / (double)windowSizeInDurations), 1.0);
        maxGangsPerUnit = Math.max(maxGangsPerUnit / this.smoothnessFactor, 1);
        if (windowSizeInDurations <= 0) {
            return null;
        }
        TreeSet<DurationInterval> durationIntervalsSortedByCost = new TreeSet<DurationInterval>(new Comparator<DurationInterval>(){

            @Override
            public int compare(DurationInterval val1, DurationInterval val2) {
                int cmp = Double.compare(val1.getTotalCost(), val2.getTotalCost());
                if (cmp != 0) {
                    return cmp;
                }
                return -1 * Long.compare(val1.getEndTime(), val2.getEndTime());
            }
        });
        for (long intervalEnd = stageDeadline; intervalEnd >= stageEarliestStart + duration; intervalEnd -= duration) {
            long intervalStart = intervalEnd - duration;
            DurationInterval durationInterval = this.getDurationInterval(intervalStart, intervalEnd, planLoads, planModifications, capacity, resCalc, step);
            if (!durationInterval.canAllocate(gang, capacity, resCalc)) continue;
            durationIntervalsSortedByCost.add(durationInterval);
        }
        for (remainingGangs = totalGangs; remainingGangs > 0 && !durationIntervalsSortedByCost.isEmpty(); remainingGangs -= numGangsToAllocate) {
            DurationInterval bestDurationInterval = durationIntervalsSortedByCost.first();
            numGangsToAllocate = Math.min(maxGangsPerUnit, remainingGangs);
            numGangsToAllocate = Math.min(numGangsToAllocate, bestDurationInterval.numCanFit(gang, capacity, resCalc));
            ReservationInterval reservationInt = new ReservationInterval(bestDurationInterval.getStartTime(), bestDurationInterval.getEndTime());
            Resource reservationRes = Resources.multiply((Resource)rr.getCapability(), (double)(rr.getConcurrency() * numGangsToAllocate));
            planModifications.addInterval(reservationInt, reservationRes);
            allocationRequests.addInterval(reservationInt, reservationRes);
            durationIntervalsSortedByCost.remove(bestDurationInterval);
            DurationInterval updatedDurationInterval = this.getDurationInterval(bestDurationInterval.getStartTime(), bestDurationInterval.getStartTime() + duration, planLoads, planModifications, capacity, resCalc, step);
            if (!updatedDurationInterval.canAllocate(gang, capacity, resCalc)) continue;
            durationIntervalsSortedByCost.add(updatedDurationInterval);
        }
        Map<ReservationInterval, Resource> allocations = allocationRequests.toIntervalMap();
        if (remainingGangs <= 0) {
            return allocations;
        }
        for (Map.Entry<ReservationInterval, Resource> tempAllocation : allocations.entrySet()) {
            planModifications.removeInterval(tempAllocation.getKey(), tempAllocation.getValue());
        }
        return null;
    }

    protected DurationInterval getDurationInterval(long startTime, long endTime, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc, long step) {
        Resource dominantResources = Resource.newInstance((int)0, (int)0);
        double totalCost = 0.0;
        for (long t = startTime; t < endTime; t += step) {
            Resource load = this.getLoadAtTime(t, planLoads, planModifications);
            totalCost += this.calcCostOfLoad(load, capacity, resCalc);
            dominantResources = Resources.componentwiseMax((Resource)dominantResources, (Resource)load);
        }
        return new DurationInterval(startTime, endTime, totalCost, dominantResources);
    }

    protected double calcCostOfInterval(long startTime, long endTime, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc, long step) {
        double totalCost = 0.0;
        for (long t = startTime; t < endTime; t += step) {
            totalCost += this.calcCostOfTimeSlot(t, planLoads, planModifications, capacity, resCalc);
        }
        return totalCost;
    }

    protected double calcCostOfTimeSlot(long t, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, Resource capacity, ResourceCalculator resCalc) {
        Resource load = this.getLoadAtTime(t, planLoads, planModifications);
        return this.calcCostOfLoad(load, capacity, resCalc);
    }

    protected Resource getLoadAtTime(long t, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications) {
        Resource planLoad = planLoads.get(t);
        planLoad = planLoad == null ? Resource.newInstance((int)0, (int)0) : planLoad;
        return Resources.add((Resource)planLoad, (Resource)planModifications.getCapacityAtTime(t));
    }

    protected double calcCostOfLoad(Resource load, Resource capacity, ResourceCalculator resCalc) {
        return resCalc.ratio(load, capacity);
    }

    protected static long stepRoundDown(long t, long step) {
        return t / step * step;
    }

    protected static long stepRoundUp(long t, long step) {
        return (t + step - 1L) / step * step;
    }

    protected static class DurationInterval {
        private long startTime;
        private long endTime;
        private double cost;
        private Resource maxLoad;

        public DurationInterval(long startTime, long endTime, double cost, Resource maxLoad) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.cost = cost;
            this.maxLoad = maxLoad;
        }

        public boolean canAllocate(Resource requestedResources, Resource capacity, ResourceCalculator resCalc) {
            Resource updatedMaxLoad = Resources.add((Resource)this.maxLoad, (Resource)requestedResources);
            return resCalc.compare(capacity, updatedMaxLoad, capacity) <= 0;
        }

        public int numCanFit(Resource requestedResources, Resource capacity, ResourceCalculator resCalc) {
            Resource availableResources = Resources.subtract((Resource)capacity, (Resource)this.maxLoad);
            return (int)Math.floor(Resources.divide((ResourceCalculator)resCalc, (Resource)capacity, (Resource)availableResources, (Resource)requestedResources));
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long value) {
            this.startTime = value;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long value) {
            this.endTime = value;
        }

        public Resource getMaxLoad() {
            return this.maxLoad;
        }

        public void setMaxLoad(Resource value) {
            this.maxLoad = value;
        }

        public double getTotalCost() {
            return this.cost;
        }

        public void setTotalCost(double value) {
            this.cost = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" start: " + this.startTime).append(" end: " + this.endTime).append(" cost: " + this.cost).append(" maxLoad: " + this.maxLoad);
            return sb.toString();
        }
    }
}

