/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui.exceptionmappers;

import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.storm.daemon.common.JsonResponseBuilder;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.generated.AuthorizationException;

public class ExceptionMapperUtils {
    public static Response getResponse(Exception ex, Response.Status responseStatus, Provider<HttpServletRequest> request) {
        String callback = null;
        if (((HttpServletRequest)request.get()).getParameterMap().containsKey("callback")) {
            callback = String.valueOf(((HttpServletRequest)request.get()).getParameterMap().get("callback"));
        }
        return new JsonResponseBuilder().setData(UIHelpers.exceptionToJson(ex, responseStatus.getStatusCode())).setCallback(callback).setStatus(responseStatus.getStatusCode()).build();
    }

    public static Response getResponse(AuthorizationException ex, Provider<HttpServletRequest> request) {
        return ExceptionMapperUtils.getResponse((Exception)ex, Response.Status.UNAUTHORIZED, request);
    }

    public static Response getResponse(Exception ex, Provider<HttpServletRequest> request) {
        return ExceptionMapperUtils.getResponse(ex, Response.Status.INTERNAL_SERVER_ERROR, request);
    }
}

