/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.utils;

import com.codahale.metrics.Meter;
import com.google.common.io.ByteStreams;
import j2html.TagCreator;
import j2html.tags.DomContent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.storm.daemon.common.JsonResponseBuilder;
import org.apache.storm.daemon.ui.UIHelpers;

public class LogviewerResponseBuilder {
    private LogviewerResponseBuilder() {
    }

    public static Response buildSuccessHtmlResponse(String content) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)content).type(MediaType.TEXT_HTML_TYPE).build();
    }

    public static Response buildSuccessJsonResponse(Object entity, String callback, String origin) {
        return new JsonResponseBuilder().setData(entity).setCallback(callback).setHeaders(LogviewerResponseBuilder.getHeadersForSuccessResponse(origin)).build();
    }

    public static Response buildDownloadFile(String contentDispositionName, File file, Meter numFileDownloadExceptions) throws IOException {
        try {
            InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)LogviewerResponseBuilder.wrapWithStreamingOutput(is)).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename=\"" + contentDispositionName + "\"")).build();
        }
        catch (IOException e) {
            numFileDownloadExceptions.mark();
            throw e;
        }
    }

    public static Response buildResponseUnauthorizedUser(String user) {
        String entity = LogviewerResponseBuilder.buildUnauthorizedUserHtml(user);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)entity).type(MediaType.TEXT_HTML_TYPE).build();
    }

    public static Response buildResponsePageNotFound() {
        return Response.status((int)404).entity((Object)"Page not found").type(MediaType.TEXT_HTML_TYPE).build();
    }

    public static Response buildUnauthorizedUserJsonResponse(String user, String callback) {
        return new JsonResponseBuilder().setData(UIHelpers.unauthorizedUserJson(user)).setCallback(callback).setStatus(403).build();
    }

    public static Response buildExceptionJsonResponse(Exception ex, String callback) {
        int statusCode = 500;
        return new JsonResponseBuilder().setData(UIHelpers.exceptionToJson(ex, statusCode)).setCallback(callback).setStatus(statusCode).build();
    }

    private static Map<String, Object> getHeadersForSuccessResponse(String origin) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Access-Control-Allow-Origin", origin);
        headers.put("Access-Control-Allow-Credentials", "true");
        return headers;
    }

    private static String buildUnauthorizedUserHtml(String user) {
        String content = "User '" + StringEscapeUtils.escapeHtml((String)user) + "' is not authorized.";
        return TagCreator.body((DomContent[])new DomContent[]{TagCreator.h2((String)content)}).render();
    }

    private static StreamingOutput wrapWithStreamingOutput(InputStream inputStream) {
        return os -> {
            OutputStream wrappedOutputStream = os;
            if (!(os instanceof BufferedOutputStream)) {
                wrappedOutputStream = new BufferedOutputStream(os);
            }
            ByteStreams.copy((InputStream)inputStream, (OutputStream)wrappedOutputStream);
            wrappedOutputStream.flush();
        };
    }
}

