/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.handler;

import com.codahale.metrics.Meter;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.logviewer.utils.LogviewerResponseBuilder;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.metric.StormMetricsRegistry;

public class LogviewerProfileHandler {
    public static final String WORKER_LOG_FILENAME = "worker.log";
    private final Meter numFileDownloadExceptions;
    private final Path logRoot;
    private final ResourceAuthorizer resourceAuthorizer;
    private final DirectoryCleaner directoryCleaner;

    public LogviewerProfileHandler(String logRoot, ResourceAuthorizer resourceAuthorizer, StormMetricsRegistry metricsRegistry) {
        this.logRoot = Paths.get(logRoot, new String[0]).toAbsolutePath().normalize();
        this.resourceAuthorizer = resourceAuthorizer;
        this.numFileDownloadExceptions = metricsRegistry.registerMeter("logviewer:num-file-download-exceptions");
        this.directoryCleaner = new DirectoryCleaner(metricsRegistry);
    }

    public Response listDumpFiles(String topologyId, String hostPort, String user) throws IOException {
        String portStr = hostPort.split(":")[1];
        Path rawDir = this.logRoot.resolve(topologyId).resolve(portStr);
        Path absDir = rawDir.toAbsolutePath().normalize();
        if (!absDir.startsWith(this.logRoot) || !rawDir.normalize().toString().equals(rawDir.toString())) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (absDir.toFile().exists()) {
            String workerFileRelativePath = String.join((CharSequence)File.separator, topologyId, portStr, WORKER_LOG_FILENAME);
            if (this.resourceAuthorizer.isUserAllowedToAccessFile(user, workerFileRelativePath)) {
                String content = this.buildDumpFileListPage(topologyId, hostPort, absDir.toFile());
                return LogviewerResponseBuilder.buildSuccessHtmlResponse(content);
            }
            return LogviewerResponseBuilder.buildResponseUnauthorizedUser(user);
        }
        return LogviewerResponseBuilder.buildResponsePageNotFound();
    }

    public Response downloadDumpFile(String topologyId, String hostPort, String fileName, String user) throws IOException {
        String[] hostPortSplit = hostPort.split(":");
        String host = hostPortSplit[0];
        String portStr = hostPortSplit[1];
        Path rawFile = this.logRoot.resolve(topologyId).resolve(portStr).resolve(fileName);
        Path absFile = rawFile.toAbsolutePath().normalize();
        if (!absFile.startsWith(this.logRoot) || !rawFile.normalize().toString().equals(rawFile.toString())) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (absFile.toFile().exists()) {
            String workerFileRelativePath = String.join((CharSequence)File.separator, topologyId, portStr, WORKER_LOG_FILENAME);
            if (this.resourceAuthorizer.isUserAllowedToAccessFile(user, workerFileRelativePath)) {
                String downloadedFileName = host + "-" + topologyId + "-" + portStr + "-" + absFile.getFileName();
                return LogviewerResponseBuilder.buildDownloadFile(downloadedFileName, absFile.toFile(), this.numFileDownloadExceptions);
            }
            return LogviewerResponseBuilder.buildResponseUnauthorizedUser(user);
        }
        return LogviewerResponseBuilder.buildResponsePageNotFound();
    }

    private String buildDumpFileListPage(String topologyId, String hostPort, File dir) throws IOException {
        List<DomContent> liTags = this.getProfilerDumpFiles(dir).stream().map(file -> TagCreator.li((DomContent[])new DomContent[]{TagCreator.a((String)file).withHref("/api/v1/dumps/" + topologyId + "/" + hostPort + "/" + file)})).collect(Collectors.toList());
        return TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)"File Dumps - Storm Log Viewer"), ((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref("/css/bootstrap-3.3.1.min.css"), ((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref("/css/jquery.dataTables.1.10.4.min.css"), ((EmptyTag)TagCreator.link().withRel("stylesheet")).withHref("/css/style.css")}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])liTags.toArray(new DomContent[0]))})}).render();
    }

    private List<String> getProfilerDumpFiles(File dir) throws IOException {
        List<Path> filesForDir = this.directoryCleaner.getFilesForDir(dir.toPath());
        return filesForDir.stream().map(path -> path.toFile()).filter(file -> {
            String fileName = file.getName();
            return StringUtils.isNotEmpty((String)fileName) && (fileName.endsWith(".txt") || fileName.endsWith(".jfr") || fileName.endsWith(".bin"));
        }).map(File::getName).collect(Collectors.toList());
    }
}

