/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.StormSubmitter;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.ClusterSummary;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(UploadCredentials.class);

    public static void main(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("f", "file", null).opt("u", "user", null).arg("topologyName", CLI.FIRST_WINS).optionalArg("rawCredentials", CLI.INTO_LIST).parse(args);
        String credentialFile = (String)cl.get("f");
        List rawCredentials = (List)cl.get("rawCredentials");
        String topologyName = (String)cl.get("topologyName");
        if (null != rawCredentials && rawCredentials.size() % 2 != 0) {
            throw new RuntimeException("Need an even number of arguments to make a map");
        }
        HashMap<String, String> credentialsMap = new HashMap<String, String>();
        if (null != credentialFile) {
            Properties credentialProps = new Properties();
            credentialProps.load(new FileReader(credentialFile));
            for (Map.Entry<Object, Object> credentialProp : credentialProps.entrySet()) {
                credentialsMap.put((String)credentialProp.getKey(), (String)credentialProp.getValue());
            }
        }
        if (null != rawCredentials) {
            for (int i = 0; i < rawCredentials.size(); i += 2) {
                credentialsMap.put((String)rawCredentials.get(i), (String)rawCredentials.get(i + 1));
            }
        }
        Map topologyConf = new HashMap();
        try (NimbusClient nc = NimbusClient.getConfiguredClient(new HashMap());){
            Nimbus.Iface client = nc.getClient();
            ClusterSummary summary = client.getClusterInfo();
            for (TopologySummary topo : summary.get_topologies()) {
                if (!topologyName.equals(topo.get_name())) continue;
                String topologyId = topo.get_id();
                topologyConf = (Map)JSONValue.parse((String)client.getTopologyConf(topologyId));
                LOG.info("Using topology conf from {} as basis for getting new creds", (Object)topologyId);
                Map commandLine = Utils.readCommandLineOpts();
                List clCreds = (List)commandLine.get("topology.auto-credentials");
                List topoCreds = (List)topologyConf.get("topology.auto-credentials");
                if (clCreds != null) {
                    HashSet extra = new HashSet(clCreds);
                    if (topoCreds != null) {
                        extra.removeAll(topoCreds);
                    }
                    if (!extra.isEmpty()) {
                        LOG.warn("The topology {} is not using {} but they were included here.", (Object)topologyId, extra);
                    }
                    if (topoCreds != null) {
                        HashSet missing = new HashSet(topoCreds);
                        missing.removeAll(clCreds);
                        if (!missing.isEmpty()) {
                            LOG.warn("The topology {} is using {} but they were not included here.", (Object)topologyId, missing);
                        }
                    }
                }
                break;
            }
        }
        topologyConf.remove("java.security.auth.login.config");
        StormSubmitter.pushCredentials((String)topologyName, topologyConf, credentialsMap, (String)((String)cl.get("u")));
        LOG.info("Uploaded new creds to topology: {}", (Object)topologyName);
    }
}

