/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.List;
import java.util.Map;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.utils.NimbusClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillTopology {
    private static final Logger LOG = LoggerFactory.getLogger(KillTopology.class);

    public static void main(String[] args) throws Exception {
        Map<String, Object> cl = CLI.opt("w", "wait", null, CLI.AS_INT).arg("TOPO", CLI.INTO_LIST).parse(args);
        final List names = (List)cl.get("TOPO");
        Integer wait = (Integer)cl.get("w");
        final KillOptions opts = new KillOptions();
        if (wait != null) {
            opts.set_wait_secs(wait.intValue());
        }
        NimbusClient.withConfiguredClient((NimbusClient.WithNimbus)new NimbusClient.WithNimbus(){

            public void run(Nimbus.Iface nimbus) throws Exception {
                for (String name : names) {
                    nimbus.killTopologyWithOpts(name, opts);
                    LOG.info("Killed topology: {}", (Object)name);
                }
            }
        });
    }
}

