/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.ErrorInfo;
import org.apache.storm.generated.GetInfoOptions;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NumErrorsChoice;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.json.simple.JSONValue;

public class GetErrors {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("Topology name must be provided.");
        }
        final String name = args[0];
        NimbusClient.withConfiguredClient((NimbusClient.WithNimbus)new NimbusClient.WithNimbus(){

            public void run(Nimbus.Iface client) throws Exception {
                GetInfoOptions opts = new GetInfoOptions();
                opts.set_num_err_choice(NumErrorsChoice.ONE);
                String topologyId = Utils.getTopologyId((String)name, (Nimbus.Iface)client);
                TopologyInfo topologyInfo = null;
                if (topologyId != null) {
                    topologyInfo = client.getTopologyInfoWithOpts(topologyId, opts);
                }
                HashMap<String, Object> outputMap = new HashMap<String, Object>();
                if (topologyId == null || topologyInfo == null) {
                    outputMap.put("Failure", "No topologies running with name " + name);
                } else {
                    String topologyName = topologyInfo.get_name();
                    Map topologyErrors = topologyInfo.get_errors();
                    outputMap.put("Topology Name", topologyName);
                    outputMap.put("Comp-Errors", this.getComponentErrors(topologyErrors));
                }
                System.out.println(JSONValue.toJSONString(outputMap));
            }

            private Map<String, String> getComponentErrors(Map<String, List<ErrorInfo>> topologyErrors) {
                HashMap<String, String> componentErrorMap = new HashMap<String, String>();
                for (Map.Entry<String, List<ErrorInfo>> compNameToCompErrors : topologyErrors.entrySet()) {
                    String compName = compNameToCompErrors.getKey();
                    List<ErrorInfo> compErrors = compNameToCompErrors.getValue();
                    if (compErrors == null || compErrors.isEmpty()) continue;
                    ErrorInfo latestError = compErrors.get(0);
                    componentErrorMap.put(compName, latestError.get_error());
                }
                return componentErrorMap;
            }
        });
    }
}

