/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SingleTopologyCluster;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RAS_Nodes;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.priority.ISchedulingPriorityStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.apache.storm.scheduler.utils.ConfigLoaderFactoryService;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.shade.com.google.common.collect.ImmutableList;
import org.apache.storm.utils.DisallowedStrategyException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAwareScheduler
implements IScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAwareScheduler.class);
    private Map<String, Object> conf;
    private ISchedulingPriorityStrategy schedulingPriorityStrategy;
    private IConfigLoader configLoader;
    private int maxSchedulingAttempts;
    private int schedulingTimeoutSeconds;
    private ExecutorService backgroundScheduling;

    private static void markFailedTopology(User u, Cluster c, TopologyDetails td, String message) {
        ResourceAwareScheduler.markFailedTopology(u, c, td, message, null);
    }

    private static void markFailedTopology(User u, Cluster c, TopologyDetails td, String message, Throwable t) {
        c.setStatus(td, message);
        String realMessage = td.getId() + " " + message;
        if (t != null) {
            LOG.error(realMessage, t);
        } else {
            LOG.error(realMessage);
        }
        u.markTopoUnsuccess(td);
    }

    private static double getCpuUsed(SchedulerAssignment assignment) {
        return assignment.getScheduledResources().values().stream().mapToDouble(wr -> wr.get_cpu()).sum();
    }

    private static double getMemoryUsed(SchedulerAssignment assignment) {
        return assignment.getScheduledResources().values().stream().mapToDouble(wr -> wr.get_mem_on_heap() + wr.get_mem_off_heap()).sum();
    }

    @Override
    public void prepare(Map<String, Object> conf) {
        this.conf = conf;
        this.schedulingPriorityStrategy = (ISchedulingPriorityStrategy)ReflectionUtils.newInstance((String)((String)conf.get("resource.aware.scheduler.priority.strategy")));
        this.configLoader = ConfigLoaderFactoryService.createConfigLoader(conf);
        this.maxSchedulingAttempts = ObjectReader.getInt((Object)conf.get("resource.aware.scheduler.max.topology.scheduling.attempts"), (Integer)5);
        this.schedulingTimeoutSeconds = ObjectReader.getInt((Object)conf.get("scheduling.timeout.seconds.per.topology"), (Integer)60);
        this.backgroundScheduling = Executors.newFixedThreadPool(1);
    }

    @Override
    public void cleanup() {
        LOG.info("Cleanup ResourceAwareScheduler scheduler");
        this.backgroundScheduling.shutdown();
    }

    @Override
    public Map<String, Map<String, Double>> config() {
        return this.getUserResourcePools();
    }

    @Override
    public void schedule(Topologies topologies, Cluster cluster) {
        Map<String, User> userMap = this.getUsers(cluster);
        ArrayList<TopologyDetails> orderedTopologies = new ArrayList<TopologyDetails>(this.schedulingPriorityStrategy.getOrderedTopologies(cluster, userMap));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ordered list of topologies is: {}", orderedTopologies.stream().map(t -> t.getId()).collect(Collectors.toList()));
        }
        for (TopologyDetails td : orderedTopologies) {
            if (!cluster.needsSchedulingRas(td)) {
                cluster.setStatusIfAbsent(td.getId(), "Fully Scheduled");
                continue;
            }
            User submitter = userMap.get(td.getTopologySubmitter());
            this.scheduleTopology(td, cluster, submitter, orderedTopologies);
        }
    }

    private void scheduleTopology(TopologyDetails td, Cluster cluster, User topologySubmitter, List<TopologyDetails> orderedTopologies) {
        Cluster workingState = new Cluster(cluster);
        RAS_Nodes nodes = new RAS_Nodes(workingState);
        IStrategy rasStrategy = null;
        String strategyConf = (String)td.getConf().get("topology.scheduler.strategy");
        try {
            String strategy = (String)td.getConf().get("topology.scheduler.strategy");
            if (strategy.startsWith("backtype.storm")) {
                strategy = strategy.replace("backtype.storm", "org.apache.storm");
                LOG.debug("Replaced backtype.storm with org.apache.storm for Config.TOPOLOGY_SCHEDULER_STRATEGY");
            }
            rasStrategy = (IStrategy)ReflectionUtils.newSchedulerStrategyInstance((String)strategy, this.conf);
            rasStrategy.prepare(this.conf);
        }
        catch (DisallowedStrategyException e) {
            ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Unsuccessful in scheduling - " + e.getAttemptedClass() + " is not an allowed strategy. Please make sure your " + "topology.scheduler.strategy" + " config is one of the allowed strategies: " + e.getAllowedStrategies(), e);
            return;
        }
        catch (RuntimeException e) {
            ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Unsuccessful in scheduling - failed to create instance of topology strategy " + strategyConf + ". Please check logs for details", e);
            return;
        }
        IStrategy finalRasStrategy = rasStrategy;
        for (int i = 0; i < this.maxSchedulingAttempts; ++i) {
            SingleTopologyCluster toSchedule = new SingleTopologyCluster(workingState, td.getId());
            try {
                SchedulingResult result = null;
                Future<SchedulingResult> schedulingFuture = this.backgroundScheduling.submit(() -> finalRasStrategy.schedule(toSchedule, td));
                try {
                    result = schedulingFuture.get(this.schedulingTimeoutSeconds, TimeUnit.SECONDS);
                }
                catch (TimeoutException te) {
                    ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Scheduling took too long for " + td.getId() + " using strategy " + rasStrategy.getClass().getName() + " timeout after " + this.schedulingTimeoutSeconds + " seconds using config " + "scheduling.timeout.seconds.per.topology" + ".");
                    schedulingFuture.cancel(true);
                    return;
                }
                LOG.debug("scheduling result: {}", (Object)result);
                if (result == null) {
                    ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Internal scheduler error");
                    return;
                }
                if (result.isSuccess()) {
                    cluster.updateFrom(toSchedule);
                    cluster.setStatus(td.getId(), "Running - " + result.getMessage());
                    return;
                }
                if (result.getStatus() == SchedulingStatus.FAIL_NOT_ENOUGH_RESOURCES) {
                    LOG.debug("Not enough resources to schedule {}", (Object)td.getName());
                    ImmutableList reversedList = ImmutableList.copyOf(orderedTopologies).reverse();
                    boolean evictedSomething = false;
                    LOG.debug("attempting to make space for topo {} from user {}", (Object)td.getName(), (Object)td.getTopologySubmitter());
                    int tdIndex = reversedList.indexOf(td);
                    double cpuNeeded = td.getTotalRequestedCpu();
                    double memoryNeeded = td.getTotalRequestedMemOffHeap() + td.getTotalRequestedMemOnHeap();
                    SchedulerAssignment assignment = cluster.getAssignmentById(td.getId());
                    if (assignment != null) {
                        cpuNeeded -= ResourceAwareScheduler.getCpuUsed(assignment);
                        memoryNeeded -= ResourceAwareScheduler.getMemoryUsed(assignment);
                    }
                    for (int index = 0; index < tdIndex; ++index) {
                        TopologyDetails topologyEvict = (TopologyDetails)reversedList.get(index);
                        SchedulerAssignment evictAssignemnt = workingState.getAssignmentById(topologyEvict.getId());
                        if (evictAssignemnt == null || evictAssignemnt.getSlots().isEmpty()) continue;
                        Collection<WorkerSlot> workersToEvict = workingState.getUsedSlotsByTopologyId(topologyEvict.getId());
                        LOG.debug("Evicting Topology {} with workers: {} from user {}", new Object[]{topologyEvict.getName(), workersToEvict, topologyEvict.getTopologySubmitter()});
                        evictedSomething = true;
                        nodes.freeSlots(workersToEvict);
                        if ((cpuNeeded -= ResourceAwareScheduler.getCpuUsed(evictAssignemnt)) <= 0.0 && (memoryNeeded -= ResourceAwareScheduler.getMemoryUsed(evictAssignemnt)) <= 0.0) break;
                    }
                    if (evictedSomething) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("Not enough resources to schedule ");
                    if (memoryNeeded > 0.0 || cpuNeeded > 0.0) {
                        if (memoryNeeded > 0.0) {
                            message.append(memoryNeeded).append(" MB ");
                        }
                        if (cpuNeeded > 0.0) {
                            message.append(cpuNeeded).append("% CPU ");
                        }
                        message.append("needed even after evicting lower priority topologies. ");
                    }
                    message.append(result.getErrorMessage());
                    ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, message.toString());
                    return;
                }
                topologySubmitter.markTopoUnsuccess(td, cluster);
                return;
            }
            catch (Exception ex) {
                ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Internal Error - Exception thrown when scheduling. Please check logs for details", ex);
                return;
            }
        }
        ResourceAwareScheduler.markFailedTopology(topologySubmitter, cluster, td, "Failed to schedule within " + this.maxSchedulingAttempts + " attempts");
    }

    private Map<String, User> getUsers(Cluster cluster) {
        HashMap<String, User> userMap = new HashMap<String, User>();
        Map<String, Map<String, Double>> userResourcePools = this.getUserResourcePools();
        LOG.debug("userResourcePools: {}", userResourcePools);
        for (TopologyDetails td : cluster.getTopologies()) {
            String topologySubmitter = td.getTopologySubmitter();
            if (topologySubmitter == null || topologySubmitter.equals("")) {
                LOG.error("Cannot determine user for topology {}.  Will skip scheduling this topology", (Object)td.getName());
                continue;
            }
            if (userMap.containsKey(topologySubmitter)) continue;
            userMap.put(topologySubmitter, new User(topologySubmitter, userResourcePools.get(topologySubmitter)));
        }
        return userMap;
    }

    private Map<String, Map<String, Double>> convertToDouble(Map<String, Map<String, Number>> raw) {
        HashMap<String, Map<String, Double>> ret = new HashMap<String, Map<String, Double>>();
        if (raw != null) {
            for (Map.Entry<String, Map<String, Number>> userPoolEntry : raw.entrySet()) {
                String user = userPoolEntry.getKey();
                ret.put(user, new HashMap());
                for (Map.Entry<String, Number> resourceEntry : userPoolEntry.getValue().entrySet()) {
                    ((Map)ret.get(user)).put(resourceEntry.getKey(), resourceEntry.getValue().doubleValue());
                }
            }
        }
        return ret;
    }

    private Map<String, Map<String, Double>> getUserResourcePools() {
        Map fromFile;
        Map raw;
        if (this.configLoader != null) {
            raw = this.configLoader.load("resource.aware.scheduler.user.pools");
            if (raw != null) {
                return this.convertToDouble(raw);
            }
            LOG.warn("Config loader returned null. Will try to read from user-resource-pools.yaml");
        }
        if ((raw = (Map)(fromFile = Utils.findAndReadConfigFile((String)"user-resource-pools.yaml", (boolean)false)).get("resource.aware.scheduler.user.pools")) != null) {
            return this.convertToDouble(raw);
        }
        LOG.warn("Reading from user-resource-pools.yaml returned null. This could because the file is not available. Will load configs from storm configuration");
        raw = (Map)this.conf.get("resource.aware.scheduler.user.pools");
        return this.convertToDouble(raw);
    }
}

