/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.blacklist.strategies;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.blacklist.strategies.DefaultBlacklistStrategy;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasBlacklistStrategy
extends DefaultBlacklistStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RasBlacklistStrategy.class);

    @Override
    protected Set<String> releaseBlacklistWhenNeeded(Cluster cluster, List<String> blacklistedNodeIds) {
        LOG.info("RAS We have {} nodes blacklisted...", (Object)blacklistedNodeIds.size());
        HashSet<String> readyToRemove = new HashSet<String>();
        if (blacklistedNodeIds.size() > 0) {
            int availableSlots = cluster.getNonBlacklistedAvailableSlots(blacklistedNodeIds).size();
            int neededSlots = 0;
            NormalizedResourceOffer available = cluster.getNonBlacklistedClusterAvailableResources(blacklistedNodeIds);
            NormalizedResourceOffer needed = new NormalizedResourceOffer();
            for (TopologyDetails td : cluster.getTopologies()) {
                if (!cluster.needsSchedulingRas(td)) continue;
                int slots = 0;
                try {
                    slots = ServerUtils.getEstimatedWorkerCountForRASTopo(td.getConf(), td.getTopology());
                }
                catch (InvalidTopologyException e) {
                    LOG.warn("Could not guess the number of slots needed for {}", (Object)td.getName(), (Object)e);
                }
                int assignedSlots = cluster.getAssignedNumWorkers(td);
                int tdSlotsNeeded = slots - assignedSlots;
                neededSlots += tdSlotsNeeded;
                NormalizedResourceRequest resources = td.getApproximateTotalResources();
                needed.add(resources);
                LOG.warn("{} needs to be scheduled with {} and {} slots", new Object[]{td.getName(), resources, tdSlotsNeeded});
            }
            Map<String, SupervisorDetails> availableSupervisors = cluster.getSupervisors();
            NormalizedResourceOffer shortage = new NormalizedResourceOffer(needed);
            shortage.remove(available, cluster.getResourceMetrics());
            int shortageSlots = neededSlots - availableSlots;
            LOG.debug("Need {} and {} slots.", (Object)needed, (Object)neededSlots);
            LOG.debug("Available {} and {} slots.", (Object)available, (Object)availableSlots);
            LOG.debug("Shortage {} and {} slots.", (Object)shortage, (Object)shortageSlots);
            if (shortage.areAnyOverZero() || shortageSlots > 0) {
                LOG.info("Need {} and {} slots more. Releasing some blacklisted nodes to cover it.", (Object)shortage, (Object)shortageSlots);
                Map<String, Set<String>> hostToSupervisorIds = this.createHostToSupervisorMap(blacklistedNodeIds, cluster);
                for (Set<String> supervisorIds : hostToSupervisorIds.values()) {
                    for (String supervisorId : supervisorIds) {
                        SupervisorDetails sd = availableSupervisors.get(supervisorId);
                        if (sd == null) continue;
                        NormalizedResourceOffer sdAvailable = cluster.getAvailableResources(sd);
                        int sdAvailableSlots = cluster.getAvailablePorts(sd).size();
                        readyToRemove.add(supervisorId);
                        shortage.remove(sdAvailable, cluster.getResourceMetrics());
                        LOG.info("Releasing {} with {} and {} slots leaving {} and {} slots to go", new Object[]{supervisorId, sdAvailable, sdAvailableSlots, shortage, shortageSlots -= sdAvailableSlots});
                    }
                    if (shortage.areAnyOverZero() || shortageSlots > 0) continue;
                    break;
                }
            }
        }
        return readyToRemove;
    }
}

