/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorDetails {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorDetails.class);
    private final String id;
    private final Integer serverPort;
    private final String host;
    private final Object meta;
    private final Object schedulerMeta;
    private final NormalizedResourceOffer totalResources;
    private Set<Integer> allPorts;

    public SupervisorDetails(String id, Integer serverPort, String host, Object meta, Object schedulerMeta, Collection<? extends Number> allPorts, Map<String, Double> totalResources) {
        this.id = id;
        this.serverPort = serverPort;
        this.host = host;
        this.meta = meta;
        this.schedulerMeta = schedulerMeta;
        if (allPorts != null) {
            this.setAllPorts(allPorts);
        } else {
            this.allPorts = new HashSet<Integer>();
        }
        this.totalResources = new NormalizedResourceOffer(totalResources);
        LOG.debug("Creating a new supervisor ({}-{}) with resources: {}", new Object[]{this.host, this.id, totalResources});
    }

    public SupervisorDetails(String id, Object meta) {
        this(id, null, null, meta, null, null, null);
    }

    public SupervisorDetails(String id, Object meta, Map<String, Double> totalResources) {
        this(id, null, null, meta, null, null, totalResources);
    }

    public SupervisorDetails(String id, Object meta, Collection<? extends Number> allPorts) {
        this(id, null, null, meta, null, allPorts, null);
    }

    public SupervisorDetails(String id, String host, Object schedulerMeta, Collection<? extends Number> allPorts) {
        this(id, null, host, null, schedulerMeta, allPorts, null);
    }

    public SupervisorDetails(String id, String host, Object schedulerMeta, Collection<? extends Number> allPorts, Map<String, Double> totalResources) {
        this(id, null, host, null, schedulerMeta, allPorts, totalResources);
    }

    public SupervisorDetails(String id, int serverPort, String host, Object schedulerMeta, Collection<? extends Number> allPorts, Map<String, Double> totalResources) {
        this(id, serverPort, host, null, schedulerMeta, allPorts, totalResources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " ID: " + this.id + " HOST: " + this.host + " META: " + this.meta + " SCHED_META: " + this.schedulerMeta + " PORTS: " + this.allPorts;
    }

    public String getId() {
        return this.id;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getHost() {
        return this.host;
    }

    public Object getMeta() {
        return this.meta;
    }

    public Set<Integer> getAllPorts() {
        return this.allPorts;
    }

    private void setAllPorts(Collection<? extends Number> allPorts) {
        this.allPorts = new HashSet<Integer>();
        if (allPorts != null) {
            for (Number number : allPorts) {
                this.allPorts.add(number.intValue());
            }
        }
    }

    public Object getSchedulerMeta() {
        return this.schedulerMeta;
    }

    public double getTotalMemory() {
        return this.totalResources.getTotalMemoryMb();
    }

    public double getTotalCpu() {
        return this.totalResources.getTotalCpu();
    }

    public NormalizedResourceOffer getTotalResources() {
        return this.totalResources;
    }
}

