/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormMetricsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(StormMetricsRegistry.class);
    private final MetricRegistry registry = new MetricRegistry();
    private List<PreparableReporter> reporters;
    private boolean reportersStarted = false;

    public Meter registerMeter(String name) {
        return this.registry.meter(name);
    }

    public Meter registerMeter(String name, Meter meter) {
        return this.registry.meter(name, () -> meter);
    }

    public Timer registerTimer(String name) {
        return this.registry.timer(name);
    }

    public Histogram registerHistogram(String name) {
        return this.registry.histogram(name);
    }

    public Histogram registerHistogram(String name, Reservoir reservoir) {
        return this.registry.histogram(name, () -> new Histogram(reservoir));
    }

    public <V> Gauge<V> registerGauge(String name, Gauge<V> gauge) {
        return this.registry.gauge(name, () -> gauge);
    }

    public void registerAll(MetricSet metrics) {
        this.registry.registerAll(metrics);
    }

    public void removeAll(MetricSet metrics) {
        Map nameToMetric = metrics.getMetrics();
        this.registry.removeMatching((name, metric) -> nameToMetric.containsKey(name));
    }

    public void startMetricsReporters(Map<String, Object> daemonConf) {
        this.reporters = MetricsUtils.getPreparableReporters(daemonConf);
        for (PreparableReporter reporter : this.reporters) {
            reporter.prepare(this.registry, daemonConf);
            reporter.start();
            LOG.info("Started statistics report plugin...");
        }
        this.reportersStarted = true;
    }

    public void stopMetricsReporters() {
        if (this.reportersStarted) {
            for (PreparableReporter reporter : this.reporters) {
                reporter.stop();
            }
            this.reportersStarted = false;
        }
    }
}

