/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.daemon.supervisor.LocalContainer;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.Supervisor;
import org.apache.storm.messaging.IContext;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.LocalState;

public class LocalContainerLauncher
extends ContainerLauncher {
    private final Map<String, Object> _conf;
    private final String _supervisorId;
    private final int _supervisorPort;
    private final IContext _sharedContext;
    private final StormMetricsRegistry metricsRegistry;
    private final ContainerMemoryTracker containerMemoryTracker;
    private final Supervisor.Iface localSupervisor;

    public LocalContainerLauncher(Map<String, Object> conf, String supervisorId, int supervisorPort, IContext sharedContext, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker, Supervisor.Iface localSupervisor) {
        this._conf = conf;
        this._supervisorId = supervisorId;
        this._supervisorPort = supervisorPort;
        this._sharedContext = sharedContext;
        this.metricsRegistry = metricsRegistry;
        this.containerMemoryTracker = containerMemoryTracker;
        this.localSupervisor = localSupervisor;
    }

    @Override
    public Container launchContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        LocalContainer ret = new LocalContainer(this._conf, this._supervisorId, this._supervisorPort, port, assignment, this._sharedContext, this.metricsRegistry, this.containerMemoryTracker, this.localSupervisor);
        ret.setup();
        ret.launch();
        return ret;
    }

    @Override
    public Container recoverContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        throw new ContainerRecoveryException("Local Mode Recovery is not supported");
    }

    @Override
    public Killable recoverContainer(String workerId, LocalState localState) throws IOException {
        throw new ContainerRecoveryException("Local Mode Recovery is not supported");
    }
}

