/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc;

import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.utils.Time;

public abstract class OutstandingRequest {
    private final long _start = Time.currentTimeMillis();
    private final String _function;
    private final DRPCRequest _req;
    private volatile boolean _fetched = false;

    public OutstandingRequest(String function, DRPCRequest req) {
        this._function = function;
        this._req = req;
    }

    public DRPCRequest getRequest() {
        return this._req;
    }

    public void fetched() {
        this._fetched = true;
    }

    public boolean wasFetched() {
        return this._fetched;
    }

    public String getFunction() {
        return this._function;
    }

    public boolean isTimedOut(long timeoutMs) {
        return this._start + timeoutMs <= Time.currentTimeMillis();
    }

    public abstract void returnResult(String var1);

    public abstract void fail(DRPCExecutionException var1);
}

