/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc;

import java.util.concurrent.Semaphore;
import org.apache.storm.daemon.drpc.OutstandingRequest;
import org.apache.storm.daemon.drpc.RequestFactory;
import org.apache.storm.generated.DRPCExceptionType;
import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.utils.WrappedDRPCExecutionException;

public class BlockingOutstandingRequest
extends OutstandingRequest {
    public static final RequestFactory<BlockingOutstandingRequest> FACTORY = BlockingOutstandingRequest::new;
    private Semaphore _sem = new Semaphore(0);
    private volatile String _result = null;
    private volatile DRPCExecutionException _e = null;

    public BlockingOutstandingRequest(String function, DRPCRequest req) {
        super(function, req);
    }

    public String getResult() throws DRPCExecutionException {
        try {
            this._sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._result != null) {
            return this._result;
        }
        if (this._e == null) {
            this._e = new WrappedDRPCExecutionException("Internal Error: No Result and No Exception");
            this._e.set_type(DRPCExceptionType.INTERNAL_ERROR);
        }
        throw this._e;
    }

    @Override
    public void returnResult(String result) {
        this._result = result;
        this._sem.release();
    }

    @Override
    public void fail(DRPCExecutionException e) {
        this._e = e;
        this._sem.release();
    }
}

