/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.storm.ILocalCluster;
import org.apache.storm.LocalCluster;
import org.apache.storm.Thrift;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.scheduler.INimbus;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.CompletableSpout;
import org.apache.storm.testing.CompleteTopologyParam;
import org.apache.storm.testing.FixedTuple;
import org.apache.storm.testing.FixedTupleSpout;
import org.apache.storm.testing.MkClusterParam;
import org.apache.storm.testing.MkTupleParam;
import org.apache.storm.testing.MockedSources;
import org.apache.storm.testing.TestJob;
import org.apache.storm.testing.TrackedTopology;
import org.apache.storm.testing.TupleCaptureBolt;
import org.apache.storm.thrift.TException;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.RegisteredGlobalState;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Testing {
    public static final int TEST_TIMEOUT_MS;
    private static final Logger LOG;

    public static void whileTimeout(Condition condition, Runnable body) {
        Testing.whileTimeout(TEST_TIMEOUT_MS, condition, body);
    }

    public static void whileTimeout(long timeoutMs, Condition condition, Runnable body) {
        long endTime = System.currentTimeMillis() + timeoutMs;
        LOG.debug("Looping until {}", (Object)condition);
        int count = 0;
        while (condition.exec()) {
            ++count;
            if (System.currentTimeMillis() > endTime) {
                LOG.info("Condition {} not met in {} ms after calling {} times", new Object[]{condition, timeoutMs, count});
                LOG.info(Utils.threadDump());
                throw new AssertionError((Object)("Test timed out (" + timeoutMs + "ms) " + condition));
            }
            body.run();
        }
        LOG.debug("Condition met {}", (Object)condition);
    }

    public static <T> boolean isEvery(Collection<T> data, Predicate<T> pred) {
        return data.stream().allMatch(pred);
    }

    @Deprecated
    public static void withSimulatedTime(Runnable code) {
        try (Time.SimulatedTime st = new Time.SimulatedTime();){
            code.run();
        }
    }

    private static LocalCluster cluster(MkClusterParam param, boolean simulated) throws Exception {
        return Testing.cluster(param, null, simulated);
    }

    private static LocalCluster cluster(MkClusterParam param) throws Exception {
        return Testing.cluster(param, null, false);
    }

    private static LocalCluster cluster(MkClusterParam param, String id, boolean simulated) throws Exception {
        HashMap<String, Object> conf;
        Integer ports;
        Integer supervisors = param.getSupervisors();
        if (supervisors == null) {
            supervisors = 2;
        }
        if ((ports = param.getPortsPerSupervisor()) == null) {
            ports = 3;
        }
        if ((conf = param.getDaemonConf()) == null) {
            conf = new HashMap<String, Object>();
        }
        return new LocalCluster.Builder().withSupervisors(supervisors).withPortsPerSupervisor(ports).withDaemonConf(conf).withNimbusDaemon(param.isNimbusDaemon()).withTracked(id).withSimulatedTime(simulated).build();
    }

    @Deprecated
    public static void withLocalCluster(TestJob code) {
        Testing.withLocalCluster(new MkClusterParam(), code);
    }

    @Deprecated
    public static void withLocalCluster(MkClusterParam param, TestJob code) {
        try (LocalCluster lc = Testing.cluster(param);){
            code.run(lc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static ILocalCluster getLocalCluster(Map<String, Object> clusterConf) {
        HashMap<String, Object> conf = (HashMap<String, Object>)clusterConf.get("daemon-conf");
        if (conf == null) {
            conf = new HashMap<String, Object>();
        }
        Number supervisors = (Number)clusterConf.getOrDefault("supervisors", 2);
        Number ports = (Number)clusterConf.getOrDefault("ports-per-supervisor", 3);
        INimbus inimbus = (INimbus)clusterConf.get("inimbus");
        Number portMin = (Number)clusterConf.getOrDefault("supervisor-slot-port-min", 1024);
        Boolean nimbusDaemon = (Boolean)clusterConf.getOrDefault("nimbus-daemon", false);
        try {
            return new LocalCluster.Builder().withSupervisors(supervisors.intValue()).withDaemonConf(conf).withPortsPerSupervisor(ports.intValue()).withINimbus(inimbus).withSupervisorSlotPortMin(portMin).withNimbusDaemon(nimbusDaemon).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void withSimulatedTimeLocalCluster(TestJob code) {
        Testing.withSimulatedTimeLocalCluster(new MkClusterParam(), code);
    }

    @Deprecated
    public static void withSimulatedTimeLocalCluster(MkClusterParam param, TestJob code) {
        try (LocalCluster lc = Testing.cluster(param, true);){
            code.run(lc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void withTrackedCluster(TestJob code) {
        Testing.withTrackedCluster(new MkClusterParam(), code);
    }

    @Deprecated
    public static int globalAmt(String id, String key) {
        LOG.warn("Reading tracked metrics for ID {}", (Object)id);
        return ((AtomicInteger)((ConcurrentHashMap)RegisteredGlobalState.getState((String)id)).get(key)).get();
    }

    @Deprecated
    public static void withTrackedCluster(MkClusterParam param, TestJob code) {
        try (LocalCluster lc = Testing.cluster(param, Utils.uuid(), true);){
            code.run(lc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CapturedTopology<TrackedTopology> trackAndCaptureTopology(ILocalCluster cluster, StormTopology topology) {
        CapturedTopology<StormTopology> captured = Testing.captureTopology(topology);
        return new CapturedTopology<TrackedTopology>(new TrackedTopology((StormTopology)captured.topology, cluster), captured.capturer);
    }

    public static CapturedTopology<StormTopology> captureTopology(StormTopology topology) {
        StreamInfo info;
        String stream;
        String id;
        topology = topology.deepCopy();
        TupleCaptureBolt capturer = new TupleCaptureBolt();
        HashMap<GlobalStreamId, Grouping> captureBoltInputs = new HashMap<GlobalStreamId, Grouping>();
        for (Map.Entry spoutEntry : topology.get_spouts().entrySet()) {
            id = (String)spoutEntry.getKey();
            for (Map.Entry streamEntry : ((SpoutSpec)spoutEntry.getValue()).get_common().get_streams().entrySet()) {
                stream = (String)streamEntry.getKey();
                info = (StreamInfo)streamEntry.getValue();
                if (info.is_direct()) {
                    captureBoltInputs.put(new GlobalStreamId(id, stream), Thrift.prepareDirectGrouping());
                    continue;
                }
                captureBoltInputs.put(new GlobalStreamId(id, stream), Thrift.prepareGlobalGrouping());
            }
        }
        for (Map.Entry boltEntry : topology.get_bolts().entrySet()) {
            id = (String)boltEntry.getKey();
            for (Map.Entry streamEntry : ((Bolt)boltEntry.getValue()).get_common().get_streams().entrySet()) {
                stream = (String)streamEntry.getKey();
                info = (StreamInfo)streamEntry.getValue();
                if (info.is_direct()) {
                    captureBoltInputs.put(new GlobalStreamId(id, stream), Thrift.prepareDirectGrouping());
                    continue;
                }
                captureBoltInputs.put(new GlobalStreamId(id, stream), Thrift.prepareGlobalGrouping());
            }
        }
        topology.put_to_bolts(Utils.uuid(), new Bolt(Thrift.serializeComponentObject((Object)capturer), Thrift.prepareComponentCommon(captureBoltInputs, new HashMap(), null)));
        return new CapturedTopology<StormTopology>(topology, capturer);
    }

    public static Map<String, List<FixedTuple>> completeTopology(ILocalCluster cluster, StormTopology topology) throws InterruptedException, TException {
        return Testing.completeTopology(cluster, topology, new CompleteTopologyParam());
    }

    public static Map<String, List<FixedTuple>> completeTopology(ILocalCluster cluster, StormTopology topology, CompleteTopologyParam param) throws TException, InterruptedException {
        Map ret = null;
        IStormClusterState state = cluster.getClusterState();
        CapturedTopology<StormTopology> capTopo = Testing.captureTopology(topology);
        topology = (StormTopology)capTopo.topology;
        String topoName = param.getTopologyName();
        if (topoName == null) {
            topoName = "topologytest-" + Utils.uuid();
        }
        Map spouts = topology.get_spouts();
        MockedSources ms = param.getMockedSources();
        if (ms != null) {
            for (Map.Entry entry : ms.getData().entrySet()) {
                FixedTupleSpout newSpout = new FixedTupleSpout((List)entry.getValue());
                ((SpoutSpec)spouts.get(entry.getKey())).set_spout_object(Thrift.serializeComponentObject((Object)newSpout));
            }
        }
        List spoutObjects = spouts.values().stream().map(spec -> Thrift.deserializeComponentObject((ComponentObject)spec.get_spout_object())).collect(Collectors.toList());
        for (Object o : spoutObjects) {
            if (o instanceof CompletableSpout) continue;
            throw new RuntimeException("Cannot complete topology unless every spout is a CompletableSpout (or mocked to be); failed by " + o);
        }
        for (Object spout : spoutObjects) {
            ((CompletableSpout)spout).startup();
        }
        cluster.submitTopology(topoName, param.getStormConf(), topology);
        if (Time.isSimulating()) {
            cluster.advanceClusterTime(11);
        }
        String string = (String)state.getTopoId(topoName).get();
        Testing.simulateWait(cluster);
        Integer timeoutMs = param.getTimeoutMs();
        if (timeoutMs == null) {
            timeoutMs = TEST_TIMEOUT_MS;
        }
        Testing.whileTimeout(timeoutMs.intValue(), () -> !Testing.isEvery(spoutObjects, o -> ((CompletableSpout)o).isExhausted()), () -> {
            try {
                Testing.simulateWait(cluster);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        });
        KillOptions killOpts = new KillOptions();
        killOpts.set_wait_secs(0);
        cluster.killTopologyWithOpts(topoName, killOpts);
        Testing.whileTimeout(timeoutMs.intValue(), () -> state.assignmentInfo(topoId, null) != null, () -> {
            try {
                Testing.simulateWait(cluster);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        });
        if (param.getCleanupState()) {
            for (Object o : spoutObjects) {
                ((CompletableSpout)o).clean();
            }
            ret = capTopo.capturer.getAndRemoveResults();
        } else {
            ret = capTopo.capturer.getAndClearResults();
        }
        return ret;
    }

    public static void simulateWait(ILocalCluster cluster) throws InterruptedException {
        if (Time.isSimulating()) {
            cluster.advanceClusterTime(10);
            Thread.sleep(100L);
        }
    }

    public static List<List<Object>> readTuples(Map<String, List<FixedTuple>> results, String componentId) {
        return Testing.readTuples(results, componentId, "default");
    }

    public static List<List<Object>> readTuples(Map<String, List<FixedTuple>> results, String componentId, String streamId) {
        ArrayList<List<Object>> ret = new ArrayList<List<Object>>();
        List<FixedTuple> streamResult = results.get(componentId);
        if (streamResult != null) {
            for (FixedTuple tuple : streamResult) {
                if (!streamId.equals(tuple.stream)) continue;
                ret.add(tuple.values);
            }
        }
        return ret;
    }

    @Deprecated
    public static TrackedTopology mkTrackedTopology(ILocalCluster cluster, StormTopology topology) {
        return new TrackedTopology(topology, cluster);
    }

    public static void trackedWait(CapturedTopology<TrackedTopology> topo) {
        ((TrackedTopology)topo.topology).trackedWait();
    }

    public static void trackedWait(CapturedTopology<TrackedTopology> topo, Integer amt) {
        ((TrackedTopology)topo.topology).trackedWait(amt);
    }

    public static void trackedWait(CapturedTopology<TrackedTopology> topo, Integer amt, Integer timeoutMs) {
        ((TrackedTopology)topo.topology).trackedWait(amt, timeoutMs);
    }

    public static void trackedWait(TrackedTopology topo) {
        topo.trackedWait();
    }

    public static void trackedWait(TrackedTopology topo, Integer amt) {
        topo.trackedWait(amt);
    }

    public static void trackedWait(TrackedTopology topo, Integer amt, Integer timeoutMs) {
        topo.trackedWait(amt, timeoutMs);
    }

    public static void advanceClusterTime(ILocalCluster cluster, Integer secs) throws InterruptedException {
        Testing.advanceClusterTime(cluster, secs, 1);
    }

    public static void advanceClusterTime(ILocalCluster cluster, Integer secs, Integer step) throws InterruptedException {
        cluster.advanceClusterTime(secs.intValue(), step.intValue());
    }

    public static <T> Map<T, Integer> multiset(Collection<T> c) {
        HashMap<T, Integer> ret = new HashMap<T, Integer>();
        for (T t : c) {
            Integer i = (Integer)ret.get(t);
            if (i == null) {
                i = new Integer(0);
            }
            i = i + 1;
            ret.put(t, i);
        }
        return ret;
    }

    private static void printRec(Object o, String prefix) {
        if (o instanceof Collection) {
            LOG.info("{} {} ({}) [", new Object[]{prefix, o, o.getClass()});
            for (Object sub : (Collection)o) {
                Testing.printRec(sub, prefix + "  ");
            }
            LOG.info("{} ]", (Object)prefix);
        } else if (o instanceof Map) {
            Map m = (Map)o;
            LOG.info("{} {} ({}) {", new Object[]{prefix, o, o.getClass()});
            for (Map.Entry entry : m.entrySet()) {
                Testing.printRec(entry.getKey(), prefix + "  ");
                LOG.info("{} ->", (Object)prefix);
                Testing.printRec(entry.getValue(), prefix + "  ");
            }
            LOG.info("{} }", (Object)prefix);
        } else {
            LOG.info("{} {} ({})", new Object[]{prefix, o, o.getClass()});
        }
    }

    public static <T> boolean multiseteq(Collection<T> a, Collection<T> b) {
        boolean ret = Testing.multiset(a).equals(Testing.multiset(b));
        if (!ret) {
            Testing.printRec(Testing.multiset(a), "MS-A:");
            Testing.printRec(Testing.multiset(b), "MS-B:");
        }
        return ret;
    }

    public static Tuple testTuple(List<Object> values) {
        return Testing.testTuple(values, new MkTupleParam());
    }

    public static Tuple testTuple(List<Object> values, MkTupleParam param) {
        String component;
        String stream = param.getStream();
        if (stream == null) {
            stream = "default";
        }
        if ((component = param.getComponent()) == null) {
            component = "component";
        }
        int task = 1;
        ArrayList<String> fields = param.getFields();
        if (fields == null) {
            fields = new ArrayList<String>(values.size());
            for (int i = 1; i <= values.size(); ++i) {
                fields.add("field" + i);
            }
        }
        HashMap<Integer, String> taskToComp = new HashMap<Integer, String>();
        taskToComp.put(task, component);
        HashMap compToStreamToFields = new HashMap();
        HashMap<String, Fields> streamToFields = new HashMap<String, Fields>();
        streamToFields.put(stream, new Fields(fields));
        compToStreamToFields.put(component, streamToFields);
        TopologyContext context = new TopologyContext(null, ConfigUtils.readStormConfig(), taskToComp, null, compToStreamToFields, null, "test-storm-id", null, null, Integer.valueOf(1), null, null, new HashMap(), new HashMap(), new HashMap(), new HashMap(), new AtomicBoolean(false), null);
        return new TupleImpl((GeneralTopologyContext)context, values, component, 1, stream);
    }

    static {
        LOG = LoggerFactory.getLogger(Testing.class);
        int timeout = 10000;
        try {
            timeout = Integer.parseInt(System.getenv("STORM_TEST_TIMEOUT_MS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_TIMEOUT_MS = timeout;
    }

    public static final class CapturedTopology<T> {
        public final T topology;
        public final TupleCaptureBolt capturer;

        public CapturedTopology(T topology, TupleCaptureBolt capturer) {
            this.topology = topology;
            this.capturer = capturer;
        }
    }

    public static interface Condition {
        public boolean exec();
    }
}

