/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.nimbus.ITopologyActionNotifierPlugin;
import org.apache.storm.scheduler.blacklist.reporters.IReporter;
import org.apache.storm.scheduler.blacklist.strategies.IBlacklistStrategy;
import org.apache.storm.scheduler.resource.strategies.priority.ISchedulingPriorityStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.validation.ConfigValidationAnnotations;
import org.apache.storm.validation.Validated;

public class DaemonConfig
implements Validated {
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_NETTY_FLUSH_CHECK_INTERVAL_MS = "storm.messaging.netty.flush.check.interval.ms";
    @ConfigValidationAnnotations.IsStringList
    public static final String STORM_DAEMON_METRICS_REPORTER_PLUGINS = "storm.daemon.metrics.reporter.plugins";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DAEMON_METRICS_REPORTER_PLUGIN_DOMAIN = "storm.daemon.metrics.reporter.plugin.domain";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_DAEMON_METRICS_REPORTER_CSV_LOG_DIR = "storm.daemon.metrics.reporter.csv.log.dir";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_LOG4J2_CONF_DIR = "storm.log4j2.conf.dir";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_SCHEDULER = "storm.scheduler";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SCHEDULING_TIMEOUT_SECONDS_PER_TOPOLOGY = "scheduling.timeout.seconds.per.topology";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String BLACKLIST_SCHEDULER_TOLERANCE_TIME = "blacklist.scheduler.tolerance.time.secs";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String BLACKLIST_SCHEDULER_TOLERANCE_COUNT = "blacklist.scheduler.tolerance.count";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String BLACKLIST_SCHEDULER_RESUME_TIME = "blacklist.scheduler.resume.time.secs";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IReporter.class)
    public static final String BLACKLIST_SCHEDULER_REPORTER = "blacklist.scheduler.reporter";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IBlacklistStrategy.class)
    public static final String BLACKLIST_SCHEDULER_STRATEGY = "blacklist.scheduler.strategy";
    @ConfigValidationAnnotations.IsBoolean
    public static final String SCHEDULER_DISPLAY_RESOURCE = "scheduler.display.resource";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_HEALTH_CHECK_DIR = "storm.health.check.dir";
    @ConfigValidationAnnotations.IsNumber
    public static final String STORM_HEALTH_CHECK_TIMEOUT_MS = "storm.health.check.timeout.ms";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_DAEMON_USER = "nimbus.daemon.user";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String NIMBUS_CHILDOPTS = "nimbus.childopts";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_TASK_TIMEOUT_SECS = "nimbus.task.timeout.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_MONITOR_FREQ_SECS = "nimbus.monitor.freq.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_CLEANUP_INBOX_FREQ_SECS = "nimbus.cleanup.inbox.freq.secs";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_INBOX_JAR_EXPIRATION_SECS = "nimbus.inbox.jar.expiration.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_SUPERVISOR_TIMEOUT_SECS = "nimbus.supervisor.timeout.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_TASK_LAUNCH_SECS = "nimbus.task.launch.secs";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_FILE_COPY_EXPIRATION_SECS = "nimbus.file.copy.expiration.secs";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_TOPOLOGY_VALIDATOR = "nimbus.topology.validator";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_AUTHORIZER = "nimbus.authorizer";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IAuthorizer.class)
    @ConfigValidationAnnotations.IsString
    public static final String SUPERVISOR_AUTHORIZER = "supervisor.authorizer";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_IMPERSONATION_AUTHORIZER = "nimbus.impersonation.authorizer";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String NIMBUS_CREDENTIAL_RENEW_FREQ_SECS = "nimbus.credential.renewers.freq.secs";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=ITopologyActionNotifierPlugin.class)
    public static final String NIMBUS_TOPOLOGY_ACTION_NOTIFIER_PLUGIN = "nimbus.topology.action.notifier.plugin.class";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_ASSIGNMENTS_SERVICE_THREADS = "nimbus.assignments.service.threads";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_ASSIGNMENTS_SERVICE_THREAD_QUEUE_SIZE = "nimbus.assignments.service.thread.queue.size";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_WORKER_HEARTBEATS_RECOVERY_STRATEGY_CLASS = "nimbus.worker.heartbeats.recovery.strategy.class";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_TOPOLOGY_BLOBSTORE_DELETION_DELAY_MS = "nimbus.topology.blobstore.deletion.delay.ms";
    @ConfigValidationAnnotations.IsString
    public static final String UI_HOST = "ui.host";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String UI_PORT = "ui.port";
    @ConfigValidationAnnotations.IsBoolean
    public static final String UI_DISABLE_HTTP_BINDING = "ui.disable.http.binding";
    @ConfigValidationAnnotations.IsBoolean
    public static final String UI_DISABLE_SPOUT_LAG_MONITORING = "ui.disable.spout.lag.monitoring";
    @ConfigValidationAnnotations.IsBoolean
    public static final String LOGVIEWER_DISABLE_HTTP_BINDING = "logviewer.disable.http.binding";
    @ConfigValidationAnnotations.IsBoolean
    public static final String DRPC_DISABLE_HTTP_BINDING = "drpc.disable.http.binding";
    @ConfigValidationAnnotations.IsString
    public static final String UI_PROJECT_BUGTRACKER_URL = "ui.project.bugtracker.url";
    @ConfigValidationAnnotations.IsString
    public static final String UI_CENTRAL_LOGGING_URL = "ui.central.logging.url";
    @ConfigValidationAnnotations.IsInteger
    public static final String UI_PAGINATION = "ui.pagination";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_PORT = "logviewer.port";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String LOGVIEWER_CHILDOPTS = "logviewer.childopts";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_CLEANUP_INTERVAL_SECS = "logviewer.cleanup.interval.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_CLEANUP_AGE_MINS = "logviewer.cleanup.age.mins";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_MAX_SUM_WORKER_LOGS_SIZE_MB = "logviewer.max.sum.worker.logs.size.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_MAX_PER_WORKER_LOGS_SIZE_MB = "logviewer.max.per.worker.logs.size.mb";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String LOGVIEWER_HTTPS_PORT = "logviewer.https.port";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_HTTPS_KEYSTORE_PATH = "logviewer.https.keystore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String LOGVIEWER_HTTPS_KEYSTORE_PASSWORD = "logviewer.https.keystore.password";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_HTTPS_KEYSTORE_TYPE = "logviewer.https.keystore.type";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String LOGVIEWER_HTTPS_KEY_PASSWORD = "logviewer.https.key.password";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_HTTPS_TRUSTSTORE_PATH = "logviewer.https.truststore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String LOGVIEWER_HTTPS_TRUSTSTORE_PASSWORD = "logviewer.https.truststore.password";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_HTTPS_TRUSTSTORE_TYPE = "logviewer.https.truststore.type";
    @ConfigValidationAnnotations.IsBoolean
    public static final String LOGVIEWER_HTTPS_WANT_CLIENT_AUTH = "logviewer.https.want.client.auth";
    @ConfigValidationAnnotations.IsBoolean
    public static final String LOGVIEWER_HTTPS_NEED_CLIENT_AUTH = "logviewer.https.need.client.auth";
    @ConfigValidationAnnotations.IsStringList
    public static final String LOGS_USERS = "logs.users";
    @ConfigValidationAnnotations.IsStringList
    public static final String LOGS_GROUPS = "logs.groups";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_APPENDER_NAME = "logviewer.appender.name";
    @ConfigValidationAnnotations.IsString
    public static final String LOGVIEWER_FILTER = "logviewer.filter";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String LOGVIEWER_FILTER_PARAMS = "logviewer.filter.params";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String UI_CHILDOPTS = "ui.childopts";
    @ConfigValidationAnnotations.IsString
    public static final String UI_FILTER = "ui.filter";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String UI_FILTER_PARAMS = "ui.filter.params";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String UI_HEADER_BUFFER_BYTES = "ui.header.buffer.bytes";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String UI_HTTPS_PORT = "ui.https.port";
    @ConfigValidationAnnotations.IsString
    public static final String UI_HTTPS_KEYSTORE_PATH = "ui.https.keystore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String UI_HTTPS_KEYSTORE_PASSWORD = "ui.https.keystore.password";
    @ConfigValidationAnnotations.IsString
    public static final String UI_HTTPS_KEYSTORE_TYPE = "ui.https.keystore.type";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String UI_HTTPS_KEY_PASSWORD = "ui.https.key.password";
    @ConfigValidationAnnotations.IsString
    public static final String UI_HTTPS_TRUSTSTORE_PATH = "ui.https.truststore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String UI_HTTPS_TRUSTSTORE_PASSWORD = "ui.https.truststore.password";
    @ConfigValidationAnnotations.IsString
    public static final String UI_HTTPS_TRUSTSTORE_TYPE = "ui.https.truststore.type";
    @ConfigValidationAnnotations.IsBoolean
    public static final String UI_HTTPS_WANT_CLIENT_AUTH = "ui.https.want.client.auth";
    @ConfigValidationAnnotations.IsBoolean
    public static final String UI_HTTPS_NEED_CLIENT_AUTH = "ui.https.need.client.auth";
    @ConfigValidationAnnotations.IsNumber
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String PACEMAKER_MAX_THREADS = "pacemaker.max.threads";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String PACEMAKER_CHILDOPTS = "pacemaker.childopts";
    @ConfigValidationAnnotations.IsInteger
    public static final String DRPC_HTTP_PORT = "drpc.http.port";
    @ConfigValidationAnnotations.IsInteger
    public static final String DRPC_HTTPS_PORT = "drpc.https.port";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_HTTPS_KEYSTORE_PATH = "drpc.https.keystore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String DRPC_HTTPS_KEYSTORE_PASSWORD = "drpc.https.keystore.password";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_HTTPS_KEYSTORE_TYPE = "drpc.https.keystore.type";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String DRPC_HTTPS_KEY_PASSWORD = "drpc.https.key.password";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_HTTPS_TRUSTSTORE_PATH = "drpc.https.truststore.path";
    @ConfigValidationAnnotations.IsString
    @ConfigValidationAnnotations.Password
    public static final String DRPC_HTTPS_TRUSTSTORE_PASSWORD = "drpc.https.truststore.password";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_HTTPS_TRUSTSTORE_TYPE = "drpc.https.truststore.type";
    @ConfigValidationAnnotations.IsBoolean
    public static final String DRPC_HTTPS_WANT_CLIENT_AUTH = "drpc.https.want.client.auth";
    @ConfigValidationAnnotations.IsBoolean
    public static final String DRPC_HTTPS_NEED_CLIENT_AUTH = "drpc.https.need.client.auth";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_AUTHORIZER = "drpc.authorizer";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String DRPC_REQUEST_TIMEOUT_SECS = "drpc.request.timeout.secs";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String DRPC_CHILDOPTS = "drpc.childopts";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String SUPERVISOR_SCHEDULER_META = "supervisor.scheduler.meta";
    @ConfigValidationAnnotations.IsNoDuplicateInList
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsListEntryCustom(entryValidatorClasses={ConfigValidation.IntegerValidator.class, ConfigValidation.PositiveNumberValidator.class})
    public static final String SUPERVISOR_SLOTS_PORTS = "supervisor.slots.ports";
    @ConfigValidationAnnotations.IsString
    public static final String SUPERVISOR_BLOBSTORE = "supervisor.blobstore.class";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_LOCALIZER_CACHE_TARGET_SIZE_MB = "supervisor.localizer.cache.target.size.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_LOCALIZER_CACHE_CLEANUP_INTERVAL_MS = "supervisor.localizer.cleanup.interval.ms";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_BLOBSTORE_DOWNLOAD_THREAD_COUNT = "supervisor.blobstore.download.thread.count";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_BLOBSTORE_DOWNLOAD_MAX_RETRIES = "supervisor.blobstore.download.max_retries";
    @ConfigValidationAnnotations.IsString
    public static final String NIMBUS_BLOBSTORE = "nimbus.blobstore.class";
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_BLOBSTORE_EXPIRATION_SECS = "nimbus.blobstore.expiration.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String NIMBUS_SLOTS_PER_TOPOLOGY = "nimbus.slots.perTopology";
    @ConfigValidationAnnotations.IsString
    public static final String DRPC_HTTP_FILTER = "drpc.http.filter";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=String.class)
    public static final String DRPC_HTTP_FILTER_PARAMS = "drpc.http.filter.params";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static final String NIMBUS_EXECUTORS_PER_TOPOLOGY = "nimbus.executors.perTopology";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String SUPERVISOR_CHILDOPTS = "supervisor.childopts";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String SUPERVISOR_WORKER_START_TIMEOUT_SECS = "supervisor.worker.start.timeout.secs";
    @ConfigValidationAnnotations.IsBoolean
    public static final String SUPERVISOR_ENABLE = "supervisor.enable";
    @ConfigValidationAnnotations.IsInteger
    public static final String SUPERVISOR_HEARTBEAT_FREQUENCY_SECS = "supervisor.heartbeat.frequency.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SUPERVISOR_MONITOR_FREQUENCY_SECS = "supervisor.monitor.frequency.secs";
    @ConfigValidationAnnotations.IsStringOrStringList
    public static final String WORKER_PROFILER_CHILDOPTS = "worker.profiler.childopts";
    @ConfigValidationAnnotations.IsBoolean
    public static final String WORKER_PROFILER_ENABLED = "worker.profiler.enabled";
    @ConfigValidationAnnotations.IsString
    public static final String WORKER_PROFILER_COMMAND = "worker.profiler.command";
    @ConfigValidationAnnotations.IsListEntryCustom(entryValidatorClasses={ConfigValidation.ClusterMetricRegistryValidator.class})
    public static final String STORM_CLUSTER_METRICS_CONSUMER_REGISTER = "storm.cluster.metrics.consumer.register";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String STORM_CLUSTER_METRICS_CONSUMER_PUBLISH_INTERVAL_SECS = "storm.cluster.metrics.consumer.publish.interval.secs";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_TOPOLOGY_CLASSPATH_BEGINNING_ENABLED = "storm.topology.classpath.beginning.enabled";
    @ConfigValidationAnnotations.IsString
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    @ConfigValidationAnnotations.IsString
    public static final String DEV_ZOOKEEPER_PATH = "dev.zookeeper.path";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=Number.class)
    public static final String ISOLATION_SCHEDULER_MACHINES = "isolation.scheduler.machines";
    @ConfigValidationAnnotations.IsString
    public static final String SCHEDULER_CONFIG_LOADER_URI = "scheduler.config.loader.uri";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SCHEDULER_CONFIG_LOADER_POLLTIME_SECS = "scheduler.config.loader.polltime.secs";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String SCHEDULER_CONFIG_LOADER_TIMEOUT_SECS = "scheduler.config.loader.timeout.secs";
    @ConfigValidationAnnotations.IsString
    public static final String SCHEDULER_CONFIG_LOADER_ARTIFACTORY_BASE_DIRECTORY = "scheduler.config.loader.artifactory.base.directory";
    @ConfigValidationAnnotations.IsMapEntryType(keyType=String.class, valueType=Number.class)
    public static final String MULTITENANT_SCHEDULER_USER_POOLS = "multitenant.scheduler.user.pools";
    @ConfigValidationAnnotations.IsMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.UserResourcePoolEntryValidator.class})
    public static final String RESOURCE_AWARE_SCHEDULER_USER_POOLS = "resource.aware.scheduler.user.pools";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=ISchedulingPriorityStrategy.class)
    public static final String RESOURCE_AWARE_SCHEDULER_PRIORITY_STRATEGY = "resource.aware.scheduler.priority.strategy";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String RESOURCE_AWARE_SCHEDULER_MAX_TOPOLOGY_SCHEDULING_ATTEMPTS = "resource.aware.scheduler.max.topology.scheduling.attempts";
    @ConfigValidationAnnotations.IsInteger
    @ConfigValidationAnnotations.IsPositiveNumber
    public static final String RESOURCE_AWARE_SCHEDULER_MAX_STATE_SEARCH = "resource.aware.scheduler.constraint.max.state.search";
    @ConfigValidationAnnotations.IsInteger
    public static final String NIMBUS_CODE_SYNC_FREQ_SECS = "nimbus.code.sync.freq.secs";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=ResourceIsolationInterface.class)
    public static final String STORM_RESOURCE_ISOLATION_PLUGIN = "storm.resource.isolation.plugin";
    @ConfigValidationAnnotations.IsStringList
    public static final String STORM_CGROUP_RESOURCES = "storm.cgroup.resources";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_CGROUP_HIERARCHY_NAME = "storm.cgroup.hierarchy.name";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_RESOURCE_ISOLATION_PLUGIN_ENABLE = "storm.resource.isolation.plugin.enable";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsString
    public static final String STORM_METRIC_STORE_CLASS = "storm.metricstore.class";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.IsString
    public static final String STORM_METRIC_PROCESSOR_CLASS = "storm.metricprocessor.class";
    @ConfigValidationAnnotations.IsString
    public static final String STORM_ROCKSDB_LOCATION = "storm.metricstore.rocksdb.location";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_ROCKSDB_CREATE_IF_MISSING = "storm.metricstore.rocksdb.create_if_missing";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ROCKSDB_METADATA_STRING_CACHE_CAPACITY = "storm.metricstore.rocksdb.metadata_string_cache_capacity";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ROCKSDB_METRIC_RETENTION_HOURS = "storm.metricstore.rocksdb.retention_hours";
    @ConfigValidationAnnotations.IsInteger
    public static final String STORM_ROCKSDB_METRIC_DELETION_PERIOD_HOURS = "storm.metricstore.rocksdb.deletion_period_hours";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_NIMBUS_ZOOKEEPER_ACLS_CHECK = "storm.nimbus.zookeeper.acls.check";
    @ConfigValidationAnnotations.IsBoolean
    public static final String STORM_NIMBUS_ZOOKEEPER_ACLS_FIXUP = "storm.nimbus.zookeeper.acls.fixup";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IStrategy.class)
    public static final String VALIDATE_TOPOLOGY_SCHEDULER_STRATEGY = "topology.scheduler.strategy";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IHttpCredentialsPlugin.class)
    public static final String UI_HTTP_CREDS_PLUGIN = "ui.http.creds.plugin";
    @ConfigValidationAnnotations.IsImplementationOfClass(implementsClass=IHttpCredentialsPlugin.class)
    public static final String DRPC_HTTP_CREDS_PLUGIN = "drpc.http.creds.plugin";
    @ConfigValidationAnnotations.IsString
    public static String STORM_SUPERVISOR_CGROUP_ROOTDIR = "storm.supervisor.cgroup.rootdir";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_WORKER_CGROUP_MEMORY_MB_LIMIT = "storm.worker.cgroup.memory.mb.limit";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_WORKER_CGROUP_CPU_LIMIT = "storm.worker.cgroup.cpu.limit";
    @ConfigValidationAnnotations.IsString
    public static String STORM_CGROUP_CGEXEC_CMD = "storm.cgroup.cgexec.cmd";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static String STORM_CGROUP_MEMORY_LIMIT_TOLERANCE_MARGIN_MB = "storm.cgroup.memory.limit.tolerance.margin.mb";
    @ConfigValidationAnnotations.IsBoolean
    public static String STORM_CGROUP_INHERIT_CPUSET_CONFIGS = "storm.cgroup.inherit.cpuset.configs";
    @ConfigValidationAnnotations.IsBoolean
    public static String STORM_CGROUP_MEMORY_ENFORCEMENT_ENABLE = "storm.cgroup.memory.enforcement.enable";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_SUPERVISOR_MEMORY_LIMIT_TOLERANCE_MARGIN_MB = "storm.supervisor.memory.limit.tolerance.margin.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_SUPERVISOR_HARD_MEMORY_LIMIT_MULTIPLIER = "storm.supervisor.hard.memory.limit.multiplier";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static String STORM_SUPERVISOR_HARD_LIMIT_MEMORY_OVERAGE_MB = "storm.supervisor.hard.memory.limit.overage.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_SUPERVISOR_LOW_MEMORY_THRESHOLD_MB = "storm.supervisor.low.memory.threshold.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_SUPERVISOR_MEDIUM_MEMORY_THRESHOLD_MB = "storm.supervisor.medium.memory.threshold.mb";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_SUPERVISOR_MEDIUM_MEMORY_GRACE_PERIOD_MS = "storm.supervisor.medium.memory.grace.period.ms";
    @ConfigValidationAnnotations.IsPositiveNumber(includeZero=true)
    public static String STORM_WORKER_MIN_CPU_PCORE_PERCENT = "storm.worker.min.cpu.pcore.percent";
    @ConfigValidationAnnotations.IsPositiveNumber
    public static String STORM_WORKER_TOKEN_LIFE_TIME_HOURS = "storm.worker.token.life.time.hours";

    public static String getCgroupRootDir(Map<String, Object> conf) {
        return (String)conf.get(STORM_SUPERVISOR_CGROUP_ROOTDIR);
    }

    public static String getCgroupStormHierarchyDir(Map<String, Object> conf) {
        return (String)conf.get("storm.cgroup.hierarchy.dir");
    }

    public static ArrayList<String> getCgroupStormResources(Map<String, Object> conf) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String entry : (Iterable)conf.get(STORM_CGROUP_RESOURCES)) {
            ret.add(entry);
        }
        return ret;
    }

    public static String getCgroupStormHierarchyName(Map<String, Object> conf) {
        return (String)conf.get(STORM_CGROUP_HIERARCHY_NAME);
    }
}

