/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.LogCLIHelpers;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LogsCLI
extends Configured
implements Tool {
    private static final String CONTAINER_ID_OPTION = "containerId";
    private static final String APPLICATION_ID_OPTION = "applicationId";
    private static final String NODE_ADDRESS_OPTION = "nodeAddress";
    private static final String APP_OWNER_OPTION = "appOwner";
    private static final String AM_CONTAINER_OPTION = "am";
    private static final String CONTAINER_LOG_FILES = "logFiles";
    public static final String HELP_CMD = "help";

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption(HELP_CMD, false, "Displays help for all commands.");
        Option appIdOpt = new Option(APPLICATION_ID_OPTION, true, "ApplicationId (required)");
        appIdOpt.setRequired(true);
        opts.addOption(appIdOpt);
        opts.addOption(CONTAINER_ID_OPTION, true, "ContainerId. By default, it will only print syslog if the application is runing. Work with -logFiles to get other logs.");
        opts.addOption(NODE_ADDRESS_OPTION, true, "NodeAddress in the format nodename:port");
        opts.addOption(APP_OWNER_OPTION, true, "AppOwner (assumed to be current user if not specified)");
        Option amOption = new Option(AM_CONTAINER_OPTION, true, "Prints the AM Container logs for this application. Specify comma-separated value to get logs for related AM Container. For example, If we specify -am 1,2, we will get the logs for the first AM Container as well as the second AM Container. To get logs for all AM Containers, use -am ALL. To get logs for the latest AM Container, use -am -1. By default, it will only print out syslog. Work with -logFiles to get other logs");
        amOption.setValueSeparator(',');
        amOption.setArgs(-2);
        amOption.setArgName("AM Containers");
        opts.addOption(amOption);
        Option logFileOpt = new Option(CONTAINER_LOG_FILES, true, "Work with -am/-containerId and specify comma-separated value to get specified container log files. Use \"ALL\" to fetch all the log files for the container.");
        logFileOpt.setValueSeparator(',');
        logFileOpt.setArgs(-2);
        logFileOpt.setArgName("Log File Name");
        opts.addOption(logFileOpt);
        opts.getOption(APPLICATION_ID_OPTION).setArgName("Application ID");
        opts.getOption(CONTAINER_ID_OPTION).setArgName("Container ID");
        opts.getOption(NODE_ADDRESS_OPTION).setArgName("Node Address");
        opts.getOption(APP_OWNER_OPTION).setArgName("Application Owner");
        opts.getOption(AM_CONTAINER_OPTION).setArgName("AM Containers");
        Options printOpts = new Options();
        printOpts.addOption(opts.getOption(HELP_CMD));
        printOpts.addOption(opts.getOption(CONTAINER_ID_OPTION));
        printOpts.addOption(opts.getOption(NODE_ADDRESS_OPTION));
        printOpts.addOption(opts.getOption(APP_OWNER_OPTION));
        printOpts.addOption(opts.getOption(AM_CONTAINER_OPTION));
        printOpts.addOption(opts.getOption(CONTAINER_LOG_FILES));
        if (args.length < 1) {
            this.printHelpMessage(printOpts);
            return -1;
        }
        if (args[0].equals("-help")) {
            this.printHelpMessage(printOpts);
            return 0;
        }
        GnuParser parser = new GnuParser();
        String appIdStr = null;
        String containerIdStr = null;
        String nodeAddress = null;
        String appOwner = null;
        boolean getAMContainerLogs = false;
        String[] logFiles = null;
        ArrayList<String> amContainersList = new ArrayList<String>();
        try {
            CommandLine commandLine = parser.parse(opts, args, true);
            appIdStr = commandLine.getOptionValue(APPLICATION_ID_OPTION);
            containerIdStr = commandLine.getOptionValue(CONTAINER_ID_OPTION);
            nodeAddress = commandLine.getOptionValue(NODE_ADDRESS_OPTION);
            appOwner = commandLine.getOptionValue(APP_OWNER_OPTION);
            getAMContainerLogs = commandLine.hasOption(AM_CONTAINER_OPTION);
            if (getAMContainerLogs) {
                String[] amContainers;
                for (String am : amContainers = commandLine.getOptionValues(AM_CONTAINER_OPTION)) {
                    boolean errorInput = false;
                    if (am.trim().equalsIgnoreCase("ALL")) {
                        amContainersList.add("ALL");
                        break;
                    }
                    try {
                        int id = Integer.parseInt(am.trim());
                        if (id != -1 && id <= 0) {
                            errorInput = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        errorInput = true;
                    }
                    if (errorInput) {
                        System.err.println("Invalid input for option -am. Valid inputs are 'ALL', -1 and any other integer which is larger than 0.");
                        this.printHelpMessage(printOpts);
                        return -1;
                    }
                    amContainersList.add(am.trim());
                }
            }
            if (commandLine.hasOption(CONTAINER_LOG_FILES)) {
                logFiles = commandLine.getOptionValues(CONTAINER_LOG_FILES);
            }
        }
        catch (ParseException e) {
            System.err.println("options parsing failed: " + e.getMessage());
            this.printHelpMessage(printOpts);
            return -1;
        }
        if (appIdStr == null) {
            System.err.println("ApplicationId cannot be null!");
            this.printHelpMessage(printOpts);
            return -1;
        }
        ApplicationId appId = null;
        try {
            appId = ApplicationId.fromString((String)appIdStr);
        }
        catch (Exception e) {
            System.err.println("Invalid ApplicationId specified");
            return -1;
        }
        LogCLIHelpers logCliHelper = new LogCLIHelpers();
        logCliHelper.setConf(this.getConf());
        if (appOwner == null || appOwner.isEmpty()) {
            appOwner = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        YarnApplicationState appState = YarnApplicationState.NEW;
        try {
            appState = this.getApplicationState(appId);
            if (appState == YarnApplicationState.NEW || appState == YarnApplicationState.NEW_SAVING || appState == YarnApplicationState.SUBMITTED) {
                System.out.println("Logs are not avaiable right now.");
                return -1;
            }
        }
        catch (IOException | YarnException e) {
            System.err.println("Unable to get ApplicationState. Attempting to fetch logs directly from the filesystem.");
        }
        if (getAMContainerLogs) {
            if (logFiles == null || logFiles.length == 0) {
                logFiles = new String[]{"syslog"};
            }
            if (appState == YarnApplicationState.ACCEPTED || appState == YarnApplicationState.RUNNING) {
                return this.printAMContainerLogs(this.getConf(), appIdStr, amContainersList, logFiles, logCliHelper, appOwner, false);
            }
            if (this.getConf().getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
                return this.printAMContainerLogs(this.getConf(), appIdStr, amContainersList, logFiles, logCliHelper, appOwner, true);
            }
            System.out.println("Can not get AMContainers logs for the application:" + appId);
            System.out.println("This application:" + appId + " is finished." + " Please enable the application history service. Or Using " + "yarn logs -applicationId <appId> -containerId <containerId> " + "--nodeAddress <nodeHttpAddress> to get the container logs");
            return -1;
        }
        int resultCode = 0;
        if (containerIdStr != null) {
            if (nodeAddress != null && this.isApplicationFinished(appState)) {
                List<String> logs = logFiles == null ? null : (this.fetchAllLogFiles(logFiles) ? null : Arrays.asList(logFiles));
                return logCliHelper.dumpAContainersLogsForALogType(appIdStr, containerIdStr, nodeAddress, appOwner, logs);
            }
            try {
                ContainerReport report = this.getContainerReport(containerIdStr);
                String nodeHttpAddress = report.getNodeHttpAddress().replaceFirst(WebAppUtils.getHttpSchemePrefix((Configuration)this.getConf()), "");
                String nodeId = report.getAssignedNode().toString();
                if (!this.isApplicationFinished(appState)) {
                    if (logFiles == null || logFiles.length == 0) {
                        logFiles = new String[]{"syslog"};
                    }
                    this.printContainerLogsFromRunningApplication(this.getConf(), appIdStr, containerIdStr, nodeHttpAddress, nodeId, logFiles, logCliHelper, appOwner);
                } else {
                    String[] requestedLogFiles = logFiles;
                    if (this.fetchAllLogFiles(logFiles)) {
                        requestedLogFiles = null;
                    }
                    this.printContainerLogsForFinishedApplication(appIdStr, containerIdStr, nodeId, requestedLogFiles, logCliHelper, appOwner);
                }
                return resultCode;
            }
            catch (IOException | YarnException ex) {
                System.err.println("Unable to get logs for this container:" + containerIdStr + "for the application:" + appId);
                if (!this.getConf().getBoolean("yarn.timeline-service.generic-application-history.enabled", false)) {
                    System.out.println("Please enable the application history service. Or ");
                }
                System.out.println("Using yarn logs -applicationId <appId> -containerId <containerId> --nodeAddress <nodeHttpAddress> to get the container logs");
                return -1;
            }
        }
        if (nodeAddress == null) {
            resultCode = logCliHelper.dumpAllContainersLogs(appId, appOwner, System.out);
        } else {
            System.out.println("Should at least provide ContainerId!");
            this.printHelpMessage(printOpts);
            resultCode = -1;
        }
        return resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YarnApplicationState getApplicationState(ApplicationId appId) throws IOException, YarnException {
        try (YarnClient yarnClient = this.createYarnClient();){
            ApplicationReport appReport = yarnClient.getApplicationReport(appId);
            YarnApplicationState yarnApplicationState = appReport.getYarnApplicationState();
            return yarnApplicationState;
        }
    }

    @VisibleForTesting
    protected YarnClient createYarnClient() {
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(this.getConf());
        yarnClient.start();
        return yarnClient;
    }

    public static void main(String[] args) throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        LogsCLI logDumper = new LogsCLI();
        logDumper.setConf((Configuration)conf);
        int exitCode = logDumper.run(args);
        System.exit(exitCode);
    }

    private void printHelpMessage(Options options) {
        System.out.println("Retrieve logs for completed YARN applications.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("yarn logs -applicationId <application ID> [OPTIONS]", new Options());
        formatter.setSyntaxPrefix("");
        formatter.printHelp("general options are:", options);
    }

    private List<JSONObject> getAMContainerInfoForRMWebService(Configuration conf, String appId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        Client webServiceClient = Client.create();
        String webAppAddress = WebAppUtils.getRMWebAppURLWithScheme((Configuration)conf);
        WebResource webResource = webServiceClient.resource(webAppAddress);
        ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("cluster").path("apps").path(appId).path("appattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = ((JSONObject)response.getEntity(JSONObject.class)).getJSONObject("appAttempts");
        JSONArray requests = json.getJSONArray("appAttempt");
        ArrayList<JSONObject> amContainersList = new ArrayList<JSONObject>();
        for (int i = 0; i < requests.length(); ++i) {
            amContainersList.add(requests.getJSONObject(i));
        }
        return amContainersList;
    }

    private List<JSONObject> getAMContainerInfoForAHSWebService(Configuration conf, String appId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        Client webServiceClient = Client.create();
        String webAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
        WebResource webResource = webServiceClient.resource(webAppAddress);
        ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("applicationhistory").path("apps").path(appId).path("appattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONArray requests = json.getJSONArray("appAttempt");
        ArrayList<JSONObject> amContainersList = new ArrayList<JSONObject>();
        for (int i = 0; i < requests.length(); ++i) {
            amContainersList.add(requests.getJSONObject(i));
        }
        Collections.reverse(amContainersList);
        return amContainersList;
    }

    private boolean fetchAllLogFiles(String[] logFiles) {
        List<String> logs;
        return logFiles != null && (logs = Arrays.asList(logFiles)).contains("ALL");
    }

    private String[] getContainerLogFiles(Configuration conf, String containerIdStr, String nodeHttpAddress) throws IOException {
        ArrayList<String> logFiles;
        block5: {
            logFiles = new ArrayList<String>();
            Client webServiceClient = Client.create();
            try {
                WebResource webResource = webServiceClient.resource(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + nodeHttpAddress);
                ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("node").path("containers").path(containerIdStr).accept(new String[]{"application/xml"}).get(ClientResponse.class);
                if (!response.getClientResponseStatus().equals((Object)ClientResponse.Status.OK)) break block5;
                try {
                    String xml = (String)response.getEntity(String.class);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList elements = dom.getElementsByTagName("containerLogFiles");
                    for (int i = 0; i < elements.getLength(); ++i) {
                        logFiles.add(elements.item(i).getTextContent());
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to parse xml from webservice. Error:");
                    System.out.println(e.getMessage());
                    throw new IOException(e);
                }
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                System.out.println("Unable to fetch log files list");
                throw new IOException(ex);
            }
        }
        return logFiles.toArray(new String[0]);
    }

    private void printContainerLogsFromRunningApplication(Configuration conf, String appId, String containerIdStr, String nodeHttpAddress, String nodeId, String[] logFiles, LogCLIHelpers logCliHelper, String appOwner) throws IOException {
        String[] requestedLogFiles = logFiles;
        if (this.fetchAllLogFiles(logFiles)) {
            requestedLogFiles = this.getContainerLogFiles(this.getConf(), containerIdStr, nodeHttpAddress);
        }
        Client webServiceClient = Client.create();
        String containerString = "\n\nContainer: " + containerIdStr;
        System.out.println(containerString);
        System.out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
        for (String logFile : requestedLogFiles) {
            System.out.println("LogType:" + logFile);
            System.out.println("Log Upload Time:" + Times.format((long)System.currentTimeMillis()));
            System.out.println("Log Contents:");
            try {
                WebResource webResource = webServiceClient.resource(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + nodeHttpAddress);
                ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("node").path("containerlogs").path(containerIdStr).path(logFile).accept(new String[]{"text/plain"}).get(ClientResponse.class);
                System.out.println((String)response.getEntity(String.class));
                System.out.println("End of LogType:" + logFile);
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                System.out.println("Can not find the log file:" + logFile + " for the container:" + containerIdStr + " in NodeManager:" + nodeId);
            }
        }
        logCliHelper.dumpAContainersLogsForALogType(appId, containerIdStr, nodeId, appOwner, Arrays.asList(requestedLogFiles));
    }

    private void printContainerLogsForFinishedApplication(String appId, String containerId, String nodeAddress, String[] logFiles, LogCLIHelpers logCliHelper, String appOwner) throws IOException {
        String containerString = "\n\nContainer: " + containerId;
        System.out.println(containerString);
        System.out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
        logCliHelper.dumpAContainersLogsForALogType(appId, containerId, nodeAddress, appOwner, logFiles != null ? Arrays.asList(logFiles) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerReport getContainerReport(String containerIdStr) throws YarnException, IOException {
        try (YarnClient yarnClient = this.createYarnClient();){
            ContainerReport containerReport = yarnClient.getContainerReport(ContainerId.fromString((String)containerIdStr));
            return containerReport;
        }
    }

    private boolean isApplicationFinished(YarnApplicationState appState) {
        return appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED;
    }

    private int printAMContainerLogs(Configuration conf, String appId, List<String> amContainers, String[] logFiles, LogCLIHelpers logCliHelper, String appOwner, boolean applicationFinished) throws Exception {
        String errorMessage;
        boolean getAMContainerLists;
        ArrayList<AMLogsRequest> requests;
        block14: {
            List<JSONObject> amContainersList = null;
            requests = new ArrayList<AMLogsRequest>();
            getAMContainerLists = false;
            errorMessage = "";
            try {
                amContainersList = this.getAMContainerInfoForRMWebService(conf, appId);
                if (amContainersList != null && !amContainersList.isEmpty()) {
                    getAMContainerLists = true;
                    for (JSONObject jSONObject : amContainersList) {
                        AMLogsRequest request = new AMLogsRequest(applicationFinished);
                        request.setAmContainerId(jSONObject.getString(CONTAINER_ID_OPTION));
                        request.setNodeHttpAddress(jSONObject.getString("nodeHttpAddress"));
                        request.setNodeId(jSONObject.getString("nodeId"));
                        requests.add(request);
                    }
                }
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
                if (!applicationFinished) break block14;
                try {
                    amContainersList = this.getAMContainerInfoForAHSWebService(conf, appId);
                    if (amContainersList != null && !amContainersList.isEmpty()) {
                        getAMContainerLists = true;
                        for (JSONObject amContainer : amContainersList) {
                            AMLogsRequest request = new AMLogsRequest(applicationFinished);
                            request.setAmContainerId(amContainer.getString("amContainerId"));
                            requests.add(request);
                        }
                    }
                }
                catch (Exception exception) {
                    errorMessage = exception.getMessage();
                }
            }
        }
        if (!getAMContainerLists) {
            System.err.println("Unable to get AM container informations for the application:" + appId);
            System.err.println(errorMessage);
            return -1;
        }
        if (amContainers.contains("ALL")) {
            for (AMLogsRequest aMLogsRequest : requests) {
                this.outputAMContainerLogs(aMLogsRequest, conf, appId, logFiles, logCliHelper, appOwner);
            }
            System.out.println();
            System.out.println("Specified ALL for -am option. Printed logs for all am containers.");
        } else {
            for (String string : amContainers) {
                int amContainerId = Integer.parseInt(string.trim());
                if (amContainerId == -1) {
                    this.outputAMContainerLogs((AMLogsRequest)requests.get(requests.size() - 1), conf, appId, logFiles, logCliHelper, appOwner);
                    continue;
                }
                if (amContainerId > requests.size()) continue;
                this.outputAMContainerLogs((AMLogsRequest)requests.get(amContainerId - 1), conf, appId, logFiles, logCliHelper, appOwner);
            }
        }
        return 0;
    }

    private void outputAMContainerLogs(AMLogsRequest request, Configuration conf, String appId, String[] logFiles, LogCLIHelpers logCliHelper, String appOwner) throws Exception {
        String nodeHttpAddress = request.getNodeHttpAddress();
        String containerId = request.getAmContainerId();
        String nodeId = request.getNodeId();
        if (request.isAppFinished()) {
            if (containerId != null && !containerId.isEmpty()) {
                if (nodeId == null || nodeId.isEmpty()) {
                    try {
                        nodeId = this.getContainerReport(containerId).getAssignedNode().toString();
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                        nodeId = null;
                    }
                }
                if (nodeId != null && !nodeId.isEmpty()) {
                    String[] requestedLogFilesList = null;
                    if (!this.fetchAllLogFiles(logFiles)) {
                        requestedLogFilesList = logFiles;
                    }
                    this.printContainerLogsForFinishedApplication(appId, containerId, nodeId, requestedLogFilesList, logCliHelper, appOwner);
                }
            }
        } else if (nodeHttpAddress != null && containerId != null && !nodeHttpAddress.isEmpty() && !containerId.isEmpty()) {
            String[] requestedLogFiles = logFiles;
            if (this.fetchAllLogFiles(logFiles)) {
                requestedLogFiles = this.getContainerLogFiles(this.getConf(), containerId, nodeHttpAddress);
            }
            this.printContainerLogsFromRunningApplication(conf, appId, containerId, nodeHttpAddress, nodeId, requestedLogFiles, logCliHelper, appOwner);
        }
    }

    private static class AMLogsRequest {
        private String amContainerId;
        private String nodeId;
        private String nodeHttpAddress;
        private final boolean isAppFinished;

        AMLogsRequest(boolean isAppFinished) {
            this.isAppFinished = isAppFinished;
            this.setAmContainerId("");
            this.setNodeId("");
            this.setNodeHttpAddress("");
        }

        public String getAmContainerId() {
            return this.amContainerId;
        }

        public void setAmContainerId(String amContainerId) {
            this.amContainerId = amContainerId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeHttpAddress() {
            return this.nodeHttpAddress;
        }

        public void setNodeHttpAddress(String nodeHttpAddress) {
            this.nodeHttpAddress = nodeHttpAddress;
        }

        public boolean isAppFinished() {
            return this.isAppFinished;
        }
    }
}

