/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.auth.Subject;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.NimbusBlobStore;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.ClusterSummary;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.serialization.SerializationDelegate;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.shade.com.google.common.collect.MapDifference;
import org.apache.storm.shade.com.google.common.collect.Maps;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.shade.org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.apache.zookeeper.ZooDefs;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Id;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.storm.shade.org.json.simple.parser.ParseException;
import org.apache.storm.shade.org.yaml.snakeyaml.Yaml;
import org.apache.storm.shade.org.yaml.snakeyaml.constructor.BaseConstructor;
import org.apache.storm.shade.org.yaml.snakeyaml.constructor.SafeConstructor;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TDeserializer;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TSerializer;
import org.apache.storm.utils.IPredicate;
import org.apache.storm.utils.IVersionInfo;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.SimpleVersion;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.VersionInfo;
import org.apache.storm.utils.WrappedInvalidTopologyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_STREAM_ID = "default";
    private static final Set<Class<?>> defaultAllowedExceptions = Collections.emptySet();
    private static final List<String> LOCALHOST_ADDRESSES = Lists.newArrayList((Object[])new String[]{"localhost", "127.0.0.1", "0:0:0:0:0:0:0:1"});
    static SerializationDelegate serializationDelegate;
    private static ThreadLocal<TSerializer> threadSer;
    private static ThreadLocal<TDeserializer> threadDes;
    private static ClassLoader cl;
    private static Map<String, Object> localConf;
    private static Utils _instance;
    private static String memoizedLocalHostnameString;
    public static final Pattern TOPOLOGY_KEY_PATTERN;

    public static Utils setInstance(Utils u) {
        Utils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    @VisibleForTesting
    public static void setClassLoaderForJavaDeSerialize(ClassLoader cl) {
        Utils.cl = cl;
    }

    @VisibleForTesting
    public static void resetClassLoaderForJavaDeSerialize() {
        cl = ClassLoader.getSystemClassLoader();
    }

    public static List<URL> findResources(String name) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(name);
            ArrayList<URL> ret = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                ret.add(resources.nextElement());
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> findAndReadConfigFile(String name, boolean mustExist) {
        InputStream in = null;
        boolean confFileEmpty = false;
        try {
            Yaml yaml;
            in = Utils.getConfigFileInputStream(name);
            if (null != in) {
                yaml = new Yaml((BaseConstructor)new SafeConstructor());
                Map ret = (Map)yaml.load((Reader)new InputStreamReader(in));
                if (null != ret) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(ret);
                    return hashMap;
                }
                confFileEmpty = true;
            }
            if (mustExist) {
                if (confFileEmpty) {
                    throw new RuntimeException("Config file " + name + " doesn't have any valid storm configs");
                }
                throw new RuntimeException("Could not find config file on classpath " + name);
            }
            yaml = new HashMap();
            return yaml;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static Map<String, Object> findAndReadConfigFile(String name) {
        return Utils.findAndReadConfigFile(name, true);
    }

    private static InputStream getConfigFileInputStream(String configFilePath) throws IOException {
        if (null == configFilePath) {
            throw new IOException("Could not find config file, name not specified");
        }
        HashSet<URL> resources = new HashSet<URL>(Utils.findResources(configFilePath));
        if (resources.isEmpty()) {
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                return new FileInputStream(configFile);
            }
        } else {
            if (resources.size() > 1) {
                throw new IOException("Found multiple " + configFilePath + " resources. You're probably bundling the Storm jars with your topology jar. " + resources);
            }
            LOG.debug("Using " + configFilePath + " from resources");
            URL resource = resources.iterator().next();
            return resource.openStream();
        }
        return null;
    }

    public static Map<String, Object> readDefaultConfig() {
        return Utils.findAndReadConfigFile("defaults.yaml", true);
    }

    public static String urlEncodeUtf8(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static String urlDecodeUtf8(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static Map<String, Object> readCommandLineOpts() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getProperty("storm.options");
        if (commandOptions != null) {
            String[] configs;
            for (String config : configs = commandOptions.split(",(?![^\\[\\]{}]*(]|}))")) {
                String[] options = (config = Utils.urlDecodeUtf8(config)).split("=", 2);
                if (options.length != 2) continue;
                Object val = options[1];
                try {
                    val = JSONValue.parseWithException((String)options[1]);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ret.put(options[0], val);
            }
        }
        return ret;
    }

    public static Map<String, Object> readStormConfig() {
        Map<String, Object> ret = Utils.readDefaultConfig();
        String confFile = System.getProperty("storm.conf.file");
        Map<String, Object> storm = confFile == null || confFile.equals("") ? Utils.findAndReadConfigFile("storm.yaml", false) : Utils.findAndReadConfigFile(confFile, true);
        ret.putAll(storm);
        ret.putAll(Utils.readCommandLineOpts());
        return ret;
    }

    public static long bitXorVals(List<Long> coll) {
        long result2 = 0L;
        for (Long val : coll) {
            result2 ^= val.longValue();
        }
        return result2;
    }

    public static long bitXor(Long a, Long b) {
        return a ^ b;
    }

    public static void addShutdownHookWithForceKillIn1Sec(Runnable func) {
        Utils.addShutdownHookWithDelayedForceKill(func, 1);
    }

    public static void addShutdownHookWithDelayedForceKill(Runnable func, int numSecs) {
        Thread sleepKill = new Thread(() -> {
            try {
                LOG.info("Halting after {} seconds", (Object)numSecs);
                Time.sleepSecs(numSecs);
                LOG.warn("Forcing Halt... {}", (Object)Utils.threadDump());
                Runtime.getRuntime().halt(20);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                LOG.warn("Exception in the ShutDownHook", (Throwable)e);
            }
        });
        sleepKill.setDaemon(true);
        Thread wrappedFunc = new Thread(() -> {
            func.run();
            sleepKill.interrupt();
        });
        Runtime.getRuntime().addShutdownHook(wrappedFunc);
        Runtime.getRuntime().addShutdownHook(sleepKill);
    }

    public static boolean isSystemId(String id) {
        return id.startsWith("__");
    }

    public static SmartThread asyncLoop(final Callable afn, boolean isDaemon, Thread.UncaughtExceptionHandler eh, int priority, final boolean isFactory, boolean startImmediately, String threadName) {
        SmartThread thread = new SmartThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Callable fn;
                    Callable callable = fn = isFactory ? (Callable)afn.call() : afn;
                    while (true) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        Long s = (Long)fn.call();
                        if (s != null) {
                            if (s <= 0L) continue;
                            Time.sleep(s);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, t)) {
                        LOG.info("Async loop interrupted!");
                        return;
                    }
                    LOG.error("Async loop died!", t);
                    throw new RuntimeException(t);
                }
            }
        });
        if (eh != null) {
            thread.setUncaughtExceptionHandler(eh);
        } else {
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Async loop died!", e);
                    Utils.exitProcess(1, "Async loop died!");
                }
            });
        }
        thread.setDaemon(isDaemon);
        thread.setPriority(priority);
        if (threadName != null && !threadName.isEmpty()) {
            thread.setName(thread.getName() + "-" + threadName);
        }
        if (startImmediately) {
            thread.start();
        }
        return thread;
    }

    public static SmartThread asyncLoop(Callable afn, String threadName, Thread.UncaughtExceptionHandler eh) {
        return Utils.asyncLoop(afn, false, eh, 5, false, true, threadName);
    }

    public static SmartThread asyncLoop(Callable afn) {
        return Utils.asyncLoop(afn, false, null, 5, false, true, null);
    }

    public static boolean exceptionCauseIsInstanceOf(Class klass, Throwable throwable) {
        return Utils.unwrapTo(klass, throwable) != null;
    }

    public static <T extends Throwable> T unwrapTo(Class<T> klass, Throwable t) {
        while (t != null) {
            if (klass.isInstance(t)) {
                return (T)t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static <T extends Throwable> void unwrapAndThrow(Class<T> klass, Throwable t) throws T {
        T ret = Utils.unwrapTo(klass, t);
        if (ret != null) {
            throw ret;
        }
    }

    public static RuntimeException wrapInRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static long secureRandomLong() {
        return UUID.randomUUID().getLeastSignificantBits();
    }

    public static String hostname() throws UnknownHostException {
        return _instance.hostnameImpl();
    }

    public static String localHostname() throws UnknownHostException {
        return _instance.localHostnameImpl();
    }

    public static void exitProcess(int val, String msg) {
        String combinedErrorMessage = "Halting process: " + msg;
        LOG.error(combinedErrorMessage, (Throwable)new RuntimeException(combinedErrorMessage));
        Runtime.getRuntime().exit(val);
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static byte[] javaSerialize(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T javaDeserialize(byte[] serialized, Class<T> clazz) {
        if ("true".equalsIgnoreCase(System.getProperty("java.deserialization.disabled"))) {
            throw new AssertionError((Object)"java deserialization has been disabled and is only safe from within a worker process");
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            ObjectInputStream ois = null;
            ois = null == cl ? new ObjectInputStream(bis) : new ClassLoaderObjectInputStream(cl, (InputStream)bis);
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <S, T> T get(Map<S, T> m, S key, T def) {
        T ret = m.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static double zeroIfNaNOrInf(double x) {
        return Double.isNaN(x) || Double.isInfinite(x) ? 0.0 : x;
    }

    public static <T> String join(Iterable<T> coll, String sep) {
        Iterator<T> it = coll.iterator();
        StringBuilder ret = new StringBuilder();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(sep);
        }
        return ret.toString();
    }

    public static Id parseZkId(String id, String configName) {
        String[] split = id.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException(configName + " does not appear to be in the form scheme:acl, i.e. sasl:storm-user");
        }
        return new Id(split[0], split[1]);
    }

    public static ACL getSuperUserAcl(Map<String, Object> conf) {
        String stormZKUser = (String)conf.get("storm.zookeeper.superACL");
        if (stormZKUser == null) {
            throw new IllegalArgumentException("Authentication is enabled but storm.zookeeper.superACL is not set");
        }
        return new ACL(31, Utils.parseZkId(stormZKUser, "storm.zookeeper.superACL"));
    }

    public static List<ACL> getWorkerACL(Map<String, Object> conf) {
        if (!Utils.isZkAuthenticationConfiguredTopology(conf)) {
            return null;
        }
        ArrayList<ACL> ret = new ArrayList<ACL>(ZooDefs.Ids.CREATOR_ALL_ACL);
        ret.add(Utils.getSuperUserAcl(conf));
        return ret;
    }

    public static boolean isZkAuthenticationConfiguredTopology(Map<String, Object> conf) {
        return conf != null && conf.get("storm.zookeeper.topology.auth.scheme") != null && !((String)conf.get("storm.zookeeper.topology.auth.scheme")).isEmpty();
    }

    public static void handleUncaughtException(Throwable t) {
        Utils.handleUncaughtException(t, defaultAllowedExceptions);
    }

    public static void handleUncaughtException(Throwable t, Set<Class<?>> allowedExceptions) {
        if (t != null && t instanceof OutOfMemoryError) {
            try {
                System.err.println("Halting due to Out Of Memory Error..." + Thread.currentThread().getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Runtime.getRuntime().halt(-1);
        }
        if (allowedExceptions.contains(t.getClass())) {
            LOG.info("Swallowing {} {}", t.getClass(), (Object)t);
            return;
        }
        throw new Error(t);
    }

    public static byte[] thriftSerialize(TBase t) {
        try {
            TSerializer ser = threadSer.get();
            if (ser == null) {
                ser = new TSerializer();
                threadSer.set(ser);
            }
            return ser.serialize(t);
        }
        catch (TException e) {
            LOG.error("Failed to serialize to thrift: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T thriftDeserialize(Class<T> c, byte[] b) {
        try {
            return Utils.thriftDeserialize(c, b, 0, b.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T thriftDeserialize(Class<T> c, byte[] b, int offset, int length) {
        try {
            T ret = c.newInstance();
            TDeserializer des = Utils.getDes();
            des.deserialize((TBase)ret, b, offset, length);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static TDeserializer getDes() {
        TDeserializer des = threadDes.get();
        if (des == null) {
            des = new TDeserializer();
            threadDes.set(des);
        }
        return des;
    }

    public static void sleepNoSimulation(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long millis) {
        try {
            Time.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static UptimeComputer makeUptimeComputer() {
        return _instance.makeUptimeComputerImpl();
    }

    public static <K, V> HashMap<V, List<K>> reverseMap(Map<K, V> map) {
        HashMap<V, ArrayList<K>> rtn = new HashMap<V, ArrayList<K>>();
        if (map == null) {
            return rtn;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            ArrayList<K> list = (ArrayList<K>)rtn.get(val);
            if (list == null) {
                list = new ArrayList<K>();
                rtn.put(entry.getValue(), list);
            }
            list.add(key);
        }
        return rtn;
    }

    public static Map<Object, List<Object>> reverseMap(List<List<Object>> listSeq) {
        HashMap<Object, List<Object>> rtn = new HashMap<Object, List<Object>>();
        if (listSeq == null) {
            return rtn;
        }
        for (List<Object> listEntry : listSeq) {
            Object key = listEntry.get(0);
            Object val = listEntry.get(1);
            ArrayList<Object> list = (ArrayList<Object>)rtn.get(val);
            if (list == null) {
                list = new ArrayList<Object>();
                rtn.put(val, list);
            }
            list.add(key);
        }
        return rtn;
    }

    public static boolean isOnWindows() {
        if (System.getenv("OS") != null) {
            return System.getenv("OS").equals("Windows_NT");
        }
        return false;
    }

    public static boolean checkFileExists(String path) {
        return Files.exists(new File(path).toPath(), new LinkOption[0]);
    }

    public static void forceDelete(String path) throws IOException {
        _instance.forceDeleteImpl(path);
    }

    public static byte[] serialize(Object obj) {
        return serializationDelegate.serialize(obj);
    }

    public static <T> T deserialize(byte[] serialized, Class<T> clazz) {
        return serializationDelegate.deserialize(serialized, clazz);
    }

    public static String serializeToString(Object obj) {
        return Base64.getEncoder().encodeToString(serializationDelegate.serialize(obj));
    }

    public static <T> T deserializeFromString(String str, Class<T> clazz) {
        return Utils.deserialize(Base64.getDecoder().decode(str), clazz);
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static Runnable mkSuicideFn() {
        return new Runnable(){

            @Override
            public void run() {
                Utils.exitProcess(1, "Worker died");
            }
        };
    }

    public static void readAndLogStream(String prefix, InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = r.readLine()) != null) {
                LOG.info("{}:{}", (Object)prefix, (Object)line);
            }
        }
        catch (IOException e) {
            LOG.warn("Error while trying to log stream", (Throwable)e);
        }
    }

    private static SerializationDelegate getSerializationDelegate(Map<String, Object> topoConf) {
        SerializationDelegate delegate;
        String delegateClassName = (String)topoConf.get("storm.meta.serialization.delegate");
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            delegate = (SerializationDelegate)delegateClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to construct serialization delegate class " + delegateClassName, e);
        }
        delegate.prepare(topoConf);
        return delegate;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String id) {
        if (topology.get_spouts().containsKey(id)) {
            return topology.get_spouts().get(id).get_common();
        }
        if (topology.get_bolts().containsKey(id)) {
            return topology.get_bolts().get(id).get_common();
        }
        if (topology.get_state_spouts().containsKey(id)) {
            return topology.get_state_spouts().get(id).get_common();
        }
        throw new IllegalArgumentException("Could not find component with id " + id);
    }

    public static List<Object> tuple(Object ... values) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(v);
        }
        return ret;
    }

    public static byte[] gzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            out.write(data);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] gunzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            GZIPInputStream in = new GZIPInputStream(bis);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
            in.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getRepeat(List<String> list) {
        ArrayList<String> rtn = new ArrayList<String>();
        HashSet<String> idSet = new HashSet<String>();
        for (String id : list) {
            if (idSet.contains(id)) {
                rtn.add(id);
                continue;
            }
            idSet.add(id);
        }
        return rtn;
    }

    public static GlobalStreamId getGlobalStreamId(String streamId, String componentId) {
        if (componentId == null) {
            return new GlobalStreamId(streamId, DEFAULT_STREAM_ID);
        }
        return new GlobalStreamId(streamId, componentId);
    }

    public static Object getSetComponentObject(ComponentObject obj) {
        if (obj.getSetField() == ComponentObject._Fields.SERIALIZED_JAVA) {
            return Utils.javaDeserialize(obj.get_serialized_java(), Serializable.class);
        }
        if (obj.getSetField() == ComponentObject._Fields.JAVA_OBJECT) {
            return obj.get_java_object();
        }
        return obj.get_shell();
    }

    public static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    public static String processPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = name.split("@");
        if (split.length != 2) {
            throw new RuntimeException("Got unexpected process name: " + name);
        }
        return split[0];
    }

    public static Map<String, Object> fromCompressedJsonConf(byte[] serialized) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            InputStreamReader in = new InputStreamReader(new GZIPInputStream(bis));
            Object ret = JSONValue.parseWithException((Reader)in);
            in.close();
            return (Map)ret;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> redactValue(Map<String, Object> m, String key) {
        if (m.containsKey(key)) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(m);
            Object value = newMap.get(key);
            String v = value.toString();
            String redacted = new String(new char[v.length()]).replace("\u0000", "#");
            newMap.put(key, redacted);
            return newMap;
        }
        return m;
    }

    public static Thread.UncaughtExceptionHandler createDefaultUncaughtExceptionHandler() {
        return (thread, thrown) -> {
            try {
                Utils.handleUncaughtException(thrown);
            }
            catch (Error err) {
                LOG.error("Received error in thread {}.. terminating server...", (Object)thread.getName(), (Object)err);
                Runtime.getRuntime().exit(-2);
            }
        };
    }

    public static void setupDefaultUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(Utils.createDefaultUncaughtExceptionHandler());
    }

    public static Double parseJvmHeapMemByChildOpts(List<String> options, Double defaultValue) {
        if (options != null) {
            Pattern optsPattern = Pattern.compile("Xmx([0-9]+)([mkgMKG])");
            for (String option : options) {
                int unit;
                Matcher m;
                if (option == null || !(m = optsPattern.matcher(option)).find()) continue;
                int value = Integer.parseInt(m.group(1));
                char unitChar = m.group(2).toLowerCase().charAt(0);
                switch (unitChar) {
                    case 'k': {
                        unit = 1024;
                        break;
                    }
                    case 'm': {
                        unit = 0x100000;
                        break;
                    }
                    case 'g': {
                        unit = 0x40000000;
                        break;
                    }
                    default: {
                        unit = 1;
                    }
                }
                Double result2 = (double)(value * unit) / 1024.0 / 1024.0;
                return result2 < 1.0 ? 1.0 : result2;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static ClientBlobStore getClientBlobStore(Map<String, Object> conf) {
        ClientBlobStore store = (ClientBlobStore)ReflectionUtils.newInstance((String)conf.get("client.blobstore.class"));
        store.prepare(conf);
        return store;
    }

    private static Object normalizeConfValue(Object obj) {
        if (obj instanceof Map) {
            return Utils.normalizeConf((Map)obj);
        }
        if (obj instanceof Collection) {
            ArrayList<Object> confList = new ArrayList<Object>((Collection)obj);
            for (int i = 0; i < confList.size(); ++i) {
                Object val = confList.get(i);
                confList.set(i, Utils.normalizeConfValue(val));
            }
            return confList;
        }
        if (obj instanceof Integer) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        return obj;
    }

    private static Map<String, Object> normalizeConf(Map<String, Object> conf) {
        if (conf == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(conf);
        for (Map.Entry entry : ret.entrySet()) {
            ret.put((String)entry.getKey(), Utils.normalizeConfValue(entry.getValue()));
        }
        return ret;
    }

    public static boolean isValidConf(Map<String, Object> topoConfIn) {
        Map<String, Object> origTopoConf = Utils.normalizeConf(topoConfIn);
        try {
            Map<String, Object> deserTopoConf = Utils.normalizeConf((Map)JSONValue.parseWithException((String)JSONValue.toJSONString(topoConfIn)));
            return Utils.isValidConf(origTopoConf, deserTopoConf);
        }
        catch (ParseException e) {
            LOG.error("Json serialized config could not be deserialized", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    static boolean isValidConf(Map<String, Object> orig, Map<String, Object> deser) {
        MapDifference diff = Maps.difference(orig, deser);
        if (diff.areEqual()) {
            return true;
        }
        for (Map.Entry entryOnLeft : diff.entriesOnlyOnLeft().entrySet()) {
            LOG.warn("Config property ({}) is found in original config, but missing from the serialized-deserialized config. This is due to an internal error in serialization. Name: {} - Value: {}", new Object[]{entryOnLeft.getKey(), entryOnLeft.getKey(), entryOnLeft.getValue()});
        }
        for (Map.Entry entryOnRight : diff.entriesOnlyOnRight().entrySet()) {
            LOG.warn("Config property ({}) is not found in original config, but present in serialized-deserialized config. This is due to an internal error in serialization. Name: {} - Value: {}", new Object[]{entryOnRight.getKey(), entryOnRight.getKey(), entryOnRight.getValue()});
        }
        for (Map.Entry entryDiffers : diff.entriesDiffering().entrySet()) {
            Object leftValue = ((MapDifference.ValueDifference)entryDiffers.getValue()).leftValue();
            Object rightValue = ((MapDifference.ValueDifference)entryDiffers.getValue()).rightValue();
            LOG.warn("Config value differs after json serialization. Name: {} - Original Value: {} - DeSer. Value: {}", new Object[]{entryDiffers.getKey(), leftValue, rightValue});
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TopologyInfo getTopologyInfo(String name, String asUser, Map<String, Object> topoConf) {
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(topoConf, asUser);){
            String topologyId = Utils.getTopologyId(name, client.getClient());
            if (null != topologyId) {
                TopologyInfo topologyInfo = client.getClient().getTopologyInfo(topologyId);
                return topologyInfo;
            }
            TopologyInfo topologyInfo = null;
            return topologyInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTopologyId(String name, Nimbus.Iface client) {
        try {
            ClusterSummary summary = client.getClusterInfo();
            for (TopologySummary s : summary.get_topologies()) {
                if (!s.get_name().equals(name)) continue;
                return s.get_id();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void validateTopologyBlobStoreMap(Map<String, Object> topoConf) throws InvalidTopologyException, AuthorizationException {
        try (NimbusBlobStore client = new NimbusBlobStore();){
            client.prepare(topoConf);
            Utils.validateTopologyBlobStoreMap(topoConf, client);
        }
    }

    public static void validateTopologyBlobStoreMap(Map<String, Object> topoConf, NimbusBlobStore client) throws InvalidTopologyException, AuthorizationException {
        Map blobStoreMap = (Map)topoConf.get("topology.blobstore.map");
        if (blobStoreMap != null) {
            for (String key : blobStoreMap.keySet()) {
                try {
                    client.getBlobMeta(key);
                }
                catch (KeyNotFoundException keyNotFound) {
                    throw new WrappedInvalidTopologyException("Key not found: " + keyNotFound.get_msg());
                }
            }
        }
    }

    public static void validateTopologyBlobStoreMap(Map<String, Object> topoConf, BlobStore blobStore) throws InvalidTopologyException, AuthorizationException {
        Map blobStoreMap = (Map)topoConf.get("topology.blobstore.map");
        if (blobStoreMap != null) {
            Subject subject = ReqContext.context().subject();
            for (String key : blobStoreMap.keySet()) {
                try {
                    blobStore.getBlobMeta(key, subject);
                }
                catch (KeyNotFoundException keyNotFound) {
                    throw new WrappedInvalidTopologyException("Key not found: " + keyNotFound.get_msg());
                }
            }
        }
    }

    public static String threadDump() {
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMxBean.getThreadInfo(threadMxBean.getAllThreadIds(), 100);
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread t = entry.getKey();
            ThreadInfo threadInfo = threadMxBean.getThreadInfo(t.getId());
            if (threadInfo == null) continue;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            if (t.isDaemon()) {
                dump.append("(DAEMON)");
            }
            dump.append("\n   lock: ");
            dump.append(threadInfo.getLockName());
            dump.append(" owner: ");
            dump.append(threadInfo.getLockOwnerName());
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    public static boolean checkDirExists(String dir) {
        File file = new File(dir);
        return file.isDirectory();
    }

    public static Object getConfiguredClass(Map<String, Object> conf, Object configKey) {
        if (conf.containsKey(configKey)) {
            return ReflectionUtils.newInstance((String)conf.get(configKey));
        }
        return null;
    }

    public static boolean isZkAuthenticationConfiguredStormServer(Map<String, Object> conf) {
        return null != System.getProperty("java.security.auth.login.config") || conf != null && conf.get("storm.zookeeper.auth.scheme") != null && !((String)conf.get("storm.zookeeper.auth.scheme")).isEmpty();
    }

    public static byte[] toCompressedJsonConf(Map<String, Object> topoConf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(new GZIPOutputStream(bos));
            JSONValue.writeJSONString(topoConf, (Writer)out);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static double nullToZero(Double v) {
        return v != null ? v : 0.0;
    }

    public static <V> V OR(V a, V b) {
        return a == null ? b : a;
    }

    public static TreeMap<Integer, Integer> integerDivided(int sum, int numPieces) {
        int base = sum / numPieces;
        int numInc = sum % numPieces;
        int numBases = numPieces - numInc;
        TreeMap<Integer, Integer> ret = new TreeMap<Integer, Integer>();
        ret.put(base, numBases);
        if (numInc != 0) {
            ret.put(base + 1, numInc);
        }
        return ret;
    }

    public static <T> List<List<T>> partitionFixed(int maxNumChunks, Collection<T> coll) {
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        if (maxNumChunks == 0 || coll == null) {
            return ret;
        }
        TreeMap<Integer, Integer> parts = Utils.integerDivided(coll.size(), maxNumChunks);
        ArrayList sortedKeys = new ArrayList(parts.keySet());
        Collections.sort(sortedKeys, Collections.reverseOrder());
        Iterator<T> it = coll.iterator();
        for (Integer chunkSize : sortedKeys) {
            if (!it.hasNext()) break;
            Integer times = (Integer)parts.get(chunkSize);
            for (int i = 0; i < times && it.hasNext(); ++i) {
                ArrayList<T> chunkList = new ArrayList<T>();
                for (int j = 0; j < chunkSize && it.hasNext(); ++j) {
                    chunkList.add(it.next());
                }
                ret.add(chunkList);
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readYamlFile(String yamlFile) {
        try (FileReader reader = new FileReader(yamlFile);){
            Object object = new Yaml((BaseConstructor)new SafeConstructor()).load((Reader)reader);
            return object;
        }
        catch (Exception ex) {
            LOG.error("Failed to read yaml file.", (Throwable)ex);
            return null;
        }
    }

    public static int getAvailablePort(int preferredPort) {
        int localPort;
        block14: {
            localPort = -1;
            try (ServerSocket socket = new ServerSocket(preferredPort);){
                localPort = socket.getLocalPort();
            }
            catch (IOException exp) {
                if (preferredPort <= 0) break block14;
                return Utils.getAvailablePort(0);
            }
        }
        return localPort;
    }

    public static int getAvailablePort() {
        return Utils.getAvailablePort(0);
    }

    public static <T> T findOne(IPredicate<T> pred, Collection<T> coll) {
        if (coll == null) {
            return null;
        }
        for (T elem : coll) {
            if (!pred.test(elem)) continue;
            return elem;
        }
        return null;
    }

    public static <T, U> T findOne(IPredicate<T> pred, Map<U, T> map) {
        if (map == null) {
            return null;
        }
        return (T)Utils.findOne(pred, map.entrySet());
    }

    public static Map<String, Object> parseJson(String json) {
        if (json == null) {
            return new HashMap<String, Object>();
        }
        try {
            return (Map)JSONValue.parseWithException((String)json);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String memoizedLocalHostname() throws UnknownHostException {
        if (memoizedLocalHostnameString == null) {
            memoizedLocalHostnameString = Utils.localHostname();
        }
        return memoizedLocalHostnameString;
    }

    public static StormTopology addVersions(StormTopology topology) {
        String jdkVersion;
        String stormVersion = VersionInfo.getVersion();
        if (stormVersion != null && !"Unknown".equalsIgnoreCase(stormVersion) && !topology.is_set_storm_version()) {
            topology.set_storm_version(stormVersion);
        }
        if ((jdkVersion = System.getProperty("java.version")) != null && !topology.is_set_jdk_version()) {
            topology.set_jdk_version(jdkVersion);
        }
        return topology;
    }

    public static NavigableMap<SimpleVersion, List<String>> getConfiguredClasspathVersions(Map<String, Object> conf, List<String> currentClassPath) {
        TreeMap<SimpleVersion, List<String>> ret = new TreeMap<SimpleVersion, List<String>>();
        Map fromConf = conf.getOrDefault("supervisor.worker.version.classpath.map", Collections.emptyMap());
        for (Map.Entry entry : fromConf.entrySet()) {
            ret.put(new SimpleVersion((String)entry.getKey()), Arrays.asList(((String)entry.getValue()).split(File.pathSeparator)));
        }
        ret.put(VersionInfo.OUR_VERSION, currentClassPath);
        return ret;
    }

    public static NavigableMap<String, IVersionInfo> getAlternativeVersionsMap(Map<String, Object> conf) {
        TreeMap<String, IVersionInfo> ret = new TreeMap<String, IVersionInfo>();
        Map fromConf = conf.getOrDefault("supervisor.worker.version.classpath.map", Collections.emptyMap());
        for (Map.Entry entry : fromConf.entrySet()) {
            IVersionInfo version = VersionInfo.getFromClasspath((String)entry.getValue());
            if (version != null) {
                ret.put((String)entry.getKey(), version);
                continue;
            }
            LOG.error("Could not find the real version of {} from CP {}", entry.getKey(), entry.getValue());
            ret.put((String)entry.getKey(), new IVersionInfo(){

                @Override
                public String getVersion() {
                    return "Unknown";
                }

                @Override
                public String getRevision() {
                    return "Unknown";
                }

                @Override
                public String getBranch() {
                    return "Unknown";
                }

                @Override
                public String getDate() {
                    return "Unknown";
                }

                @Override
                public String getUser() {
                    return "Unknown";
                }

                @Override
                public String getUrl() {
                    return "Unknown";
                }

                @Override
                public String getSrcChecksum() {
                    return "Unknown";
                }

                @Override
                public String getBuildVersion() {
                    return "Unknown";
                }
            });
        }
        return ret;
    }

    public static NavigableMap<SimpleVersion, String> getConfiguredWorkerMainVersions(Map<String, Object> conf) {
        TreeMap<SimpleVersion, String> ret = new TreeMap<SimpleVersion, String>();
        Map fromConf = conf.getOrDefault("supervisor.worker.version.main.map", Collections.emptyMap());
        for (Map.Entry entry : fromConf.entrySet()) {
            ret.put(new SimpleVersion((String)entry.getKey()), (String)entry.getValue());
        }
        ret.put(VersionInfo.OUR_VERSION, "org.apache.storm.daemon.worker.Worker");
        return ret;
    }

    public static NavigableMap<SimpleVersion, String> getConfiguredWorkerLogWriterVersions(Map<String, Object> conf) {
        TreeMap<SimpleVersion, String> ret = new TreeMap<SimpleVersion, String>();
        Map fromConf = conf.getOrDefault("supervisor.worker.version.logwriter.map", Collections.emptyMap());
        for (Map.Entry entry : fromConf.entrySet()) {
            ret.put(new SimpleVersion((String)entry.getKey()), (String)entry.getValue());
        }
        ret.put(VersionInfo.OUR_VERSION, "org.apache.storm.LogWriter");
        return ret;
    }

    public static <T> T getCompatibleVersion(NavigableMap<SimpleVersion, T> versionedMap, SimpleVersion desiredVersion, String what, T defaultValue) {
        Map.Entry<SimpleVersion, T> ret = versionedMap.ceilingEntry(desiredVersion);
        if (ret == null || ret.getKey().getMajor() != desiredVersion.getMajor()) {
            ret = versionedMap.floorEntry(desiredVersion);
            if (ret == null || ret.getKey().getMajor() != desiredVersion.getMajor()) {
                if (defaultValue != null) {
                    LOG.warn("Could not find any compatible {} falling back to using {}", (Object)what, defaultValue);
                }
                return defaultValue;
            }
            LOG.warn("Could not find a higer compatible version for {} {}, using {} instead", new Object[]{what, desiredVersion, ret.getKey()});
        }
        return ret.getValue();
    }

    private static Map<String, Object> readConfIgnoreNotFound(Yaml yaml, File f) throws IOException {
        Map ret = null;
        if (f.exists()) {
            try (FileReader fr = new FileReader(f);){
                ret = (Map)yaml.load((Reader)fr);
            }
        }
        return ret;
    }

    public static Map<String, Object> getConfigFromClasspath(List<String> cp, Map<String, Object> conf) throws IOException {
        if (cp == null || cp.isEmpty()) {
            return conf;
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map<String, Object> defaultsConf = null;
        Map<String, Object> stormConf = null;
        for (String part : cp) {
            JarConfigReader jarConfigReader;
            File f = new File(part);
            if (f.getName().equals("*")) {
                File[] jarFiles;
                File dir = f.getParentFile();
                if (dir == null) {
                    dir = new File(".");
                }
                if ((jarFiles = dir.listFiles((dir1, name) -> name.endsWith(".jar") || name.endsWith(".JAR"))) == null) {
                    throw new IOException("Fail to list jar files in directory: " + dir);
                }
                for (File jarFile : jarFiles) {
                    JarConfigReader jarConfigReader2 = new JarConfigReader(yaml, defaultsConf, stormConf, jarFile).readJar();
                    defaultsConf = jarConfigReader2.getDefaultsConf();
                    stormConf = jarConfigReader2.getStormConf();
                }
                continue;
            }
            if (f.isDirectory()) {
                if (defaultsConf == null) {
                    defaultsConf = Utils.readConfIgnoreNotFound(yaml, new File(f, "defaults.yaml"));
                }
                if (stormConf != null) continue;
                stormConf = Utils.readConfIgnoreNotFound(yaml, new File(f, "storm.yaml"));
                continue;
            }
            if (!f.isFile()) continue;
            String fileName = f.getName();
            if (fileName.endsWith(".zip") || fileName.endsWith(".ZIP")) {
                jarConfigReader = new JarConfigReader(yaml, defaultsConf, stormConf, f).readZip();
                defaultsConf = jarConfigReader.getDefaultsConf();
                stormConf = jarConfigReader.getStormConf();
                continue;
            }
            if (!fileName.endsWith(".jar") && !fileName.endsWith(".JAR")) continue;
            jarConfigReader = new JarConfigReader(yaml, defaultsConf, stormConf, f).readJar();
            defaultsConf = jarConfigReader.getDefaultsConf();
            stormConf = jarConfigReader.getStormConf();
        }
        if (stormConf != null) {
            defaultsConf.putAll(stormConf);
        }
        return defaultsConf;
    }

    public static boolean isLocalhostAddress(String address) {
        return LOCALHOST_ADDRESSES.contains(address);
    }

    public static <K, V> Map<K, V> merge(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> other) {
        HashMap<? extends K, ? extends V> ret = new HashMap<K, V>(first);
        if (other != null) {
            ret.putAll(other);
        }
        return ret;
    }

    public static <V> ArrayList<V> convertToArray(Map<Integer, V> srcMap, int start) {
        Set<Integer> ids = srcMap.keySet();
        Integer largestId = (Integer)ids.stream().max(Integer::compareTo).get();
        int end = largestId - start;
        ArrayList<Object> result2 = new ArrayList<Object>(Collections.nCopies(end + 1, null));
        for (Map.Entry<Integer, V> entry : srcMap.entrySet()) {
            int id = entry.getKey();
            if (id < start) {
                LOG.debug("Entry {} will be skipped it is too small {} ...", (Object)id, (Object)start);
                continue;
            }
            result2.set(id - start, entry.getValue());
        }
        return result2;
    }

    protected void forceDeleteImpl(String path) throws IOException {
        LOG.debug("Deleting path {}", (Object)path);
        if (Utils.checkFileExists(path)) {
            try {
                FileUtils.forceDelete((File)new File(path));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public UptimeComputer makeUptimeComputerImpl() {
        return new UptimeComputer();
    }

    protected String localHostnameImpl() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    protected String hostnameImpl() throws UnknownHostException {
        if (localConf == null) {
            return Utils.memoizedLocalHostname();
        }
        Object hostnameString = localConf.get("storm.local.hostname");
        if (hostnameString == null || hostnameString.equals("")) {
            return Utils.memoizedLocalHostname();
        }
        return (String)hostnameString;
    }

    public static boolean isValidKey(String key) {
        if (StringUtils.isEmpty((String)key) || "..".equals(key) || ".".equals(key) || !TOPOLOGY_KEY_PATTERN.matcher(key).matches()) {
            LOG.error("'{}' does not appear to be valid. It must match {}. And it can't be \".\", \"..\", null or empty string.", (Object)key, (Object)TOPOLOGY_KEY_PATTERN);
            return false;
        }
        return true;
    }

    static {
        threadSer = new ThreadLocal();
        threadDes = new ThreadLocal();
        cl = null;
        _instance = new Utils();
        memoizedLocalHostnameString = null;
        TOPOLOGY_KEY_PATTERN = Pattern.compile("^[\\w \\t\\._-]+$", 256);
        localConf = Utils.readStormConfig();
        serializationDelegate = Utils.getSerializationDelegate(localConf);
    }

    private static class JarConfigReader {
        private Yaml yaml;
        private Map<String, Object> defaultsConf;
        private Map<String, Object> stormConf;
        private File file;

        public JarConfigReader(Yaml yaml, Map<String, Object> defaultsConf, Map<String, Object> stormConf, File file) {
            this.yaml = yaml;
            this.defaultsConf = defaultsConf;
            this.stormConf = stormConf;
            this.file = file;
        }

        public Map<String, Object> getDefaultsConf() {
            return this.defaultsConf;
        }

        public Map<String, Object> getStormConf() {
            return this.stormConf;
        }

        public JarConfigReader readZip() throws IOException {
            try (ZipFile zipFile = new ZipFile(this.file);){
                this.readArchive(zipFile);
            }
            return this;
        }

        public JarConfigReader readJar() throws IOException {
            try (JarFile jarFile = new JarFile(this.file);){
                this.readArchive(jarFile);
            }
            return this;
        }

        private void readArchive(ZipFile zipFile) throws IOException {
            Enumeration<? extends ZipEntry> zipEnums = zipFile.entries();
            while (zipEnums.hasMoreElements()) {
                Throwable throwable;
                InputStreamReader isr;
                ZipEntry entry = zipEnums.nextElement();
                if (entry.isDirectory()) continue;
                if (this.defaultsConf == null && entry.getName().equals("defaults.yaml")) {
                    isr = new InputStreamReader(zipFile.getInputStream(entry));
                    throwable = null;
                    try {
                        this.defaultsConf = (Map)this.yaml.load((Reader)isr);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (isr != null) {
                            if (throwable != null) {
                                try {
                                    isr.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                isr.close();
                            }
                        }
                    }
                }
                if (this.stormConf != null || !entry.getName().equals("storm.yaml")) continue;
                isr = new InputStreamReader(zipFile.getInputStream(entry));
                throwable = null;
                try {
                    this.stormConf = (Map)this.yaml.load((Reader)isr);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
        }
    }

    public static class UptimeComputer {
        int startTime = Time.currentTimeSecs();

        public int upTime() {
            return Time.deltaSecs(this.startTime);
        }
    }

    public static class SmartThread
    extends Thread {
        public SmartThread(Runnable r) {
            super(r);
        }

        public boolean isSleeping() {
            return Time.isThreadWaiting(this);
        }
    }
}

