/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.api.IStatefulObject;
import org.apache.storm.metric.internal.RateTracker;
import org.apache.storm.metrics2.JcMetrics;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.storm.shade.org.jctools.queues.MessagePassingQueue;
import org.apache.storm.shade.org.jctools.queues.MpscArrayQueue;
import org.apache.storm.shade.org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCQueue
implements IStatefulObject,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JCQueue.class);
    private static final String PREFIX = "jc-";
    private static final ScheduledThreadPoolExecutor METRICS_REPORTER_EXECUTOR = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jc-metrics-reporter").build());
    private final ExitCondition continueRunning = () -> true;
    private final JcMetrics jcMetrics;
    private final MpscArrayQueue<Object> recvQueue;
    private final MpscUnboundedArrayQueue<Object> overflowQ;
    private final int overflowLimit;
    private final int producerBatchSz;
    private final DirectInserter directInserter = new DirectInserter(this);
    private final ThreadLocal<BatchInserter> thdLocalBatcher = new ThreadLocal();
    private final QueueMetrics metrics;
    private final IWaitStrategy backPressureWaitStrategy;
    private final String queueName;

    public JCQueue(String queueName, int size, int overflowLimit, int producerBatchSz, IWaitStrategy backPressureWaitStrategy, String topologyId, String componentId, Integer taskId, int port, StormMetricRegistry metricRegistry) {
        this.queueName = queueName;
        this.overflowLimit = overflowLimit;
        this.recvQueue = new MpscArrayQueue(size);
        this.overflowQ = new MpscUnboundedArrayQueue(size);
        this.metrics = new QueueMetrics();
        this.jcMetrics = metricRegistry.jcMetrics(queueName, topologyId, componentId, taskId, port);
        this.producerBatchSz = Math.max(1, Math.min(producerBatchSz, size / 2));
        this.backPressureWaitStrategy = backPressureWaitStrategy;
        if (!METRICS_REPORTER_EXECUTOR.isShutdown()) {
            METRICS_REPORTER_EXECUTOR.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    JCQueue.this.jcMetrics.set(JCQueue.this.metrics);
                }
            }, 15L, 15L, TimeUnit.SECONDS);
        }
    }

    public String getName() {
        return this.queueName;
    }

    @Override
    public void close() {
        METRICS_REPORTER_EXECUTOR.shutdown();
        this.metrics.close();
    }

    public int consume(Consumer consumer) {
        return this.consume(consumer, this.continueRunning);
    }

    public int consume(Consumer consumer, ExitCondition exitCond) {
        try {
            return this.consumeImpl(consumer, exitCond);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.recvQueue.size() + this.overflowQ.size();
    }

    private int consumeImpl(Consumer consumer, ExitCondition exitCond) throws InterruptedException {
        int overflowDrainCount;
        Object tuple;
        int drainCount = 0;
        while (exitCond.keepRunning() && (tuple = this.recvQueue.poll()) != null) {
            consumer.accept(tuple);
            ++drainCount;
        }
        int limit = this.overflowQ.size();
        for (overflowDrainCount = 0; exitCond.keepRunning() && overflowDrainCount < limit; ++overflowDrainCount) {
            Object tuple2 = this.overflowQ.poll();
            consumer.accept(tuple2);
        }
        int total = drainCount + overflowDrainCount;
        if (total > 0) {
            consumer.flush();
        }
        return total;
    }

    private boolean tryPublishInternal(Object obj) {
        if (this.recvQueue.offer(obj)) {
            this.metrics.notifyArrivals(1L);
            return true;
        }
        return false;
    }

    private int tryPublishInternal(final ArrayList<Object> objs) {
        MessagePassingQueue.Supplier<Object> supplier = new MessagePassingQueue.Supplier<Object>(){
            int counter = 0;

            public Object get() {
                return objs.get(this.counter++);
            }
        };
        int count = this.recvQueue.fill((MessagePassingQueue.Supplier)supplier, objs.size());
        this.metrics.notifyArrivals(count);
        return count;
    }

    private Inserter getInserter() {
        Inserter inserter;
        if (this.producerBatchSz > 1) {
            inserter = this.thdLocalBatcher.get();
            if (inserter == null) {
                BatchInserter b = new BatchInserter(this, this.producerBatchSz);
                inserter = b;
                this.thdLocalBatcher.set(b);
            }
        } else {
            inserter = this.directInserter;
        }
        return inserter;
    }

    public void publish(Object obj) throws InterruptedException {
        Inserter inserter = this.getInserter();
        inserter.publish(obj);
    }

    public boolean tryPublish(Object obj) {
        Inserter inserter = this.getInserter();
        return inserter.tryPublish(obj);
    }

    public boolean tryPublishDirect(Object obj) {
        return this.tryPublishInternal(obj);
    }

    public boolean tryPublishToOverflow(Object obj) {
        if (this.overflowLimit > 0 && this.overflowQ.size() >= this.overflowLimit) {
            return false;
        }
        this.overflowQ.add(obj);
        return true;
    }

    public void recordMsgDrop() {
        this.getMetrics().notifyDroppedMsg();
    }

    public boolean isEmptyOverflow() {
        return this.overflowQ.isEmpty();
    }

    public int getOverflowCount() {
        return this.overflowQ.size();
    }

    public int getQueuedCount() {
        return this.recvQueue.size();
    }

    public void flush() throws InterruptedException {
        Inserter inserter = this.getInserter();
        inserter.flush();
    }

    public boolean tryFlush() {
        Inserter inserter = this.getInserter();
        return inserter.tryFlush();
    }

    @Override
    public Object getState() {
        return this.metrics.getState();
    }

    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    public class QueueMetrics
    implements Closeable {
        private final RateTracker arrivalsTracker = new RateTracker(10000, 10);
        private final RateTracker insertFailuresTracker = new RateTracker(10000, 10);
        private final AtomicLong droppedMessages = new AtomicLong(0L);

        public long population() {
            return JCQueue.this.recvQueue.size();
        }

        public long capacity() {
            return JCQueue.this.recvQueue.capacity();
        }

        public Object getState() {
            HashMap<String, Number> state = new HashMap<String, Number>();
            double arrivalRateInSecs = this.arrivalsTracker.reportRate();
            long tuplePop = this.population();
            double sojournTime = (double)tuplePop / Math.max(arrivalRateInSecs, 1.0E-5) * 1000.0;
            long cap = this.capacity();
            float pctFull = 1.0f * (float)tuplePop / (float)cap;
            state.put("capacity", cap);
            state.put("pct_full", Float.valueOf(pctFull));
            state.put("population", tuplePop);
            state.put("arrival_rate_secs", arrivalRateInSecs);
            state.put("sojourn_time_ms", sojournTime);
            state.put("insert_failures", this.insertFailuresTracker.reportRate());
            state.put("dropped_messages", this.droppedMessages);
            state.put("overflow", JCQueue.this.overflowQ.size());
            return state;
        }

        public void notifyArrivals(long counts) {
            this.arrivalsTracker.notify(counts);
        }

        public void notifyInsertFailure() {
            this.insertFailuresTracker.notify(1L);
        }

        public void notifyDroppedMsg() {
            this.droppedMessages.incrementAndGet();
        }

        @Override
        public void close() {
            this.arrivalsTracker.close();
            this.insertFailuresTracker.close();
        }
    }

    private static class BatchInserter
    implements Inserter {
        private final int batchSz;
        private JCQueue queue;
        private ArrayList<Object> currentBatch;

        public BatchInserter(JCQueue queue, int batchSz) {
            this.queue = queue;
            this.batchSz = batchSz;
            this.currentBatch = new ArrayList(batchSz + 1);
        }

        @Override
        public void publish(Object obj) throws InterruptedException {
            this.currentBatch.add(obj);
            if (this.currentBatch.size() >= this.batchSz) {
                this.flush();
            }
        }

        @Override
        public boolean tryPublish(Object obj) {
            if (this.currentBatch.size() >= this.batchSz && !this.tryFlush()) {
                return false;
            }
            this.currentBatch.add(obj);
            return true;
        }

        @Override
        public void flush() throws InterruptedException {
            if (this.currentBatch.isEmpty()) {
                return;
            }
            int publishCount = this.queue.tryPublishInternal(this.currentBatch);
            int retryCount = 0;
            while (publishCount == 0) {
                this.queue.metrics.notifyInsertFailure();
                if (retryCount == 0) {
                    LOG.debug("Experiencing Back Pressure when flushing batch to Q: {}. Entering BackPressure Wait.", (Object)this.queue.getName());
                }
                retryCount = this.queue.backPressureWaitStrategy.idle(retryCount);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                publishCount = this.queue.tryPublishInternal(this.currentBatch);
            }
            this.currentBatch.subList(0, publishCount).clear();
        }

        @Override
        public boolean tryFlush() {
            if (this.currentBatch.isEmpty()) {
                return true;
            }
            int publishCount = this.queue.tryPublishInternal(this.currentBatch);
            if (publishCount == 0) {
                this.queue.metrics.notifyInsertFailure();
                return false;
            }
            this.currentBatch.subList(0, publishCount).clear();
            return true;
        }
    }

    private static class DirectInserter
    implements Inserter {
        private JCQueue queue;

        public DirectInserter(JCQueue queue) {
            this.queue = queue;
        }

        @Override
        public void publish(Object obj) throws InterruptedException {
            boolean inserted = this.queue.tryPublishInternal(obj);
            int idleCount = 0;
            while (!inserted) {
                this.queue.metrics.notifyInsertFailure();
                if (idleCount == 0) {
                    LOG.debug("Experiencing Back Pressure on recvQueue: '{}'. Entering BackPressure Wait", (Object)this.queue.getName());
                }
                idleCount = this.queue.backPressureWaitStrategy.idle(idleCount);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                inserted = this.queue.tryPublishInternal(obj);
            }
        }

        @Override
        public boolean tryPublish(Object obj) {
            boolean inserted = this.queue.tryPublishInternal(obj);
            if (!inserted) {
                this.queue.metrics.notifyInsertFailure();
                return false;
            }
            return true;
        }

        @Override
        public void flush() throws InterruptedException {
        }

        @Override
        public boolean tryFlush() {
            return true;
        }
    }

    public static interface ExitCondition {
        public boolean keepRunning();
    }

    public static interface Consumer
    extends MessagePassingQueue.Consumer<Object> {
        public void accept(Object var1);

        public void flush() throws InterruptedException;
    }

    private static interface Inserter {
        public void publish(Object var1) throws InterruptedException;

        public boolean tryPublish(Object var1);

        public void flush() throws InterruptedException;

        public boolean tryFlush();
    }
}

