/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.spout.IBatchID;
import org.apache.storm.trident.tuple.ConsList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.trident.windowing.AbstractTridentWindowManager;
import org.apache.storm.trident.windowing.ITridentWindowManager;
import org.apache.storm.trident.windowing.InMemoryTridentWindowManager;
import org.apache.storm.trident.windowing.StoreBasedTridentWindowManager;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.WindowsStoreFactory;
import org.apache.storm.trident.windowing.config.WindowConfig;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowTridentProcessor
implements TridentProcessor {
    public static final String TRIGGER_INPROCESS_PREFIX = "tip|";
    public static final String TRIGGER_PREFIX = "tr|";
    public static final String TRIGGER_COUNT_PREFIX = "tc|";
    public static final String TRIGGER_FIELD_NAME = "_task_info";
    public static final long DEFAULT_INMEMORY_TUPLE_CACHE_LIMIT = 100L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowTridentProcessor.class);
    private final String windowId;
    private final Fields inputFields;
    private final Aggregator aggregator;
    private final boolean storeTuplesInStore;
    private String windowTriggerInprocessId;
    private WindowConfig windowConfig;
    private WindowsStoreFactory windowStoreFactory;
    private WindowsStore windowStore;
    private TopologyContext topologyContext;
    private FreshCollector collector;
    private TridentTupleView.ProjectionFactory projection;
    private TridentContext tridentContext;
    private ITridentWindowManager tridentWindowManager;
    private String windowTaskId;

    public WindowTridentProcessor(WindowConfig windowConfig, String uniqueWindowId, WindowsStoreFactory windowStoreFactory, Fields inputFields, Aggregator aggregator, boolean storeTuplesInStore) {
        this.windowConfig = windowConfig;
        this.windowId = uniqueWindowId;
        this.windowStoreFactory = windowStoreFactory;
        this.inputFields = inputFields;
        this.aggregator = aggregator;
        this.storeTuplesInStore = storeTuplesInStore;
    }

    public static String getWindowTriggerInprocessIdPrefix(String windowTaskId) {
        return TRIGGER_INPROCESS_PREFIX + windowTaskId;
    }

    public static String getWindowTriggerTaskPrefix(String windowTaskId) {
        return TRIGGER_PREFIX + windowTaskId;
    }

    public static Object getBatchTxnId(Object batchId) {
        if (batchId instanceof IBatchID) {
            return ((IBatchID)batchId).getId();
        }
        return null;
    }

    static boolean retriedAttempt(Object batchId) {
        if (batchId instanceof IBatchID) {
            return ((IBatchID)batchId).getAttemptId() > 0;
        }
        return false;
    }

    public static String generateWindowTriggerKey(String windowTaskId, int triggerId) {
        return TRIGGER_PREFIX + windowTaskId + triggerId;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, TridentContext tridentContext) {
        this.topologyContext = context;
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Aggregation related operation can only have one parent");
        }
        this.tridentContext = tridentContext;
        this.collector = new FreshCollector(tridentContext);
        this.projection = new TridentTupleView.ProjectionFactory(parents.get(0), this.inputFields);
        this.windowStore = this.windowStoreFactory.create(topoConf);
        this.windowTaskId = this.windowId + "|" + this.topologyContext.getThisTaskId() + "|";
        this.windowTriggerInprocessId = WindowTridentProcessor.getWindowTriggerInprocessIdPrefix(this.windowTaskId);
        Long maxTuplesCacheSize = this.getWindowTuplesCacheSize(topoConf);
        this.tridentWindowManager = this.storeTuplesInStore ? new StoreBasedTridentWindowManager(this.windowConfig, this.windowTaskId, this.windowStore, this.aggregator, tridentContext.getDelegateCollector(), maxTuplesCacheSize, this.inputFields) : new InMemoryTridentWindowManager(this.windowConfig, this.windowTaskId, this.windowStore, this.aggregator, tridentContext.getDelegateCollector());
        this.tridentWindowManager.prepare();
    }

    private Long getWindowTuplesCacheSize(Map<String, Object> conf) {
        if (conf.containsKey("topology.trident.windowing.cache.tuple.limit")) {
            return ((Number)conf.get("topology.trident.windowing.cache.tuple.limit")).longValue();
        }
        return 100L;
    }

    @Override
    public void cleanup() {
        LOG.info("shutting down window manager");
        try {
            this.tridentWindowManager.shutdown();
        }
        catch (Exception ex) {
            LOG.error("Error occurred while cleaning up window processor", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this.tridentContext.getStateIndex()] = new ArrayList();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        Object state = processorContext.state[this.tridentContext.getStateIndex()];
        ((List)state).add(this.projection.create(tuple));
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishBatch(ProcessorContext processorContext) {
        Object batchId = processorContext.batchId;
        Object batchTxnId = WindowTridentProcessor.getBatchTxnId(batchId);
        LOG.debug("Received finishBatch of : [{}] ", batchId);
        List tuples = (List)processorContext.state[this.tridentContext.getStateIndex()];
        this.tridentWindowManager.addTuplesBatch(batchId, tuples);
        List<Integer> pendingTriggerIds = null;
        ArrayList<String> triggerKeys = new ArrayList<String>();
        Iterable<Object> triggerValues = null;
        if (WindowTridentProcessor.retriedAttempt(batchId) && (pendingTriggerIds = (List)this.windowStore.get(this.inprocessTriggerKey(batchTxnId))) != null) {
            for (Integer pendingTriggerId : pendingTriggerIds) {
                triggerKeys.add(this.triggerKey(pendingTriggerId));
            }
            triggerValues = this.windowStore.get(triggerKeys);
        }
        if (triggerValues == null) {
            pendingTriggerIds = new ArrayList();
            Queue<AbstractTridentWindowManager.TriggerResult> pendingTriggers = this.tridentWindowManager.getPendingTriggers();
            LOG.debug("pending triggers at batch: [{}] and triggers.size: [{}] ", batchId, (Object)pendingTriggers.size());
            try {
                Iterator pendingTriggersIter = pendingTriggers.iterator();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                AbstractTridentWindowManager.TriggerResult triggerResult = null;
                while (pendingTriggersIter.hasNext()) {
                    triggerResult = (AbstractTridentWindowManager.TriggerResult)pendingTriggersIter.next();
                    for (List<Object> aggregatedResult : triggerResult.result) {
                        String triggerKey = this.triggerKey(triggerResult.id);
                        triggerKeys.add(triggerKey);
                        arrayList.add(aggregatedResult);
                        pendingTriggerIds.add(triggerResult.id);
                    }
                    pendingTriggersIter.remove();
                }
                triggerValues = arrayList;
            }
            finally {
                if (!pendingTriggerIds.isEmpty()) {
                    this.windowStore.put(this.inprocessTriggerKey(batchTxnId), pendingTriggerIds);
                }
            }
        }
        this.collector.setContext(processorContext);
        int i = 0;
        for (Object t : triggerValues) {
            this.collector.emit(new ConsList(new TriggerInfo(this.windowTaskId, (Integer)pendingTriggerIds.get(i++)), (List)t));
        }
        this.collector.setContext(null);
    }

    private String inprocessTriggerKey(Object batchTxnId) {
        return this.windowTriggerInprocessId + batchTxnId;
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }

    public String triggerKey(int triggerId) {
        return WindowTridentProcessor.generateWindowTriggerKey(this.windowTaskId, triggerId);
    }

    public static class TriggerInfo
    implements Serializable {
        public final String windowTaskId;
        public final int triggerId;

        public TriggerInfo(String windowTaskId, int triggerId) {
            this.windowTaskId = windowTaskId;
            this.triggerId = triggerId;
        }

        public String generateTriggerKey() {
            return WindowTridentProcessor.generateWindowTriggerKey(this.windowTaskId, this.triggerId);
        }

        public String toString() {
            return "TriggerInfo{windowTaskId='" + this.windowTaskId + '\'' + ", triggerId=" + this.triggerId + '}';
        }
    }
}

