/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.state.KeyValueState;
import org.apache.storm.state.State;
import org.apache.storm.state.StateFactory;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.IStatefulWindowedBolt;
import org.apache.storm.topology.WindowedBoltExecutor;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.windowing.WindowLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulWindowedBoltExecutor<T extends State>
extends WindowedBoltExecutor
implements IStatefulBolt<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StatefulWindowedBoltExecutor.class);
    private final IStatefulWindowedBolt<T> statefulWindowedBolt;
    private transient String msgIdFieldName;
    private transient TopologyContext topologyContext;
    private transient OutputCollector outputCollector;
    private transient KeyValueState<TaskStream, WindowState> streamState;
    private transient List<Tuple> pendingTuples;
    private transient Map<TaskStream, WindowState> recoveryStates;
    private transient boolean stateInitialized;
    private transient boolean prePrepared;

    public StatefulWindowedBoltExecutor(IStatefulWindowedBolt<T> bolt) {
        super(bolt);
        this.statefulWindowedBolt = bolt;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.prepare(topoConf, context, collector, this.getWindowState(topoConf, context));
    }

    void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector, KeyValueState<TaskStream, WindowState> windowState) {
        this.init(topoConf, context, collector, windowState);
        super.prepare(topoConf, context, collector);
    }

    private void init(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector, KeyValueState<TaskStream, WindowState> windowState) {
        if (!topoConf.containsKey("topology.bolts.message.id.field.name")) {
            throw new IllegalArgumentException("topology.bolts.message.id.field.name is not set");
        }
        this.msgIdFieldName = (String)topoConf.get("topology.bolts.message.id.field.name");
        this.topologyContext = context;
        this.outputCollector = collector;
        this.streamState = windowState;
        this.pendingTuples = new ArrayList<Tuple>();
        this.recoveryStates = new HashMap<TaskStream, WindowState>();
        this.stateInitialized = false;
        this.prePrepared = false;
    }

    @Override
    public void execute(Tuple input) {
        if (!this.isStateInitialized()) {
            throw new IllegalStateException("execute invoked before initState with input tuple " + input);
        }
        if (this.isRecovering()) {
            this.handleRecovery(input);
        } else {
            super.execute(input);
        }
    }

    @Override
    protected void start() {
        if (!this.isStateInitialized() || this.isRecovering()) {
            LOG.debug("Will invoke start after recovery is complete.");
        } else {
            super.start();
        }
    }

    private void handleRecovery(Tuple input) {
        long msgId = this.getMsgId(input);
        TaskStream taskStream = TaskStream.fromTuple(input);
        WindowState state = this.recoveryStates.get(taskStream);
        LOG.debug("handleRecovery, recoveryStates {}", this.recoveryStates);
        if (state != null) {
            LOG.debug("Tuple msgid {}, saved state {}", (Object)msgId, (Object)state);
            if (msgId <= state.lastExpired) {
                LOG.debug("Ignoring tuple since msg id {} <= lastExpired id {}", (Object)msgId, (Object)state.lastExpired);
                this.outputCollector.ack(input);
            } else if (msgId <= state.lastEvaluated) {
                super.execute(input);
            } else {
                LOG.debug("Tuple msg id {} > lastEvaluated id {}, adding to pendingTuples and clearing recovery state for taskStream {}", new Object[]{msgId, state.lastEvaluated, taskStream});
                this.pendingTuples.add(input);
                this.clearRecoveryState(taskStream);
            }
        } else {
            this.pendingTuples.add(input);
        }
    }

    private void clearRecoveryState(TaskStream stream) {
        this.recoveryStates.remove(stream);
        if (!this.isRecovering()) {
            super.start();
            LOG.debug("Recovery complete, processing {} pending tuples", (Object)this.pendingTuples.size());
            for (Tuple tuple : this.pendingTuples) {
                super.execute(tuple);
            }
        }
    }

    private boolean isRecovering() {
        return !this.recoveryStates.isEmpty();
    }

    private boolean isStateInitialized() {
        return this.stateInitialized;
    }

    @Override
    public void initState(T state) {
        if (this.stateInitialized) {
            LOG.warn("State is already initialized. Ignoring initState");
            return;
        }
        this.statefulWindowedBolt.initState(state);
        for (GlobalStreamId streamId : this.topologyContext.getThisSources().keySet()) {
            for (int taskId : this.topologyContext.getComponentTasks(streamId.get_componentId())) {
                WindowState windowState = this.streamState.get(new TaskStream(taskId, streamId));
                if (windowState == null) continue;
                this.recoveryStates.put(new TaskStream(taskId, streamId), windowState);
            }
        }
        LOG.debug("recoveryStates {}", this.recoveryStates);
        this.stateInitialized = true;
        this.start();
    }

    @Override
    public void preCommit(long txid) {
        if (!this.isStateInitialized() || !this.isRecovering() && this.prePrepared) {
            LOG.debug("Commit streamState, txid {}", (Object)txid);
            this.streamState.commit(txid);
        } else {
            LOG.debug("Still recovering, ignoring preCommit and not committing streamState.");
        }
    }

    @Override
    public void prePrepare(long txid) {
        if (!this.isStateInitialized()) {
            LOG.warn("Cannot prepare before initState");
        } else if (!this.isRecovering()) {
            LOG.debug("Prepare streamState, txid {}", (Object)txid);
            this.streamState.prepareCommit(txid);
            this.prePrepared = true;
        } else {
            LOG.debug("Still recovering, ignoring prePrepare and not preparing streamState.");
        }
    }

    @Override
    public void preRollback() {
        LOG.debug("Rollback streamState, stateInitialized {}", (Object)this.stateInitialized);
        this.streamState.rollback();
    }

    @Override
    protected WindowLifecycleListener<Tuple> newWindowLifecycleListener() {
        final WindowLifecycleListener<Tuple> parentListener = super.newWindowLifecycleListener();
        return new WindowLifecycleListener<Tuple>(){

            @Override
            public void onExpiry(List<Tuple> events) {
                parentListener.onExpiry(events);
            }

            @Override
            public void onActivation(List<Tuple> events, List<Tuple> newEvents, List<Tuple> expired, Long timestamp) {
                if (StatefulWindowedBoltExecutor.this.isRecovering()) {
                    String msg = String.format("Unexpected activation with events %s, newEvents %s, expired %s in recovering state. recoveryStates %s ", events, newEvents, expired, StatefulWindowedBoltExecutor.this.recoveryStates);
                    LOG.error(msg);
                    throw new IllegalStateException(msg);
                }
                parentListener.onActivation(events, newEvents, expired, timestamp);
                StatefulWindowedBoltExecutor.this.updateWindowState(expired, newEvents);
            }
        };
    }

    private void updateWindowState(List<Tuple> expired, List<Tuple> newEvents) {
        LOG.debug("Update window state, {} expired, {} new events", (Object)expired.size(), (Object)newEvents.size());
        HashMap<TaskStream, WindowState> state = new HashMap<TaskStream, WindowState>();
        this.updateState(state, expired, false);
        this.updateState(state, newEvents, true);
        this.updateStreamState(state);
    }

    private void updateState(Map<TaskStream, WindowState> state, List<Tuple> tuples, boolean newEvents) {
        for (Tuple tuple : tuples) {
            TaskStream taskStream = TaskStream.fromTuple(tuple);
            WindowState curState = state.get(taskStream);
            WindowState newState = this.getUpdatedState(curState, this.getMsgId(tuple), newEvents);
            if (newState == null) continue;
            state.put(taskStream, newState);
        }
    }

    private void updateStreamState(Map<TaskStream, WindowState> state) {
        for (Map.Entry<TaskStream, WindowState> entry : state.entrySet()) {
            TaskStream taskStream = entry.getKey();
            WindowState newState = entry.getValue();
            WindowState curState = this.streamState.get(taskStream);
            if (curState == null) {
                this.streamState.put(taskStream, newState);
                continue;
            }
            WindowState updatedState = new WindowState(Math.max(newState.lastExpired, curState.lastExpired), Math.max(newState.lastEvaluated, curState.lastEvaluated));
            LOG.debug("Update window state, taskStream {}, curState {}, newState {}", new Object[]{taskStream, curState, updatedState});
            this.streamState.put(taskStream, updatedState);
        }
    }

    private WindowState getUpdatedState(WindowState state, long msgId, boolean newEvents) {
        WindowState result2 = null;
        if (newEvents) {
            if (state == null) {
                result2 = new WindowState(Long.MIN_VALUE, msgId);
            } else if (msgId > state.lastEvaluated) {
                result2 = new WindowState(state.lastExpired, msgId);
            }
        } else if (state == null) {
            result2 = new WindowState(msgId, Long.MIN_VALUE);
        } else if (msgId > state.lastExpired) {
            result2 = new WindowState(msgId, state.lastEvaluated);
        }
        return result2;
    }

    private long getMsgId(Tuple input) {
        return input.getLongByField(this.msgIdFieldName);
    }

    private KeyValueState<TaskStream, WindowState> getWindowState(Map<String, Object> topoConf, TopologyContext context) {
        String namespace = context.getThisComponentId() + "-" + context.getThisTaskId() + "-window";
        return (KeyValueState)StateFactory.getState(namespace, topoConf, context);
    }

    static class TaskStream {
        private int sourceTask;
        private GlobalStreamId streamId;

        TaskStream() {
        }

        TaskStream(int sourceTask, GlobalStreamId streamId) {
            this.sourceTask = sourceTask;
            this.streamId = streamId;
        }

        static TaskStream fromTuple(Tuple input) {
            return new TaskStream(input.getSourceTask(), input.getSourceGlobalStreamId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskStream that = (TaskStream)o;
            if (this.sourceTask != that.sourceTask) {
                return false;
            }
            return this.streamId != null ? this.streamId.equals(that.streamId) : that.streamId == null;
        }

        public int hashCode() {
            int result2 = this.streamId != null ? this.streamId.hashCode() : 0;
            result2 = 31 * result2 + this.sourceTask;
            return result2;
        }

        public String toString() {
            return "TaskStream{sourceTask=" + this.sourceTask + ", streamId=" + this.streamId + '}';
        }
    }

    static class WindowState {
        private long lastExpired;
        private long lastEvaluated;

        WindowState() {
        }

        WindowState(long lastExpired, long lastEvaluated) {
            this.lastExpired = lastExpired;
            this.lastEvaluated = lastEvaluated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WindowState that = (WindowState)o;
            if (this.lastExpired != that.lastExpired) {
                return false;
            }
            return this.lastEvaluated == that.lastEvaluated;
        }

        public int hashCode() {
            int result2 = (int)(this.lastExpired ^ this.lastExpired >>> 32);
            result2 = 31 * result2 + (int)(this.lastEvaluated ^ this.lastEvaluated >>> 32);
            return result2;
        }

        public String toString() {
            return "WindowState{lastExpired=" + this.lastExpired + ", lastEvaluated=" + this.lastEvaluated + '}';
        }
    }
}

