/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.utils.ObjectReader;

public enum ThriftConnectionType {
    NIMBUS("nimbus.thrift.transport", "nimbus.thrift.port", "nimbus.queue.size", "nimbus.thrift.threads", "nimbus.thrift.max_buffer_size", "storm.thrift.socket.timeout.ms", WorkerTokenServiceType.NIMBUS, true),
    SUPERVISOR("supervisor.thrift.transport", "supervisor.thrift.port", "supervisor.queue.size", "supervisor.thrift.threads", "supervisor.thrift.max_buffer_size", "supervisor.thrift.socket.timeout.ms", WorkerTokenServiceType.SUPERVISOR, false),
    DRPC("drpc.thrift.transport", "drpc.port", "drpc.queue.size", "drpc.worker.threads", "drpc.max_buffer_size", null, null, false),
    DRPC_INVOCATIONS("drpc.invocations.thrift.transport", "drpc.invocations.port", null, "drpc.invocations.threads", "drpc.max_buffer_size", null, WorkerTokenServiceType.DRPC, false),
    LOCAL_FAKE;

    private final String transConf;
    private final String portConf;
    private final String queueConf;
    private final String threadsConf;
    private final String buffConf;
    private final String socketTimeoutConf;
    private final boolean isFake;
    private final WorkerTokenServiceType wtType;
    private final boolean impersonationAllowed;

    private ThriftConnectionType() {
        this(null, null, null, null, null, null, true, null, false);
    }

    private ThriftConnectionType(String transConf, String portConf, String queueConf, String threadsConf, String buffConf, String socketTimeoutConf, WorkerTokenServiceType wtType, boolean impersonationAllowed) {
        this(transConf, portConf, queueConf, threadsConf, buffConf, socketTimeoutConf, false, wtType, impersonationAllowed);
    }

    private ThriftConnectionType(String transConf, String portConf, String queueConf, String threadsConf, String buffConf, String socketTimeoutConf, boolean isFake, WorkerTokenServiceType wtType, boolean impersonationAllowed) {
        this.transConf = transConf;
        this.portConf = portConf;
        this.queueConf = queueConf;
        this.threadsConf = threadsConf;
        this.buffConf = buffConf;
        this.socketTimeoutConf = socketTimeoutConf;
        this.isFake = isFake;
        this.wtType = wtType;
        this.impersonationAllowed = impersonationAllowed;
    }

    public boolean isFake() {
        return this.isFake;
    }

    public String getTransportPlugin(Map<String, Object> conf) {
        String ret = (String)conf.get(this.transConf);
        if (ret == null) {
            ret = (String)conf.get("storm.thrift.transport");
        }
        return ret;
    }

    public int getPort(Map<String, Object> conf) {
        if (this.isFake) {
            return -1;
        }
        return ObjectReader.getInt(conf.get(this.portConf));
    }

    public Integer getQueueSize(Map<String, Object> conf) {
        if (this.queueConf == null) {
            return null;
        }
        return (Integer)conf.get(this.queueConf);
    }

    public int getNumThreads(Map<String, Object> conf) {
        if (this.isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this.threadsConf));
    }

    public int getMaxBufferSize(Map<String, Object> conf) {
        if (this.isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this.buffConf));
    }

    public Integer getSocketTimeOut(Map<String, Object> conf) {
        if (this.socketTimeoutConf == null) {
            return null;
        }
        return ObjectReader.getInt(conf.get(this.socketTimeoutConf));
    }

    public WorkerTokenServiceType getWtType() {
        return this.wtType;
    }

    public boolean isImpersonationAllowed() {
        return this.impersonationAllowed;
    }
}

