/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.messaging.netty.KerberosSaslClientHandler;
import org.apache.storm.messaging.netty.SaslStormClientHandler;
import org.apache.storm.pacemaker.PacemakerClient;
import org.apache.storm.pacemaker.PacemakerClientHandler;
import org.apache.storm.pacemaker.codec.ThriftDecoder;
import org.apache.storm.pacemaker.codec.ThriftEncoder;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelInitializer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftNettyClientCodec
extends ChannelInitializer<Channel> {
    public static final String SASL_HANDLER = "sasl-handler";
    public static final String KERBEROS_HANDLER = "kerberos-handler";
    private static final Logger LOG = LoggerFactory.getLogger(ThriftNettyClientCodec.class);
    private final int thriftMessageMaxSize;
    private final PacemakerClient client;
    private final AuthMethod authMethod;
    private final Map<String, Object> topoConf;
    private final String host;

    public ThriftNettyClientCodec(PacemakerClient pacemakerClient, Map<String, Object> topoConf, AuthMethod authMethod, String host, int thriftMessageMaxSizeBytes) {
        this.client = pacemakerClient;
        this.authMethod = authMethod;
        this.topoConf = topoConf;
        this.host = host;
        this.thriftMessageMaxSize = thriftMessageMaxSizeBytes;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)new ThriftEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new ThriftDecoder(this.thriftMessageMaxSize));
        if (this.authMethod == AuthMethod.KERBEROS) {
            try {
                LOG.debug("Adding KerberosSaslClientHandler to pacemaker client pipeline.");
                pipeline.addLast(KERBEROS_HANDLER, (ChannelHandler)new KerberosSaslClientHandler(this.client, this.topoConf, "PacemakerClient", this.host));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.authMethod == AuthMethod.DIGEST) {
            try {
                LOG.debug("Adding SaslStormClientHandler to pacemaker client pipeline.");
                pipeline.addLast(SASL_HANDLER, (ChannelHandler)new SaslStormClientHandler(this.client));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.client.channelReady(ch);
        }
        pipeline.addLast("PacemakerClientHandler", (ChannelHandler)new PacemakerClientHandler(this.client));
    }

    public static enum AuthMethod {
        DIGEST,
        KERBEROS,
        NONE;

    }
}

