/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.cgroup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;
import org.apache.storm.container.cgroup.core.CpuacctCore;
import org.apache.storm.metric.cgroup.CGroupMetricsBase;

public class CGroupCpu
extends CGroupMetricsBase<Map<String, Long>> {
    long previousSystem = 0L;
    long previousUser = 0L;
    private int userHz = -1;

    public CGroupCpu(Map<String, Object> conf) {
        super(conf, SubSystemType.cpuacct);
    }

    public synchronized int getUserHZ() throws IOException {
        if (this.userHz < 0) {
            ProcessBuilder pb = new ProcessBuilder("getconf", "CLK_TCK");
            Process p = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = in.readLine().trim();
            this.userHz = Integer.valueOf(line);
        }
        return this.userHz;
    }

    @Override
    public Map<String, Long> getDataFrom(CgroupCore core) throws IOException {
        CpuacctCore cpu = (CpuacctCore)core;
        Map<CpuacctCore.StatType, Long> stat = cpu.getCpuStat();
        long systemHz = stat.get((Object)CpuacctCore.StatType.system);
        long userHz = stat.get((Object)CpuacctCore.StatType.user);
        long user = userHz - this.previousUser;
        long sys = systemHz - this.previousSystem;
        this.previousUser = userHz;
        this.previousSystem = systemHz;
        long hz = this.getUserHZ();
        HashMap<String, Long> ret = new HashMap<String, Long>();
        ret.put("user-ms", user * 1000L / hz);
        ret.put("sys-ms", sys * 1000L / hz);
        return ret;
    }
}

