/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.metric.util.DataPointExpander;
import org.apache.storm.shade.com.google.common.base.Predicate;
import org.apache.storm.shade.com.google.common.collect.Iterables;
import org.apache.storm.shade.com.google.common.collect.Lists;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConsumerBolt
implements IBolt {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsConsumerBolt.class);
    private final int maxRetainMetricTuples;
    private final Predicate<IMetricsConsumer.DataPoint> filterPredicate;
    private final DataPointExpander expander;
    private final BlockingQueue<MetricsTask> taskQueue;
    IMetricsConsumer metricsConsumer;
    String consumerClassName;
    OutputCollector collector;
    Object registrationArgument;
    private Thread taskExecuteThread;
    private volatile boolean running = true;

    public MetricsConsumerBolt(String consumerClassName, Object registrationArgument, int maxRetainMetricTuples, Predicate<IMetricsConsumer.DataPoint> filterPredicate, DataPointExpander expander) {
        this.consumerClassName = consumerClassName;
        this.registrationArgument = registrationArgument;
        this.maxRetainMetricTuples = maxRetainMetricTuples;
        this.filterPredicate = filterPredicate;
        this.expander = expander;
        this.taskQueue = this.maxRetainMetricTuples > 0 ? new LinkedBlockingDeque<MetricsTask>(this.maxRetainMetricTuples) : new LinkedBlockingDeque<MetricsTask>();
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        try {
            this.metricsConsumer = (IMetricsConsumer)Class.forName(this.consumerClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate a class listed in config under section topology.metrics.consumer.register with fully qualified name " + this.consumerClassName, e);
        }
        this.metricsConsumer.prepare(topoConf, this.registrationArgument, context, collector);
        this.collector = collector;
        this.taskExecuteThread = new Thread(new MetricsHandlerRunnable());
        this.taskExecuteThread.setDaemon(true);
        this.taskExecuteThread.start();
    }

    @Override
    public void execute(Tuple input) {
        IMetricsConsumer.TaskInfo taskInfo = (IMetricsConsumer.TaskInfo)input.getValue(0);
        Collection dataPoints = (Collection)input.getValue(1);
        Collection<IMetricsConsumer.DataPoint> expandedDataPoints = this.expander.expandDataPoints(dataPoints);
        List<IMetricsConsumer.DataPoint> filteredDataPoints = this.getFilteredDataPoints(expandedDataPoints);
        MetricsTask metricsTask = new MetricsTask(taskInfo, filteredDataPoints);
        while (!this.taskQueue.offer(metricsTask)) {
            this.taskQueue.poll();
        }
        this.collector.ack(input);
    }

    private List<IMetricsConsumer.DataPoint> getFilteredDataPoints(Collection<IMetricsConsumer.DataPoint> dataPoints) {
        return Lists.newArrayList((Iterable)Iterables.filter(dataPoints, this.filterPredicate));
    }

    @Override
    public void cleanup() {
        this.running = false;
        this.metricsConsumer.cleanup();
        this.taskExecuteThread.interrupt();
    }

    class MetricsHandlerRunnable
    implements Runnable {
        MetricsHandlerRunnable() {
        }

        @Override
        public void run() {
            while (MetricsConsumerBolt.this.running) {
                try {
                    MetricsTask task = (MetricsTask)MetricsConsumerBolt.this.taskQueue.take();
                    MetricsConsumerBolt.this.metricsConsumer.handleDataPoints(task.getTaskInfo(), task.getDataPoints());
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable t) {
                    LOG.error("Exception occurred during handle metrics", t);
                }
            }
        }
    }

    static class MetricsTask {
        private IMetricsConsumer.TaskInfo taskInfo;
        private Collection<IMetricsConsumer.DataPoint> dataPoints;

        public MetricsTask(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
            this.taskInfo = taskInfo;
            this.dataPoints = dataPoints;
        }

        public IMetricsConsumer.TaskInfo getTaskInfo() {
            return this.taskInfo;
        }

        public Collection<IMetricsConsumer.DataPoint> getDataPoints() {
            return this.dataPoints;
        }
    }
}

