/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.Date;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.apache.storm.shade.org.apache.zookeeper.Shell;

public class Login {
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    private static final long MIN_TIME_BEFORE_RELOGIN = 60000L;
    private static Random rng = new Random();
    public CallbackHandler callbackHandler;
    private static final Logger LOG = Logger.getLogger(Login.class);
    private Subject subject = null;
    private Thread thread = null;
    private boolean isKrbTicket = false;
    private boolean isUsingTicketCache = false;
    private boolean isUsingKeytab = false;
    private LoginContext login = null;
    private String loginContextName = null;
    private String keytabFile = null;
    private String principal = null;
    private long lastLogin = 0L;

    public Login(String loginContextName, CallbackHandler callbackHandler) throws LoginException {
        AppConfigurationEntry[] entries;
        this.callbackHandler = callbackHandler;
        this.login = this.login(loginContextName);
        this.loginContextName = loginContextName;
        this.subject = this.login.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] appConfigurationEntryArray = entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        int n = appConfigurationEntryArray.length;
        int n2 = 0;
        if (n2 < n) {
            String val;
            AppConfigurationEntry entry = appConfigurationEntryArray[n2];
            if (entry.getOptions().get("useTicketCache") != null && (val = (String)entry.getOptions().get("useTicketCache")).equals("true")) {
                this.isUsingTicketCache = true;
            }
            if (entry.getOptions().get("keyTab") != null) {
                this.keytabFile = (String)entry.getOptions().get("keyTab");
                this.isUsingKeytab = true;
            }
            if (entry.getOptions().get("principal") != null) {
                this.principal = (String)entry.getOptions().get("principal");
            }
        }
        if (!this.isKrbTicket) {
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.info((Object)"TGT refresh thread started.");
                block14: while (true) {
                    long nextRefresh;
                    KerberosTicket tgt = Login.this.getTGT();
                    long now = System.currentTimeMillis();
                    if (tgt == null) {
                        nextRefresh = now + 60000L;
                        Date nextRefreshDate = new Date(nextRefresh);
                        LOG.warn((Object)("No TGT found: will try again at " + nextRefreshDate));
                    } else {
                        nextRefresh = Login.this.getRefreshTime(tgt);
                        long expiry = tgt.getEndTime().getTime();
                        Date expiryDate = new Date(expiry);
                        if (Login.this.isUsingTicketCache && tgt.getEndTime().equals(tgt.getRenewTill())) {
                            LOG.error((Object)("The TGT cannot be renewed beyond the next expiry date: " + expiryDate + ".This process will not be able to authenticate new SASL connections after that time (for example, it will not be authenticate a new connection with a Zookeeper Quorum member).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife " + Login.this.principal + "' within kadmin, or instead, to generate a keytab for " + Login.this.principal + ". Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now."));
                            return;
                        }
                        if (nextRefresh > expiry || now + 60000L > expiry) {
                            nextRefresh = now;
                        } else {
                            if (nextRefresh < now + 60000L) {
                                Date until = new Date(nextRefresh);
                                Date newuntil = new Date(now + 60000L);
                                LOG.warn((Object)("TGT refresh thread time adjusted from : " + until + " to : " + newuntil + " since the former is sooner than the minimum refresh interval (" + 60L + " seconds) from now."));
                            }
                            nextRefresh = Math.max(nextRefresh, now + 60000L);
                        }
                    }
                    if (tgt != null && now > tgt.getEndTime().getTime()) {
                        if (now - tgt.getEndTime().getTime() < 600000L) {
                            Date until = new Date(now + 60000L);
                            LOG.info((Object)("TGT already expired but giving additional 10 minutes past TGT expiry, refresh sleeping until: " + until.toString()));
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException ie) {
                                LOG.warn((Object)"TGT renewal thread has been interrupted and will exit.");
                                return;
                            }
                        } else {
                            LOG.error((Object)("nextRefresh:" + new Date(nextRefresh) + " is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting worker!."));
                            Runtime.getRuntime().exit(-3);
                        }
                    } else if (now < nextRefresh) {
                        Date until = new Date(nextRefresh);
                        LOG.info((Object)("TGT refresh sleeping until: " + until.toString()));
                        try {
                            Thread.sleep(nextRefresh - now);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)"TGT renewal thread has been interrupted and will exit.");
                            return;
                        }
                    }
                    if (Login.this.isUsingTicketCache) {
                        String cmd = "/usr/bin/kinit";
                        if (System.getProperty("zookeeper.kinit") != null) {
                            cmd = System.getProperty("zookeeper.kinit");
                        }
                        String kinitArgs = "-R";
                        for (int retry = 1; retry >= 0; --retry) {
                            try {
                                LOG.debug((Object)("running ticket cache refresh command: " + cmd + " " + kinitArgs));
                                Shell.execCommand((String[])new String[]{cmd, kinitArgs});
                                break;
                            }
                            catch (Exception e) {
                                if (retry > 0) {
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException ie) {
                                        LOG.error((Object)"Interrupted while renewing TGT, exiting Login thread");
                                        return;
                                    }
                                }
                                LOG.warn((Object)("Could not renew TGT due to problem running shell command: '" + cmd + " " + kinitArgs + "'; exception was:" + e + ". Exiting refresh thread."), (Throwable)e);
                                return;
                            }
                        }
                    }
                    try {
                        int retry = 1;
                        while (true) {
                            if (retry < 0) continue block14;
                            try {
                                Login.this.reLogin();
                                continue block14;
                            }
                            catch (LoginException le) {
                                if (retry > 0) {
                                    --retry;
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        LOG.error((Object)"Interrupted during login retry after LoginException:", (Throwable)le);
                                        throw le;
                                    }
                                }
                                LOG.error((Object)("Could not refresh TGT for principal: " + Login.this.principal + "."), (Throwable)le);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException le) {
                        LOG.error((Object)"Failed to refresh TGT: refresh thread exiting now.", (Throwable)le);
                        return;
                    }
                }
            }
        });
        this.thread.setName("Refresh-TGT");
        this.thread.setDaemon(true);
    }

    public void startThreadIfNeeded() {
        if (this.thread != null) {
            this.thread.start();
        }
    }

    public void shutdown() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("error while waiting for Login thread to shutdown: " + e));
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    private synchronized LoginContext login(String loginContextName) throws LoginException {
        if (loginContextName == null) {
            throw new LoginException("loginContext name (JAAS file section header) was null. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.login.auth.config") + ") and your " + "zookeeper.sasl.clientconfig" + "(=" + System.getProperty("zookeeper.sasl.clientconfig", "Client") + ")");
        }
        LoginContext loginContext = new LoginContext(loginContextName, this.callbackHandler);
        loginContext.login();
        LOG.info((Object)"successfully logged in.");
        return loginContext;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        LOG.info((Object)("TGT valid starting at:        " + tgt.getStartTime().toString()));
        LOG.info((Object)("TGT expires:                  " + tgt.getEndTime().toString()));
        long proposedRefresh = start + (long)((double)(expires - start) * ((double)0.8f + (double)0.05f * rng.nextDouble()));
        if (proposedRefresh > expires) {
            return System.currentTimeMillis();
        }
        return proposedRefresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            LOG.debug((Object)("Found tgt " + ticket + "."));
            return ticket;
        }
        return null;
    }

    private void sleepUntilSufficientTimeElapsed() {
        long now = System.currentTimeMillis();
        if (now - this.getLastLogin() < 60000L) {
            LOG.warn((Object)"Not attempting to re-login since the last re-login was attempted less than 60 seconds before.");
            try {
                Thread.sleep(60000L - (now - this.getLastLogin()));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"TGT renewal thread has been interrupted and will exit.");
                Runtime.getRuntime().exit(-2);
            }
        }
        this.setLastLogin(System.currentTimeMillis());
    }

    private LoginContext getLogin() {
        return this.login;
    }

    private void setLogin(LoginContext login) {
        this.login = login;
    }

    private long getLastLogin() {
        return this.lastLogin;
    }

    private void setLastLogin(long time) {
        this.lastLogin = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new LoginException("login must be done first");
        }
        this.sleepUntilSufficientTimeElapsed();
        LOG.info((Object)("Initiating logout for " + this.principal));
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            login.logout();
            login = new LoginContext(this.loginContextName, this.getSubject());
            LOG.info((Object)("Initiating re-login for " + this.principal));
            login.login();
            this.setLogin(login);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

