/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.storm.messaging.netty.Login;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.KerberosPrincipalToLocal;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KerberosSaslNettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslNettyServer.class);
    private SaslServer saslServer;
    private Subject subject;
    private List<String> authorizedUsers;

    KerberosSaslNettyServer(Map<String, Object> topoConf, String jaasSection, List<String> authorizedUsers) {
        Configuration loginConf;
        this.authorizedUsers = authorizedUsers;
        LOG.debug("Getting Configuration.");
        try {
            loginConf = ClientAuthUtils.getConfiguration(topoConf);
        }
        catch (Throwable t) {
            LOG.error("Failed to get loginConf: ", t);
            throw t;
        }
        LOG.debug("KerberosSaslNettyServer: authmethod {}", (Object)"GSSAPI");
        KerberosSaslCallbackHandler ch = new KerberosSaslCallbackHandler(authorizedUsers);
        this.subject = null;
        try {
            LOG.debug("Setting Configuration to login_config: {}", (Object)loginConf);
            Configuration.setConfiguration(loginConf);
            LOG.debug("Trying to login.");
            Login login = new Login(jaasSection, ch);
            this.subject = login.getSubject();
            LOG.debug("Got Subject: {}", (Object)this.subject.toString());
        }
        catch (LoginException ex) {
            LOG.error("Server failed to login in principal:", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            LOG.error("Failed to verifyuser principal.");
            throw new RuntimeException("Fail to verify user principal with section \"" + jaasSection + "\" in login configuration file " + loginConf);
        }
        try {
            LOG.info("Creating Kerberos Server.");
            final KerberosSaslCallbackHandler fch = ch;
            Principal p = (Principal)this.subject.getPrincipals().toArray()[0];
            KerberosName kerberosName = new KerberosName(p.getName());
            final String hostName = kerberosName.getHostName();
            final String serviceName = kerberosName.getServiceName();
            LOG.debug("Server with host: {}", (Object)hostName);
            this.saslServer = Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() {
                    try {
                        TreeMap<String, String> props = new TreeMap<String, String>();
                        props.put("javax.security.sasl.qop", "auth");
                        props.put("javax.security.sasl.server.authentication", "false");
                        return Sasl.createSaslServer("GSSAPI", serviceName, hostName, props, fch);
                    }
                    catch (Exception e) {
                        LOG.error("Subject failed to create sasl server.", (Throwable)e);
                        return null;
                    }
                }
            });
            LOG.info("Got Server: {}", (Object)this.saslServer);
        }
        catch (PrivilegedActionException e) {
            LOG.error("KerberosSaslNettyServer: Could not create SaslServer: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getUserName() {
        return this.saslServer.getAuthorizationID();
    }

    public byte[] response(final byte[] token) {
        try {
            byte[] retval = Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        LOG.debug("response: Responding to input token of length: {}", (Object)token.length);
                        byte[] retval = KerberosSaslNettyServer.this.saslServer.evaluateResponse(token);
                        return retval;
                    }
                    catch (SaslException e) {
                        LOG.error("response: Failed to evaluate client token of length: {} : {}", (Object)token.length, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            return retval;
        }
        catch (PrivilegedActionException e) {
            LOG.error("Failed to generate response for token: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class KerberosSaslCallbackHandler
    implements CallbackHandler {
        private List<String> authorizedUsers;

        public KerberosSaslCallbackHandler(List<String> authorizedUsers) {
            LOG.debug("KerberosSaslCallback: Creating KerberosSaslCallback handler.");
            this.authorizedUsers = authorizedUsers;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            block0: for (Callback callback : callbacks) {
                LOG.info("Kerberos Callback Handler got callback: {}", callback.getClass());
                if (!(callback instanceof AuthorizeCallback)) continue;
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                if (!ac.getAuthenticationID().equals(ac.getAuthorizationID())) {
                    LOG.debug("{} != {}", (Object)ac.getAuthenticationID(), (Object)ac.getAuthorizationID());
                    continue;
                }
                LOG.debug("Authorized Users: {}", this.authorizedUsers);
                LOG.debug("Checking authorization for: {}", (Object)ac.getAuthorizationID());
                for (String user : this.authorizedUsers) {
                    String requester = ac.getAuthorizationID();
                    KerberosPrincipal principal = new KerberosPrincipal(requester);
                    if (!(requester = new KerberosPrincipalToLocal().toLocal(principal)).equals(user)) continue;
                    ac.setAuthorized(true);
                    continue block0;
                }
            }
        }
    }
}

