/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.DaemonCommon;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.daemon.worker.LogConfigManager;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.ExecutorShutdown;
import org.apache.storm.executor.IRunningExecutor;
import org.apache.storm.executor.LocalExecutor;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.SupervisorWorkerHeartbeat;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.IContext;
import org.apache.storm.metrics2.StormMetricRegistry;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.shade.org.apache.commons.lang.ObjectUtils;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;
import org.apache.storm.stats.ClientStatsUtil;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.SupervisorClient;
import org.apache.storm.utils.SupervisorIfaceFactory;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements Shutdownable,
DaemonCommon {
    private static final Logger LOG = LoggerFactory.getLogger(Worker.class);
    private static final Pattern BLOB_VERSION_EXTRACTION = Pattern.compile(".*\\.([0-9]+)$");
    private final Map<String, Object> conf;
    private final IContext context;
    private final String topologyId;
    private final String assignmentId;
    private final int supervisorPort;
    private final int port;
    private final String workerId;
    private final LogConfigManager logConfigManager;
    private final StormMetricRegistry metricRegistry;
    private WorkerState workerState;
    private AtomicReference<List<IRunningExecutor>> executorsAtom;
    private Thread transferThread;
    private AtomicReference<Credentials> credentialsAtom;
    private Subject subject;
    private Collection<IAutoCredentials> autoCreds;
    private final Supplier<SupervisorIfaceFactory> supervisorIfaceSupplier;

    public Worker(Map<String, Object> conf, IContext context, String topologyId, String assignmentId, int supervisorPort, int port, String workerId, Supplier<SupervisorIfaceFactory> supervisorIfaceSupplier) {
        this.conf = conf;
        this.context = context;
        this.topologyId = topologyId;
        this.assignmentId = assignmentId;
        this.supervisorPort = supervisorPort;
        this.port = port;
        this.workerId = workerId;
        this.logConfigManager = new LogConfigManager();
        this.metricRegistry = new StormMetricRegistry();
        this.supervisorIfaceSupplier = supervisorIfaceSupplier;
    }

    public static void main(String[] args) throws Exception {
        Preconditions.checkArgument((args.length == 5 ? 1 : 0) != 0, (Object)("Illegal number of arguments. Expected: 5, Actual: " + args.length));
        String stormId = args[0];
        String assignmentId = args[1];
        String supervisorPort = args[2];
        String portStr = args[3];
        String workerId = args[4];
        Map<String, Object> conf = ConfigUtils.readStormConfig();
        Utils.setupDefaultUncaughtExceptionHandler();
        StormCommon.validateDistributedMode(conf);
        int supervisorPortInt = Integer.parseInt(supervisorPort);
        Supplier<SupervisorIfaceFactory> supervisorIfaceSuppler = () -> {
            try {
                return SupervisorClient.getConfiguredClient(conf, Utils.hostname(), supervisorPortInt);
            }
            catch (UnknownHostException e) {
                throw Utils.wrapInRuntime(e);
            }
        };
        Worker worker = new Worker(conf, null, stormId, assignmentId, supervisorPortInt, Integer.parseInt(portStr), workerId, supervisorIfaceSuppler);
        worker.start();
        int workerShutdownSleepSecs = ObjectReader.getInt(conf.get("supervisor.worker.shutdown.sleep.secs"));
        LOG.info("Adding shutdown hook with kill in {} secs", (Object)workerShutdownSleepSecs);
        Utils.addShutdownHookWithDelayedForceKill(worker::shutdown, workerShutdownSleepSecs);
    }

    public void start() throws Exception {
        LOG.info("Launching worker for {} on {}:{} with id {} and conf {}", new Object[]{this.topologyId, this.assignmentId, this.port, this.workerId, ConfigUtils.maskPasswords(this.conf)});
        if (!ConfigUtils.isLocalMode(this.conf)) {
            SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
            String pid = Utils.processPid();
            FileUtils.touch((File)new File(ConfigUtils.workerPidPath(this.conf, this.workerId, pid)));
            FileUtils.writeStringToFile((File)new File(ConfigUtils.workerArtifactsPidPath(this.conf, this.topologyId, this.port)), (String)pid, (Charset)Charset.forName("UTF-8"));
        }
        Map<String, Object> topologyConf = ConfigUtils.overrideLoginConfigWithSystemProperty(ConfigUtils.readSupervisorStormConf(this.conf, this.topologyId));
        ClusterStateContext csContext = new ClusterStateContext(DaemonType.WORKER, topologyConf);
        IStateStorage stateStorage = ClusterUtils.mkStateStorage(this.conf, topologyConf, csContext);
        IStormClusterState stormClusterState = ClusterUtils.mkStormClusterState(stateStorage, null, csContext);
        this.metricRegistry.start(this.conf, DaemonType.WORKER);
        Credentials initialCredentials = stormClusterState.credentials(this.topologyId, null);
        HashMap<String, String> initCreds = new HashMap<String, String>();
        if (initialCredentials != null) {
            initCreds.putAll(initialCredentials.get_creds());
        }
        this.autoCreds = ClientAuthUtils.getAutoCredentials(topologyConf);
        this.subject = ClientAuthUtils.populateSubject(null, this.autoCreds, initCreds);
        Subject.doAs(this.subject, () -> this.loadWorker(topologyConf, stateStorage, stormClusterState, initCreds, initialCredentials));
    }

    private Object loadWorker(Map<String, Object> topologyConf, IStateStorage stateStorage, IStormClusterState stormClusterState, Map<String, String> initCreds, Credentials initialCredentials) throws Exception {
        this.workerState = new WorkerState(this.conf, this.context, this.topologyId, this.assignmentId, this.supervisorIfaceSupplier, this.port, this.workerId, topologyConf, stateStorage, stormClusterState, this.autoCreds, this.metricRegistry);
        this.doHeartBeat();
        this.executorsAtom = new AtomicReference<Object>(null);
        this.workerState.heartbeatTimer.scheduleRecurring(0, (Integer)this.conf.get("worker.heartbeat.frequency.secs"), () -> {
            try {
                this.doHeartBeat();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.workerState.executorHeartbeatTimer.scheduleRecurring(0, (Integer)this.conf.get("executor.metrics.frequency.secs"), this::doExecutorHeartbeats);
        this.workerState.refreshConnections();
        this.workerState.activateWorkerWhenAllConnectionsReady();
        this.workerState.refreshStormActive(null);
        this.workerState.runWorkerStartHooks();
        ArrayList<Executor> execs = new ArrayList<Executor>();
        for (List<Long> e : this.workerState.getLocalExecutors()) {
            int i;
            Executor executor;
            if (ConfigUtils.isLocalMode(topologyConf)) {
                executor = LocalExecutor.mkExecutor(this.workerState, e, initCreds);
                execs.add(executor);
                for (i = 0; i < executor.getTaskIds().size(); ++i) {
                    this.workerState.localReceiveQueues.put(executor.getTaskIds().get(i), executor.getReceiveQueue());
                }
                continue;
            }
            executor = Executor.mkExecutor(this.workerState, e, initCreds);
            for (i = 0; i < executor.getTaskIds().size(); ++i) {
                this.workerState.localReceiveQueues.put(executor.getTaskIds().get(i), executor.getReceiveQueue());
            }
            execs.add(executor);
        }
        ArrayList<IRunningExecutor> newExecutors = new ArrayList<IRunningExecutor>();
        for (Executor executor : execs) {
            newExecutors.add(executor.execute());
        }
        this.executorsAtom.set(newExecutors);
        if (this.workerState.hasRemoteOutboundTasks()) {
            this.transferThread = this.workerState.makeTransferThread();
            this.transferThread.setName("Worker-Transfer");
        }
        this.credentialsAtom = new AtomicReference<Credentials>(initialCredentials);
        this.establishLogSettingCallback();
        this.workerState.stormClusterState.credentials(this.topologyId, this::checkCredentialsChanged);
        this.workerState.refreshCredentialsTimer.scheduleRecurring(0, (Integer)this.conf.get("task.credentials.poll.secs"), () -> this.checkCredentialsChanged());
        this.workerState.checkForUpdatedBlobsTimer.scheduleRecurring(0, (Integer)this.conf.getOrDefault("worker.blob.update.poll.interval.secs", 10), () -> {
            try {
                LOG.debug("Checking if blobs have updated");
                this.updateBlobUpdates();
            }
            catch (IOException e) {
                LOG.error(e.getStackTrace().toString());
            }
        });
        if (!((Boolean)topologyConf.get("topology.disable.loadaware.messaging")).booleanValue()) {
            this.workerState.refreshLoadTimer.scheduleRecurringWithJitter(0, 1, 500, this::doRefreshLoad);
        }
        this.workerState.refreshConnectionsTimer.scheduleRecurring(0, (Integer)this.conf.get("task.refresh.poll.secs"), this.workerState::refreshConnections);
        this.workerState.resetLogLevelsTimer.scheduleRecurring(0, (Integer)this.conf.get("worker.log.level.reset.poll.secs"), this.logConfigManager::resetLogLevels);
        this.workerState.refreshActiveTimer.scheduleRecurring(0, (Integer)this.conf.get("task.refresh.poll.secs"), this.workerState::refreshStormActive);
        this.setupFlushTupleTimer(topologyConf, newExecutors);
        this.setupBackPressureCheckTimer(topologyConf);
        LOG.info("Worker has topology config {}", ConfigUtils.maskPasswords(topologyConf));
        LOG.info("Worker {} for storm {} on {}:{}  has finished loading", new Object[]{this.workerId, this.topologyId, this.assignmentId, this.port});
        return this;
    }

    private void setupFlushTupleTimer(Map<String, Object> topologyConf, List<IRunningExecutor> executors) {
        Integer producerBatchSize = ObjectReader.getInt(topologyConf.get("topology.producer.batch.size"));
        Integer xferBatchSize = ObjectReader.getInt(topologyConf.get("topology.transfer.batch.size"));
        Long flushIntervalMillis = ObjectReader.getLong(topologyConf.get("topology.batch.flush.interval.millis"));
        if (producerBatchSize == 1 && xferBatchSize == 1 || flushIntervalMillis == 0L) {
            LOG.info("Flush Tuple generation disabled. producerBatchSize={}, xferBatchSize={}, flushIntervalMillis={}", new Object[]{producerBatchSize, xferBatchSize, flushIntervalMillis});
            return;
        }
        this.workerState.flushTupleTimer.scheduleRecurringMs(flushIntervalMillis, flushIntervalMillis, () -> {
            for (int i = 0; i < executors.size(); ++i) {
                IRunningExecutor exec = (IRunningExecutor)executors.get(i);
                if (exec.getExecutorId().get(0) == -1L) continue;
                exec.publishFlushTuple();
            }
        });
        LOG.info("Flush tuple will be generated every {} millis", (Object)flushIntervalMillis);
    }

    private void setupBackPressureCheckTimer(Map<String, Object> topologyConf) {
        if (this.workerState.isSingleWorker()) {
            LOG.info("BackPressure change checking is disabled as there is only one worker");
            return;
        }
        Long bpCheckIntervalMs = ObjectReader.getLong(topologyConf.get("topology.backpressure.check.millis"));
        this.workerState.backPressureCheckTimer.scheduleRecurringMs(bpCheckIntervalMs, bpCheckIntervalMs, () -> this.workerState.refreshBackPressureStatus());
        LOG.info("BackPressure status change checking will be performed every {} millis", (Object)bpCheckIntervalMs);
    }

    public void doRefreshLoad() {
        this.workerState.refreshLoad(this.executorsAtom.get());
        List<IRunningExecutor> executors = this.executorsAtom.get();
        for (IRunningExecutor executor : executors) {
            executor.loadChanged(this.workerState.getLoadMapping());
        }
    }

    public void doHeartBeat() throws IOException {
        LocalState state = ConfigUtils.workerState(this.workerState.conf, this.workerState.workerId);
        LSWorkerHeartbeat lsWorkerHeartbeat = new LSWorkerHeartbeat(Time.currentTimeSecs(), this.workerState.topologyId, this.workerState.localExecutors.stream().map(executor -> new ExecutorInfo(((Long)executor.get(0)).intValue(), ((Long)executor.get(1)).intValue())).collect(Collectors.toList()), this.workerState.port);
        state.setWorkerHeartBeat(lsWorkerHeartbeat);
        state.cleanup(60);
        this.heartbeatToMasterIfLocalbeatFail(lsWorkerHeartbeat);
    }

    public void doExecutorHeartbeats() {
        List<IRunningExecutor> executors = this.executorsAtom.get();
        Map<List<Integer>, ExecutorStats> stats = null == executors ? ClientStatsUtil.mkEmptyExecutorZkHbs(this.workerState.localExecutors) : ClientStatsUtil.convertExecutorZkHbs(executors.stream().collect(Collectors.toMap(IRunningExecutor::getExecutorId, IRunningExecutor::renderStats)));
        Map<String, Object> zkHb = ClientStatsUtil.mkZkWorkerHb(this.workerState.topologyId, stats, this.workerState.uptime.upTime());
        try {
            this.workerState.stormClusterState.workerHeartbeat(this.workerState.topologyId, this.workerState.assignmentId, Long.valueOf(this.workerState.port), ClientStatsUtil.thriftifyZkWorkerHb(zkHb));
        }
        catch (Exception ex) {
            LOG.error("Worker failed to write heartbeats to ZK or Pacemaker...will retry", (Throwable)ex);
        }
    }

    public Map<String, Long> getCurrentBlobVersions() throws IOException {
        HashMap<String, Long> results = new HashMap<String, Long>();
        Map blobstoreMap = (Map)this.workerState.getTopologyConf().get("topology.blobstore.map");
        if (blobstoreMap != null) {
            String stormRoot = ConfigUtils.supervisorStormDistRoot(this.workerState.getTopologyConf(), this.workerState.getTopologyId());
            for (Map.Entry entry : blobstoreMap.entrySet()) {
                String blobWithVersion;
                Matcher m;
                String localFileName = (String)entry.getKey();
                Map blobInfo = (Map)entry.getValue();
                if (blobInfo != null && blobInfo.containsKey("localname")) {
                    localFileName = (String)blobInfo.get("localname");
                }
                if (!(m = BLOB_VERSION_EXTRACTION.matcher(blobWithVersion = new File(stormRoot, localFileName).getCanonicalFile().getName())).matches()) continue;
                results.put(localFileName, Long.valueOf(m.group(1)));
            }
        }
        return results;
    }

    public void updateBlobUpdates() throws IOException {
        Map<String, Long> latestBlobVersions = this.getCurrentBlobVersions();
        this.workerState.blobToLastKnownVersion.putAll(latestBlobVersions);
        LOG.debug("Latest versions for blobs {}", latestBlobVersions);
    }

    public void checkCredentialsChanged() {
        Credentials newCreds = this.workerState.stormClusterState.credentials(this.topologyId, null);
        if (!ObjectUtils.equals((Object)newCreds, (Object)this.credentialsAtom.get())) {
            ClientAuthUtils.updateSubject(this.subject, this.autoCreds, null == newCreds ? null : newCreds.get_creds());
            for (IRunningExecutor executor : this.executorsAtom.get()) {
                executor.credentialsChanged(newCreds);
            }
            this.credentialsAtom.set(newCreds);
        }
    }

    public void checkLogConfigChanged() {
        LogConfig logConfig = this.workerState.stormClusterState.topologyLogConfig(this.topologyId, null);
        this.logConfigManager.processLogConfigChange(logConfig);
        this.establishLogSettingCallback();
    }

    public void establishLogSettingCallback() {
        this.workerState.stormClusterState.topologyLogConfig(this.topologyId, this::checkLogConfigChanged);
    }

    private void heartbeatToMasterIfLocalbeatFail(LSWorkerHeartbeat lsWorkerHeartbeat) {
        if (ConfigUtils.isLocalMode(this.conf)) {
            return;
        }
        SupervisorWorkerHeartbeat workerHeartbeat = new SupervisorWorkerHeartbeat(lsWorkerHeartbeat.get_topology_id(), lsWorkerHeartbeat.get_executors(), lsWorkerHeartbeat.get_time_secs());
        try (SupervisorIfaceFactory fac = this.supervisorIfaceSupplier.get();){
            fac.getIface().sendSupervisorWorkerHeartbeat(workerHeartbeat);
        }
        catch (Exception tr1) {
            LOG.warn("Exception when send heartbeat to local supervisor", (Object)tr1.getMessage());
            try (NimbusClient nimbusClient = NimbusClient.getConfiguredClient(this.conf);){
                nimbusClient.getClient().sendSupervisorWorkerHeartbeat(workerHeartbeat);
            }
            catch (Exception tr2) {
                LOG.error("Exception when send heartbeat to master", (Object)tr2.getMessage());
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            LOG.info("Shutting down worker {} {} {}", new Object[]{this.topologyId, this.assignmentId, this.port});
            for (IConnection socket : this.workerState.cachedNodeToPortSocket.get().values()) {
                socket.close();
            }
            LOG.info("Terminating messaging context");
            LOG.info("Shutting down executors");
            for (IRunningExecutor executor : this.executorsAtom.get()) {
                ((ExecutorShutdown)executor).shutdown();
            }
            LOG.info("Shut down executors");
            LOG.info("Shutting down transfer thread");
            this.workerState.haltWorkerTransfer();
            if (this.transferThread != null) {
                this.transferThread.interrupt();
                this.transferThread.join();
                LOG.info("Shut down transfer thread");
            }
            this.workerState.heartbeatTimer.close();
            this.workerState.refreshConnectionsTimer.close();
            this.workerState.refreshCredentialsTimer.close();
            this.workerState.checkForUpdatedBlobsTimer.close();
            this.workerState.refreshActiveTimer.close();
            this.workerState.executorHeartbeatTimer.close();
            this.workerState.userTimer.close();
            this.workerState.refreshLoadTimer.close();
            this.workerState.resetLogLevelsTimer.close();
            this.workerState.flushTupleTimer.close();
            this.workerState.backPressureCheckTimer.close();
            this.workerState.mqContext.term();
            this.workerState.closeResources();
            this.metricRegistry.stop();
            LOG.info("Trigger any worker shutdown hooks");
            this.workerState.runWorkerShutdownHooks();
            this.workerState.stormClusterState.removeWorkerHeartbeat(this.topologyId, this.assignmentId, Long.valueOf(this.port));
            LOG.info("Disconnecting from storm cluster state context");
            this.workerState.stormClusterState.disconnect();
            this.workerState.stateStorage.close();
            LOG.info("Shut down worker {} {} {}", new Object[]{this.topologyId, this.assignmentId, this.port});
        }
        catch (Exception ex) {
            throw Utils.wrapInRuntime(ex);
        }
    }

    @Override
    public boolean isWaiting() {
        return this.workerState.heartbeatTimer.isTimerWaiting() && this.workerState.refreshConnectionsTimer.isTimerWaiting() && this.workerState.refreshLoadTimer.isTimerWaiting() && this.workerState.refreshCredentialsTimer.isTimerWaiting() && this.workerState.checkForUpdatedBlobsTimer.isTimerWaiting() && this.workerState.refreshActiveTimer.isTimerWaiting() && this.workerState.executorHeartbeatTimer.isTimerWaiting() && this.workerState.userTimer.isTimerWaiting() && this.workerState.flushTupleTimer.isTimerWaiting();
    }
}

