/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.storm.shade.org.jctools.queues.QueueProgressIndicators;
import org.apache.storm.shade.org.jctools.queues.atomic.AtomicReferenceArrayQueue;

public final class SpscAtomicArrayQueue<E>
extends AtomicReferenceArrayQueue<E>
implements QueueProgressIndicators {
    private static final Integer MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex = new AtomicLong();
    protected long producerLookAhead;
    final AtomicLong consumerIndex = new AtomicLong();
    final int lookAheadStep;

    public SpscAtomicArrayQueue(int capacity) {
        super(capacity);
        this.lookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long index = this.producerIndex.get();
        int offset = this.calcElementOffset(index, mask);
        if (index >= this.producerLookAhead) {
            int step = this.lookAheadStep;
            if (null == this.lvElement(buffer, this.calcElementOffset(index + (long)step, mask))) {
                this.producerLookAhead = index + (long)step;
            } else if (null != this.lvElement(buffer, offset)) {
                return false;
            }
        }
        this.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray lElementBuffer = this.buffer;
        long index = this.consumerIndex.get();
        int offset = this.calcElementOffset(index);
        Object e = this.lvElement(lElementBuffer, offset);
        if (null == e) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        this.soElement(lElementBuffer, offset, null);
        return e;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex.get()));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    private void soProducerIndex(long newIndex) {
        this.producerIndex.lazySet(newIndex);
    }

    private void soConsumerIndex(long newIndex) {
        this.consumerIndex.lazySet(newIndex);
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }
}

