/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.AbstractJoinTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;

public class SortMergeJoinTaskDispatcher
extends AbstractJoinTaskDispatcher
implements Dispatcher {
    public SortMergeJoinTaskDispatcher(PhysicalContext context) {
        super(context);
    }

    private void genSMBJoinWork(MapWork currWork, SMBMapJoinOperator smbJoinOp) {
        LinkedHashMap<String, PartitionDesc> aliasToPartitionInfo = currWork.getAliasToPartnInfo();
        ArrayList<Path> removePaths = new ArrayList<Path>();
        for (Map.Entry<Path, ArrayList<String>> entry : currWork.getPathToAliases().entrySet()) {
            boolean keepPath = false;
            for (String alias : entry.getValue()) {
                if (!aliasToPartitionInfo.containsKey(alias)) continue;
                keepPath = true;
                break;
            }
            if (keepPath) continue;
            removePaths.add(entry.getKey());
        }
        ArrayList removeAliases = new ArrayList();
        for (Path removePath : removePaths) {
            removeAliases.addAll(currWork.getPathToAliases().get(removePath));
            currWork.removePathToAlias(removePath);
            currWork.removePathToPartitionInfo(removePath);
        }
        for (String alias : removeAliases) {
            currWork.getAliasToPartnInfo().remove(alias);
            currWork.getAliasToWork().remove(alias);
        }
        MapredLocalWork mapredLocalWork = ((SMBJoinDesc)smbJoinOp.getConf()).getLocalWork();
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : mapredLocalWork.getAliasToWork().entrySet()) {
            String alias;
            alias = entry.getKey();
            Operator<? extends OperatorDesc> op = entry.getValue();
            FetchWork fetchWork = mapredLocalWork.getAliasToFetchWork().get(alias);
            currWork.getAliasToWork().put(alias, op);
            PartitionDesc partitionInfo = currWork.getAliasToPartnInfo().get(alias);
            if (fetchWork.getTblDir() != null) {
                currWork.mergeAliasedInput(alias, fetchWork.getTblDir(), partitionInfo);
                continue;
            }
            for (Path pathDir : fetchWork.getPartDir()) {
                currWork.mergeAliasedInput(alias, pathDir, partitionInfo);
            }
        }
        for (Operator operator : smbJoinOp.getParentOperators()) {
            if (!(operator instanceof DummyStoreOperator)) continue;
            Operator<OperatorDesc> grandParentOp = operator.getParentOperators().get(0);
            smbJoinOp.replaceParent(operator, grandParentOp);
            grandParentOp.setChildOperators(operator.getChildOperators());
            operator.setParentOperators(null);
            operator.setParentOperators(null);
        }
    }

    private MapredWork convertSMBWorkToJoinWork(MapredWork currWork, SMBMapJoinOperator oldSMBJoinOp) throws SemanticException {
        try {
            MapredWork currJoinWork = SerializationUtilities.clonePlan(currWork);
            SMBMapJoinOperator newSMBJoinOp = this.getSMBMapJoinOp(currJoinWork);
            this.genSMBJoinWork(currJoinWork.getMapWork(), newSMBJoinOp);
            return currJoinWork;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SemanticException("Generate Map Join Task Error: " + e.getMessage());
        }
    }

    private MapRedTask convertSMBTaskToMapJoinTask(MapredWork origWork, int bigTablePosition, SMBMapJoinOperator smbJoinOp) throws UnsupportedEncodingException, SemanticException {
        MapredWork newWork = SerializationUtilities.clonePlan(origWork);
        MapRedTask newTask = (MapRedTask)TaskFactory.get(newWork, this.physicalContext.getParseContext().getConf(), new Task[0]);
        MapJoinOperator newMapJoinOp = this.getMapJoinOperator(newTask, newWork, smbJoinOp, bigTablePosition);
        ReduceWork rWork = newWork.getReduceWork();
        MapJoinProcessor.genLocalWorkForMapJoin(newWork, newMapJoinOp, bigTablePosition);
        newWork.setReduceWork(rWork);
        return newTask;
    }

    private boolean isEligibleForOptimization(SMBMapJoinOperator originalSMBJoinOp) {
        if (originalSMBJoinOp == null) {
            return false;
        }
        if (!originalSMBJoinOp.isConvertedAutomaticallySMBJoin()) {
            return false;
        }
        Operator currOp = originalSMBJoinOp;
        while (true) {
            if (currOp.getChildOperators() == null || currOp.getChildOperators().isEmpty()) {
                if (currOp instanceof FileSinkOperator) {
                    FileSinkOperator fsOp = (FileSinkOperator)currOp;
                    return !((FileSinkDesc)fsOp.getConf()).isRemovedReduceSinkBucketSort();
                }
                return currOp instanceof ReduceSinkOperator;
            }
            if (currOp.getChildOperators().size() > 1) {
                return true;
            }
            currOp = currOp.getChildOperators().get(0);
        }
    }

    @Override
    public Task<? extends Serializable> processCurrentTask(MapRedTask currTask, ConditionalTask conditionalTask, Context context) throws SemanticException {
        MapredWork currWork = (MapredWork)currTask.getWork();
        SMBMapJoinOperator originalSMBJoinOp = this.getSMBMapJoinOp(currWork);
        if (!this.isEligibleForOptimization(originalSMBJoinOp)) {
            return null;
        }
        currTask.setTaskTag(8);
        ParseContext parseCtx = this.physicalContext.getParseContext();
        MapredWork currJoinWork = this.convertSMBWorkToJoinWork(currWork, originalSMBJoinOp);
        SMBMapJoinOperator newSMBJoinOp = this.getSMBMapJoinOp(currJoinWork);
        currWork.getMapWork().setLeftInputJoin(((SMBJoinDesc)originalSMBJoinOp.getConf()).isLeftInputJoin());
        currWork.getMapWork().setBaseSrc(((SMBJoinDesc)originalSMBJoinOp.getConf()).getBaseSrc());
        currWork.getMapWork().setMapAliases(((SMBJoinDesc)originalSMBJoinOp.getConf()).getMapAliases());
        currJoinWork.getMapWork().setLeftInputJoin(((SMBJoinDesc)originalSMBJoinOp.getConf()).isLeftInputJoin());
        currJoinWork.getMapWork().setBaseSrc(((SMBJoinDesc)originalSMBJoinOp.getConf()).getBaseSrc());
        currJoinWork.getMapWork().setMapAliases(((SMBJoinDesc)originalSMBJoinOp.getConf()).getMapAliases());
        ArrayList listWorks = new ArrayList();
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        LinkedHashMap<Task<? extends Serializable>, Set<String>> taskToAliases = new LinkedHashMap<Task<? extends Serializable>, Set<String>>();
        LinkedHashMap<Path, ArrayList<String>> pathToAliases = currJoinWork.getMapWork().getPathToAliases();
        SMBJoinDesc originalSMBJoinDesc = (SMBJoinDesc)originalSMBJoinOp.getConf();
        Byte[] order = originalSMBJoinDesc.getTagOrder();
        int numAliases = order.length;
        Set<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(originalSMBJoinDesc.getConds());
        HashMap<String, Long> aliasToSize = new HashMap<String, Long>();
        Configuration conf = context.getConf();
        try {
            long aliasTotalKnownInputSize = this.getTotalKnownInputSize(context, currJoinWork.getMapWork(), pathToAliases, aliasToSize);
            long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            for (int bigTablePosition = 0; bigTablePosition < numAliases; ++bigTablePosition) {
                long smallTblTotalKnownSize;
                Operator<OperatorDesc> parentOp;
                MapRedTask newTask;
                MapWork mapWork;
                Set<String> aliases;
                long aliasKnownSize;
                if (!bigTableCandidates.contains(bigTablePosition) || (aliasKnownSize = Utilities.sumOf(aliasToSize, aliases = GenMapRedUtils.findAliases(mapWork = ((MapredWork)(newTask = this.convertSMBTaskToMapJoinTask(currJoinWork, bigTablePosition, newSMBJoinOp)).getWork()).getMapWork(), parentOp = originalSMBJoinOp.getParentOperators().get(bigTablePosition)))) > 0L && (smallTblTotalKnownSize = aliasTotalKnownInputSize - aliasKnownSize) > ThresholdOfSmallTblSizeSum) continue;
                listWorks.add(newTask.getWork());
                listTasks.add(newTask);
                newTask.setTaskTag(4);
                newTask.setFetchSource(currTask.isFetchSource());
                newTask.setBackupTask(currTask);
                newTask.setBackupChildrenTasks(currTask.getChildTasks());
                taskToAliases.put(newTask, aliases);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SemanticException("Generate Map Join Task Error: ", e);
        }
        listWorks.add(currTask.getWork());
        listTasks.add(currTask);
        currWork.getMapWork().setLeftInputJoin(false);
        currWork.getMapWork().setBaseSrc(null);
        currWork.getMapWork().setMapAliases(null);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, parseCtx.getConf(), new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverCommonJoin());
        ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx resolverCtx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
        resolverCtx.setPathToAliases(pathToAliases);
        resolverCtx.setAliasToKnownSize(aliasToSize);
        resolverCtx.setTaskToAliases(taskToAliases);
        resolverCtx.setCommonJoinTask(currTask);
        resolverCtx.setLocalTmpDir(context.getLocalScratchDir(false));
        resolverCtx.setHdfsTmpDir(context.getMRScratchDir());
        cndTsk.setResolverCtx(resolverCtx);
        this.replaceTaskWithConditionalTask(currTask, cndTsk);
        return cndTsk;
    }

    private boolean reducerAllowedSMBJoinOp(Operator<? extends OperatorDesc> reducer) {
        while (reducer != null) {
            if (!reducer.opAllowedBeforeSortMergeJoin()) {
                return false;
            }
            List<Operator<OperatorDesc>> childOps = reducer.getChildOperators();
            if (childOps == null || childOps.isEmpty()) {
                return true;
            }
            if (childOps.size() > 1) {
                return false;
            }
            reducer = childOps.get(0);
        }
        return true;
    }

    private SMBMapJoinOperator getSMBMapJoinOp(Operator<? extends OperatorDesc> currOp, Operator<? extends OperatorDesc> reducer) {
        SMBMapJoinOperator ret = null;
        while (true) {
            if (currOp instanceof SMBMapJoinOperator) {
                if (ret != null) {
                    return null;
                }
                ret = (SMBMapJoinOperator)currOp;
            }
            if (!currOp.opAllowedBeforeSortMergeJoin()) {
                return null;
            }
            List<Operator<OperatorDesc>> childOps = currOp.getChildOperators();
            if (childOps == null || childOps.isEmpty()) {
                return this.reducerAllowedSMBJoinOp(reducer) ? ret : null;
            }
            if (childOps.size() > 1) {
                return null;
            }
            currOp = childOps.get(0);
        }
    }

    private SMBMapJoinOperator getSMBMapJoinOp(MapredWork work) throws SemanticException {
        if (work != null && work.getReduceWork() != null) {
            Operator<?> reducer = work.getReduceWork().getReducer();
            for (Operator<? extends OperatorDesc> op : work.getMapWork().getAliasToWork().values()) {
                SMBMapJoinOperator smbMapJoinOp = this.getSMBMapJoinOp(op, reducer);
                if (smbMapJoinOp == null) continue;
                return smbMapJoinOp;
            }
        }
        return null;
    }

    private MapJoinOperator getMapJoinOperator(MapRedTask task, MapredWork work, SMBMapJoinOperator oldSMBJoinOp, int mapJoinPos) throws SemanticException {
        SMBMapJoinOperator newSMBJoinOp = this.getSMBMapJoinOp((MapredWork)task.getWork());
        return MapJoinProcessor.convertSMBJoinToMapJoin(this.physicalContext.getConf(), newSMBJoinOp, mapJoinPos, true);
    }
}

