/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstantPropagateProcFactory {
    protected static final Logger LOG = LoggerFactory.getLogger((String)ConstantPropagateProcFactory.class.getName());
    protected static Set<Class<?>> propagatableUdfs = new HashSet();
    private static final Set<PrimitiveObjectInspector.PrimitiveCategory> unSupportedTypes;
    private static final Set<PrimitiveObjectInspector.PrimitiveCategory> unsafeConversionTypes;

    private ConstantPropagateProcFactory() {
    }

    public static ColumnInfo resolveColumn(RowSchema rs, ExprNodeColumnDesc desc) {
        ColumnInfo ci = rs.getColumnInfo(desc.getTabAlias(), desc.getColumn());
        if (ci == null) {
            ci = rs.getColumnInfo(desc.getColumn());
        }
        if (ci == null) {
            return null;
        }
        return ci;
    }

    private static ExprNodeConstantDesc typeCast(ExprNodeDesc desc, TypeInfo ti) {
        return ConstantPropagateProcFactory.typeCast(desc, ti, false);
    }

    private static ExprNodeConstantDesc typeCast(ExprNodeDesc desc, TypeInfo ti, boolean performSafeTypeCast) {
        ObjectInspector oi;
        ExprNodeConstantDesc c;
        boolean brokenDataTypesCombination;
        if (desc instanceof ExprNodeConstantDesc && null == ((ExprNodeConstantDesc)desc).getValue()) {
            return null;
        }
        if (!(ti instanceof PrimitiveTypeInfo) || !(desc.getTypeInfo() instanceof PrimitiveTypeInfo)) {
            return null;
        }
        PrimitiveTypeInfo priti = (PrimitiveTypeInfo)ti;
        PrimitiveTypeInfo descti = (PrimitiveTypeInfo)desc.getTypeInfo();
        if (unSupportedTypes.contains((Object)priti.getPrimitiveCategory()) || unSupportedTypes.contains((Object)descti.getPrimitiveCategory())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unsupported types " + priti + "; " + descti);
            }
            return null;
        }
        boolean bl = brokenDataTypesCombination = unsafeConversionTypes.contains((Object)priti.getPrimitiveCategory()) && !unsafeConversionTypes.contains((Object)descti.getPrimitiveCategory());
        if (performSafeTypeCast && brokenDataTypesCombination) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unsupported cast " + priti + "; " + descti);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Casting " + desc + " to type " + ti);
        }
        if (null != (c = (ExprNodeConstantDesc)desc).getFoldedFromVal() && priti.getTypeName().equals("string")) {
            return new ExprNodeConstantDesc(c.getFoldedFromVal());
        }
        ObjectInspector origOI = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(desc.getTypeInfo());
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter(origOI, oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(ti));
        Object convObj = converter.convert(c.getValue());
        if (convObj instanceof Integer) {
            switch (priti.getPrimitiveCategory()) {
                case BYTE: {
                    convObj = new Byte((byte)((Integer)convObj).intValue());
                    break;
                }
                case SHORT: {
                    convObj = new Short((short)((Integer)convObj).intValue());
                    break;
                }
                case LONG: {
                    convObj = new Long(((Integer)convObj).intValue());
                }
            }
        }
        return new ExprNodeConstantDesc(ti, convObj);
    }

    public static ExprNodeDesc foldExpr(ExprNodeGenericFuncDesc funcDesc) {
        GenericUDF udf = funcDesc.getGenericUDF();
        if (!ConstantPropagateProcFactory.isDeterministicUdf(udf, funcDesc.getChildren())) {
            return funcDesc;
        }
        return ConstantPropagateProcFactory.evaluateFunction(funcDesc.getGenericUDF(), funcDesc.getChildren(), funcDesc.getChildren());
    }

    private static ExprNodeDesc foldExpr(ExprNodeDesc desc, Map<ColumnInfo, ExprNodeDesc> constants, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> op, int tag, boolean propagate) throws UDFArgumentException {
        if (cppCtx.getConstantPropagateOption() == ConstantPropagateProcCtx.ConstantPropagateOption.SHORTCUT) {
            return ConstantPropagateProcFactory.foldExprShortcut(desc, constants, cppCtx, op, tag, propagate);
        }
        return ConstantPropagateProcFactory.foldExprFull(desc, constants, cppCtx, op, tag, propagate);
    }

    private static ExprNodeDesc foldNegative(ExprNodeDesc desc) throws UDFArgumentException {
        ExprNodeDesc child;
        ExprNodeGenericFuncDesc funcDesc;
        GenericUDF udf;
        if (desc instanceof ExprNodeGenericFuncDesc && (udf = (funcDesc = (ExprNodeGenericFuncDesc)desc).getGenericUDF()) instanceof GenericUDFOPNot && (child = funcDesc.getChildren().get(0)) instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc childDesc = (ExprNodeGenericFuncDesc)child;
            GenericUDF childUDF = childDesc.getGenericUDF();
            List<ExprNodeDesc> grandChildren = child.getChildren();
            if (childUDF instanceof GenericUDFBaseCompare || childUDF instanceof GenericUDFOPNull || childUDF instanceof GenericUDFOPNotNull) {
                ArrayList<ExprNodeDesc> newGrandChildren = new ArrayList<ExprNodeDesc>();
                for (ExprNodeDesc grandChild : grandChildren) {
                    newGrandChildren.add(ConstantPropagateProcFactory.foldNegative(grandChild));
                }
                return ExprNodeGenericFuncDesc.newInstance(childUDF.negative(), newGrandChildren);
            }
            if (childUDF instanceof GenericUDFOPAnd || childUDF instanceof GenericUDFOPOr) {
                ArrayList<ExprNodeDesc> newGrandChildren = new ArrayList<ExprNodeDesc>();
                for (ExprNodeDesc grandChild : grandChildren) {
                    newGrandChildren.add(ConstantPropagateProcFactory.foldNegative(ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), Arrays.asList(grandChild))));
                }
                return ExprNodeGenericFuncDesc.newInstance(childUDF.negative(), newGrandChildren);
            }
            if (childUDF instanceof GenericUDFOPNot) {
                return ConstantPropagateProcFactory.foldNegative(child.getChildren().get(0));
            }
            ArrayList<ExprNodeDesc> newGrandChildren = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc grandChild : grandChildren) {
                newGrandChildren.add(ConstantPropagateProcFactory.foldNegative(grandChild));
            }
            childDesc.setChildren(newGrandChildren);
            return funcDesc;
        }
        return desc;
    }

    private static ExprNodeDesc foldExprShortcut(ExprNodeDesc desc, Map<ColumnInfo, ExprNodeDesc> constants, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> op, int tag, boolean propagate) throws UDFArgumentException {
        if ((desc = ConstantPropagateProcFactory.foldNegative(desc)) instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)desc;
            GenericUDF udf = funcDesc.getGenericUDF();
            boolean propagateNext = propagate && propagatableUdfs.contains(udf.getClass());
            ArrayList<ExprNodeDesc> newExprs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc childExpr : desc.getChildren()) {
                newExprs.add(ConstantPropagateProcFactory.foldExpr(childExpr, constants, cppCtx, op, tag, propagateNext));
            }
            if (!ConstantPropagateProcFactory.isDeterministicUdf(udf, newExprs)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Function " + udf.getClass() + " is undeterministic. Don't evaluate immediately.");
                }
                ((ExprNodeGenericFuncDesc)desc).setChildren(newExprs);
                return desc;
            }
            ExprNodeDesc shortcut = ConstantPropagateProcFactory.shortcutFunction(udf, newExprs, op);
            if (shortcut != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Folding expression:" + desc + " -> " + shortcut);
                }
                return shortcut;
            }
            ((ExprNodeGenericFuncDesc)desc).setChildren(newExprs);
        }
        return desc;
    }

    private static ExprNodeDesc foldExprFull(ExprNodeDesc desc, Map<ColumnInfo, ExprNodeDesc> constants, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> op, int tag, boolean propagate) throws UDFArgumentException {
        if ((desc = ConstantPropagateProcFactory.foldNegative(desc)) instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)desc;
            GenericUDF udf = funcDesc.getGenericUDF();
            boolean propagateNext = propagate && propagatableUdfs.contains(udf.getClass());
            ArrayList<ExprNodeDesc> newExprs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc childExpr : desc.getChildren()) {
                newExprs.add(ConstantPropagateProcFactory.foldExpr(childExpr, constants, cppCtx, op, tag, propagateNext));
            }
            if (!ConstantPropagateProcFactory.isDeterministicUdf(udf, newExprs)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Function " + udf.getClass() + " is undeterministic. Don't evaluate immediately.");
                }
                ((ExprNodeGenericFuncDesc)desc).setChildren(newExprs);
                return desc;
            }
            ExprNodeDesc constant = ConstantPropagateProcFactory.evaluateFunction(udf, newExprs, desc.getChildren());
            if (constant != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Folding expression:" + desc + " -> " + constant);
                }
                return constant;
            }
            ExprNodeDesc shortcut = ConstantPropagateProcFactory.shortcutFunction(udf, newExprs, op);
            if (shortcut != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Folding expression:" + desc + " -> " + shortcut);
                }
                return shortcut;
            }
            ((ExprNodeGenericFuncDesc)desc).setChildren(newExprs);
            if (propagate) {
                ConstantPropagateProcFactory.propagate(udf, newExprs, op.getSchema(), constants);
            }
            return desc;
        }
        if (desc instanceof ExprNodeColumnDesc) {
            if (op.getParentOperators() == null || op.getParentOperators().isEmpty()) {
                return desc;
            }
            Operator<OperatorDesc> parent = op.getParentOperators().get(tag);
            ExprNodeDesc col = ConstantPropagateProcFactory.evaluateColumn((ExprNodeColumnDesc)desc, cppCtx, parent);
            if (col != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Folding expression:" + desc + " -> " + col);
                }
                return col;
            }
        }
        return desc;
    }

    private static boolean isDeterministicUdf(GenericUDF udf, List<ExprNodeDesc> children) {
        String[] jars;
        String[] files;
        UDFType udfType = udf.getClass().getAnnotation(UDFType.class);
        if (udf instanceof GenericUDFBridge) {
            udfType = ((GenericUDFBridge)udf).getUdfClass().getAnnotation(UDFType.class);
        }
        if (!udfType.deterministic()) {
            return udf.getClass().equals(GenericUDFUnixTimeStamp.class) && children != null && children.size() > 0;
        }
        if (udf instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)udf;
            String udfClassName = bridge.getUdfClassName();
            try {
                UDF udfInternal = (UDF)Class.forName(bridge.getUdfClassName(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance();
                files = udfInternal.getRequiredFiles();
                jars = udfInternal.getRequiredJars();
            }
            catch (Exception e) {
                LOG.error("The UDF implementation class '" + udfClassName + "' is not present in the class path");
                return false;
            }
        } else {
            files = udf.getRequiredFiles();
            jars = udf.getRequiredJars();
        }
        return files == null && jars == null;
    }

    private static void propagate(GenericUDF udf, List<ExprNodeDesc> newExprs, RowSchema rs, Map<ColumnInfo, ExprNodeDesc> constants) {
        ExprNodeDesc operand;
        if (udf instanceof GenericUDFOPEqual) {
            ExprNodeConstantDesc v;
            ExprNodeDesc lOperand = newExprs.get(0);
            ExprNodeDesc rOperand = newExprs.get(1);
            if (lOperand instanceof ExprNodeConstantDesc) {
                v = (ExprNodeConstantDesc)lOperand;
            } else if (rOperand instanceof ExprNodeConstantDesc) {
                v = (ExprNodeConstantDesc)rOperand;
            } else {
                return;
            }
            ExprNodeColumnDesc c = ExprNodeDescUtils.getColumnExpr(lOperand);
            if (null == c) {
                c = ExprNodeDescUtils.getColumnExpr(rOperand);
            }
            if (null == c) {
                return;
            }
            ColumnInfo ci = ConstantPropagateProcFactory.resolveColumn(rs, c);
            if (ci != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filter " + udf + " is identified as a value assignment, propagate it.");
                }
                if (!v.getTypeInfo().equals(ci.getType())) {
                    v = ConstantPropagateProcFactory.typeCast(v, ci.getType(), true);
                }
                if (v != null) {
                    constants.put(ci, v);
                }
            }
        } else if (udf instanceof GenericUDFOPNull && (operand = newExprs.get(0)) instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc c;
            ColumnInfo ci;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Filter " + udf + " is identified as a value assignment, propagate it.");
            }
            if ((ci = ConstantPropagateProcFactory.resolveColumn(rs, c = (ExprNodeColumnDesc)operand)) != null) {
                constants.put(ci, new ExprNodeConstantDesc(ci.getType(), null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ExprNodeDesc shortcutFunction(GenericUDF udf, List<ExprNodeDesc> newExprs, Operator<? extends Serializable> op) throws UDFArgumentException {
        ExprNodeDesc thenExpr;
        BitSet positionsToRemove;
        if (udf instanceof GenericUDFOPEqual) {
            assert (newExprs.size() == 2);
            boolean foundUDFInFirst = false;
            ExprNodeGenericFuncDesc caseOrWhenexpr = null;
            if (newExprs.get(0) instanceof ExprNodeGenericFuncDesc && ((caseOrWhenexpr = (ExprNodeGenericFuncDesc)newExprs.get(0)).getGenericUDF() instanceof GenericUDFWhen || caseOrWhenexpr.getGenericUDF() instanceof GenericUDFCase)) {
                foundUDFInFirst = true;
            }
            if (!foundUDFInFirst && newExprs.get(1) instanceof ExprNodeGenericFuncDesc && !((caseOrWhenexpr = (ExprNodeGenericFuncDesc)newExprs.get(1)).getGenericUDF() instanceof GenericUDFWhen) && !(caseOrWhenexpr.getGenericUDF() instanceof GenericUDFCase)) {
                return null;
            }
            if (null == caseOrWhenexpr) {
                return null;
            }
            GenericUDF childUDF = caseOrWhenexpr.getGenericUDF();
            List<ExprNodeDesc> children = caseOrWhenexpr.getChildren();
            if (childUDF instanceof GenericUDFWhen) {
                int i;
                for (i = 1; i < children.size(); i += 2) {
                    children.set(i, ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), Lists.newArrayList(children.get(i), newExprs.get(foundUDFInFirst ? 1 : 0))));
                }
                if (children.size() % 2 == 1) {
                    i = children.size() - 1;
                    children.set(i, ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), Lists.newArrayList(children.get(i), newExprs.get(foundUDFInFirst ? 1 : 0))));
                }
                ExprNodeGenericFuncDesc newCaseOrWhenExpr = ExprNodeGenericFuncDesc.newInstance(childUDF, caseOrWhenexpr.getFuncText(), children);
                return newCaseOrWhenExpr;
            }
            if (childUDF instanceof GenericUDFCase) {
                int i;
                for (i = 2; i < children.size(); i += 2) {
                    children.set(i, ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), Lists.newArrayList(children.get(i), newExprs.get(foundUDFInFirst ? 1 : 0))));
                }
                if (children.size() % 2 == 0) {
                    i = children.size() - 1;
                    children.set(i, ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), Lists.newArrayList(children.get(i), newExprs.get(foundUDFInFirst ? 1 : 0))));
                }
                ExprNodeGenericFuncDesc newCaseOrWhenExpr = ExprNodeGenericFuncDesc.newInstance(childUDF, caseOrWhenexpr.getFuncText(), children);
                return newCaseOrWhenExpr;
            }
            return null;
        }
        if (udf instanceof GenericUDFOPAnd) {
            int i;
            positionsToRemove = new BitSet();
            ArrayList<ExprNodeDesc> notNullExprs = new ArrayList<ExprNodeDesc>();
            ArrayList<Integer> notNullExprsPositions = new ArrayList<Integer>();
            ArrayList<void> compareExprs = new ArrayList<void>();
            for (i = 0; i < newExprs.size(); ++i) {
                void var9_32;
                ExprNodeDesc childExpr = newExprs.get(i);
                if (childExpr instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc exprNodeConstantDesc = (ExprNodeConstantDesc)childExpr;
                    if (Boolean.TRUE.equals(exprNodeConstantDesc.getValue())) {
                        positionsToRemove.set(i);
                        continue;
                    }
                    return childExpr;
                }
                if (childExpr instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)childExpr).getGenericUDF() instanceof GenericUDFOPNotNull && childExpr.getChildren().get(0) instanceof ExprNodeColumnDesc) {
                    notNullExprs.add(childExpr.getChildren().get(0));
                    notNullExprsPositions.add(i);
                    continue;
                }
                if (!(childExpr instanceof ExprNodeGenericFuncDesc) || !(((ExprNodeGenericFuncDesc)childExpr).getGenericUDF() instanceof GenericUDFBaseCompare) || ((ExprNodeGenericFuncDesc)childExpr).getGenericUDF() instanceof GenericUDFOPNotEqual || childExpr.getChildren().size() != 2) continue;
                ExprNodeColumnDesc exprNodeColumnDesc = ExprNodeDescUtils.getColumnExpr(childExpr.getChildren().get(0));
                if (null == exprNodeColumnDesc) {
                    ExprNodeColumnDesc exprNodeColumnDesc2 = ExprNodeDescUtils.getColumnExpr(childExpr.getChildren().get(1));
                }
                if (var9_32 == null) continue;
                compareExprs.add(var9_32);
            }
            block3: for (i = 0; i < notNullExprs.size(); ++i) {
                for (ExprNodeDesc exprNodeDesc : compareExprs) {
                    if (!((ExprNodeDesc)notNullExprs.get(i)).isSame(exprNodeDesc)) continue;
                    positionsToRemove.set((Integer)notNullExprsPositions.get(i));
                    continue block3;
                }
            }
            int pos = 0;
            int removed = 0;
            while ((pos = positionsToRemove.nextSetBit(pos)) != -1) {
                newExprs.remove(pos - removed);
                ++pos;
                ++removed;
            }
            if (newExprs.size() == 0) {
                return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, Boolean.TRUE);
            }
            if (newExprs.size() == 1) {
                return newExprs.get(0);
            }
        }
        if (udf instanceof GenericUDFOPOr) {
            positionsToRemove = new BitSet();
            for (int i = 0; i < newExprs.size(); ++i) {
                ExprNodeDesc childExpr = newExprs.get(i);
                if (!(childExpr instanceof ExprNodeConstantDesc)) continue;
                ExprNodeConstantDesc c = (ExprNodeConstantDesc)childExpr;
                if (Boolean.FALSE.equals(c.getValue())) {
                    positionsToRemove.set(i);
                    continue;
                }
                if (!Boolean.TRUE.equals(c.getValue())) continue;
                return childExpr;
            }
            int pos = 0;
            int removed = 0;
            while ((pos = positionsToRemove.nextSetBit(pos)) != -1) {
                newExprs.remove(pos - removed);
                ++pos;
                ++removed;
            }
            if (newExprs.size() == 0) {
                return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, Boolean.FALSE);
            }
            if (newExprs.size() == 1) {
                return newExprs.get(0);
            }
        }
        if (udf instanceof GenericUDFWhen) {
            if (newExprs.size() != 2 && newExprs.size() != 3) {
                return null;
            }
            thenExpr = newExprs.get(1);
            ExprNodeDesc elseExpr = newExprs.size() == 3 ? newExprs.get(2) : new ExprNodeConstantDesc(newExprs.get(1).getTypeInfo(), null);
            ExprNodeDesc whenExpr = newExprs.get(0);
            if (whenExpr instanceof ExprNodeConstantDesc) {
                Boolean whenVal = (Boolean)((ExprNodeConstantDesc)whenExpr).getValue();
                return whenVal == null || Boolean.FALSE.equals(whenVal) ? elseExpr : thenExpr;
            }
            if (thenExpr instanceof ExprNodeConstantDesc && elseExpr instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)thenExpr;
                ExprNodeDesc constElse = elseExpr;
                Object thenVal = constThen.getValue();
                Object object = ((ExprNodeConstantDesc)constElse).getValue();
                if (thenVal == null) {
                    if (object == null) {
                        return thenExpr;
                    }
                    if (op instanceof FilterOperator) {
                        return Boolean.TRUE.equals(object) ? ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), newExprs.subList(0, 1)) : (Boolean.FALSE.equals(object) ? elseExpr : null);
                    }
                    return null;
                }
                if (object == null && op instanceof FilterOperator) {
                    return Boolean.TRUE.equals(thenVal) ? whenExpr : (Boolean.FALSE.equals(thenVal) ? thenExpr : null);
                }
                if (thenVal.equals(object)) {
                    return thenExpr;
                }
                if (thenVal instanceof Boolean && object instanceof Boolean) {
                    ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                    children.add(whenExpr);
                    children.add(new ExprNodeConstantDesc(false));
                    ExprNodeGenericFuncDesc func = ExprNodeGenericFuncDesc.newInstance(new GenericUDFNvl(), children);
                    if (Boolean.TRUE.equals(thenVal)) {
                        return func;
                    }
                    ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
                    exprs.add(func);
                    return ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), exprs);
                }
                return null;
            }
        }
        if (udf instanceof GenericUDFCase) {
            ExprNodeDesc elseExpr;
            if (newExprs.size() != 3 && newExprs.size() != 4) {
                return null;
            }
            thenExpr = newExprs.get(2);
            ExprNodeDesc exprNodeDesc = elseExpr = newExprs.size() == 4 ? newExprs.get(3) : new ExprNodeConstantDesc(newExprs.get(2).getTypeInfo(), null);
            if (thenExpr instanceof ExprNodeConstantDesc && elseExpr instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)thenExpr;
                ExprNodeDesc constElse = elseExpr;
                Object thenVal = constThen.getValue();
                Object elseVal = ((ExprNodeConstantDesc)constElse).getValue();
                if (thenVal == null) {
                    if (null == elseVal) {
                        return thenExpr;
                    }
                    if (op instanceof FilterOperator) {
                        return Boolean.TRUE.equals(elseVal) ? ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNotEqual(), newExprs.subList(0, 2)) : (Boolean.FALSE.equals(elseVal) ? elseExpr : null);
                    }
                    return null;
                }
                if (null == elseVal && op instanceof FilterOperator) {
                    return Boolean.TRUE.equals(thenVal) ? ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), newExprs.subList(0, 2)) : (Boolean.FALSE.equals(thenVal) ? thenExpr : null);
                }
                if (thenVal.equals(elseVal)) {
                    return thenExpr;
                }
                if (thenVal instanceof Boolean && elseVal instanceof Boolean) {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPEqual(), newExprs.subList(0, 2));
                    ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                    children.add(exprNodeGenericFuncDesc);
                    children.add(new ExprNodeConstantDesc(false));
                    ExprNodeGenericFuncDesc func = ExprNodeGenericFuncDesc.newInstance(new GenericUDFNvl(), children);
                    if (Boolean.TRUE.equals(thenVal)) {
                        return func;
                    }
                    ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
                    exprs.add(func);
                    return ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), exprs);
                }
                return null;
            }
        }
        if (udf instanceof GenericUDFUnixTimeStamp && newExprs.size() >= 1) {
            return ExprNodeGenericFuncDesc.newInstance(new GenericUDFToUnixTimeStamp(), newExprs);
        }
        return null;
    }

    private static ExprNodeDesc evaluateColumn(ExprNodeColumnDesc desc, ConstantPropagateProcCtx cppCtx, Operator<? extends Serializable> parent) {
        RowSchema rs = parent.getSchema();
        ColumnInfo ci = rs.getColumnInfo(desc.getColumn());
        if (ci == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Reverse look up of column " + desc + " error!");
            }
            ci = rs.getColumnInfo(desc.getTabAlias(), desc.getColumn());
        }
        if (ci == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Can't resolve " + desc.getTabAlias() + "." + desc.getColumn());
            }
            return null;
        }
        ExprNodeDesc constant = null;
        if (ci.getAlias() == null) {
            for (Map.Entry<ColumnInfo, ExprNodeDesc> e : cppCtx.getOpToConstantExprs().get(parent).entrySet()) {
                if (!e.getKey().getInternalName().equals(ci.getInternalName())) continue;
                constant = e.getValue();
                break;
            }
        } else {
            constant = cppCtx.getOpToConstantExprs().get(parent).get(ci);
        }
        if (constant != null) {
            if (constant instanceof ExprNodeConstantDesc && !constant.getTypeInfo().equals(desc.getTypeInfo())) {
                return ConstantPropagateProcFactory.typeCast(constant, desc.getTypeInfo());
            }
            return constant;
        }
        return null;
    }

    private static ExprNodeDesc evaluateFunction(GenericUDF udf, List<ExprNodeDesc> exprs, List<ExprNodeDesc> oldExprs) {
        GenericUDF.DeferredObject[] arguments = new GenericUDF.DeferredJavaObject[exprs.size()];
        ObjectInspector[] argois = new ObjectInspector[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            ExprNodeDesc desc = exprs.get(i);
            if (desc instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)exprs.get(i);
                if (!constant.getTypeInfo().equals(oldExprs.get(i).getTypeInfo()) && (constant = ConstantPropagateProcFactory.typeCast(constant, oldExprs.get(i).getTypeInfo())) == null) {
                    return null;
                }
                if (constant.getTypeInfo().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    return null;
                }
                Object value = constant.getValue();
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)constant.getTypeInfo();
                Object writableValue = null == value ? value : PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pti).getPrimitiveWritableObject(value);
                arguments[i] = new GenericUDF.DeferredJavaObject(writableValue);
                argois[i] = ObjectInspectorUtils.getConstantObjectInspector(constant.getWritableObjectInspector(), writableValue);
                continue;
            }
            if (desc instanceof ExprNodeGenericFuncDesc) {
                ExprNodeDesc evaluatedFn = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)desc);
                if (null == evaluatedFn || !(evaluatedFn instanceof ExprNodeConstantDesc)) {
                    return null;
                }
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)evaluatedFn;
                if (constant.getTypeInfo().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    return null;
                }
                Object writableValue = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)constant.getTypeInfo()).getPrimitiveWritableObject(constant.getValue());
                arguments[i] = new GenericUDF.DeferredJavaObject(writableValue);
                argois[i] = ObjectInspectorUtils.getConstantObjectInspector(constant.getWritableObjectInspector(), writableValue);
                continue;
            }
            return null;
        }
        try {
            ObjectInspector oi = udf.initialize(argois);
            Object o = udf.evaluate(arguments);
            if (LOG.isDebugEnabled()) {
                LOG.debug(udf.getClass().getName() + "(" + exprs + ")=" + o);
            }
            if (o == null) {
                return new ExprNodeConstantDesc(TypeInfoUtils.getTypeInfoFromObjectInspector(oi), o);
            }
            Class<?> clz = o.getClass();
            if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(clz)) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                PrimitiveTypeInfo typeInfo = poi.getTypeInfo();
                o = poi.getPrimitiveJavaObject(o);
                if (((TypeInfo)typeInfo).getTypeName().contains("decimal") || ((TypeInfo)typeInfo).getTypeName().contains("varchar") || ((TypeInfo)typeInfo).getTypeName().contains("char")) {
                    return new ExprNodeConstantDesc(typeInfo, o);
                }
            } else {
                if (udf instanceof GenericUDFStruct && oi instanceof StandardConstantStructObjectInspector) {
                    ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                    TypeInfo structType = TypeInfoUtils.getTypeInfoFromObjectInspector(coi);
                    return new ExprNodeConstantDesc(structType, ObjectInspectorUtils.copyToStandardJavaObject(o, coi));
                }
                if (!PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(clz)) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Unable to evaluate " + udf + ". Return value unrecoginizable.");
                    }
                    return null;
                }
            }
            String constStr = null;
            if (arguments.length == 1 && FunctionRegistry.isOpCast(udf)) {
                constStr = ((GenericUDF.DeferredJavaObject)arguments[0]).get().toString();
            }
            return new ExprNodeConstantDesc(o).setFoldedFromVal(constStr);
        }
        catch (HiveException e) {
            LOG.error("Evaluation function " + udf.getClass() + " failed in Constant Propagation Optimizer.");
            throw new RuntimeException(e);
        }
    }

    private static void foldOperator(Operator<? extends Serializable> op, ConstantPropagateProcCtx cppCtx) throws SemanticException {
        Map<String, ExprNodeDesc> colExprMap;
        RowSchema schema = op.getSchema();
        Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getOpToConstantExprs().get(op);
        if (schema != null && schema.getSignature() != null) {
            for (ColumnInfo col : schema.getSignature()) {
                ExprNodeDesc constant = constants.get(col);
                if (constant == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Replacing column " + col + " with constant " + constant + " in " + op);
                }
                if (!col.getType().equals(constant.getTypeInfo())) {
                    constant = ConstantPropagateProcFactory.typeCast(constant, col.getType());
                }
                if (constant == null) continue;
                col.setObjectinspector(constant.getWritableObjectInspector());
            }
        }
        if ((colExprMap = op.getColumnExprMap()) != null) {
            for (Map.Entry<ColumnInfo, ExprNodeDesc> e : constants.entrySet()) {
                String internalName = e.getKey().getInternalName();
                if (!colExprMap.containsKey(internalName)) continue;
                colExprMap.put(internalName, e.getValue());
            }
        }
    }

    public static ConstantPropagateFilterProc getFilterProc() {
        return new ConstantPropagateFilterProc();
    }

    public static ConstantPropagateGroupByProc getGroupByProc() {
        return new ConstantPropagateGroupByProc();
    }

    public static ConstantPropagateDefaultProc getDefaultProc() {
        return new ConstantPropagateDefaultProc();
    }

    public static ConstantPropagateSelectProc getSelectProc() {
        return new ConstantPropagateSelectProc();
    }

    public static NodeProcessor getFileSinkProc() {
        return new ConstantPropagateFileSinkProc();
    }

    public static NodeProcessor getStopProc() {
        return new ConstantPropagateStopProc();
    }

    public static NodeProcessor getReduceSinkProc() {
        return new ConstantPropagateReduceSinkProc();
    }

    public static NodeProcessor getJoinProc() {
        return new ConstantPropagateJoinProc();
    }

    public static NodeProcessor getTableScanProc() {
        return new ConstantPropagateTableScanProc();
    }

    static {
        propagatableUdfs.add(GenericUDFOPAnd.class);
        unSupportedTypes = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR)).add((Object)PrimitiveObjectInspector.PrimitiveCategory.CHAR)).build();
        unsafeConversionTypes = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING)).add((Object)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR)).add((Object)PrimitiveObjectInspector.PrimitiveCategory.CHAR)).build();
    }

    public static class ConstantPropagateTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator op = (TableScanOperator)nd;
            TableScanDesc conf = (TableScanDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ExprNodeGenericFuncDesc pred = conf.getFilterExpr();
            if (pred == null) {
                return null;
            }
            ExprNodeDesc constant = ConstantPropagateProcFactory.foldExpr(pred, constants, cppCtx, op, 0, false);
            if (constant instanceof ExprNodeGenericFuncDesc) {
                conf.setFilterExpr((ExprNodeGenericFuncDesc)constant);
            } else {
                conf.setFilterExpr(null);
            }
            return null;
        }
    }

    public static class ConstantPropagateJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            JoinDesc conf = (JoinDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            if (op.getChildOperators().size() == 1 && op.getChildOperators().get(0) instanceof ReduceSinkOperator) {
                LOG.debug("Skip JOIN-RS structure.");
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Old exprs " + conf.getExprs());
            }
            for (Map.Entry<Byte, List<ExprNodeDesc>> e : conf.getExprs().entrySet()) {
                byte tag = e.getKey();
                List<ExprNodeDesc> exprs = e.getValue();
                if (exprs == null) continue;
                ArrayList<ExprNodeDesc> newExprs = new ArrayList<ExprNodeDesc>();
                for (ExprNodeDesc expr : exprs) {
                    ExprNodeDesc newExpr = ConstantPropagateProcFactory.foldExpr(expr, constants, cppCtx, op, tag, false);
                    if (newExpr instanceof ExprNodeConstantDesc) {
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info("expr " + newExpr + " fold from " + expr + " is removed.");
                        continue;
                    }
                    newExprs.add(newExpr);
                }
                e.setValue(newExprs);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("New exprs " + conf.getExprs());
            }
            for (List<ExprNodeDesc> v : conf.getFilters().values()) {
                for (int i = 0; i < v.size(); ++i) {
                    ExprNodeDesc expr = ConstantPropagateProcFactory.foldExpr(v.get(i), constants, cppCtx, op, 0, false);
                    v.set(i, expr);
                }
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp;
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)op.getConf();
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            RowSchema rs = op.getSchema();
            if (op.getColumnExprMap() != null && rs != null) {
                for (ColumnInfo columnInfo : rs.getSignature()) {
                    ExprNodeDesc exprNodeDesc;
                    if (VirtualColumn.isVirtualColumnBasedOnAlias(columnInfo) || !((exprNodeDesc = op.getColumnExprMap().get(columnInfo.getInternalName())) instanceof ExprNodeConstantDesc)) continue;
                    constants.put(columnInfo, exprNodeDesc);
                }
            }
            if (constants.isEmpty()) {
                return null;
            }
            if (op.getChildOperators().size() == 1 && op.getChildOperators().get(0) instanceof JoinOperator && this.skipFolding((JoinDesc)(joinOp = (JoinOperator)op.getChildOperators().get(0)).getConf())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skip folding in outer join " + op);
                }
                cppCtx.getOpToConstantExprs().put(op, new HashMap());
                return null;
            }
            if (rsDesc.getDistinctColumnIndices() != null && !rsDesc.getDistinctColumnIndices().isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skip folding in distinct subqueries " + op);
                }
                cppCtx.getOpToConstantExprs().put(op, new HashMap());
                return null;
            }
            ArrayList<ExprNodeDesc> newKeyEpxrs = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc exprNodeDesc : rsDesc.getKeyCols()) {
                ExprNodeDesc newDesc = ConstantPropagateProcFactory.foldExpr(exprNodeDesc, constants, cppCtx, op, 0, false);
                if (newDesc != exprNodeDesc && exprNodeDesc instanceof ExprNodeColumnDesc && newDesc instanceof ExprNodeConstantDesc) {
                    ((ExprNodeConstantDesc)newDesc).setFoldedFromCol(((ExprNodeColumnDesc)exprNodeDesc).getColumn());
                }
                newKeyEpxrs.add(newDesc);
            }
            rsDesc.setKeyCols(newKeyEpxrs);
            ArrayList<ExprNodeDesc> arrayList = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc desc : rsDesc.getPartitionCols()) {
                ExprNodeDesc expr = ConstantPropagateProcFactory.foldExpr(desc, constants, cppCtx, op, 0, false);
                if (expr != desc && desc instanceof ExprNodeColumnDesc && expr instanceof ExprNodeConstantDesc) {
                    ((ExprNodeConstantDesc)expr).setFoldedFromCol(((ExprNodeColumnDesc)desc).getColumn());
                }
                arrayList.add(expr);
            }
            rsDesc.setPartitionCols(arrayList);
            ArrayList<ExprNodeDesc> arrayList2 = new ArrayList<ExprNodeDesc>();
            for (ExprNodeDesc desc : rsDesc.getValueCols()) {
                arrayList2.add(ConstantPropagateProcFactory.foldExpr(desc, constants, cppCtx, op, 0, false));
            }
            rsDesc.setValueCols(arrayList2);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }

        private boolean skipFolding(JoinDesc joinDesc) {
            for (JoinCondDesc cond : joinDesc.getConds()) {
                if (cond.getType() == 0 || cond.getType() == 4 || cond.getType() == 5) continue;
                return true;
            }
            return false;
        }
    }

    public static class ConstantPropagateStopProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            cppCtx.getOpToConstantExprs().put(op, new HashMap());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stop propagate constants on op " + op.getOperatorId());
            }
            return null;
        }
    }

    public static class ConstantPropagateFileSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FileSinkOperator op = (FileSinkOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            if (constants.isEmpty()) {
                return null;
            }
            FileSinkDesc fsdesc = (FileSinkDesc)op.getConf();
            DynamicPartitionCtx dpCtx = fsdesc.getDynPartCtx();
            if (dpCtx != null) {
                Operator<OperatorDesc> parent = op.getParentOperators().get(0);
                Map<ColumnInfo, ExprNodeDesc> parentConstants = cppCtx.getPropagatedConstants(parent);
                RowSchema rs = parent.getSchema();
                boolean allConstant = true;
                int dpColStartIdx = Utilities.getDPColOffset(fsdesc);
                ArrayList<ColumnInfo> colInfos = rs.getSignature();
                for (int i = dpColStartIdx; i < colInfos.size(); ++i) {
                    ColumnInfo ci = (ColumnInfo)colInfos.get(i);
                    if (parentConstants.get(ci) != null) continue;
                    allConstant = false;
                    break;
                }
                if (allConstant) {
                    this.pruneDP(fsdesc);
                }
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }

        private void pruneDP(FileSinkDesc fsdesc) {
            LOG.info("DP can be rewritten to SP!");
        }
    }

    public static class ConstantPropagateSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            List<ExprNodeDesc> colList = ((SelectDesc)op.getConf()).getColList();
            List<String> columnNames = ((SelectDesc)op.getConf()).getOutputColumnNames();
            Map<String, ExprNodeDesc> columnExprMap = op.getColumnExprMap();
            if (colList != null) {
                for (int i = 0; i < colList.size(); ++i) {
                    ColumnInfo colInfo;
                    ExprNodeDesc newCol = ConstantPropagateProcFactory.foldExpr(colList.get(i), constants, cppCtx, op, 0, false);
                    if (!(colList.get(i) instanceof ExprNodeConstantDesc) && newCol instanceof ExprNodeConstantDesc) {
                        String colName = colList.get(i).getExprString();
                        if (HiveConf.getPositionFromInternalName(colName) == -1) {
                            ((ExprNodeConstantDesc)newCol).setFoldedFromCol(colName);
                        } else {
                            ExprNodeDesc desc = columnExprMap.get(colName);
                            if (desc instanceof ExprNodeConstantDesc) {
                                ((ExprNodeConstantDesc)newCol).setFoldedFromCol(((ExprNodeConstantDesc)desc).getFoldedFromCol());
                            }
                        }
                    }
                    colList.set(i, newCol);
                    if (newCol instanceof ExprNodeConstantDesc && op.getSchema() != null && !VirtualColumn.isVirtualColumnBasedOnAlias(colInfo = op.getSchema().getSignature().get(i))) {
                        constants.put(colInfo, newCol);
                    }
                    if (columnExprMap == null) continue;
                    columnExprMap.put(columnNames.get(i), newCol);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New column list:(" + StringUtils.join(colList, " ") + ")");
                }
            }
            return null;
        }
    }

    public static class ConstantPropagateDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Operator op = (Operator)nd;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            RowSchema rs = op.getSchema();
            if (op.getColumnExprMap() != null && rs != null) {
                for (ColumnInfo colInfo : rs.getSignature()) {
                    ExprNodeDesc expr;
                    if (VirtualColumn.isVirtualColumnBasedOnAlias(colInfo) || !((expr = op.getColumnExprMap().get(colInfo.getInternalName())) instanceof ExprNodeConstantDesc)) continue;
                    constants.put(colInfo, expr);
                }
            }
            if (constants.isEmpty()) {
                return null;
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator op = (GroupByOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> colToConstants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, colToConstants);
            RowSchema rs = op.getSchema();
            if (op.getColumnExprMap() != null && rs != null) {
                for (ColumnInfo colInfo : rs.getSignature()) {
                    ExprNodeDesc expr;
                    if (VirtualColumn.isVirtualColumnBasedOnAlias(colInfo) || !((expr = op.getColumnExprMap().get(colInfo.getInternalName())) instanceof ExprNodeConstantDesc)) continue;
                    colToConstants.put(colInfo, expr);
                }
            }
            if (colToConstants.isEmpty()) {
                return null;
            }
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                ExprNodeDesc key = keys.get(i);
                ExprNodeDesc newkey = ConstantPropagateProcFactory.foldExpr(key, colToConstants, cppCtx, op, 0, false);
                keys.set(i, newkey);
            }
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }

    public static class ConstantPropagateFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDesc newCondn;
            FilterOperator op = (FilterOperator)nd;
            ConstantPropagateProcCtx cppCtx = (ConstantPropagateProcCtx)ctx;
            Map<ColumnInfo, ExprNodeDesc> constants = cppCtx.getPropagatedConstants(op);
            cppCtx.getOpToConstantExprs().put(op, constants);
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Old filter FIL[" + op.getIdentifier() + "] conditions:" + condn.getExprString());
            }
            if ((newCondn = ConstantPropagateProcFactory.foldExpr(condn, constants, cppCtx, op, 0, true)) instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc c = (ExprNodeConstantDesc)newCondn;
                if (Boolean.TRUE.equals(c.getValue())) {
                    cppCtx.addOpToDelete(op);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Filter expression " + condn + " holds true. Will delete it.");
                    }
                } else if (Boolean.FALSE.equals(c.getValue()) && LOG.isWarnEnabled()) {
                    LOG.warn("Filter expression " + condn + " holds false!");
                }
            }
            if (newCondn instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)newCondn).getValue() == null) {
                newCondn = new ExprNodeConstantDesc(Boolean.FALSE);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("New filter FIL[" + op.getIdentifier() + "] conditions:" + newCondn.getExprString());
            }
            ((FilterDesc)op.getConf()).setPredicate(newCondn);
            ConstantPropagateProcFactory.foldOperator(op, cppCtx);
            return null;
        }
    }
}

