/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TFieldIdEnum;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TField;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolFactory;
import org.apache.storm.thrift.protocol.TProtocolUtil;
import org.apache.storm.thrift.transport.TMemoryInputTransport;

public class TDeserializer {
    private final TProtocol protocol_;
    private final TMemoryInputTransport trans_ = new TMemoryInputTransport();

    public TDeserializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TDeserializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.trans_);
    }

    public void deserialize(TBase base, byte[] bytes) throws TException {
        this.deserialize(base, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(TBase base, byte[] bytes, int offset, int length) throws TException {
        try {
            this.trans_.reset(bytes, offset, length);
            base.read(this.protocol_);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public void deserialize(TBase base, String data, String charset) throws TException {
        try {
            this.deserialize(base, data.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
        finally {
            this.protocol_.reset();
        }
    }

    public void partialDeserialize(TBase tb, byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            if (this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest) != null) {
                tb.read(this.protocol_);
            }
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public Boolean partialDeserializeBool(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Boolean)this.partialDeserializeField((byte)2, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Byte partialDeserializeByte(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Byte)this.partialDeserializeField((byte)3, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Double partialDeserializeDouble(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Double)this.partialDeserializeField((byte)4, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeI16(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Short)this.partialDeserializeField((byte)6, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Integer partialDeserializeI32(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Integer)this.partialDeserializeField((byte)8, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Long partialDeserializeI64(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (Long)this.partialDeserializeField((byte)10, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public String partialDeserializeString(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (String)this.partialDeserializeField((byte)11, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public ByteBuffer partialDeserializeByteArray(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        return (ByteBuffer)this.partialDeserializeField((byte)100, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeSetFieldIdInUnion(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field = this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest);
            if (field != null) {
                this.protocol_.readStructBegin();
                Short s = this.protocol_.readFieldBegin().id;
                return s;
            }
            Short s = null;
            return s;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private Object partialDeserializeField(byte ttype, byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        try {
            TField field = this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest);
            if (field != null) {
                switch (ttype) {
                    case 2: {
                        if (field.type != 2) break;
                        Boolean bl = this.protocol_.readBool();
                        return bl;
                    }
                    case 3: {
                        if (field.type != 3) break;
                        Byte by = this.protocol_.readByte();
                        return by;
                    }
                    case 4: {
                        if (field.type != 4) break;
                        Double d = this.protocol_.readDouble();
                        return d;
                    }
                    case 6: {
                        if (field.type != 6) break;
                        Short s = this.protocol_.readI16();
                        return s;
                    }
                    case 8: {
                        if (field.type != 8) break;
                        Integer n = this.protocol_.readI32();
                        return n;
                    }
                    case 10: {
                        if (field.type != 10) break;
                        Long l = this.protocol_.readI64();
                        return l;
                    }
                    case 11: {
                        if (field.type != 11) break;
                        String string = this.protocol_.readString();
                        return string;
                    }
                    case 100: {
                        if (field.type != 11) break;
                        ByteBuffer byteBuffer = this.protocol_.readBinary();
                        return byteBuffer;
                    }
                }
            }
            Object var6_15 = null;
            return var6_15;
        }
        catch (Exception e) {
            throw new TException(e);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private TField locateField(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) throws TException {
        this.trans_.reset(bytes);
        TFieldIdEnum[] fieldIdPath = new TFieldIdEnum[fieldIdPathRest.length + 1];
        fieldIdPath[0] = fieldIdPathFirst;
        for (int i = 0; i < fieldIdPathRest.length; ++i) {
            fieldIdPath[i + 1] = fieldIdPathRest[i];
        }
        int curPathIndex = 0;
        TField field = null;
        this.protocol_.readStructBegin();
        while (curPathIndex < fieldIdPath.length) {
            field = this.protocol_.readFieldBegin();
            if (field.type == 0 || field.id > fieldIdPath[curPathIndex].getThriftFieldId()) {
                return null;
            }
            if (field.id != fieldIdPath[curPathIndex].getThriftFieldId()) {
                TProtocolUtil.skip(this.protocol_, field.type);
                this.protocol_.readFieldEnd();
                continue;
            }
            if (++curPathIndex >= fieldIdPath.length) continue;
            this.protocol_.readStructBegin();
        }
        return field;
    }

    public void fromString(TBase base, String data) throws TException {
        this.deserialize(base, data.getBytes());
    }
}

