/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.mapreduce.DefaultOutputCommitterContainer;
import org.apache.hive.hcatalog.mapreduce.DefaultRecordWriterContainer;
import org.apache.hive.hcatalog.mapreduce.InternalUtil;
import org.apache.hive.hcatalog.mapreduce.OutputFormatContainer;

class DefaultOutputFormatContainer
extends OutputFormatContainer {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public DefaultOutputFormatContainer(OutputFormat<WritableComparable<?>, Writable> of) {
        super(of);
    }

    static synchronized String getOutputName(int partition) {
        return "part-" + NUMBER_FORMAT.format(partition);
    }

    public RecordWriter<WritableComparable<?>, HCatRecord> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        String name = DefaultOutputFormatContainer.getOutputName(context.getTaskAttemptID().getTaskID().getId());
        return new DefaultRecordWriterContainer(context, this.getBaseOutputFormat().getRecordWriter(null, new JobConf(context.getConfiguration()), name, (Progressable)InternalUtil.createReporter(context)));
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new DefaultOutputCommitterContainer((JobContext)context, new JobConf(context.getConfiguration()).getOutputCommitter());
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        OutputFormat outputFormat = this.getBaseOutputFormat();
        JobConf jobConf = new JobConf(context.getConfiguration());
        outputFormat.checkOutputSpecs(null, jobConf);
        HCatUtil.copyConf((Configuration)jobConf, context.getConfiguration());
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

