/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.common;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoCreds
implements IAutoCredentials,
ICredentialsRenewer,
INimbusCredentialPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAutoCreds.class);
    public static final String CONFIG_KEY_RESOURCES = "resources";
    private Set<String> configKeys = new HashSet<String>();
    private Map<String, Map<String, Object>> configMap = new HashMap<String, Map<String, Object>>();

    public void prepare(Map conf) {
        this.doPrepare(conf);
        this.loadConfigKeys(conf);
        for (String key : this.configKeys) {
            if (!conf.containsKey(key)) continue;
            Map config = (Map)conf.get(key);
            this.configMap.put(key, config);
            LOG.info("configKey = {}, config = {}", (Object)key, (Object)config);
        }
    }

    public void populateCredentials(Map<String, String> credentials, Map<String, Object> topoConf, String topologyOwnerPrincipal) {
        try {
            List<String> loadedKeys = this.loadConfigKeys(topoConf);
            if (!loadedKeys.isEmpty()) {
                Map<String, Object> updatedConf = this.updateConfigs(topoConf);
                for (String configKey : loadedKeys) {
                    credentials.put(this.getCredentialKey(configKey), DatatypeConverter.printBase64Binary((byte[])this.getHadoopCredentials(updatedConf, configKey, topologyOwnerPrincipal)));
                }
            } else {
                credentials.put(this.getCredentialKey(""), DatatypeConverter.printBase64Binary((byte[])this.getHadoopCredentials(topoConf, topologyOwnerPrincipal)));
            }
            LOG.info("Tokens added to credentials map.");
        }
        catch (Exception e) {
            LOG.error("Could not populate credentials.", (Throwable)e);
        }
    }

    private Map<String, Object> updateConfigs(Map topologyConf) {
        HashMap<String, Object> res = new HashMap<String, Object>(topologyConf);
        for (String configKey : this.configKeys) {
            if (res.containsKey(configKey) || !this.configMap.containsKey(configKey)) continue;
            res.put(configKey, this.configMap.get(configKey));
        }
        return res;
    }

    public void renew(Map<String, String> credentials, Map<String, Object> topologyConf, String ownerPrincipal) {
        this.doRenew(credentials, this.updateConfigs(topologyConf), ownerPrincipal);
    }

    public void populateCredentials(Map<String, String> credentials) {
        credentials.put(this.getCredentialKey(""), DatatypeConverter.printBase64Binary((byte[])"dummy place holder".getBytes()));
    }

    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    protected Set<Pair<String, Credentials>> getCredentials(Map<String, String> credentials) {
        HashSet<Pair<String, Credentials>> res = new HashSet<Pair<String, Credentials>>();
        if (!this.configKeys.isEmpty()) {
            for (String configKey : this.configKeys) {
                Credentials cred = this.doGetCredentials(credentials, configKey);
                if (cred == null) continue;
                res.add((Pair<String, Credentials>)new Pair((Object)configKey, (Object)cred));
            }
        } else {
            Credentials cred = this.doGetCredentials(credentials, "");
            if (cred != null) {
                res.add((Pair<String, Credentials>)new Pair((Object)"", (Object)cred));
            }
        }
        return res;
    }

    protected void fillHadoopConfiguration(Map topoConf, String configKey, Configuration configuration) {
        Map config = (Map)topoConf.get(configKey);
        LOG.info("TopoConf {}, got config {}, for configKey {}", new Object[]{topoConf, config, configKey});
        if (config != null) {
            ArrayList resourcesToLoad = new ArrayList();
            for (Map.Entry entry : config.entrySet()) {
                if (((String)entry.getKey()).equals(CONFIG_KEY_RESOURCES)) {
                    resourcesToLoad.addAll((List)entry.getValue());
                    continue;
                }
                configuration.set((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            LOG.info("Resources to load {}", resourcesToLoad);
            for (String pathStr : resourcesToLoad) {
                configuration.addResource(new Path(Paths.get(pathStr, new String[0]).toUri()));
            }
        }
        LOG.info("Initializing UGI with config {}", (Object)configuration);
        UserGroupInformation.setConfiguration((Configuration)configuration);
    }

    protected abstract void doPrepare(Map var1);

    protected abstract String getConfigKeyString();

    protected abstract String getCredentialKey(String var1);

    protected abstract byte[] getHadoopCredentials(Map<String, Object> var1, String var2, String var3);

    protected abstract byte[] getHadoopCredentials(Map<String, Object> var1, String var2);

    protected abstract void doRenew(Map<String, String> var1, Map<String, Object> var2, String var3);

    private void addCredentialToSubject(Subject subject, Map<String, String> credentials) {
        try {
            for (Pair<String, Credentials> cred : this.getCredentials(credentials)) {
                subject.getPrivateCredentials().add(cred.getSecond());
                LOG.info("Credentials added to the subject.");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize and get UserGroupInformation.", (Throwable)e);
        }
    }

    private void addTokensToUGI(Subject subject) {
        Set<Credentials> privateCredentials;
        if (subject != null && (privateCredentials = subject.getPrivateCredentials(Credentials.class)) != null) {
            for (Credentials cred : privateCredentials) {
                Collection allTokens = cred.getAllTokens();
                if (allTokens == null) continue;
                for (Token token : allTokens) {
                    try {
                        if (token == null) {
                            LOG.debug("Ignoring null token");
                            continue;
                        }
                        LOG.debug("Current user: {}", (Object)UserGroupInformation.getCurrentUser());
                        LOG.debug("Token from Credentials : {}", (Object)token);
                        TokenIdentifier tokenId = token.decodeIdentifier();
                        if (tokenId != null) {
                            LOG.debug("Token identifier : {}", (Object)tokenId);
                            LOG.debug("Username in token identifier : {}", (Object)tokenId.getUser());
                        }
                        UserGroupInformation.getCurrentUser().addToken(token);
                        LOG.info("Added delegation tokens to UGI.");
                    }
                    catch (IOException e) {
                        LOG.error("Exception while trying to add tokens to ugi", (Throwable)e);
                    }
                }
            }
        }
    }

    private Credentials doGetCredentials(Map<String, String> credentials, String configKey) {
        Credentials credential = null;
        if (credentials != null && credentials.containsKey(this.getCredentialKey(configKey))) {
            try {
                byte[] credBytes = DatatypeConverter.parseBase64Binary((String)credentials.get(this.getCredentialKey(configKey)));
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(credBytes));
                credential = new Credentials();
                credential.readFields((DataInput)in);
            }
            catch (Exception e) {
                LOG.error("Could not obtain credentials from credentials map.", (Throwable)e);
            }
        }
        return credential;
    }

    private List<String> loadConfigKeys(Map conf) {
        List<String> keys = (List<String>)conf.get(this.getConfigKeyString());
        if (keys != null) {
            this.configKeys.addAll(keys);
        } else {
            keys = Collections.emptyList();
        }
        return keys;
    }
}

