/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class TemporaryRowHolderResultSet
implements CursorResultSet,
NoPutResultSet,
Cloneable {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private ResultDescription resultDescription;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this(transactionController, execRowArray, resultDescription, bl, false, 0L, temporaryRowHolderImpl);
    }

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl, boolean bl2, long l, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.tc = transactionController;
        this.rowArray = execRowArray;
        this.resultDescription = resultDescription;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = bl;
        this.isAppendable = bl2;
        this.positionIndexConglomId = l;
        this.holder = temporaryRowHolderImpl;
    }

    public void reset(ExecRow[] execRowArray) {
        this.rowArray = execRowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
    }

    public void reStartScan(long l, long l2) throws StandardException {
        if (this.isAppendable) {
            this.positionIndexConglomId = l2;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    private static int[] supersetofAllColumns(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length + nArray2.length;
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = -1;
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = nArray[n];
        }
        n = nArray.length;
        for (int i = 0; i < nArray2.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (nArray3[j] != nArray2[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            nArray3[n] = nArray2[i];
            ++n;
        }
        nArray3 = TemporaryRowHolderResultSet.shrinkArray(nArray3);
        Arrays.sort(nArray3);
        return nArray3;
    }

    private static int[] shrinkArray(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            ++n;
        }
        if (n > 0) {
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                nArray2[n3++] = nArray[i];
            }
            return nArray2;
        }
        return null;
    }

    private static int[] justTheRequiredColumnsPositions(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == -1) continue;
            ++n;
        }
        if (n > 0) {
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                nArray2[n3++] = i + 1;
            }
            return nArray2;
        }
        return null;
    }

    public static TemporaryRowHolderResultSet getNewRSOnCurrentRow(TriggerDescriptor triggerDescriptor, Activation activation, CursorResultSet cursorResultSet, int[] nArray) throws StandardException {
        TemporaryRowHolderImpl temporaryRowHolderImpl;
        DataDictionary dataDictionary = activation.getLanguageConnectionContext().getDataDictionary();
        if (!dataDictionary.checkVersion(210, null)) {
            TemporaryRowHolderImpl temporaryRowHolderImpl2 = new TemporaryRowHolderImpl(activation, null, cursorResultSet.getResultDescription());
            temporaryRowHolderImpl2.insert(cursorResultSet.getCurrentRow());
            return (TemporaryRowHolderResultSet)temporaryRowHolderImpl2.getResultSet();
        }
        int[] nArray2 = triggerDescriptor.getReferencedColsInTriggerAction();
        int[] nArray3 = triggerDescriptor.getReferencedCols();
        if (nArray3 != null && triggerDescriptor.isRowTrigger() && nArray2 != null && nArray2.length != 0) {
            int n;
            int n2;
            int[] nArray4;
            int[] nArray5 = TemporaryRowHolderResultSet.supersetofAllColumns(nArray3, nArray2);
            int n3 = nArray5.length;
            int[] nArray6 = new int[n3];
            if (nArray != null) {
                nArray4 = TemporaryRowHolderResultSet.justTheRequiredColumnsPositions(nArray);
            } else {
                n2 = triggerDescriptor.getTableDescriptor().getNumberOfColumns();
                nArray4 = new int[n2];
                for (n = 1; n <= n2; ++n) {
                    nArray4[n - 1] = n;
                }
            }
            n2 = 0;
            block1: for (n = 0; n < n3; ++n) {
                while (n2 < nArray4.length) {
                    if (nArray4[n2] == nArray5[n]) {
                        nArray6[n] = n2 + 1;
                        continue block1;
                    }
                    ++n2;
                }
            }
            temporaryRowHolderImpl = new TemporaryRowHolderImpl(activation, null, activation.getLanguageConnectionContext().getLanguageFactory().getResultDescription(cursorResultSet.getResultDescription(), nArray6));
            ExecRow execRow = activation.getExecutionFactory().getValueRow(n3);
            for (int i = 0; i < n3; ++i) {
                execRow.setColumn(i + 1, cursorResultSet.getCurrentRow().getColumn(nArray6[i]));
            }
            temporaryRowHolderImpl.insert(execRow);
        } else {
            temporaryRowHolderImpl = new TemporaryRowHolderImpl(activation, null, cursorResultSet.getResultDescription());
            temporaryRowHolderImpl.insert(cursorResultSet.getCurrentRow());
        }
        return (TemporaryRowHolderResultSet)temporaryRowHolderImpl.getResultSet();
    }

    public void markAsTopResultSet() {
    }

    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.getTemporaryConglomId() == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.getTemporaryConglomId(), false, 0, 7, 5, null, null, 0, null, null, 0);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow.getRowArray());
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long l) throws StandardException {
        if (this.holder.getTemporaryConglomId() == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(l);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new SQLLongint(l)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, dataValueDescriptorArray, 1, null, null, -1);
        } else {
            this.indexsc.reopenScan(dataValueDescriptorArray, 1, null, null, -1);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation rowLocation = (RowLocation)this.indexRow[1];
        boolean bl = this.heapCC.fetch(rowLocation, this.currentRow.getRowArray(), null);
        ++this.numRowsOut;
        return this.currentRow;
    }

    public int getPointOfAttachment() {
        return -1;
    }

    public int getScanIsolationLevel() {
        return 5;
    }

    public void setTargetResultSet(TargetResultSet targetResultSet) {
    }

    public void setNeedsRowLocation(boolean bl) {
    }

    public double getEstimatedRowCount() {
        return 0.0;
    }

    public int resultSetNumber() {
        return 0;
    }

    public void setCurrentRow(ExecRow execRow) {
        this.currentRow = execRow;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public void close() throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
    }

    public boolean returnsRows() {
        return true;
    }

    public long modifiedRowCount() {
        return 0L;
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void open() throws StandardException {
        this.openCore();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        return null;
    }

    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        return null;
    }

    public boolean checkRowPosition(int n) {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        this.close();
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finished = true;
        this.close();
    }

    public long getExecuteTime() {
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    public long getTimeSpent(int n) {
        return 0L;
    }

    public NoPutResultSet[] getSubqueryTrackingArray(int n) {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    public boolean requiresRelocking() {
        return false;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        return null;
    }

    public boolean needsToClone() {
        return false;
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return false;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
    }

    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
    }

    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public void addWarning(SQLWarning sQLWarning) {
        this.getActivation().addWarning(sQLWarning);
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
    }

    public void markRowAsDeleted() throws StandardException {
    }

    public final Activation getActivation() {
        return this.holder.activation;
    }
}

