/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Security {
    private static final Logger LOG = LoggerFactory.getLogger(HCatOutputFormat.class);

    Security() {
    }

    public static Security getInstance() {
        return LazyHolder.INSTANCE;
    }

    boolean isSecurityEnabled() {
        try {
            Method m = UserGroupInformation.class.getMethod("isSecurityEnabled", new Class[0]);
            return (Boolean)m.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            LOG.info("Security is not supported by this version of hadoop.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to call isSecurityEnabled()";
            LOG.info(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Failed to call isSecurityEnabled()";
            LOG.info(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
        return false;
    }

    String getTokenSignature(OutputJobInfo outputJobInfo) {
        Map<String, String> partValues;
        String tableName;
        StringBuilder result = new StringBuilder("");
        String dbName = outputJobInfo.getDatabaseName();
        if (dbName != null) {
            result.append(dbName);
        }
        if ((tableName = outputJobInfo.getTableName()) != null) {
            result.append("." + tableName);
        }
        if ((partValues = outputJobInfo.getPartitionValues()) != null) {
            for (Map.Entry<String, String> entry : partValues.entrySet()) {
                result.append("/");
                result.append(entry.getKey());
                result.append("=");
                result.append(entry.getValue());
            }
        }
        return result.toString();
    }

    void handleSecurity(Credentials credentials, OutputJobInfo outputJobInfo, HiveMetaStoreClient client, Configuration conf, boolean harRequested) throws IOException, MetaException, TException, Exception {
        UserGroupInformation ugi;
        org.apache.hadoop.hive.thrift.DelegationTokenSelector hiveTokenSelector;
        Token<? extends AbstractDelegationTokenIdentifier> hiveToken;
        if (UserGroupInformation.isSecurityEnabled() && (hiveToken = (hiveTokenSelector = new org.apache.hadoop.hive.thrift.DelegationTokenSelector()).selectToken(new Text(), (ugi = UserGroupInformation.getCurrentUser()).getTokens())) == null) {
            DelegationTokenSelector jtTokenSelector;
            Token jtToken;
            String tokenSignature = this.getTokenSignature(outputJobInfo);
            hiveToken = HCatUtil.extractThriftToken(client.getDelegationToken(ugi.getUserName()), tokenSignature);
            if (harRequested && (jtToken = (jtTokenSelector = new DelegationTokenSelector()).selectToken(SecurityUtil.buildTokenService((InetSocketAddress)ShimLoader.getHadoopShims().getHCatShim().getResourceManagerAddress(conf)), ugi.getTokens())) == null) {
                credentials.addToken(new Text("hcat jt token"), HCatUtil.getJobTrackerDelegationToken(conf, ugi.getUserName()));
            }
            credentials.addToken(new Text(ugi.getUserName() + "_" + tokenSignature), hiveToken);
            conf.set("mapreduce.lib.hcatoutput.token.sig", tokenSignature);
        }
    }

    void handleSecurity(Job job, OutputJobInfo outputJobInfo, HiveMetaStoreClient client, Configuration conf, boolean harRequested) throws IOException, MetaException, TException, Exception {
        this.handleSecurity(job.getCredentials(), outputJobInfo, client, conf, harRequested);
    }

    void cancelToken(HiveMetaStoreClient client, JobContext context) throws IOException, MetaException {
        String tokenStrForm = client.getTokenStrForm();
        if (tokenStrForm != null && context.getConfiguration().get("mapreduce.lib.hcatoutput.token.sig") != null) {
            try {
                client.cancelDelegationToken(tokenStrForm);
            }
            catch (TException e) {
                String msg = "Failed to cancel delegation token";
                LOG.error(msg, (Throwable)e);
                throw new IOException(msg, e);
            }
        }
    }

    private static final class LazyHolder {
        public static final Security INSTANCE = new Security();

        private LazyHolder() {
        }
    }
}

