/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.Flushable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SyncRequestProcessor.class);
    private final ZooKeeperServer zks;
    private final LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private final RequestProcessor nextProcessor;
    private Thread snapInProcess = null;
    private volatile boolean running;
    private final LinkedList<Request> toFlush = new LinkedList();
    private final Random r = new Random(System.nanoTime());
    private static int snapCount = ZooKeeperServer.getSnapCount();
    private static int randRoll;
    private final Request requestOfDeath = Request.requestOfDeath;

    public SyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("SyncThread:" + zks.getServerId());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        this.running = true;
    }

    public static void setSnapCount(int count2) {
        snapCount = count2;
        randRoll = count2;
    }

    public static int getSnapCount() {
        return snapCount;
    }

    private static void setRandRoll(int roll2) {
        randRoll = roll2;
    }

    @Override
    public void run() {
        try {
            int logCount = 0;
            SyncRequestProcessor.setRandRoll(this.r.nextInt(snapCount / 2));
            while (true) {
                Request si = null;
                if (this.toFlush.isEmpty()) {
                    si = this.queuedRequests.take();
                } else {
                    si = this.queuedRequests.poll();
                    if (si == null) {
                        this.flush(this.toFlush);
                        continue;
                    }
                }
                if (si != this.requestOfDeath) {
                    if (si == null) continue;
                    if (this.zks.getZKDatabase().append(si)) {
                        if (++logCount > snapCount / 2 + randRoll) {
                            randRoll = this.r.nextInt(snapCount / 2);
                            this.zks.getZKDatabase().rollLog();
                            if (this.snapInProcess != null && this.snapInProcess.isAlive()) {
                                LOG.warn("Too busy to snap, skipping");
                            } else {
                                this.snapInProcess = new Thread("Snapshot Thread"){

                                    public void run() {
                                        try {
                                            SyncRequestProcessor.this.zks.takeSnapshot();
                                        }
                                        catch (Exception e) {
                                            LOG.warn("Unexpected exception", e);
                                        }
                                    }
                                };
                                this.snapInProcess.start();
                            }
                            logCount = 0;
                        }
                    } else if (this.toFlush.isEmpty()) {
                        if (this.nextProcessor == null) continue;
                        this.nextProcessor.processRequest(si);
                        if (!(this.nextProcessor instanceof Flushable)) continue;
                        ((Flushable)((Object)this.nextProcessor)).flush();
                        continue;
                    }
                    this.toFlush.add(si);
                    if (this.toFlush.size() <= 1000) continue;
                    this.flush(this.toFlush);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            LOG.error("Severe unrecoverable error, exiting", t);
            this.running = false;
            System.exit(11);
        }
        LOG.info("SyncRequestProcessor exited!");
    }

    private void flush(LinkedList<Request> toFlush) throws IOException, RequestProcessor.RequestProcessorException {
        if (toFlush.isEmpty()) {
            return;
        }
        this.zks.getZKDatabase().commit();
        while (!toFlush.isEmpty()) {
            Request i = toFlush.remove();
            if (this.nextProcessor == null) continue;
            this.nextProcessor.processRequest(i);
        }
        if (this.nextProcessor != null && this.nextProcessor instanceof Flushable) {
            ((Flushable)((Object)this.nextProcessor)).flush();
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.queuedRequests.add(this.requestOfDeath);
        try {
            if (this.running) {
                this.join();
            }
            if (!this.toFlush.isEmpty()) {
                this.flush(this.toFlush);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while wating for " + this + " to finish");
        }
        catch (IOException e) {
            LOG.warn("Got IO exception during shutdown");
        }
        catch (RequestProcessor.RequestProcessorException e) {
            LOG.warn("Got request processor exception during shutdown");
        }
        if (this.nextProcessor != null) {
            this.nextProcessor.shutdown();
        }
    }

    @Override
    public void processRequest(Request request) {
        this.queuedRequests.add(request);
    }
}

