/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hack.relocation;

import org.apache.storm.hack.relocation.Relocator;

public class SimpleRelocator
implements Relocator {
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final String warnMessage;

    public SimpleRelocator(String patt, String shadedPattern, String warnMessage) {
        if (patt == null) {
            this.pattern = "";
            this.pathPattern = "";
        } else {
            this.pattern = patt.replace('/', '.');
            this.pathPattern = patt.replace('.', '/');
        }
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern.replace('/', '.');
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        this.warnMessage = warnMessage;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        return path.startsWith(this.pathPattern) || path.startsWith("/" + this.pathPattern);
    }

    @Override
    public boolean canRelocateClass(String clazz) {
        return clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    @Override
    public String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    @Override
    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }

    @Override
    public String applyToSourceContent(String sourceContent) {
        return sourceContent.replaceAll("\\b" + this.pattern, this.shadedPattern);
    }

    @Override
    public String getWarnMessage() {
        return this.warnMessage;
    }
}

