#!/usr/bin/env python
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#
# Autogenerated by Thrift Compiler (0.9.3)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:utf8strings
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException

from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class ComponentType:
  BOLT = 1
  SPOUT = 2

  _VALUES_TO_NAMES = {
    1: "BOLT",
    2: "SPOUT",
  }

  _NAMES_TO_VALUES = {
    "BOLT": 1,
    "SPOUT": 2,
  }

class TopologyInitialStatus:
  ACTIVE = 1
  INACTIVE = 2

  _VALUES_TO_NAMES = {
    1: "ACTIVE",
    2: "INACTIVE",
  }

  _NAMES_TO_VALUES = {
    "ACTIVE": 1,
    "INACTIVE": 2,
  }

class AccessControlType:
  OTHER = 1
  USER = 2

  _VALUES_TO_NAMES = {
    1: "OTHER",
    2: "USER",
  }

  _NAMES_TO_VALUES = {
    "OTHER": 1,
    "USER": 2,
  }

class TopologyStatus:
  ACTIVE = 1
  INACTIVE = 2
  REBALANCING = 3
  KILLED = 4

  _VALUES_TO_NAMES = {
    1: "ACTIVE",
    2: "INACTIVE",
    3: "REBALANCING",
    4: "KILLED",
  }

  _NAMES_TO_VALUES = {
    "ACTIVE": 1,
    "INACTIVE": 2,
    "REBALANCING": 3,
    "KILLED": 4,
  }

class NumErrorsChoice:
  ALL = 0
  NONE = 1
  ONE = 2

  _VALUES_TO_NAMES = {
    0: "ALL",
    1: "NONE",
    2: "ONE",
  }

  _NAMES_TO_VALUES = {
    "ALL": 0,
    "NONE": 1,
    "ONE": 2,
  }

class ProfileAction:
  JPROFILE_STOP = 0
  JPROFILE_START = 1
  JPROFILE_DUMP = 2
  JMAP_DUMP = 3
  JSTACK_DUMP = 4
  JVM_RESTART = 5

  _VALUES_TO_NAMES = {
    0: "JPROFILE_STOP",
    1: "JPROFILE_START",
    2: "JPROFILE_DUMP",
    3: "JMAP_DUMP",
    4: "JSTACK_DUMP",
    5: "JVM_RESTART",
  }

  _NAMES_TO_VALUES = {
    "JPROFILE_STOP": 0,
    "JPROFILE_START": 1,
    "JPROFILE_DUMP": 2,
    "JMAP_DUMP": 3,
    "JSTACK_DUMP": 4,
    "JVM_RESTART": 5,
  }

class LogLevelAction:
  UNCHANGED = 1
  UPDATE = 2
  REMOVE = 3

  _VALUES_TO_NAMES = {
    1: "UNCHANGED",
    2: "UPDATE",
    3: "REMOVE",
  }

  _NAMES_TO_VALUES = {
    "UNCHANGED": 1,
    "UPDATE": 2,
    "REMOVE": 3,
  }

class HBServerMessageType:
  CREATE_PATH = 0
  CREATE_PATH_RESPONSE = 1
  EXISTS = 2
  EXISTS_RESPONSE = 3
  SEND_PULSE = 4
  SEND_PULSE_RESPONSE = 5
  GET_ALL_PULSE_FOR_PATH = 6
  GET_ALL_PULSE_FOR_PATH_RESPONSE = 7
  GET_ALL_NODES_FOR_PATH = 8
  GET_ALL_NODES_FOR_PATH_RESPONSE = 9
  GET_PULSE = 10
  GET_PULSE_RESPONSE = 11
  DELETE_PATH = 12
  DELETE_PATH_RESPONSE = 13
  DELETE_PULSE_ID = 14
  DELETE_PULSE_ID_RESPONSE = 15
  CONTROL_MESSAGE = 16
  SASL_MESSAGE_TOKEN = 17
  NOT_AUTHORIZED = 18

  _VALUES_TO_NAMES = {
    0: "CREATE_PATH",
    1: "CREATE_PATH_RESPONSE",
    2: "EXISTS",
    3: "EXISTS_RESPONSE",
    4: "SEND_PULSE",
    5: "SEND_PULSE_RESPONSE",
    6: "GET_ALL_PULSE_FOR_PATH",
    7: "GET_ALL_PULSE_FOR_PATH_RESPONSE",
    8: "GET_ALL_NODES_FOR_PATH",
    9: "GET_ALL_NODES_FOR_PATH_RESPONSE",
    10: "GET_PULSE",
    11: "GET_PULSE_RESPONSE",
    12: "DELETE_PATH",
    13: "DELETE_PATH_RESPONSE",
    14: "DELETE_PULSE_ID",
    15: "DELETE_PULSE_ID_RESPONSE",
    16: "CONTROL_MESSAGE",
    17: "SASL_MESSAGE_TOKEN",
    18: "NOT_AUTHORIZED",
  }

  _NAMES_TO_VALUES = {
    "CREATE_PATH": 0,
    "CREATE_PATH_RESPONSE": 1,
    "EXISTS": 2,
    "EXISTS_RESPONSE": 3,
    "SEND_PULSE": 4,
    "SEND_PULSE_RESPONSE": 5,
    "GET_ALL_PULSE_FOR_PATH": 6,
    "GET_ALL_PULSE_FOR_PATH_RESPONSE": 7,
    "GET_ALL_NODES_FOR_PATH": 8,
    "GET_ALL_NODES_FOR_PATH_RESPONSE": 9,
    "GET_PULSE": 10,
    "GET_PULSE_RESPONSE": 11,
    "DELETE_PATH": 12,
    "DELETE_PATH_RESPONSE": 13,
    "DELETE_PULSE_ID": 14,
    "DELETE_PULSE_ID_RESPONSE": 15,
    "CONTROL_MESSAGE": 16,
    "SASL_MESSAGE_TOKEN": 17,
    "NOT_AUTHORIZED": 18,
  }


class JavaObjectArg:
  """
  Attributes:
   - int_arg
   - long_arg
   - string_arg
   - bool_arg
   - binary_arg
   - double_arg
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'int_arg', None, None, ), # 1
    (2, TType.I64, 'long_arg', None, None, ), # 2
    (3, TType.STRING, 'string_arg', None, None, ), # 3
    (4, TType.BOOL, 'bool_arg', None, None, ), # 4
    (5, TType.STRING, 'binary_arg', None, None, ), # 5
    (6, TType.DOUBLE, 'double_arg', None, None, ), # 6
  )

  def __init__(self, int_arg=None, long_arg=None, string_arg=None, bool_arg=None, binary_arg=None, double_arg=None,):
    self.int_arg = int_arg
    self.long_arg = long_arg
    self.string_arg = string_arg
    self.bool_arg = bool_arg
    self.binary_arg = binary_arg
    self.double_arg = double_arg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.int_arg = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.long_arg = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.string_arg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.bool_arg = iprot.readBool()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.binary_arg = iprot.readString()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.DOUBLE:
          self.double_arg = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('JavaObjectArg')
    if self.int_arg is not None:
      oprot.writeFieldBegin('int_arg', TType.I32, 1)
      oprot.writeI32(self.int_arg)
      oprot.writeFieldEnd()
    if self.long_arg is not None:
      oprot.writeFieldBegin('long_arg', TType.I64, 2)
      oprot.writeI64(self.long_arg)
      oprot.writeFieldEnd()
    if self.string_arg is not None:
      oprot.writeFieldBegin('string_arg', TType.STRING, 3)
      oprot.writeString(self.string_arg.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.bool_arg is not None:
      oprot.writeFieldBegin('bool_arg', TType.BOOL, 4)
      oprot.writeBool(self.bool_arg)
      oprot.writeFieldEnd()
    if self.binary_arg is not None:
      oprot.writeFieldBegin('binary_arg', TType.STRING, 5)
      oprot.writeString(self.binary_arg)
      oprot.writeFieldEnd()
    if self.double_arg is not None:
      oprot.writeFieldBegin('double_arg', TType.DOUBLE, 6)
      oprot.writeDouble(self.double_arg)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.int_arg)
    value = (value * 31) ^ hash(self.long_arg)
    value = (value * 31) ^ hash(self.string_arg)
    value = (value * 31) ^ hash(self.bool_arg)
    value = (value * 31) ^ hash(self.binary_arg)
    value = (value * 31) ^ hash(self.double_arg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class JavaObject:
  """
  Attributes:
   - full_class_name
   - args_list
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'full_class_name', None, None, ), # 1
    (2, TType.LIST, 'args_list', (TType.STRUCT,(JavaObjectArg, JavaObjectArg.thrift_spec)), None, ), # 2
  )

  def __init__(self, full_class_name=None, args_list=None,):
    self.full_class_name = full_class_name
    self.args_list = args_list

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.full_class_name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.args_list = []
          (_etype3, _size0) = iprot.readListBegin()
          for _i4 in xrange(_size0):
            _elem5 = JavaObjectArg()
            _elem5.read(iprot)
            self.args_list.append(_elem5)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('JavaObject')
    if self.full_class_name is not None:
      oprot.writeFieldBegin('full_class_name', TType.STRING, 1)
      oprot.writeString(self.full_class_name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.args_list is not None:
      oprot.writeFieldBegin('args_list', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.args_list))
      for iter6 in self.args_list:
        iter6.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.full_class_name is None:
      raise TProtocol.TProtocolException(message='Required field full_class_name is unset!')
    if self.args_list is None:
      raise TProtocol.TProtocolException(message='Required field args_list is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.full_class_name)
    value = (value * 31) ^ hash(self.args_list)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NullStruct:

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NullStruct')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class GlobalStreamId:
  """
  Attributes:
   - componentId
   - streamId
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'componentId', None, None, ), # 1
    (2, TType.STRING, 'streamId', None, None, ), # 2
  )

  def __init__(self, componentId=None, streamId=None,):
    self.componentId = componentId
    self.streamId = streamId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.componentId = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.streamId = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('GlobalStreamId')
    if self.componentId is not None:
      oprot.writeFieldBegin('componentId', TType.STRING, 1)
      oprot.writeString(self.componentId.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.streamId is not None:
      oprot.writeFieldBegin('streamId', TType.STRING, 2)
      oprot.writeString(self.streamId.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.componentId is None:
      raise TProtocol.TProtocolException(message='Required field componentId is unset!')
    if self.streamId is None:
      raise TProtocol.TProtocolException(message='Required field streamId is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.componentId)
    value = (value * 31) ^ hash(self.streamId)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Grouping:
  """
  Attributes:
   - fields
   - shuffle
   - all
   - none
   - direct
   - custom_object
   - custom_serialized
   - local_or_shuffle
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'fields', (TType.STRING,None), None, ), # 1
    (2, TType.STRUCT, 'shuffle', (NullStruct, NullStruct.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'all', (NullStruct, NullStruct.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'none', (NullStruct, NullStruct.thrift_spec), None, ), # 4
    (5, TType.STRUCT, 'direct', (NullStruct, NullStruct.thrift_spec), None, ), # 5
    (6, TType.STRUCT, 'custom_object', (JavaObject, JavaObject.thrift_spec), None, ), # 6
    (7, TType.STRING, 'custom_serialized', None, None, ), # 7
    (8, TType.STRUCT, 'local_or_shuffle', (NullStruct, NullStruct.thrift_spec), None, ), # 8
  )

  def __init__(self, fields=None, shuffle=None, all=None, none=None, direct=None, custom_object=None, custom_serialized=None, local_or_shuffle=None,):
    self.fields = fields
    self.shuffle = shuffle
    self.all = all
    self.none = none
    self.direct = direct
    self.custom_object = custom_object
    self.custom_serialized = custom_serialized
    self.local_or_shuffle = local_or_shuffle

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.fields = []
          (_etype10, _size7) = iprot.readListBegin()
          for _i11 in xrange(_size7):
            _elem12 = iprot.readString().decode('utf-8')
            self.fields.append(_elem12)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.shuffle = NullStruct()
          self.shuffle.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.all = NullStruct()
          self.all.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.none = NullStruct()
          self.none.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.direct = NullStruct()
          self.direct.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRUCT:
          self.custom_object = JavaObject()
          self.custom_object.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.custom_serialized = iprot.readString()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRUCT:
          self.local_or_shuffle = NullStruct()
          self.local_or_shuffle.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Grouping')
    if self.fields is not None:
      oprot.writeFieldBegin('fields', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.fields))
      for iter13 in self.fields:
        oprot.writeString(iter13.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.shuffle is not None:
      oprot.writeFieldBegin('shuffle', TType.STRUCT, 2)
      self.shuffle.write(oprot)
      oprot.writeFieldEnd()
    if self.all is not None:
      oprot.writeFieldBegin('all', TType.STRUCT, 3)
      self.all.write(oprot)
      oprot.writeFieldEnd()
    if self.none is not None:
      oprot.writeFieldBegin('none', TType.STRUCT, 4)
      self.none.write(oprot)
      oprot.writeFieldEnd()
    if self.direct is not None:
      oprot.writeFieldBegin('direct', TType.STRUCT, 5)
      self.direct.write(oprot)
      oprot.writeFieldEnd()
    if self.custom_object is not None:
      oprot.writeFieldBegin('custom_object', TType.STRUCT, 6)
      self.custom_object.write(oprot)
      oprot.writeFieldEnd()
    if self.custom_serialized is not None:
      oprot.writeFieldBegin('custom_serialized', TType.STRING, 7)
      oprot.writeString(self.custom_serialized)
      oprot.writeFieldEnd()
    if self.local_or_shuffle is not None:
      oprot.writeFieldBegin('local_or_shuffle', TType.STRUCT, 8)
      self.local_or_shuffle.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.fields)
    value = (value * 31) ^ hash(self.shuffle)
    value = (value * 31) ^ hash(self.all)
    value = (value * 31) ^ hash(self.none)
    value = (value * 31) ^ hash(self.direct)
    value = (value * 31) ^ hash(self.custom_object)
    value = (value * 31) ^ hash(self.custom_serialized)
    value = (value * 31) ^ hash(self.local_or_shuffle)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class StreamInfo:
  """
  Attributes:
   - output_fields
   - direct
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'output_fields', (TType.STRING,None), None, ), # 1
    (2, TType.BOOL, 'direct', None, None, ), # 2
  )

  def __init__(self, output_fields=None, direct=None,):
    self.output_fields = output_fields
    self.direct = direct

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.output_fields = []
          (_etype17, _size14) = iprot.readListBegin()
          for _i18 in xrange(_size14):
            _elem19 = iprot.readString().decode('utf-8')
            self.output_fields.append(_elem19)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.BOOL:
          self.direct = iprot.readBool()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StreamInfo')
    if self.output_fields is not None:
      oprot.writeFieldBegin('output_fields', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.output_fields))
      for iter20 in self.output_fields:
        oprot.writeString(iter20.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.direct is not None:
      oprot.writeFieldBegin('direct', TType.BOOL, 2)
      oprot.writeBool(self.direct)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.output_fields is None:
      raise TProtocol.TProtocolException(message='Required field output_fields is unset!')
    if self.direct is None:
      raise TProtocol.TProtocolException(message='Required field direct is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.output_fields)
    value = (value * 31) ^ hash(self.direct)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ShellComponent:
  """
  Attributes:
   - execution_command
   - script
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'execution_command', None, None, ), # 1
    (2, TType.STRING, 'script', None, None, ), # 2
  )

  def __init__(self, execution_command=None, script=None,):
    self.execution_command = execution_command
    self.script = script

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.execution_command = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.script = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ShellComponent')
    if self.execution_command is not None:
      oprot.writeFieldBegin('execution_command', TType.STRING, 1)
      oprot.writeString(self.execution_command.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.script is not None:
      oprot.writeFieldBegin('script', TType.STRING, 2)
      oprot.writeString(self.script.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.execution_command)
    value = (value * 31) ^ hash(self.script)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ComponentObject:
  """
  Attributes:
   - serialized_java
   - shell
   - java_object
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'serialized_java', None, None, ), # 1
    (2, TType.STRUCT, 'shell', (ShellComponent, ShellComponent.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'java_object', (JavaObject, JavaObject.thrift_spec), None, ), # 3
  )

  def __init__(self, serialized_java=None, shell=None, java_object=None,):
    self.serialized_java = serialized_java
    self.shell = shell
    self.java_object = java_object

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.serialized_java = iprot.readString()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.shell = ShellComponent()
          self.shell.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.java_object = JavaObject()
          self.java_object.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ComponentObject')
    if self.serialized_java is not None:
      oprot.writeFieldBegin('serialized_java', TType.STRING, 1)
      oprot.writeString(self.serialized_java)
      oprot.writeFieldEnd()
    if self.shell is not None:
      oprot.writeFieldBegin('shell', TType.STRUCT, 2)
      self.shell.write(oprot)
      oprot.writeFieldEnd()
    if self.java_object is not None:
      oprot.writeFieldBegin('java_object', TType.STRUCT, 3)
      self.java_object.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.serialized_java)
    value = (value * 31) ^ hash(self.shell)
    value = (value * 31) ^ hash(self.java_object)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ComponentCommon:
  """
  Attributes:
   - inputs
   - streams
   - parallelism_hint
   - json_conf
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'inputs', (TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.STRUCT,(Grouping, Grouping.thrift_spec)), None, ), # 1
    (2, TType.MAP, 'streams', (TType.STRING,None,TType.STRUCT,(StreamInfo, StreamInfo.thrift_spec)), None, ), # 2
    (3, TType.I32, 'parallelism_hint', None, None, ), # 3
    (4, TType.STRING, 'json_conf', None, None, ), # 4
  )

  def __init__(self, inputs=None, streams=None, parallelism_hint=None, json_conf=None,):
    self.inputs = inputs
    self.streams = streams
    self.parallelism_hint = parallelism_hint
    self.json_conf = json_conf

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.inputs = {}
          (_ktype22, _vtype23, _size21 ) = iprot.readMapBegin()
          for _i25 in xrange(_size21):
            _key26 = GlobalStreamId()
            _key26.read(iprot)
            _val27 = Grouping()
            _val27.read(iprot)
            self.inputs[_key26] = _val27
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.streams = {}
          (_ktype29, _vtype30, _size28 ) = iprot.readMapBegin()
          for _i32 in xrange(_size28):
            _key33 = iprot.readString().decode('utf-8')
            _val34 = StreamInfo()
            _val34.read(iprot)
            self.streams[_key33] = _val34
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.parallelism_hint = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.json_conf = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ComponentCommon')
    if self.inputs is not None:
      oprot.writeFieldBegin('inputs', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.inputs))
      for kiter35,viter36 in self.inputs.items():
        kiter35.write(oprot)
        viter36.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.streams is not None:
      oprot.writeFieldBegin('streams', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.streams))
      for kiter37,viter38 in self.streams.items():
        oprot.writeString(kiter37.encode('utf-8'))
        viter38.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.parallelism_hint is not None:
      oprot.writeFieldBegin('parallelism_hint', TType.I32, 3)
      oprot.writeI32(self.parallelism_hint)
      oprot.writeFieldEnd()
    if self.json_conf is not None:
      oprot.writeFieldBegin('json_conf', TType.STRING, 4)
      oprot.writeString(self.json_conf.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.inputs is None:
      raise TProtocol.TProtocolException(message='Required field inputs is unset!')
    if self.streams is None:
      raise TProtocol.TProtocolException(message='Required field streams is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.inputs)
    value = (value * 31) ^ hash(self.streams)
    value = (value * 31) ^ hash(self.parallelism_hint)
    value = (value * 31) ^ hash(self.json_conf)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SpoutSpec:
  """
  Attributes:
   - spout_object
   - common
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'spout_object', (ComponentObject, ComponentObject.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'common', (ComponentCommon, ComponentCommon.thrift_spec), None, ), # 2
  )

  def __init__(self, spout_object=None, common=None,):
    self.spout_object = spout_object
    self.common = common

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.spout_object = ComponentObject()
          self.spout_object.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.common = ComponentCommon()
          self.common.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SpoutSpec')
    if self.spout_object is not None:
      oprot.writeFieldBegin('spout_object', TType.STRUCT, 1)
      self.spout_object.write(oprot)
      oprot.writeFieldEnd()
    if self.common is not None:
      oprot.writeFieldBegin('common', TType.STRUCT, 2)
      self.common.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.spout_object is None:
      raise TProtocol.TProtocolException(message='Required field spout_object is unset!')
    if self.common is None:
      raise TProtocol.TProtocolException(message='Required field common is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.spout_object)
    value = (value * 31) ^ hash(self.common)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Bolt:
  """
  Attributes:
   - bolt_object
   - common
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'bolt_object', (ComponentObject, ComponentObject.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'common', (ComponentCommon, ComponentCommon.thrift_spec), None, ), # 2
  )

  def __init__(self, bolt_object=None, common=None,):
    self.bolt_object = bolt_object
    self.common = common

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.bolt_object = ComponentObject()
          self.bolt_object.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.common = ComponentCommon()
          self.common.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Bolt')
    if self.bolt_object is not None:
      oprot.writeFieldBegin('bolt_object', TType.STRUCT, 1)
      self.bolt_object.write(oprot)
      oprot.writeFieldEnd()
    if self.common is not None:
      oprot.writeFieldBegin('common', TType.STRUCT, 2)
      self.common.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.bolt_object is None:
      raise TProtocol.TProtocolException(message='Required field bolt_object is unset!')
    if self.common is None:
      raise TProtocol.TProtocolException(message='Required field common is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.bolt_object)
    value = (value * 31) ^ hash(self.common)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class StateSpoutSpec:
  """
  Attributes:
   - state_spout_object
   - common
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'state_spout_object', (ComponentObject, ComponentObject.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'common', (ComponentCommon, ComponentCommon.thrift_spec), None, ), # 2
  )

  def __init__(self, state_spout_object=None, common=None,):
    self.state_spout_object = state_spout_object
    self.common = common

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.state_spout_object = ComponentObject()
          self.state_spout_object.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.common = ComponentCommon()
          self.common.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StateSpoutSpec')
    if self.state_spout_object is not None:
      oprot.writeFieldBegin('state_spout_object', TType.STRUCT, 1)
      self.state_spout_object.write(oprot)
      oprot.writeFieldEnd()
    if self.common is not None:
      oprot.writeFieldBegin('common', TType.STRUCT, 2)
      self.common.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.state_spout_object is None:
      raise TProtocol.TProtocolException(message='Required field state_spout_object is unset!')
    if self.common is None:
      raise TProtocol.TProtocolException(message='Required field common is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.state_spout_object)
    value = (value * 31) ^ hash(self.common)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class StormTopology:
  """
  Attributes:
   - spouts
   - bolts
   - state_spouts
   - worker_hooks
   - dependency_jars
   - dependency_artifacts
   - storm_version
   - jdk_version
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'spouts', (TType.STRING,None,TType.STRUCT,(SpoutSpec, SpoutSpec.thrift_spec)), None, ), # 1
    (2, TType.MAP, 'bolts', (TType.STRING,None,TType.STRUCT,(Bolt, Bolt.thrift_spec)), None, ), # 2
    (3, TType.MAP, 'state_spouts', (TType.STRING,None,TType.STRUCT,(StateSpoutSpec, StateSpoutSpec.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'worker_hooks', (TType.STRING,None), None, ), # 4
    (5, TType.LIST, 'dependency_jars', (TType.STRING,None), None, ), # 5
    (6, TType.LIST, 'dependency_artifacts', (TType.STRING,None), None, ), # 6
    (7, TType.STRING, 'storm_version', None, None, ), # 7
    (8, TType.STRING, 'jdk_version', None, None, ), # 8
  )

  def __init__(self, spouts=None, bolts=None, state_spouts=None, worker_hooks=None, dependency_jars=None, dependency_artifacts=None, storm_version=None, jdk_version=None,):
    self.spouts = spouts
    self.bolts = bolts
    self.state_spouts = state_spouts
    self.worker_hooks = worker_hooks
    self.dependency_jars = dependency_jars
    self.dependency_artifacts = dependency_artifacts
    self.storm_version = storm_version
    self.jdk_version = jdk_version

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.spouts = {}
          (_ktype40, _vtype41, _size39 ) = iprot.readMapBegin()
          for _i43 in xrange(_size39):
            _key44 = iprot.readString().decode('utf-8')
            _val45 = SpoutSpec()
            _val45.read(iprot)
            self.spouts[_key44] = _val45
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.bolts = {}
          (_ktype47, _vtype48, _size46 ) = iprot.readMapBegin()
          for _i50 in xrange(_size46):
            _key51 = iprot.readString().decode('utf-8')
            _val52 = Bolt()
            _val52.read(iprot)
            self.bolts[_key51] = _val52
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.state_spouts = {}
          (_ktype54, _vtype55, _size53 ) = iprot.readMapBegin()
          for _i57 in xrange(_size53):
            _key58 = iprot.readString().decode('utf-8')
            _val59 = StateSpoutSpec()
            _val59.read(iprot)
            self.state_spouts[_key58] = _val59
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.worker_hooks = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = iprot.readString()
            self.worker_hooks.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.dependency_jars = []
          (_etype69, _size66) = iprot.readListBegin()
          for _i70 in xrange(_size66):
            _elem71 = iprot.readString().decode('utf-8')
            self.dependency_jars.append(_elem71)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.LIST:
          self.dependency_artifacts = []
          (_etype75, _size72) = iprot.readListBegin()
          for _i76 in xrange(_size72):
            _elem77 = iprot.readString().decode('utf-8')
            self.dependency_artifacts.append(_elem77)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.storm_version = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.jdk_version = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StormTopology')
    if self.spouts is not None:
      oprot.writeFieldBegin('spouts', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.spouts))
      for kiter78,viter79 in self.spouts.items():
        oprot.writeString(kiter78.encode('utf-8'))
        viter79.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.bolts is not None:
      oprot.writeFieldBegin('bolts', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.bolts))
      for kiter80,viter81 in self.bolts.items():
        oprot.writeString(kiter80.encode('utf-8'))
        viter81.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.state_spouts is not None:
      oprot.writeFieldBegin('state_spouts', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.state_spouts))
      for kiter82,viter83 in self.state_spouts.items():
        oprot.writeString(kiter82.encode('utf-8'))
        viter83.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.worker_hooks is not None:
      oprot.writeFieldBegin('worker_hooks', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.worker_hooks))
      for iter84 in self.worker_hooks:
        oprot.writeString(iter84)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.dependency_jars is not None:
      oprot.writeFieldBegin('dependency_jars', TType.LIST, 5)
      oprot.writeListBegin(TType.STRING, len(self.dependency_jars))
      for iter85 in self.dependency_jars:
        oprot.writeString(iter85.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.dependency_artifacts is not None:
      oprot.writeFieldBegin('dependency_artifacts', TType.LIST, 6)
      oprot.writeListBegin(TType.STRING, len(self.dependency_artifacts))
      for iter86 in self.dependency_artifacts:
        oprot.writeString(iter86.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.storm_version is not None:
      oprot.writeFieldBegin('storm_version', TType.STRING, 7)
      oprot.writeString(self.storm_version.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.jdk_version is not None:
      oprot.writeFieldBegin('jdk_version', TType.STRING, 8)
      oprot.writeString(self.jdk_version.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.spouts is None:
      raise TProtocol.TProtocolException(message='Required field spouts is unset!')
    if self.bolts is None:
      raise TProtocol.TProtocolException(message='Required field bolts is unset!')
    if self.state_spouts is None:
      raise TProtocol.TProtocolException(message='Required field state_spouts is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.spouts)
    value = (value * 31) ^ hash(self.bolts)
    value = (value * 31) ^ hash(self.state_spouts)
    value = (value * 31) ^ hash(self.worker_hooks)
    value = (value * 31) ^ hash(self.dependency_jars)
    value = (value * 31) ^ hash(self.dependency_artifacts)
    value = (value * 31) ^ hash(self.storm_version)
    value = (value * 31) ^ hash(self.jdk_version)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class AlreadyAliveException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('AlreadyAliveException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NotAliveException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NotAliveException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class AuthorizationException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('AuthorizationException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class InvalidTopologyException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('InvalidTopologyException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class KeyNotFoundException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('KeyNotFoundException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class KeyAlreadyExistsException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('KeyAlreadyExistsException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologySummary:
  """
  Attributes:
   - id
   - name
   - num_tasks
   - num_executors
   - num_workers
   - uptime_secs
   - status
   - sched_status
   - owner
   - replication_count
   - requested_memonheap
   - requested_memoffheap
   - requested_cpu
   - assigned_memonheap
   - assigned_memoffheap
   - assigned_cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'id', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.I32, 'num_tasks', None, None, ), # 3
    (4, TType.I32, 'num_executors', None, None, ), # 4
    (5, TType.I32, 'num_workers', None, None, ), # 5
    (6, TType.I32, 'uptime_secs', None, None, ), # 6
    (7, TType.STRING, 'status', None, None, ), # 7
    None, # 8
    None, # 9
    None, # 10
    None, # 11
    None, # 12
    None, # 13
    None, # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    None, # 50
    None, # 51
    None, # 52
    None, # 53
    None, # 54
    None, # 55
    None, # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    None, # 100
    None, # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    None, # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    None, # 200
    None, # 201
    None, # 202
    None, # 203
    None, # 204
    None, # 205
    None, # 206
    None, # 207
    None, # 208
    None, # 209
    None, # 210
    None, # 211
    None, # 212
    None, # 213
    None, # 214
    None, # 215
    None, # 216
    None, # 217
    None, # 218
    None, # 219
    None, # 220
    None, # 221
    None, # 222
    None, # 223
    None, # 224
    None, # 225
    None, # 226
    None, # 227
    None, # 228
    None, # 229
    None, # 230
    None, # 231
    None, # 232
    None, # 233
    None, # 234
    None, # 235
    None, # 236
    None, # 237
    None, # 238
    None, # 239
    None, # 240
    None, # 241
    None, # 242
    None, # 243
    None, # 244
    None, # 245
    None, # 246
    None, # 247
    None, # 248
    None, # 249
    None, # 250
    None, # 251
    None, # 252
    None, # 253
    None, # 254
    None, # 255
    None, # 256
    None, # 257
    None, # 258
    None, # 259
    None, # 260
    None, # 261
    None, # 262
    None, # 263
    None, # 264
    None, # 265
    None, # 266
    None, # 267
    None, # 268
    None, # 269
    None, # 270
    None, # 271
    None, # 272
    None, # 273
    None, # 274
    None, # 275
    None, # 276
    None, # 277
    None, # 278
    None, # 279
    None, # 280
    None, # 281
    None, # 282
    None, # 283
    None, # 284
    None, # 285
    None, # 286
    None, # 287
    None, # 288
    None, # 289
    None, # 290
    None, # 291
    None, # 292
    None, # 293
    None, # 294
    None, # 295
    None, # 296
    None, # 297
    None, # 298
    None, # 299
    None, # 300
    None, # 301
    None, # 302
    None, # 303
    None, # 304
    None, # 305
    None, # 306
    None, # 307
    None, # 308
    None, # 309
    None, # 310
    None, # 311
    None, # 312
    None, # 313
    None, # 314
    None, # 315
    None, # 316
    None, # 317
    None, # 318
    None, # 319
    None, # 320
    None, # 321
    None, # 322
    None, # 323
    None, # 324
    None, # 325
    None, # 326
    None, # 327
    None, # 328
    None, # 329
    None, # 330
    None, # 331
    None, # 332
    None, # 333
    None, # 334
    None, # 335
    None, # 336
    None, # 337
    None, # 338
    None, # 339
    None, # 340
    None, # 341
    None, # 342
    None, # 343
    None, # 344
    None, # 345
    None, # 346
    None, # 347
    None, # 348
    None, # 349
    None, # 350
    None, # 351
    None, # 352
    None, # 353
    None, # 354
    None, # 355
    None, # 356
    None, # 357
    None, # 358
    None, # 359
    None, # 360
    None, # 361
    None, # 362
    None, # 363
    None, # 364
    None, # 365
    None, # 366
    None, # 367
    None, # 368
    None, # 369
    None, # 370
    None, # 371
    None, # 372
    None, # 373
    None, # 374
    None, # 375
    None, # 376
    None, # 377
    None, # 378
    None, # 379
    None, # 380
    None, # 381
    None, # 382
    None, # 383
    None, # 384
    None, # 385
    None, # 386
    None, # 387
    None, # 388
    None, # 389
    None, # 390
    None, # 391
    None, # 392
    None, # 393
    None, # 394
    None, # 395
    None, # 396
    None, # 397
    None, # 398
    None, # 399
    None, # 400
    None, # 401
    None, # 402
    None, # 403
    None, # 404
    None, # 405
    None, # 406
    None, # 407
    None, # 408
    None, # 409
    None, # 410
    None, # 411
    None, # 412
    None, # 413
    None, # 414
    None, # 415
    None, # 416
    None, # 417
    None, # 418
    None, # 419
    None, # 420
    None, # 421
    None, # 422
    None, # 423
    None, # 424
    None, # 425
    None, # 426
    None, # 427
    None, # 428
    None, # 429
    None, # 430
    None, # 431
    None, # 432
    None, # 433
    None, # 434
    None, # 435
    None, # 436
    None, # 437
    None, # 438
    None, # 439
    None, # 440
    None, # 441
    None, # 442
    None, # 443
    None, # 444
    None, # 445
    None, # 446
    None, # 447
    None, # 448
    None, # 449
    None, # 450
    None, # 451
    None, # 452
    None, # 453
    None, # 454
    None, # 455
    None, # 456
    None, # 457
    None, # 458
    None, # 459
    None, # 460
    None, # 461
    None, # 462
    None, # 463
    None, # 464
    None, # 465
    None, # 466
    None, # 467
    None, # 468
    None, # 469
    None, # 470
    None, # 471
    None, # 472
    None, # 473
    None, # 474
    None, # 475
    None, # 476
    None, # 477
    None, # 478
    None, # 479
    None, # 480
    None, # 481
    None, # 482
    None, # 483
    None, # 484
    None, # 485
    None, # 486
    None, # 487
    None, # 488
    None, # 489
    None, # 490
    None, # 491
    None, # 492
    None, # 493
    None, # 494
    None, # 495
    None, # 496
    None, # 497
    None, # 498
    None, # 499
    None, # 500
    None, # 501
    None, # 502
    None, # 503
    None, # 504
    None, # 505
    None, # 506
    None, # 507
    None, # 508
    None, # 509
    None, # 510
    None, # 511
    None, # 512
    (513, TType.STRING, 'sched_status', None, None, ), # 513
    (514, TType.STRING, 'owner', None, None, ), # 514
    (515, TType.I32, 'replication_count', None, None, ), # 515
    None, # 516
    None, # 517
    None, # 518
    None, # 519
    None, # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ), # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ), # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ), # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ), # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ), # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ), # 526
  )

  def __init__(self, id=None, name=None, num_tasks=None, num_executors=None, num_workers=None, uptime_secs=None, status=None, sched_status=None, owner=None, replication_count=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None,):
    self.id = id
    self.name = name
    self.num_tasks = num_tasks
    self.num_executors = num_executors
    self.num_workers = num_workers
    self.uptime_secs = uptime_secs
    self.status = status
    self.sched_status = sched_status
    self.owner = owner
    self.replication_count = replication_count
    self.requested_memonheap = requested_memonheap
    self.requested_memoffheap = requested_memoffheap
    self.requested_cpu = requested_cpu
    self.assigned_memonheap = assigned_memonheap
    self.assigned_memoffheap = assigned_memoffheap
    self.assigned_cpu = assigned_cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.num_tasks = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.num_executors = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.num_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 513:
        if ftype == TType.STRING:
          self.sched_status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 514:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 515:
        if ftype == TType.I32:
          self.replication_count = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 521:
        if ftype == TType.DOUBLE:
          self.requested_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 522:
        if ftype == TType.DOUBLE:
          self.requested_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 523:
        if ftype == TType.DOUBLE:
          self.requested_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 524:
        if ftype == TType.DOUBLE:
          self.assigned_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 525:
        if ftype == TType.DOUBLE:
          self.assigned_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 526:
        if ftype == TType.DOUBLE:
          self.assigned_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologySummary')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.STRING, 1)
      oprot.writeString(self.id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.num_tasks is not None:
      oprot.writeFieldBegin('num_tasks', TType.I32, 3)
      oprot.writeI32(self.num_tasks)
      oprot.writeFieldEnd()
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.I32, 4)
      oprot.writeI32(self.num_executors)
      oprot.writeFieldEnd()
    if self.num_workers is not None:
      oprot.writeFieldBegin('num_workers', TType.I32, 5)
      oprot.writeI32(self.num_workers)
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 6)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.status is not None:
      oprot.writeFieldBegin('status', TType.STRING, 7)
      oprot.writeString(self.status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.sched_status is not None:
      oprot.writeFieldBegin('sched_status', TType.STRING, 513)
      oprot.writeString(self.sched_status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 514)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.replication_count is not None:
      oprot.writeFieldBegin('replication_count', TType.I32, 515)
      oprot.writeI32(self.replication_count)
      oprot.writeFieldEnd()
    if self.requested_memonheap is not None:
      oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
      oprot.writeDouble(self.requested_memonheap)
      oprot.writeFieldEnd()
    if self.requested_memoffheap is not None:
      oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
      oprot.writeDouble(self.requested_memoffheap)
      oprot.writeFieldEnd()
    if self.requested_cpu is not None:
      oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
      oprot.writeDouble(self.requested_cpu)
      oprot.writeFieldEnd()
    if self.assigned_memonheap is not None:
      oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
      oprot.writeDouble(self.assigned_memonheap)
      oprot.writeFieldEnd()
    if self.assigned_memoffheap is not None:
      oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
      oprot.writeDouble(self.assigned_memoffheap)
      oprot.writeFieldEnd()
    if self.assigned_cpu is not None:
      oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
      oprot.writeDouble(self.assigned_cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.id is None:
      raise TProtocol.TProtocolException(message='Required field id is unset!')
    if self.name is None:
      raise TProtocol.TProtocolException(message='Required field name is unset!')
    if self.num_tasks is None:
      raise TProtocol.TProtocolException(message='Required field num_tasks is unset!')
    if self.num_executors is None:
      raise TProtocol.TProtocolException(message='Required field num_executors is unset!')
    if self.num_workers is None:
      raise TProtocol.TProtocolException(message='Required field num_workers is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    if self.status is None:
      raise TProtocol.TProtocolException(message='Required field status is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.id)
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.num_tasks)
    value = (value * 31) ^ hash(self.num_executors)
    value = (value * 31) ^ hash(self.num_workers)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.status)
    value = (value * 31) ^ hash(self.sched_status)
    value = (value * 31) ^ hash(self.owner)
    value = (value * 31) ^ hash(self.replication_count)
    value = (value * 31) ^ hash(self.requested_memonheap)
    value = (value * 31) ^ hash(self.requested_memoffheap)
    value = (value * 31) ^ hash(self.requested_cpu)
    value = (value * 31) ^ hash(self.assigned_memonheap)
    value = (value * 31) ^ hash(self.assigned_memoffheap)
    value = (value * 31) ^ hash(self.assigned_cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SupervisorSummary:
  """
  Attributes:
   - host
   - uptime_secs
   - num_workers
   - num_used_workers
   - supervisor_id
   - version
   - total_resources
   - used_mem
   - used_cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'host', None, None, ), # 1
    (2, TType.I32, 'uptime_secs', None, None, ), # 2
    (3, TType.I32, 'num_workers', None, None, ), # 3
    (4, TType.I32, 'num_used_workers', None, None, ), # 4
    (5, TType.STRING, 'supervisor_id', None, None, ), # 5
    (6, TType.STRING, 'version', None, "VERSION_NOT_PROVIDED", ), # 6
    (7, TType.MAP, 'total_resources', (TType.STRING,None,TType.DOUBLE,None), None, ), # 7
    (8, TType.DOUBLE, 'used_mem', None, None, ), # 8
    (9, TType.DOUBLE, 'used_cpu', None, None, ), # 9
  )

  def __init__(self, host=None, uptime_secs=None, num_workers=None, num_used_workers=None, supervisor_id=None, version=thrift_spec[6][4], total_resources=None, used_mem=None, used_cpu=None,):
    self.host = host
    self.uptime_secs = uptime_secs
    self.num_workers = num_workers
    self.num_used_workers = num_used_workers
    self.supervisor_id = supervisor_id
    self.version = version
    self.total_resources = total_resources
    self.used_mem = used_mem
    self.used_cpu = used_cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.num_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.num_used_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.supervisor_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.version = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.total_resources = {}
          (_ktype88, _vtype89, _size87 ) = iprot.readMapBegin()
          for _i91 in xrange(_size87):
            _key92 = iprot.readString().decode('utf-8')
            _val93 = iprot.readDouble()
            self.total_resources[_key92] = _val93
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.DOUBLE:
          self.used_mem = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.DOUBLE:
          self.used_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SupervisorSummary')
    if self.host is not None:
      oprot.writeFieldBegin('host', TType.STRING, 1)
      oprot.writeString(self.host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 2)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.num_workers is not None:
      oprot.writeFieldBegin('num_workers', TType.I32, 3)
      oprot.writeI32(self.num_workers)
      oprot.writeFieldEnd()
    if self.num_used_workers is not None:
      oprot.writeFieldBegin('num_used_workers', TType.I32, 4)
      oprot.writeI32(self.num_used_workers)
      oprot.writeFieldEnd()
    if self.supervisor_id is not None:
      oprot.writeFieldBegin('supervisor_id', TType.STRING, 5)
      oprot.writeString(self.supervisor_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.STRING, 6)
      oprot.writeString(self.version.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.total_resources is not None:
      oprot.writeFieldBegin('total_resources', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.total_resources))
      for kiter94,viter95 in self.total_resources.items():
        oprot.writeString(kiter94.encode('utf-8'))
        oprot.writeDouble(viter95)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.used_mem is not None:
      oprot.writeFieldBegin('used_mem', TType.DOUBLE, 8)
      oprot.writeDouble(self.used_mem)
      oprot.writeFieldEnd()
    if self.used_cpu is not None:
      oprot.writeFieldBegin('used_cpu', TType.DOUBLE, 9)
      oprot.writeDouble(self.used_cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.host is None:
      raise TProtocol.TProtocolException(message='Required field host is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    if self.num_workers is None:
      raise TProtocol.TProtocolException(message='Required field num_workers is unset!')
    if self.num_used_workers is None:
      raise TProtocol.TProtocolException(message='Required field num_used_workers is unset!')
    if self.supervisor_id is None:
      raise TProtocol.TProtocolException(message='Required field supervisor_id is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.host)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.num_workers)
    value = (value * 31) ^ hash(self.num_used_workers)
    value = (value * 31) ^ hash(self.supervisor_id)
    value = (value * 31) ^ hash(self.version)
    value = (value * 31) ^ hash(self.total_resources)
    value = (value * 31) ^ hash(self.used_mem)
    value = (value * 31) ^ hash(self.used_cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NimbusSummary:
  """
  Attributes:
   - host
   - port
   - uptime_secs
   - isLeader
   - version
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'host', None, None, ), # 1
    (2, TType.I32, 'port', None, None, ), # 2
    (3, TType.I32, 'uptime_secs', None, None, ), # 3
    (4, TType.BOOL, 'isLeader', None, None, ), # 4
    (5, TType.STRING, 'version', None, None, ), # 5
  )

  def __init__(self, host=None, port=None, uptime_secs=None, isLeader=None, version=None,):
    self.host = host
    self.port = port
    self.uptime_secs = uptime_secs
    self.isLeader = isLeader
    self.version = version

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.port = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.isLeader = iprot.readBool()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.version = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NimbusSummary')
    if self.host is not None:
      oprot.writeFieldBegin('host', TType.STRING, 1)
      oprot.writeString(self.host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.I32, 2)
      oprot.writeI32(self.port)
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.isLeader is not None:
      oprot.writeFieldBegin('isLeader', TType.BOOL, 4)
      oprot.writeBool(self.isLeader)
      oprot.writeFieldEnd()
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.STRING, 5)
      oprot.writeString(self.version.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.host is None:
      raise TProtocol.TProtocolException(message='Required field host is unset!')
    if self.port is None:
      raise TProtocol.TProtocolException(message='Required field port is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    if self.isLeader is None:
      raise TProtocol.TProtocolException(message='Required field isLeader is unset!')
    if self.version is None:
      raise TProtocol.TProtocolException(message='Required field version is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.host)
    value = (value * 31) ^ hash(self.port)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.isLeader)
    value = (value * 31) ^ hash(self.version)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ClusterSummary:
  """
  Attributes:
   - supervisors
   - nimbus_uptime_secs
   - topologies
   - nimbuses
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'supervisors', (TType.STRUCT,(SupervisorSummary, SupervisorSummary.thrift_spec)), None, ), # 1
    (2, TType.I32, 'nimbus_uptime_secs', None, 0, ), # 2
    (3, TType.LIST, 'topologies', (TType.STRUCT,(TopologySummary, TopologySummary.thrift_spec)), None, ), # 3
    (4, TType.LIST, 'nimbuses', (TType.STRUCT,(NimbusSummary, NimbusSummary.thrift_spec)), None, ), # 4
  )

  def __init__(self, supervisors=None, nimbus_uptime_secs=thrift_spec[2][4], topologies=None, nimbuses=None,):
    self.supervisors = supervisors
    self.nimbus_uptime_secs = nimbus_uptime_secs
    self.topologies = topologies
    self.nimbuses = nimbuses

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.supervisors = []
          (_etype99, _size96) = iprot.readListBegin()
          for _i100 in xrange(_size96):
            _elem101 = SupervisorSummary()
            _elem101.read(iprot)
            self.supervisors.append(_elem101)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.nimbus_uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.topologies = []
          (_etype105, _size102) = iprot.readListBegin()
          for _i106 in xrange(_size102):
            _elem107 = TopologySummary()
            _elem107.read(iprot)
            self.topologies.append(_elem107)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.nimbuses = []
          (_etype111, _size108) = iprot.readListBegin()
          for _i112 in xrange(_size108):
            _elem113 = NimbusSummary()
            _elem113.read(iprot)
            self.nimbuses.append(_elem113)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ClusterSummary')
    if self.supervisors is not None:
      oprot.writeFieldBegin('supervisors', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.supervisors))
      for iter114 in self.supervisors:
        iter114.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.nimbus_uptime_secs is not None:
      oprot.writeFieldBegin('nimbus_uptime_secs', TType.I32, 2)
      oprot.writeI32(self.nimbus_uptime_secs)
      oprot.writeFieldEnd()
    if self.topologies is not None:
      oprot.writeFieldBegin('topologies', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.topologies))
      for iter115 in self.topologies:
        iter115.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.nimbuses is not None:
      oprot.writeFieldBegin('nimbuses', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.nimbuses))
      for iter116 in self.nimbuses:
        iter116.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.supervisors is None:
      raise TProtocol.TProtocolException(message='Required field supervisors is unset!')
    if self.topologies is None:
      raise TProtocol.TProtocolException(message='Required field topologies is unset!')
    if self.nimbuses is None:
      raise TProtocol.TProtocolException(message='Required field nimbuses is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.supervisors)
    value = (value * 31) ^ hash(self.nimbus_uptime_secs)
    value = (value * 31) ^ hash(self.topologies)
    value = (value * 31) ^ hash(self.nimbuses)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ErrorInfo:
  """
  Attributes:
   - error
   - error_time_secs
   - host
   - port
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'error', None, None, ), # 1
    (2, TType.I32, 'error_time_secs', None, None, ), # 2
    (3, TType.STRING, 'host', None, None, ), # 3
    (4, TType.I32, 'port', None, None, ), # 4
  )

  def __init__(self, error=None, error_time_secs=None, host=None, port=None,):
    self.error = error
    self.error_time_secs = error_time_secs
    self.host = host
    self.port = port

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.error = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.error_time_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.port = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ErrorInfo')
    if self.error is not None:
      oprot.writeFieldBegin('error', TType.STRING, 1)
      oprot.writeString(self.error.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.error_time_secs is not None:
      oprot.writeFieldBegin('error_time_secs', TType.I32, 2)
      oprot.writeI32(self.error_time_secs)
      oprot.writeFieldEnd()
    if self.host is not None:
      oprot.writeFieldBegin('host', TType.STRING, 3)
      oprot.writeString(self.host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.I32, 4)
      oprot.writeI32(self.port)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.error is None:
      raise TProtocol.TProtocolException(message='Required field error is unset!')
    if self.error_time_secs is None:
      raise TProtocol.TProtocolException(message='Required field error_time_secs is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.error)
    value = (value * 31) ^ hash(self.error_time_secs)
    value = (value * 31) ^ hash(self.host)
    value = (value * 31) ^ hash(self.port)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class BoltStats:
  """
  Attributes:
   - acked
   - failed
   - process_ms_avg
   - executed
   - execute_ms_avg
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'acked', (TType.STRING,None,TType.MAP,(TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.I64,None)), None, ), # 1
    (2, TType.MAP, 'failed', (TType.STRING,None,TType.MAP,(TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.I64,None)), None, ), # 2
    (3, TType.MAP, 'process_ms_avg', (TType.STRING,None,TType.MAP,(TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.DOUBLE,None)), None, ), # 3
    (4, TType.MAP, 'executed', (TType.STRING,None,TType.MAP,(TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.I64,None)), None, ), # 4
    (5, TType.MAP, 'execute_ms_avg', (TType.STRING,None,TType.MAP,(TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.DOUBLE,None)), None, ), # 5
  )

  def __init__(self, acked=None, failed=None, process_ms_avg=None, executed=None, execute_ms_avg=None,):
    self.acked = acked
    self.failed = failed
    self.process_ms_avg = process_ms_avg
    self.executed = executed
    self.execute_ms_avg = execute_ms_avg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.acked = {}
          (_ktype118, _vtype119, _size117 ) = iprot.readMapBegin()
          for _i121 in xrange(_size117):
            _key122 = iprot.readString().decode('utf-8')
            _val123 = {}
            (_ktype125, _vtype126, _size124 ) = iprot.readMapBegin()
            for _i128 in xrange(_size124):
              _key129 = GlobalStreamId()
              _key129.read(iprot)
              _val130 = iprot.readI64()
              _val123[_key129] = _val130
            iprot.readMapEnd()
            self.acked[_key122] = _val123
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.failed = {}
          (_ktype132, _vtype133, _size131 ) = iprot.readMapBegin()
          for _i135 in xrange(_size131):
            _key136 = iprot.readString().decode('utf-8')
            _val137 = {}
            (_ktype139, _vtype140, _size138 ) = iprot.readMapBegin()
            for _i142 in xrange(_size138):
              _key143 = GlobalStreamId()
              _key143.read(iprot)
              _val144 = iprot.readI64()
              _val137[_key143] = _val144
            iprot.readMapEnd()
            self.failed[_key136] = _val137
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.process_ms_avg = {}
          (_ktype146, _vtype147, _size145 ) = iprot.readMapBegin()
          for _i149 in xrange(_size145):
            _key150 = iprot.readString().decode('utf-8')
            _val151 = {}
            (_ktype153, _vtype154, _size152 ) = iprot.readMapBegin()
            for _i156 in xrange(_size152):
              _key157 = GlobalStreamId()
              _key157.read(iprot)
              _val158 = iprot.readDouble()
              _val151[_key157] = _val158
            iprot.readMapEnd()
            self.process_ms_avg[_key150] = _val151
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.executed = {}
          (_ktype160, _vtype161, _size159 ) = iprot.readMapBegin()
          for _i163 in xrange(_size159):
            _key164 = iprot.readString().decode('utf-8')
            _val165 = {}
            (_ktype167, _vtype168, _size166 ) = iprot.readMapBegin()
            for _i170 in xrange(_size166):
              _key171 = GlobalStreamId()
              _key171.read(iprot)
              _val172 = iprot.readI64()
              _val165[_key171] = _val172
            iprot.readMapEnd()
            self.executed[_key164] = _val165
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.execute_ms_avg = {}
          (_ktype174, _vtype175, _size173 ) = iprot.readMapBegin()
          for _i177 in xrange(_size173):
            _key178 = iprot.readString().decode('utf-8')
            _val179 = {}
            (_ktype181, _vtype182, _size180 ) = iprot.readMapBegin()
            for _i184 in xrange(_size180):
              _key185 = GlobalStreamId()
              _key185.read(iprot)
              _val186 = iprot.readDouble()
              _val179[_key185] = _val186
            iprot.readMapEnd()
            self.execute_ms_avg[_key178] = _val179
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('BoltStats')
    if self.acked is not None:
      oprot.writeFieldBegin('acked', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.acked))
      for kiter187,viter188 in self.acked.items():
        oprot.writeString(kiter187.encode('utf-8'))
        oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter188))
        for kiter189,viter190 in viter188.items():
          kiter189.write(oprot)
          oprot.writeI64(viter190)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.failed is not None:
      oprot.writeFieldBegin('failed', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.failed))
      for kiter191,viter192 in self.failed.items():
        oprot.writeString(kiter191.encode('utf-8'))
        oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter192))
        for kiter193,viter194 in viter192.items():
          kiter193.write(oprot)
          oprot.writeI64(viter194)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.process_ms_avg is not None:
      oprot.writeFieldBegin('process_ms_avg', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.process_ms_avg))
      for kiter195,viter196 in self.process_ms_avg.items():
        oprot.writeString(kiter195.encode('utf-8'))
        oprot.writeMapBegin(TType.STRUCT, TType.DOUBLE, len(viter196))
        for kiter197,viter198 in viter196.items():
          kiter197.write(oprot)
          oprot.writeDouble(viter198)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.executed is not None:
      oprot.writeFieldBegin('executed', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.executed))
      for kiter199,viter200 in self.executed.items():
        oprot.writeString(kiter199.encode('utf-8'))
        oprot.writeMapBegin(TType.STRUCT, TType.I64, len(viter200))
        for kiter201,viter202 in viter200.items():
          kiter201.write(oprot)
          oprot.writeI64(viter202)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.execute_ms_avg is not None:
      oprot.writeFieldBegin('execute_ms_avg', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.execute_ms_avg))
      for kiter203,viter204 in self.execute_ms_avg.items():
        oprot.writeString(kiter203.encode('utf-8'))
        oprot.writeMapBegin(TType.STRUCT, TType.DOUBLE, len(viter204))
        for kiter205,viter206 in viter204.items():
          kiter205.write(oprot)
          oprot.writeDouble(viter206)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.acked is None:
      raise TProtocol.TProtocolException(message='Required field acked is unset!')
    if self.failed is None:
      raise TProtocol.TProtocolException(message='Required field failed is unset!')
    if self.process_ms_avg is None:
      raise TProtocol.TProtocolException(message='Required field process_ms_avg is unset!')
    if self.executed is None:
      raise TProtocol.TProtocolException(message='Required field executed is unset!')
    if self.execute_ms_avg is None:
      raise TProtocol.TProtocolException(message='Required field execute_ms_avg is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.acked)
    value = (value * 31) ^ hash(self.failed)
    value = (value * 31) ^ hash(self.process_ms_avg)
    value = (value * 31) ^ hash(self.executed)
    value = (value * 31) ^ hash(self.execute_ms_avg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SpoutStats:
  """
  Attributes:
   - acked
   - failed
   - complete_ms_avg
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'acked', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.I64,None)), None, ), # 1
    (2, TType.MAP, 'failed', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.I64,None)), None, ), # 2
    (3, TType.MAP, 'complete_ms_avg', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.DOUBLE,None)), None, ), # 3
  )

  def __init__(self, acked=None, failed=None, complete_ms_avg=None,):
    self.acked = acked
    self.failed = failed
    self.complete_ms_avg = complete_ms_avg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.acked = {}
          (_ktype208, _vtype209, _size207 ) = iprot.readMapBegin()
          for _i211 in xrange(_size207):
            _key212 = iprot.readString().decode('utf-8')
            _val213 = {}
            (_ktype215, _vtype216, _size214 ) = iprot.readMapBegin()
            for _i218 in xrange(_size214):
              _key219 = iprot.readString().decode('utf-8')
              _val220 = iprot.readI64()
              _val213[_key219] = _val220
            iprot.readMapEnd()
            self.acked[_key212] = _val213
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.failed = {}
          (_ktype222, _vtype223, _size221 ) = iprot.readMapBegin()
          for _i225 in xrange(_size221):
            _key226 = iprot.readString().decode('utf-8')
            _val227 = {}
            (_ktype229, _vtype230, _size228 ) = iprot.readMapBegin()
            for _i232 in xrange(_size228):
              _key233 = iprot.readString().decode('utf-8')
              _val234 = iprot.readI64()
              _val227[_key233] = _val234
            iprot.readMapEnd()
            self.failed[_key226] = _val227
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.complete_ms_avg = {}
          (_ktype236, _vtype237, _size235 ) = iprot.readMapBegin()
          for _i239 in xrange(_size235):
            _key240 = iprot.readString().decode('utf-8')
            _val241 = {}
            (_ktype243, _vtype244, _size242 ) = iprot.readMapBegin()
            for _i246 in xrange(_size242):
              _key247 = iprot.readString().decode('utf-8')
              _val248 = iprot.readDouble()
              _val241[_key247] = _val248
            iprot.readMapEnd()
            self.complete_ms_avg[_key240] = _val241
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SpoutStats')
    if self.acked is not None:
      oprot.writeFieldBegin('acked', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.acked))
      for kiter249,viter250 in self.acked.items():
        oprot.writeString(kiter249.encode('utf-8'))
        oprot.writeMapBegin(TType.STRING, TType.I64, len(viter250))
        for kiter251,viter252 in viter250.items():
          oprot.writeString(kiter251.encode('utf-8'))
          oprot.writeI64(viter252)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.failed is not None:
      oprot.writeFieldBegin('failed', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.failed))
      for kiter253,viter254 in self.failed.items():
        oprot.writeString(kiter253.encode('utf-8'))
        oprot.writeMapBegin(TType.STRING, TType.I64, len(viter254))
        for kiter255,viter256 in viter254.items():
          oprot.writeString(kiter255.encode('utf-8'))
          oprot.writeI64(viter256)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.complete_ms_avg is not None:
      oprot.writeFieldBegin('complete_ms_avg', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.complete_ms_avg))
      for kiter257,viter258 in self.complete_ms_avg.items():
        oprot.writeString(kiter257.encode('utf-8'))
        oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(viter258))
        for kiter259,viter260 in viter258.items():
          oprot.writeString(kiter259.encode('utf-8'))
          oprot.writeDouble(viter260)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.acked is None:
      raise TProtocol.TProtocolException(message='Required field acked is unset!')
    if self.failed is None:
      raise TProtocol.TProtocolException(message='Required field failed is unset!')
    if self.complete_ms_avg is None:
      raise TProtocol.TProtocolException(message='Required field complete_ms_avg is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.acked)
    value = (value * 31) ^ hash(self.failed)
    value = (value * 31) ^ hash(self.complete_ms_avg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ExecutorSpecificStats:
  """
  Attributes:
   - bolt
   - spout
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'bolt', (BoltStats, BoltStats.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'spout', (SpoutStats, SpoutStats.thrift_spec), None, ), # 2
  )

  def __init__(self, bolt=None, spout=None,):
    self.bolt = bolt
    self.spout = spout

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.bolt = BoltStats()
          self.bolt.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.spout = SpoutStats()
          self.spout.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ExecutorSpecificStats')
    if self.bolt is not None:
      oprot.writeFieldBegin('bolt', TType.STRUCT, 1)
      self.bolt.write(oprot)
      oprot.writeFieldEnd()
    if self.spout is not None:
      oprot.writeFieldBegin('spout', TType.STRUCT, 2)
      self.spout.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.bolt)
    value = (value * 31) ^ hash(self.spout)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ExecutorStats:
  """
  Attributes:
   - emitted
   - transferred
   - specific
   - rate
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'emitted', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.I64,None)), None, ), # 1
    (2, TType.MAP, 'transferred', (TType.STRING,None,TType.MAP,(TType.STRING,None,TType.I64,None)), None, ), # 2
    (3, TType.STRUCT, 'specific', (ExecutorSpecificStats, ExecutorSpecificStats.thrift_spec), None, ), # 3
    (4, TType.DOUBLE, 'rate', None, None, ), # 4
  )

  def __init__(self, emitted=None, transferred=None, specific=None, rate=None,):
    self.emitted = emitted
    self.transferred = transferred
    self.specific = specific
    self.rate = rate

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.emitted = {}
          (_ktype262, _vtype263, _size261 ) = iprot.readMapBegin()
          for _i265 in xrange(_size261):
            _key266 = iprot.readString().decode('utf-8')
            _val267 = {}
            (_ktype269, _vtype270, _size268 ) = iprot.readMapBegin()
            for _i272 in xrange(_size268):
              _key273 = iprot.readString().decode('utf-8')
              _val274 = iprot.readI64()
              _val267[_key273] = _val274
            iprot.readMapEnd()
            self.emitted[_key266] = _val267
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.transferred = {}
          (_ktype276, _vtype277, _size275 ) = iprot.readMapBegin()
          for _i279 in xrange(_size275):
            _key280 = iprot.readString().decode('utf-8')
            _val281 = {}
            (_ktype283, _vtype284, _size282 ) = iprot.readMapBegin()
            for _i286 in xrange(_size282):
              _key287 = iprot.readString().decode('utf-8')
              _val288 = iprot.readI64()
              _val281[_key287] = _val288
            iprot.readMapEnd()
            self.transferred[_key280] = _val281
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.specific = ExecutorSpecificStats()
          self.specific.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.DOUBLE:
          self.rate = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ExecutorStats')
    if self.emitted is not None:
      oprot.writeFieldBegin('emitted', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.emitted))
      for kiter289,viter290 in self.emitted.items():
        oprot.writeString(kiter289.encode('utf-8'))
        oprot.writeMapBegin(TType.STRING, TType.I64, len(viter290))
        for kiter291,viter292 in viter290.items():
          oprot.writeString(kiter291.encode('utf-8'))
          oprot.writeI64(viter292)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.transferred is not None:
      oprot.writeFieldBegin('transferred', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.MAP, len(self.transferred))
      for kiter293,viter294 in self.transferred.items():
        oprot.writeString(kiter293.encode('utf-8'))
        oprot.writeMapBegin(TType.STRING, TType.I64, len(viter294))
        for kiter295,viter296 in viter294.items():
          oprot.writeString(kiter295.encode('utf-8'))
          oprot.writeI64(viter296)
        oprot.writeMapEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.specific is not None:
      oprot.writeFieldBegin('specific', TType.STRUCT, 3)
      self.specific.write(oprot)
      oprot.writeFieldEnd()
    if self.rate is not None:
      oprot.writeFieldBegin('rate', TType.DOUBLE, 4)
      oprot.writeDouble(self.rate)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.emitted is None:
      raise TProtocol.TProtocolException(message='Required field emitted is unset!')
    if self.transferred is None:
      raise TProtocol.TProtocolException(message='Required field transferred is unset!')
    if self.specific is None:
      raise TProtocol.TProtocolException(message='Required field specific is unset!')
    if self.rate is None:
      raise TProtocol.TProtocolException(message='Required field rate is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.emitted)
    value = (value * 31) ^ hash(self.transferred)
    value = (value * 31) ^ hash(self.specific)
    value = (value * 31) ^ hash(self.rate)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ExecutorInfo:
  """
  Attributes:
   - task_start
   - task_end
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'task_start', None, None, ), # 1
    (2, TType.I32, 'task_end', None, None, ), # 2
  )

  def __init__(self, task_start=None, task_end=None,):
    self.task_start = task_start
    self.task_end = task_end

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.task_start = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.task_end = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ExecutorInfo')
    if self.task_start is not None:
      oprot.writeFieldBegin('task_start', TType.I32, 1)
      oprot.writeI32(self.task_start)
      oprot.writeFieldEnd()
    if self.task_end is not None:
      oprot.writeFieldBegin('task_end', TType.I32, 2)
      oprot.writeI32(self.task_end)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.task_start is None:
      raise TProtocol.TProtocolException(message='Required field task_start is unset!')
    if self.task_end is None:
      raise TProtocol.TProtocolException(message='Required field task_end is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.task_start)
    value = (value * 31) ^ hash(self.task_end)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ExecutorSummary:
  """
  Attributes:
   - executor_info
   - component_id
   - host
   - port
   - uptime_secs
   - stats
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'executor_info', (ExecutorInfo, ExecutorInfo.thrift_spec), None, ), # 1
    (2, TType.STRING, 'component_id', None, None, ), # 2
    (3, TType.STRING, 'host', None, None, ), # 3
    (4, TType.I32, 'port', None, None, ), # 4
    (5, TType.I32, 'uptime_secs', None, None, ), # 5
    None, # 6
    (7, TType.STRUCT, 'stats', (ExecutorStats, ExecutorStats.thrift_spec), None, ), # 7
  )

  def __init__(self, executor_info=None, component_id=None, host=None, port=None, uptime_secs=None, stats=None,):
    self.executor_info = executor_info
    self.component_id = component_id
    self.host = host
    self.port = port
    self.uptime_secs = uptime_secs
    self.stats = stats

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.executor_info = ExecutorInfo()
          self.executor_info.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.component_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.port = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRUCT:
          self.stats = ExecutorStats()
          self.stats.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ExecutorSummary')
    if self.executor_info is not None:
      oprot.writeFieldBegin('executor_info', TType.STRUCT, 1)
      self.executor_info.write(oprot)
      oprot.writeFieldEnd()
    if self.component_id is not None:
      oprot.writeFieldBegin('component_id', TType.STRING, 2)
      oprot.writeString(self.component_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.host is not None:
      oprot.writeFieldBegin('host', TType.STRING, 3)
      oprot.writeString(self.host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.I32, 4)
      oprot.writeI32(self.port)
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 5)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.stats is not None:
      oprot.writeFieldBegin('stats', TType.STRUCT, 7)
      self.stats.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.executor_info is None:
      raise TProtocol.TProtocolException(message='Required field executor_info is unset!')
    if self.component_id is None:
      raise TProtocol.TProtocolException(message='Required field component_id is unset!')
    if self.host is None:
      raise TProtocol.TProtocolException(message='Required field host is unset!')
    if self.port is None:
      raise TProtocol.TProtocolException(message='Required field port is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.executor_info)
    value = (value * 31) ^ hash(self.component_id)
    value = (value * 31) ^ hash(self.host)
    value = (value * 31) ^ hash(self.port)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.stats)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class DebugOptions:
  """
  Attributes:
   - enable
   - samplingpct
  """

  thrift_spec = (
    None, # 0
    (1, TType.BOOL, 'enable', None, None, ), # 1
    (2, TType.DOUBLE, 'samplingpct', None, None, ), # 2
  )

  def __init__(self, enable=None, samplingpct=None,):
    self.enable = enable
    self.samplingpct = samplingpct

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.BOOL:
          self.enable = iprot.readBool()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.DOUBLE:
          self.samplingpct = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('DebugOptions')
    if self.enable is not None:
      oprot.writeFieldBegin('enable', TType.BOOL, 1)
      oprot.writeBool(self.enable)
      oprot.writeFieldEnd()
    if self.samplingpct is not None:
      oprot.writeFieldBegin('samplingpct', TType.DOUBLE, 2)
      oprot.writeDouble(self.samplingpct)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.enable)
    value = (value * 31) ^ hash(self.samplingpct)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologyInfo:
  """
  Attributes:
   - id
   - name
   - uptime_secs
   - executors
   - status
   - errors
   - component_debug
   - sched_status
   - owner
   - replication_count
   - requested_memonheap
   - requested_memoffheap
   - requested_cpu
   - assigned_memonheap
   - assigned_memoffheap
   - assigned_cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'id', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.I32, 'uptime_secs', None, None, ), # 3
    (4, TType.LIST, 'executors', (TType.STRUCT,(ExecutorSummary, ExecutorSummary.thrift_spec)), None, ), # 4
    (5, TType.STRING, 'status', None, None, ), # 5
    (6, TType.MAP, 'errors', (TType.STRING,None,TType.LIST,(TType.STRUCT,(ErrorInfo, ErrorInfo.thrift_spec))), None, ), # 6
    (7, TType.MAP, 'component_debug', (TType.STRING,None,TType.STRUCT,(DebugOptions, DebugOptions.thrift_spec)), None, ), # 7
    None, # 8
    None, # 9
    None, # 10
    None, # 11
    None, # 12
    None, # 13
    None, # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    None, # 50
    None, # 51
    None, # 52
    None, # 53
    None, # 54
    None, # 55
    None, # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    None, # 100
    None, # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    None, # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    None, # 200
    None, # 201
    None, # 202
    None, # 203
    None, # 204
    None, # 205
    None, # 206
    None, # 207
    None, # 208
    None, # 209
    None, # 210
    None, # 211
    None, # 212
    None, # 213
    None, # 214
    None, # 215
    None, # 216
    None, # 217
    None, # 218
    None, # 219
    None, # 220
    None, # 221
    None, # 222
    None, # 223
    None, # 224
    None, # 225
    None, # 226
    None, # 227
    None, # 228
    None, # 229
    None, # 230
    None, # 231
    None, # 232
    None, # 233
    None, # 234
    None, # 235
    None, # 236
    None, # 237
    None, # 238
    None, # 239
    None, # 240
    None, # 241
    None, # 242
    None, # 243
    None, # 244
    None, # 245
    None, # 246
    None, # 247
    None, # 248
    None, # 249
    None, # 250
    None, # 251
    None, # 252
    None, # 253
    None, # 254
    None, # 255
    None, # 256
    None, # 257
    None, # 258
    None, # 259
    None, # 260
    None, # 261
    None, # 262
    None, # 263
    None, # 264
    None, # 265
    None, # 266
    None, # 267
    None, # 268
    None, # 269
    None, # 270
    None, # 271
    None, # 272
    None, # 273
    None, # 274
    None, # 275
    None, # 276
    None, # 277
    None, # 278
    None, # 279
    None, # 280
    None, # 281
    None, # 282
    None, # 283
    None, # 284
    None, # 285
    None, # 286
    None, # 287
    None, # 288
    None, # 289
    None, # 290
    None, # 291
    None, # 292
    None, # 293
    None, # 294
    None, # 295
    None, # 296
    None, # 297
    None, # 298
    None, # 299
    None, # 300
    None, # 301
    None, # 302
    None, # 303
    None, # 304
    None, # 305
    None, # 306
    None, # 307
    None, # 308
    None, # 309
    None, # 310
    None, # 311
    None, # 312
    None, # 313
    None, # 314
    None, # 315
    None, # 316
    None, # 317
    None, # 318
    None, # 319
    None, # 320
    None, # 321
    None, # 322
    None, # 323
    None, # 324
    None, # 325
    None, # 326
    None, # 327
    None, # 328
    None, # 329
    None, # 330
    None, # 331
    None, # 332
    None, # 333
    None, # 334
    None, # 335
    None, # 336
    None, # 337
    None, # 338
    None, # 339
    None, # 340
    None, # 341
    None, # 342
    None, # 343
    None, # 344
    None, # 345
    None, # 346
    None, # 347
    None, # 348
    None, # 349
    None, # 350
    None, # 351
    None, # 352
    None, # 353
    None, # 354
    None, # 355
    None, # 356
    None, # 357
    None, # 358
    None, # 359
    None, # 360
    None, # 361
    None, # 362
    None, # 363
    None, # 364
    None, # 365
    None, # 366
    None, # 367
    None, # 368
    None, # 369
    None, # 370
    None, # 371
    None, # 372
    None, # 373
    None, # 374
    None, # 375
    None, # 376
    None, # 377
    None, # 378
    None, # 379
    None, # 380
    None, # 381
    None, # 382
    None, # 383
    None, # 384
    None, # 385
    None, # 386
    None, # 387
    None, # 388
    None, # 389
    None, # 390
    None, # 391
    None, # 392
    None, # 393
    None, # 394
    None, # 395
    None, # 396
    None, # 397
    None, # 398
    None, # 399
    None, # 400
    None, # 401
    None, # 402
    None, # 403
    None, # 404
    None, # 405
    None, # 406
    None, # 407
    None, # 408
    None, # 409
    None, # 410
    None, # 411
    None, # 412
    None, # 413
    None, # 414
    None, # 415
    None, # 416
    None, # 417
    None, # 418
    None, # 419
    None, # 420
    None, # 421
    None, # 422
    None, # 423
    None, # 424
    None, # 425
    None, # 426
    None, # 427
    None, # 428
    None, # 429
    None, # 430
    None, # 431
    None, # 432
    None, # 433
    None, # 434
    None, # 435
    None, # 436
    None, # 437
    None, # 438
    None, # 439
    None, # 440
    None, # 441
    None, # 442
    None, # 443
    None, # 444
    None, # 445
    None, # 446
    None, # 447
    None, # 448
    None, # 449
    None, # 450
    None, # 451
    None, # 452
    None, # 453
    None, # 454
    None, # 455
    None, # 456
    None, # 457
    None, # 458
    None, # 459
    None, # 460
    None, # 461
    None, # 462
    None, # 463
    None, # 464
    None, # 465
    None, # 466
    None, # 467
    None, # 468
    None, # 469
    None, # 470
    None, # 471
    None, # 472
    None, # 473
    None, # 474
    None, # 475
    None, # 476
    None, # 477
    None, # 478
    None, # 479
    None, # 480
    None, # 481
    None, # 482
    None, # 483
    None, # 484
    None, # 485
    None, # 486
    None, # 487
    None, # 488
    None, # 489
    None, # 490
    None, # 491
    None, # 492
    None, # 493
    None, # 494
    None, # 495
    None, # 496
    None, # 497
    None, # 498
    None, # 499
    None, # 500
    None, # 501
    None, # 502
    None, # 503
    None, # 504
    None, # 505
    None, # 506
    None, # 507
    None, # 508
    None, # 509
    None, # 510
    None, # 511
    None, # 512
    (513, TType.STRING, 'sched_status', None, None, ), # 513
    (514, TType.STRING, 'owner', None, None, ), # 514
    (515, TType.I32, 'replication_count', None, None, ), # 515
    None, # 516
    None, # 517
    None, # 518
    None, # 519
    None, # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ), # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ), # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ), # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ), # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ), # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ), # 526
  )

  def __init__(self, id=None, name=None, uptime_secs=None, executors=None, status=None, errors=None, component_debug=None, sched_status=None, owner=None, replication_count=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None,):
    self.id = id
    self.name = name
    self.uptime_secs = uptime_secs
    self.executors = executors
    self.status = status
    self.errors = errors
    self.component_debug = component_debug
    self.sched_status = sched_status
    self.owner = owner
    self.replication_count = replication_count
    self.requested_memonheap = requested_memonheap
    self.requested_memoffheap = requested_memoffheap
    self.requested_cpu = requested_cpu
    self.assigned_memonheap = assigned_memonheap
    self.assigned_memoffheap = assigned_memoffheap
    self.assigned_cpu = assigned_cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.executors = []
          (_etype300, _size297) = iprot.readListBegin()
          for _i301 in xrange(_size297):
            _elem302 = ExecutorSummary()
            _elem302.read(iprot)
            self.executors.append(_elem302)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.errors = {}
          (_ktype304, _vtype305, _size303 ) = iprot.readMapBegin()
          for _i307 in xrange(_size303):
            _key308 = iprot.readString().decode('utf-8')
            _val309 = []
            (_etype313, _size310) = iprot.readListBegin()
            for _i314 in xrange(_size310):
              _elem315 = ErrorInfo()
              _elem315.read(iprot)
              _val309.append(_elem315)
            iprot.readListEnd()
            self.errors[_key308] = _val309
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.component_debug = {}
          (_ktype317, _vtype318, _size316 ) = iprot.readMapBegin()
          for _i320 in xrange(_size316):
            _key321 = iprot.readString().decode('utf-8')
            _val322 = DebugOptions()
            _val322.read(iprot)
            self.component_debug[_key321] = _val322
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 513:
        if ftype == TType.STRING:
          self.sched_status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 514:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 515:
        if ftype == TType.I32:
          self.replication_count = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 521:
        if ftype == TType.DOUBLE:
          self.requested_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 522:
        if ftype == TType.DOUBLE:
          self.requested_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 523:
        if ftype == TType.DOUBLE:
          self.requested_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 524:
        if ftype == TType.DOUBLE:
          self.assigned_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 525:
        if ftype == TType.DOUBLE:
          self.assigned_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 526:
        if ftype == TType.DOUBLE:
          self.assigned_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologyInfo')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.STRING, 1)
      oprot.writeString(self.id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.executors is not None:
      oprot.writeFieldBegin('executors', TType.LIST, 4)
      oprot.writeListBegin(TType.STRUCT, len(self.executors))
      for iter323 in self.executors:
        iter323.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.status is not None:
      oprot.writeFieldBegin('status', TType.STRING, 5)
      oprot.writeString(self.status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.errors is not None:
      oprot.writeFieldBegin('errors', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.errors))
      for kiter324,viter325 in self.errors.items():
        oprot.writeString(kiter324.encode('utf-8'))
        oprot.writeListBegin(TType.STRUCT, len(viter325))
        for iter326 in viter325:
          iter326.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.component_debug is not None:
      oprot.writeFieldBegin('component_debug', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.component_debug))
      for kiter327,viter328 in self.component_debug.items():
        oprot.writeString(kiter327.encode('utf-8'))
        viter328.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sched_status is not None:
      oprot.writeFieldBegin('sched_status', TType.STRING, 513)
      oprot.writeString(self.sched_status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 514)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.replication_count is not None:
      oprot.writeFieldBegin('replication_count', TType.I32, 515)
      oprot.writeI32(self.replication_count)
      oprot.writeFieldEnd()
    if self.requested_memonheap is not None:
      oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
      oprot.writeDouble(self.requested_memonheap)
      oprot.writeFieldEnd()
    if self.requested_memoffheap is not None:
      oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
      oprot.writeDouble(self.requested_memoffheap)
      oprot.writeFieldEnd()
    if self.requested_cpu is not None:
      oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
      oprot.writeDouble(self.requested_cpu)
      oprot.writeFieldEnd()
    if self.assigned_memonheap is not None:
      oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
      oprot.writeDouble(self.assigned_memonheap)
      oprot.writeFieldEnd()
    if self.assigned_memoffheap is not None:
      oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
      oprot.writeDouble(self.assigned_memoffheap)
      oprot.writeFieldEnd()
    if self.assigned_cpu is not None:
      oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
      oprot.writeDouble(self.assigned_cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.id is None:
      raise TProtocol.TProtocolException(message='Required field id is unset!')
    if self.name is None:
      raise TProtocol.TProtocolException(message='Required field name is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    if self.executors is None:
      raise TProtocol.TProtocolException(message='Required field executors is unset!')
    if self.status is None:
      raise TProtocol.TProtocolException(message='Required field status is unset!')
    if self.errors is None:
      raise TProtocol.TProtocolException(message='Required field errors is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.id)
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.executors)
    value = (value * 31) ^ hash(self.status)
    value = (value * 31) ^ hash(self.errors)
    value = (value * 31) ^ hash(self.component_debug)
    value = (value * 31) ^ hash(self.sched_status)
    value = (value * 31) ^ hash(self.owner)
    value = (value * 31) ^ hash(self.replication_count)
    value = (value * 31) ^ hash(self.requested_memonheap)
    value = (value * 31) ^ hash(self.requested_memoffheap)
    value = (value * 31) ^ hash(self.requested_cpu)
    value = (value * 31) ^ hash(self.assigned_memonheap)
    value = (value * 31) ^ hash(self.assigned_memoffheap)
    value = (value * 31) ^ hash(self.assigned_cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class CommonAggregateStats:
  """
  Attributes:
   - num_executors
   - num_tasks
   - emitted
   - transferred
   - acked
   - failed
   - resources_map
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'num_executors', None, None, ), # 1
    (2, TType.I32, 'num_tasks', None, None, ), # 2
    (3, TType.I64, 'emitted', None, None, ), # 3
    (4, TType.I64, 'transferred', None, None, ), # 4
    (5, TType.I64, 'acked', None, None, ), # 5
    (6, TType.I64, 'failed', None, None, ), # 6
    (7, TType.MAP, 'resources_map', (TType.STRING,None,TType.DOUBLE,None), None, ), # 7
  )

  def __init__(self, num_executors=None, num_tasks=None, emitted=None, transferred=None, acked=None, failed=None, resources_map=None,):
    self.num_executors = num_executors
    self.num_tasks = num_tasks
    self.emitted = emitted
    self.transferred = transferred
    self.acked = acked
    self.failed = failed
    self.resources_map = resources_map

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.num_executors = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.num_tasks = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.emitted = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.transferred = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.acked = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I64:
          self.failed = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.resources_map = {}
          (_ktype330, _vtype331, _size329 ) = iprot.readMapBegin()
          for _i333 in xrange(_size329):
            _key334 = iprot.readString().decode('utf-8')
            _val335 = iprot.readDouble()
            self.resources_map[_key334] = _val335
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('CommonAggregateStats')
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.I32, 1)
      oprot.writeI32(self.num_executors)
      oprot.writeFieldEnd()
    if self.num_tasks is not None:
      oprot.writeFieldBegin('num_tasks', TType.I32, 2)
      oprot.writeI32(self.num_tasks)
      oprot.writeFieldEnd()
    if self.emitted is not None:
      oprot.writeFieldBegin('emitted', TType.I64, 3)
      oprot.writeI64(self.emitted)
      oprot.writeFieldEnd()
    if self.transferred is not None:
      oprot.writeFieldBegin('transferred', TType.I64, 4)
      oprot.writeI64(self.transferred)
      oprot.writeFieldEnd()
    if self.acked is not None:
      oprot.writeFieldBegin('acked', TType.I64, 5)
      oprot.writeI64(self.acked)
      oprot.writeFieldEnd()
    if self.failed is not None:
      oprot.writeFieldBegin('failed', TType.I64, 6)
      oprot.writeI64(self.failed)
      oprot.writeFieldEnd()
    if self.resources_map is not None:
      oprot.writeFieldBegin('resources_map', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
      for kiter336,viter337 in self.resources_map.items():
        oprot.writeString(kiter336.encode('utf-8'))
        oprot.writeDouble(viter337)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.num_executors)
    value = (value * 31) ^ hash(self.num_tasks)
    value = (value * 31) ^ hash(self.emitted)
    value = (value * 31) ^ hash(self.transferred)
    value = (value * 31) ^ hash(self.acked)
    value = (value * 31) ^ hash(self.failed)
    value = (value * 31) ^ hash(self.resources_map)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SpoutAggregateStats:
  """
  Attributes:
   - complete_latency_ms
  """

  thrift_spec = (
    None, # 0
    (1, TType.DOUBLE, 'complete_latency_ms', None, None, ), # 1
  )

  def __init__(self, complete_latency_ms=None,):
    self.complete_latency_ms = complete_latency_ms

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.DOUBLE:
          self.complete_latency_ms = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SpoutAggregateStats')
    if self.complete_latency_ms is not None:
      oprot.writeFieldBegin('complete_latency_ms', TType.DOUBLE, 1)
      oprot.writeDouble(self.complete_latency_ms)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.complete_latency_ms)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class BoltAggregateStats:
  """
  Attributes:
   - execute_latency_ms
   - process_latency_ms
   - executed
   - capacity
  """

  thrift_spec = (
    None, # 0
    (1, TType.DOUBLE, 'execute_latency_ms', None, None, ), # 1
    (2, TType.DOUBLE, 'process_latency_ms', None, None, ), # 2
    (3, TType.I64, 'executed', None, None, ), # 3
    (4, TType.DOUBLE, 'capacity', None, None, ), # 4
  )

  def __init__(self, execute_latency_ms=None, process_latency_ms=None, executed=None, capacity=None,):
    self.execute_latency_ms = execute_latency_ms
    self.process_latency_ms = process_latency_ms
    self.executed = executed
    self.capacity = capacity

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.DOUBLE:
          self.execute_latency_ms = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.DOUBLE:
          self.process_latency_ms = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.executed = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.DOUBLE:
          self.capacity = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('BoltAggregateStats')
    if self.execute_latency_ms is not None:
      oprot.writeFieldBegin('execute_latency_ms', TType.DOUBLE, 1)
      oprot.writeDouble(self.execute_latency_ms)
      oprot.writeFieldEnd()
    if self.process_latency_ms is not None:
      oprot.writeFieldBegin('process_latency_ms', TType.DOUBLE, 2)
      oprot.writeDouble(self.process_latency_ms)
      oprot.writeFieldEnd()
    if self.executed is not None:
      oprot.writeFieldBegin('executed', TType.I64, 3)
      oprot.writeI64(self.executed)
      oprot.writeFieldEnd()
    if self.capacity is not None:
      oprot.writeFieldBegin('capacity', TType.DOUBLE, 4)
      oprot.writeDouble(self.capacity)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.execute_latency_ms)
    value = (value * 31) ^ hash(self.process_latency_ms)
    value = (value * 31) ^ hash(self.executed)
    value = (value * 31) ^ hash(self.capacity)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SpecificAggregateStats:
  """
  Attributes:
   - bolt
   - spout
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'bolt', (BoltAggregateStats, BoltAggregateStats.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'spout', (SpoutAggregateStats, SpoutAggregateStats.thrift_spec), None, ), # 2
  )

  def __init__(self, bolt=None, spout=None,):
    self.bolt = bolt
    self.spout = spout

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.bolt = BoltAggregateStats()
          self.bolt.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.spout = SpoutAggregateStats()
          self.spout.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SpecificAggregateStats')
    if self.bolt is not None:
      oprot.writeFieldBegin('bolt', TType.STRUCT, 1)
      self.bolt.write(oprot)
      oprot.writeFieldEnd()
    if self.spout is not None:
      oprot.writeFieldBegin('spout', TType.STRUCT, 2)
      self.spout.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.bolt)
    value = (value * 31) ^ hash(self.spout)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ComponentAggregateStats:
  """
  Attributes:
   - type
   - common_stats
   - specific_stats
   - last_error
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'type', None, None, ), # 1
    (2, TType.STRUCT, 'common_stats', (CommonAggregateStats, CommonAggregateStats.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'specific_stats', (SpecificAggregateStats, SpecificAggregateStats.thrift_spec), None, ), # 3
    (4, TType.STRUCT, 'last_error', (ErrorInfo, ErrorInfo.thrift_spec), None, ), # 4
  )

  def __init__(self, type=None, common_stats=None, specific_stats=None, last_error=None,):
    self.type = type
    self.common_stats = common_stats
    self.specific_stats = specific_stats
    self.last_error = last_error

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.type = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.common_stats = CommonAggregateStats()
          self.common_stats.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.specific_stats = SpecificAggregateStats()
          self.specific_stats.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.last_error = ErrorInfo()
          self.last_error.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ComponentAggregateStats')
    if self.type is not None:
      oprot.writeFieldBegin('type', TType.I32, 1)
      oprot.writeI32(self.type)
      oprot.writeFieldEnd()
    if self.common_stats is not None:
      oprot.writeFieldBegin('common_stats', TType.STRUCT, 2)
      self.common_stats.write(oprot)
      oprot.writeFieldEnd()
    if self.specific_stats is not None:
      oprot.writeFieldBegin('specific_stats', TType.STRUCT, 3)
      self.specific_stats.write(oprot)
      oprot.writeFieldEnd()
    if self.last_error is not None:
      oprot.writeFieldBegin('last_error', TType.STRUCT, 4)
      self.last_error.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.type)
    value = (value * 31) ^ hash(self.common_stats)
    value = (value * 31) ^ hash(self.specific_stats)
    value = (value * 31) ^ hash(self.last_error)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologyStats:
  """
  Attributes:
   - window_to_emitted
   - window_to_transferred
   - window_to_complete_latencies_ms
   - window_to_acked
   - window_to_failed
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'window_to_emitted', (TType.STRING,None,TType.I64,None), None, ), # 1
    (2, TType.MAP, 'window_to_transferred', (TType.STRING,None,TType.I64,None), None, ), # 2
    (3, TType.MAP, 'window_to_complete_latencies_ms', (TType.STRING,None,TType.DOUBLE,None), None, ), # 3
    (4, TType.MAP, 'window_to_acked', (TType.STRING,None,TType.I64,None), None, ), # 4
    (5, TType.MAP, 'window_to_failed', (TType.STRING,None,TType.I64,None), None, ), # 5
  )

  def __init__(self, window_to_emitted=None, window_to_transferred=None, window_to_complete_latencies_ms=None, window_to_acked=None, window_to_failed=None,):
    self.window_to_emitted = window_to_emitted
    self.window_to_transferred = window_to_transferred
    self.window_to_complete_latencies_ms = window_to_complete_latencies_ms
    self.window_to_acked = window_to_acked
    self.window_to_failed = window_to_failed

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.window_to_emitted = {}
          (_ktype339, _vtype340, _size338 ) = iprot.readMapBegin()
          for _i342 in xrange(_size338):
            _key343 = iprot.readString().decode('utf-8')
            _val344 = iprot.readI64()
            self.window_to_emitted[_key343] = _val344
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.window_to_transferred = {}
          (_ktype346, _vtype347, _size345 ) = iprot.readMapBegin()
          for _i349 in xrange(_size345):
            _key350 = iprot.readString().decode('utf-8')
            _val351 = iprot.readI64()
            self.window_to_transferred[_key350] = _val351
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.window_to_complete_latencies_ms = {}
          (_ktype353, _vtype354, _size352 ) = iprot.readMapBegin()
          for _i356 in xrange(_size352):
            _key357 = iprot.readString().decode('utf-8')
            _val358 = iprot.readDouble()
            self.window_to_complete_latencies_ms[_key357] = _val358
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.window_to_acked = {}
          (_ktype360, _vtype361, _size359 ) = iprot.readMapBegin()
          for _i363 in xrange(_size359):
            _key364 = iprot.readString().decode('utf-8')
            _val365 = iprot.readI64()
            self.window_to_acked[_key364] = _val365
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.window_to_failed = {}
          (_ktype367, _vtype368, _size366 ) = iprot.readMapBegin()
          for _i370 in xrange(_size366):
            _key371 = iprot.readString().decode('utf-8')
            _val372 = iprot.readI64()
            self.window_to_failed[_key371] = _val372
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologyStats')
    if self.window_to_emitted is not None:
      oprot.writeFieldBegin('window_to_emitted', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_emitted))
      for kiter373,viter374 in self.window_to_emitted.items():
        oprot.writeString(kiter373.encode('utf-8'))
        oprot.writeI64(viter374)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.window_to_transferred is not None:
      oprot.writeFieldBegin('window_to_transferred', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_transferred))
      for kiter375,viter376 in self.window_to_transferred.items():
        oprot.writeString(kiter375.encode('utf-8'))
        oprot.writeI64(viter376)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.window_to_complete_latencies_ms is not None:
      oprot.writeFieldBegin('window_to_complete_latencies_ms', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.window_to_complete_latencies_ms))
      for kiter377,viter378 in self.window_to_complete_latencies_ms.items():
        oprot.writeString(kiter377.encode('utf-8'))
        oprot.writeDouble(viter378)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.window_to_acked is not None:
      oprot.writeFieldBegin('window_to_acked', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_acked))
      for kiter379,viter380 in self.window_to_acked.items():
        oprot.writeString(kiter379.encode('utf-8'))
        oprot.writeI64(viter380)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.window_to_failed is not None:
      oprot.writeFieldBegin('window_to_failed', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.I64, len(self.window_to_failed))
      for kiter381,viter382 in self.window_to_failed.items():
        oprot.writeString(kiter381.encode('utf-8'))
        oprot.writeI64(viter382)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.window_to_emitted)
    value = (value * 31) ^ hash(self.window_to_transferred)
    value = (value * 31) ^ hash(self.window_to_complete_latencies_ms)
    value = (value * 31) ^ hash(self.window_to_acked)
    value = (value * 31) ^ hash(self.window_to_failed)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class WorkerSummary:
  """
  Attributes:
   - supervisor_id
   - host
   - port
   - topology_id
   - topology_name
   - num_executors
   - component_to_num_tasks
   - time_secs
   - uptime_secs
   - requested_memonheap
   - requested_memoffheap
   - requested_cpu
   - assigned_memonheap
   - assigned_memoffheap
   - assigned_cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'supervisor_id', None, None, ), # 1
    (2, TType.STRING, 'host', None, None, ), # 2
    (3, TType.I32, 'port', None, None, ), # 3
    (4, TType.STRING, 'topology_id', None, None, ), # 4
    (5, TType.STRING, 'topology_name', None, None, ), # 5
    (6, TType.I32, 'num_executors', None, None, ), # 6
    (7, TType.MAP, 'component_to_num_tasks', (TType.STRING,None,TType.I64,None), None, ), # 7
    (8, TType.I32, 'time_secs', None, None, ), # 8
    (9, TType.I32, 'uptime_secs', None, None, ), # 9
    None, # 10
    None, # 11
    None, # 12
    None, # 13
    None, # 14
    None, # 15
    None, # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    None, # 50
    None, # 51
    None, # 52
    None, # 53
    None, # 54
    None, # 55
    None, # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    None, # 100
    None, # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    None, # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    None, # 200
    None, # 201
    None, # 202
    None, # 203
    None, # 204
    None, # 205
    None, # 206
    None, # 207
    None, # 208
    None, # 209
    None, # 210
    None, # 211
    None, # 212
    None, # 213
    None, # 214
    None, # 215
    None, # 216
    None, # 217
    None, # 218
    None, # 219
    None, # 220
    None, # 221
    None, # 222
    None, # 223
    None, # 224
    None, # 225
    None, # 226
    None, # 227
    None, # 228
    None, # 229
    None, # 230
    None, # 231
    None, # 232
    None, # 233
    None, # 234
    None, # 235
    None, # 236
    None, # 237
    None, # 238
    None, # 239
    None, # 240
    None, # 241
    None, # 242
    None, # 243
    None, # 244
    None, # 245
    None, # 246
    None, # 247
    None, # 248
    None, # 249
    None, # 250
    None, # 251
    None, # 252
    None, # 253
    None, # 254
    None, # 255
    None, # 256
    None, # 257
    None, # 258
    None, # 259
    None, # 260
    None, # 261
    None, # 262
    None, # 263
    None, # 264
    None, # 265
    None, # 266
    None, # 267
    None, # 268
    None, # 269
    None, # 270
    None, # 271
    None, # 272
    None, # 273
    None, # 274
    None, # 275
    None, # 276
    None, # 277
    None, # 278
    None, # 279
    None, # 280
    None, # 281
    None, # 282
    None, # 283
    None, # 284
    None, # 285
    None, # 286
    None, # 287
    None, # 288
    None, # 289
    None, # 290
    None, # 291
    None, # 292
    None, # 293
    None, # 294
    None, # 295
    None, # 296
    None, # 297
    None, # 298
    None, # 299
    None, # 300
    None, # 301
    None, # 302
    None, # 303
    None, # 304
    None, # 305
    None, # 306
    None, # 307
    None, # 308
    None, # 309
    None, # 310
    None, # 311
    None, # 312
    None, # 313
    None, # 314
    None, # 315
    None, # 316
    None, # 317
    None, # 318
    None, # 319
    None, # 320
    None, # 321
    None, # 322
    None, # 323
    None, # 324
    None, # 325
    None, # 326
    None, # 327
    None, # 328
    None, # 329
    None, # 330
    None, # 331
    None, # 332
    None, # 333
    None, # 334
    None, # 335
    None, # 336
    None, # 337
    None, # 338
    None, # 339
    None, # 340
    None, # 341
    None, # 342
    None, # 343
    None, # 344
    None, # 345
    None, # 346
    None, # 347
    None, # 348
    None, # 349
    None, # 350
    None, # 351
    None, # 352
    None, # 353
    None, # 354
    None, # 355
    None, # 356
    None, # 357
    None, # 358
    None, # 359
    None, # 360
    None, # 361
    None, # 362
    None, # 363
    None, # 364
    None, # 365
    None, # 366
    None, # 367
    None, # 368
    None, # 369
    None, # 370
    None, # 371
    None, # 372
    None, # 373
    None, # 374
    None, # 375
    None, # 376
    None, # 377
    None, # 378
    None, # 379
    None, # 380
    None, # 381
    None, # 382
    None, # 383
    None, # 384
    None, # 385
    None, # 386
    None, # 387
    None, # 388
    None, # 389
    None, # 390
    None, # 391
    None, # 392
    None, # 393
    None, # 394
    None, # 395
    None, # 396
    None, # 397
    None, # 398
    None, # 399
    None, # 400
    None, # 401
    None, # 402
    None, # 403
    None, # 404
    None, # 405
    None, # 406
    None, # 407
    None, # 408
    None, # 409
    None, # 410
    None, # 411
    None, # 412
    None, # 413
    None, # 414
    None, # 415
    None, # 416
    None, # 417
    None, # 418
    None, # 419
    None, # 420
    None, # 421
    None, # 422
    None, # 423
    None, # 424
    None, # 425
    None, # 426
    None, # 427
    None, # 428
    None, # 429
    None, # 430
    None, # 431
    None, # 432
    None, # 433
    None, # 434
    None, # 435
    None, # 436
    None, # 437
    None, # 438
    None, # 439
    None, # 440
    None, # 441
    None, # 442
    None, # 443
    None, # 444
    None, # 445
    None, # 446
    None, # 447
    None, # 448
    None, # 449
    None, # 450
    None, # 451
    None, # 452
    None, # 453
    None, # 454
    None, # 455
    None, # 456
    None, # 457
    None, # 458
    None, # 459
    None, # 460
    None, # 461
    None, # 462
    None, # 463
    None, # 464
    None, # 465
    None, # 466
    None, # 467
    None, # 468
    None, # 469
    None, # 470
    None, # 471
    None, # 472
    None, # 473
    None, # 474
    None, # 475
    None, # 476
    None, # 477
    None, # 478
    None, # 479
    None, # 480
    None, # 481
    None, # 482
    None, # 483
    None, # 484
    None, # 485
    None, # 486
    None, # 487
    None, # 488
    None, # 489
    None, # 490
    None, # 491
    None, # 492
    None, # 493
    None, # 494
    None, # 495
    None, # 496
    None, # 497
    None, # 498
    None, # 499
    None, # 500
    None, # 501
    None, # 502
    None, # 503
    None, # 504
    None, # 505
    None, # 506
    None, # 507
    None, # 508
    None, # 509
    None, # 510
    None, # 511
    None, # 512
    None, # 513
    None, # 514
    None, # 515
    None, # 516
    None, # 517
    None, # 518
    None, # 519
    None, # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ), # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ), # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ), # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ), # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ), # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ), # 526
  )

  def __init__(self, supervisor_id=None, host=None, port=None, topology_id=None, topology_name=None, num_executors=None, component_to_num_tasks=None, time_secs=None, uptime_secs=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None,):
    self.supervisor_id = supervisor_id
    self.host = host
    self.port = port
    self.topology_id = topology_id
    self.topology_name = topology_name
    self.num_executors = num_executors
    self.component_to_num_tasks = component_to_num_tasks
    self.time_secs = time_secs
    self.uptime_secs = uptime_secs
    self.requested_memonheap = requested_memonheap
    self.requested_memoffheap = requested_memoffheap
    self.requested_cpu = requested_cpu
    self.assigned_memonheap = assigned_memonheap
    self.assigned_memoffheap = assigned_memoffheap
    self.assigned_cpu = assigned_cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.supervisor_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.port = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.topology_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.topology_name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.num_executors = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.component_to_num_tasks = {}
          (_ktype384, _vtype385, _size383 ) = iprot.readMapBegin()
          for _i387 in xrange(_size383):
            _key388 = iprot.readString().decode('utf-8')
            _val389 = iprot.readI64()
            self.component_to_num_tasks[_key388] = _val389
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I32:
          self.time_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 521:
        if ftype == TType.DOUBLE:
          self.requested_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 522:
        if ftype == TType.DOUBLE:
          self.requested_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 523:
        if ftype == TType.DOUBLE:
          self.requested_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 524:
        if ftype == TType.DOUBLE:
          self.assigned_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 525:
        if ftype == TType.DOUBLE:
          self.assigned_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 526:
        if ftype == TType.DOUBLE:
          self.assigned_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('WorkerSummary')
    if self.supervisor_id is not None:
      oprot.writeFieldBegin('supervisor_id', TType.STRING, 1)
      oprot.writeString(self.supervisor_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.host is not None:
      oprot.writeFieldBegin('host', TType.STRING, 2)
      oprot.writeString(self.host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.I32, 3)
      oprot.writeI32(self.port)
      oprot.writeFieldEnd()
    if self.topology_id is not None:
      oprot.writeFieldBegin('topology_id', TType.STRING, 4)
      oprot.writeString(self.topology_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.topology_name is not None:
      oprot.writeFieldBegin('topology_name', TType.STRING, 5)
      oprot.writeString(self.topology_name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.I32, 6)
      oprot.writeI32(self.num_executors)
      oprot.writeFieldEnd()
    if self.component_to_num_tasks is not None:
      oprot.writeFieldBegin('component_to_num_tasks', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.I64, len(self.component_to_num_tasks))
      for kiter390,viter391 in self.component_to_num_tasks.items():
        oprot.writeString(kiter390.encode('utf-8'))
        oprot.writeI64(viter391)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.time_secs is not None:
      oprot.writeFieldBegin('time_secs', TType.I32, 8)
      oprot.writeI32(self.time_secs)
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 9)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.requested_memonheap is not None:
      oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
      oprot.writeDouble(self.requested_memonheap)
      oprot.writeFieldEnd()
    if self.requested_memoffheap is not None:
      oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
      oprot.writeDouble(self.requested_memoffheap)
      oprot.writeFieldEnd()
    if self.requested_cpu is not None:
      oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
      oprot.writeDouble(self.requested_cpu)
      oprot.writeFieldEnd()
    if self.assigned_memonheap is not None:
      oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
      oprot.writeDouble(self.assigned_memonheap)
      oprot.writeFieldEnd()
    if self.assigned_memoffheap is not None:
      oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
      oprot.writeDouble(self.assigned_memoffheap)
      oprot.writeFieldEnd()
    if self.assigned_cpu is not None:
      oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
      oprot.writeDouble(self.assigned_cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.supervisor_id)
    value = (value * 31) ^ hash(self.host)
    value = (value * 31) ^ hash(self.port)
    value = (value * 31) ^ hash(self.topology_id)
    value = (value * 31) ^ hash(self.topology_name)
    value = (value * 31) ^ hash(self.num_executors)
    value = (value * 31) ^ hash(self.component_to_num_tasks)
    value = (value * 31) ^ hash(self.time_secs)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.requested_memonheap)
    value = (value * 31) ^ hash(self.requested_memoffheap)
    value = (value * 31) ^ hash(self.requested_cpu)
    value = (value * 31) ^ hash(self.assigned_memonheap)
    value = (value * 31) ^ hash(self.assigned_memoffheap)
    value = (value * 31) ^ hash(self.assigned_cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SupervisorPageInfo:
  """
  Attributes:
   - supervisor_summaries
   - worker_summaries
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'supervisor_summaries', (TType.STRUCT,(SupervisorSummary, SupervisorSummary.thrift_spec)), None, ), # 1
    (2, TType.LIST, 'worker_summaries', (TType.STRUCT,(WorkerSummary, WorkerSummary.thrift_spec)), None, ), # 2
  )

  def __init__(self, supervisor_summaries=None, worker_summaries=None,):
    self.supervisor_summaries = supervisor_summaries
    self.worker_summaries = worker_summaries

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.supervisor_summaries = []
          (_etype395, _size392) = iprot.readListBegin()
          for _i396 in xrange(_size392):
            _elem397 = SupervisorSummary()
            _elem397.read(iprot)
            self.supervisor_summaries.append(_elem397)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.worker_summaries = []
          (_etype401, _size398) = iprot.readListBegin()
          for _i402 in xrange(_size398):
            _elem403 = WorkerSummary()
            _elem403.read(iprot)
            self.worker_summaries.append(_elem403)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SupervisorPageInfo')
    if self.supervisor_summaries is not None:
      oprot.writeFieldBegin('supervisor_summaries', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.supervisor_summaries))
      for iter404 in self.supervisor_summaries:
        iter404.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.worker_summaries is not None:
      oprot.writeFieldBegin('worker_summaries', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.worker_summaries))
      for iter405 in self.worker_summaries:
        iter405.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.supervisor_summaries)
    value = (value * 31) ^ hash(self.worker_summaries)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologyPageInfo:
  """
  Attributes:
   - id
   - name
   - uptime_secs
   - status
   - num_tasks
   - num_workers
   - num_executors
   - topology_conf
   - id_to_spout_agg_stats
   - id_to_bolt_agg_stats
   - sched_status
   - topology_stats
   - owner
   - debug_options
   - replication_count
   - workers
   - requested_memonheap
   - requested_memoffheap
   - requested_cpu
   - assigned_memonheap
   - assigned_memoffheap
   - assigned_cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'id', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.I32, 'uptime_secs', None, None, ), # 3
    (4, TType.STRING, 'status', None, None, ), # 4
    (5, TType.I32, 'num_tasks', None, None, ), # 5
    (6, TType.I32, 'num_workers', None, None, ), # 6
    (7, TType.I32, 'num_executors', None, None, ), # 7
    (8, TType.STRING, 'topology_conf', None, None, ), # 8
    (9, TType.MAP, 'id_to_spout_agg_stats', (TType.STRING,None,TType.STRUCT,(ComponentAggregateStats, ComponentAggregateStats.thrift_spec)), None, ), # 9
    (10, TType.MAP, 'id_to_bolt_agg_stats', (TType.STRING,None,TType.STRUCT,(ComponentAggregateStats, ComponentAggregateStats.thrift_spec)), None, ), # 10
    (11, TType.STRING, 'sched_status', None, None, ), # 11
    (12, TType.STRUCT, 'topology_stats', (TopologyStats, TopologyStats.thrift_spec), None, ), # 12
    (13, TType.STRING, 'owner', None, None, ), # 13
    (14, TType.STRUCT, 'debug_options', (DebugOptions, DebugOptions.thrift_spec), None, ), # 14
    (15, TType.I32, 'replication_count', None, None, ), # 15
    (16, TType.LIST, 'workers', (TType.STRUCT,(WorkerSummary, WorkerSummary.thrift_spec)), None, ), # 16
    None, # 17
    None, # 18
    None, # 19
    None, # 20
    None, # 21
    None, # 22
    None, # 23
    None, # 24
    None, # 25
    None, # 26
    None, # 27
    None, # 28
    None, # 29
    None, # 30
    None, # 31
    None, # 32
    None, # 33
    None, # 34
    None, # 35
    None, # 36
    None, # 37
    None, # 38
    None, # 39
    None, # 40
    None, # 41
    None, # 42
    None, # 43
    None, # 44
    None, # 45
    None, # 46
    None, # 47
    None, # 48
    None, # 49
    None, # 50
    None, # 51
    None, # 52
    None, # 53
    None, # 54
    None, # 55
    None, # 56
    None, # 57
    None, # 58
    None, # 59
    None, # 60
    None, # 61
    None, # 62
    None, # 63
    None, # 64
    None, # 65
    None, # 66
    None, # 67
    None, # 68
    None, # 69
    None, # 70
    None, # 71
    None, # 72
    None, # 73
    None, # 74
    None, # 75
    None, # 76
    None, # 77
    None, # 78
    None, # 79
    None, # 80
    None, # 81
    None, # 82
    None, # 83
    None, # 84
    None, # 85
    None, # 86
    None, # 87
    None, # 88
    None, # 89
    None, # 90
    None, # 91
    None, # 92
    None, # 93
    None, # 94
    None, # 95
    None, # 96
    None, # 97
    None, # 98
    None, # 99
    None, # 100
    None, # 101
    None, # 102
    None, # 103
    None, # 104
    None, # 105
    None, # 106
    None, # 107
    None, # 108
    None, # 109
    None, # 110
    None, # 111
    None, # 112
    None, # 113
    None, # 114
    None, # 115
    None, # 116
    None, # 117
    None, # 118
    None, # 119
    None, # 120
    None, # 121
    None, # 122
    None, # 123
    None, # 124
    None, # 125
    None, # 126
    None, # 127
    None, # 128
    None, # 129
    None, # 130
    None, # 131
    None, # 132
    None, # 133
    None, # 134
    None, # 135
    None, # 136
    None, # 137
    None, # 138
    None, # 139
    None, # 140
    None, # 141
    None, # 142
    None, # 143
    None, # 144
    None, # 145
    None, # 146
    None, # 147
    None, # 148
    None, # 149
    None, # 150
    None, # 151
    None, # 152
    None, # 153
    None, # 154
    None, # 155
    None, # 156
    None, # 157
    None, # 158
    None, # 159
    None, # 160
    None, # 161
    None, # 162
    None, # 163
    None, # 164
    None, # 165
    None, # 166
    None, # 167
    None, # 168
    None, # 169
    None, # 170
    None, # 171
    None, # 172
    None, # 173
    None, # 174
    None, # 175
    None, # 176
    None, # 177
    None, # 178
    None, # 179
    None, # 180
    None, # 181
    None, # 182
    None, # 183
    None, # 184
    None, # 185
    None, # 186
    None, # 187
    None, # 188
    None, # 189
    None, # 190
    None, # 191
    None, # 192
    None, # 193
    None, # 194
    None, # 195
    None, # 196
    None, # 197
    None, # 198
    None, # 199
    None, # 200
    None, # 201
    None, # 202
    None, # 203
    None, # 204
    None, # 205
    None, # 206
    None, # 207
    None, # 208
    None, # 209
    None, # 210
    None, # 211
    None, # 212
    None, # 213
    None, # 214
    None, # 215
    None, # 216
    None, # 217
    None, # 218
    None, # 219
    None, # 220
    None, # 221
    None, # 222
    None, # 223
    None, # 224
    None, # 225
    None, # 226
    None, # 227
    None, # 228
    None, # 229
    None, # 230
    None, # 231
    None, # 232
    None, # 233
    None, # 234
    None, # 235
    None, # 236
    None, # 237
    None, # 238
    None, # 239
    None, # 240
    None, # 241
    None, # 242
    None, # 243
    None, # 244
    None, # 245
    None, # 246
    None, # 247
    None, # 248
    None, # 249
    None, # 250
    None, # 251
    None, # 252
    None, # 253
    None, # 254
    None, # 255
    None, # 256
    None, # 257
    None, # 258
    None, # 259
    None, # 260
    None, # 261
    None, # 262
    None, # 263
    None, # 264
    None, # 265
    None, # 266
    None, # 267
    None, # 268
    None, # 269
    None, # 270
    None, # 271
    None, # 272
    None, # 273
    None, # 274
    None, # 275
    None, # 276
    None, # 277
    None, # 278
    None, # 279
    None, # 280
    None, # 281
    None, # 282
    None, # 283
    None, # 284
    None, # 285
    None, # 286
    None, # 287
    None, # 288
    None, # 289
    None, # 290
    None, # 291
    None, # 292
    None, # 293
    None, # 294
    None, # 295
    None, # 296
    None, # 297
    None, # 298
    None, # 299
    None, # 300
    None, # 301
    None, # 302
    None, # 303
    None, # 304
    None, # 305
    None, # 306
    None, # 307
    None, # 308
    None, # 309
    None, # 310
    None, # 311
    None, # 312
    None, # 313
    None, # 314
    None, # 315
    None, # 316
    None, # 317
    None, # 318
    None, # 319
    None, # 320
    None, # 321
    None, # 322
    None, # 323
    None, # 324
    None, # 325
    None, # 326
    None, # 327
    None, # 328
    None, # 329
    None, # 330
    None, # 331
    None, # 332
    None, # 333
    None, # 334
    None, # 335
    None, # 336
    None, # 337
    None, # 338
    None, # 339
    None, # 340
    None, # 341
    None, # 342
    None, # 343
    None, # 344
    None, # 345
    None, # 346
    None, # 347
    None, # 348
    None, # 349
    None, # 350
    None, # 351
    None, # 352
    None, # 353
    None, # 354
    None, # 355
    None, # 356
    None, # 357
    None, # 358
    None, # 359
    None, # 360
    None, # 361
    None, # 362
    None, # 363
    None, # 364
    None, # 365
    None, # 366
    None, # 367
    None, # 368
    None, # 369
    None, # 370
    None, # 371
    None, # 372
    None, # 373
    None, # 374
    None, # 375
    None, # 376
    None, # 377
    None, # 378
    None, # 379
    None, # 380
    None, # 381
    None, # 382
    None, # 383
    None, # 384
    None, # 385
    None, # 386
    None, # 387
    None, # 388
    None, # 389
    None, # 390
    None, # 391
    None, # 392
    None, # 393
    None, # 394
    None, # 395
    None, # 396
    None, # 397
    None, # 398
    None, # 399
    None, # 400
    None, # 401
    None, # 402
    None, # 403
    None, # 404
    None, # 405
    None, # 406
    None, # 407
    None, # 408
    None, # 409
    None, # 410
    None, # 411
    None, # 412
    None, # 413
    None, # 414
    None, # 415
    None, # 416
    None, # 417
    None, # 418
    None, # 419
    None, # 420
    None, # 421
    None, # 422
    None, # 423
    None, # 424
    None, # 425
    None, # 426
    None, # 427
    None, # 428
    None, # 429
    None, # 430
    None, # 431
    None, # 432
    None, # 433
    None, # 434
    None, # 435
    None, # 436
    None, # 437
    None, # 438
    None, # 439
    None, # 440
    None, # 441
    None, # 442
    None, # 443
    None, # 444
    None, # 445
    None, # 446
    None, # 447
    None, # 448
    None, # 449
    None, # 450
    None, # 451
    None, # 452
    None, # 453
    None, # 454
    None, # 455
    None, # 456
    None, # 457
    None, # 458
    None, # 459
    None, # 460
    None, # 461
    None, # 462
    None, # 463
    None, # 464
    None, # 465
    None, # 466
    None, # 467
    None, # 468
    None, # 469
    None, # 470
    None, # 471
    None, # 472
    None, # 473
    None, # 474
    None, # 475
    None, # 476
    None, # 477
    None, # 478
    None, # 479
    None, # 480
    None, # 481
    None, # 482
    None, # 483
    None, # 484
    None, # 485
    None, # 486
    None, # 487
    None, # 488
    None, # 489
    None, # 490
    None, # 491
    None, # 492
    None, # 493
    None, # 494
    None, # 495
    None, # 496
    None, # 497
    None, # 498
    None, # 499
    None, # 500
    None, # 501
    None, # 502
    None, # 503
    None, # 504
    None, # 505
    None, # 506
    None, # 507
    None, # 508
    None, # 509
    None, # 510
    None, # 511
    None, # 512
    None, # 513
    None, # 514
    None, # 515
    None, # 516
    None, # 517
    None, # 518
    None, # 519
    None, # 520
    (521, TType.DOUBLE, 'requested_memonheap', None, None, ), # 521
    (522, TType.DOUBLE, 'requested_memoffheap', None, None, ), # 522
    (523, TType.DOUBLE, 'requested_cpu', None, None, ), # 523
    (524, TType.DOUBLE, 'assigned_memonheap', None, None, ), # 524
    (525, TType.DOUBLE, 'assigned_memoffheap', None, None, ), # 525
    (526, TType.DOUBLE, 'assigned_cpu', None, None, ), # 526
  )

  def __init__(self, id=None, name=None, uptime_secs=None, status=None, num_tasks=None, num_workers=None, num_executors=None, topology_conf=None, id_to_spout_agg_stats=None, id_to_bolt_agg_stats=None, sched_status=None, topology_stats=None, owner=None, debug_options=None, replication_count=None, workers=None, requested_memonheap=None, requested_memoffheap=None, requested_cpu=None, assigned_memonheap=None, assigned_memoffheap=None, assigned_cpu=None,):
    self.id = id
    self.name = name
    self.uptime_secs = uptime_secs
    self.status = status
    self.num_tasks = num_tasks
    self.num_workers = num_workers
    self.num_executors = num_executors
    self.topology_conf = topology_conf
    self.id_to_spout_agg_stats = id_to_spout_agg_stats
    self.id_to_bolt_agg_stats = id_to_bolt_agg_stats
    self.sched_status = sched_status
    self.topology_stats = topology_stats
    self.owner = owner
    self.debug_options = debug_options
    self.replication_count = replication_count
    self.workers = workers
    self.requested_memonheap = requested_memonheap
    self.requested_memoffheap = requested_memoffheap
    self.requested_cpu = requested_cpu
    self.assigned_memonheap = assigned_memonheap
    self.assigned_memoffheap = assigned_memoffheap
    self.assigned_cpu = assigned_cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.num_tasks = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.num_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.num_executors = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.topology_conf = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.MAP:
          self.id_to_spout_agg_stats = {}
          (_ktype407, _vtype408, _size406 ) = iprot.readMapBegin()
          for _i410 in xrange(_size406):
            _key411 = iprot.readString().decode('utf-8')
            _val412 = ComponentAggregateStats()
            _val412.read(iprot)
            self.id_to_spout_agg_stats[_key411] = _val412
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.MAP:
          self.id_to_bolt_agg_stats = {}
          (_ktype414, _vtype415, _size413 ) = iprot.readMapBegin()
          for _i417 in xrange(_size413):
            _key418 = iprot.readString().decode('utf-8')
            _val419 = ComponentAggregateStats()
            _val419.read(iprot)
            self.id_to_bolt_agg_stats[_key418] = _val419
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.sched_status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRUCT:
          self.topology_stats = TopologyStats()
          self.topology_stats.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRUCT:
          self.debug_options = DebugOptions()
          self.debug_options.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.I32:
          self.replication_count = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.LIST:
          self.workers = []
          (_etype423, _size420) = iprot.readListBegin()
          for _i424 in xrange(_size420):
            _elem425 = WorkerSummary()
            _elem425.read(iprot)
            self.workers.append(_elem425)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 521:
        if ftype == TType.DOUBLE:
          self.requested_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 522:
        if ftype == TType.DOUBLE:
          self.requested_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 523:
        if ftype == TType.DOUBLE:
          self.requested_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 524:
        if ftype == TType.DOUBLE:
          self.assigned_memonheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 525:
        if ftype == TType.DOUBLE:
          self.assigned_memoffheap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 526:
        if ftype == TType.DOUBLE:
          self.assigned_cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologyPageInfo')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.STRING, 1)
      oprot.writeString(self.id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 3)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.status is not None:
      oprot.writeFieldBegin('status', TType.STRING, 4)
      oprot.writeString(self.status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.num_tasks is not None:
      oprot.writeFieldBegin('num_tasks', TType.I32, 5)
      oprot.writeI32(self.num_tasks)
      oprot.writeFieldEnd()
    if self.num_workers is not None:
      oprot.writeFieldBegin('num_workers', TType.I32, 6)
      oprot.writeI32(self.num_workers)
      oprot.writeFieldEnd()
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.I32, 7)
      oprot.writeI32(self.num_executors)
      oprot.writeFieldEnd()
    if self.topology_conf is not None:
      oprot.writeFieldBegin('topology_conf', TType.STRING, 8)
      oprot.writeString(self.topology_conf.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.id_to_spout_agg_stats is not None:
      oprot.writeFieldBegin('id_to_spout_agg_stats', TType.MAP, 9)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.id_to_spout_agg_stats))
      for kiter426,viter427 in self.id_to_spout_agg_stats.items():
        oprot.writeString(kiter426.encode('utf-8'))
        viter427.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.id_to_bolt_agg_stats is not None:
      oprot.writeFieldBegin('id_to_bolt_agg_stats', TType.MAP, 10)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.id_to_bolt_agg_stats))
      for kiter428,viter429 in self.id_to_bolt_agg_stats.items():
        oprot.writeString(kiter428.encode('utf-8'))
        viter429.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sched_status is not None:
      oprot.writeFieldBegin('sched_status', TType.STRING, 11)
      oprot.writeString(self.sched_status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.topology_stats is not None:
      oprot.writeFieldBegin('topology_stats', TType.STRUCT, 12)
      self.topology_stats.write(oprot)
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 13)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.debug_options is not None:
      oprot.writeFieldBegin('debug_options', TType.STRUCT, 14)
      self.debug_options.write(oprot)
      oprot.writeFieldEnd()
    if self.replication_count is not None:
      oprot.writeFieldBegin('replication_count', TType.I32, 15)
      oprot.writeI32(self.replication_count)
      oprot.writeFieldEnd()
    if self.workers is not None:
      oprot.writeFieldBegin('workers', TType.LIST, 16)
      oprot.writeListBegin(TType.STRUCT, len(self.workers))
      for iter430 in self.workers:
        iter430.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.requested_memonheap is not None:
      oprot.writeFieldBegin('requested_memonheap', TType.DOUBLE, 521)
      oprot.writeDouble(self.requested_memonheap)
      oprot.writeFieldEnd()
    if self.requested_memoffheap is not None:
      oprot.writeFieldBegin('requested_memoffheap', TType.DOUBLE, 522)
      oprot.writeDouble(self.requested_memoffheap)
      oprot.writeFieldEnd()
    if self.requested_cpu is not None:
      oprot.writeFieldBegin('requested_cpu', TType.DOUBLE, 523)
      oprot.writeDouble(self.requested_cpu)
      oprot.writeFieldEnd()
    if self.assigned_memonheap is not None:
      oprot.writeFieldBegin('assigned_memonheap', TType.DOUBLE, 524)
      oprot.writeDouble(self.assigned_memonheap)
      oprot.writeFieldEnd()
    if self.assigned_memoffheap is not None:
      oprot.writeFieldBegin('assigned_memoffheap', TType.DOUBLE, 525)
      oprot.writeDouble(self.assigned_memoffheap)
      oprot.writeFieldEnd()
    if self.assigned_cpu is not None:
      oprot.writeFieldBegin('assigned_cpu', TType.DOUBLE, 526)
      oprot.writeDouble(self.assigned_cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.id is None:
      raise TProtocol.TProtocolException(message='Required field id is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.id)
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.status)
    value = (value * 31) ^ hash(self.num_tasks)
    value = (value * 31) ^ hash(self.num_workers)
    value = (value * 31) ^ hash(self.num_executors)
    value = (value * 31) ^ hash(self.topology_conf)
    value = (value * 31) ^ hash(self.id_to_spout_agg_stats)
    value = (value * 31) ^ hash(self.id_to_bolt_agg_stats)
    value = (value * 31) ^ hash(self.sched_status)
    value = (value * 31) ^ hash(self.topology_stats)
    value = (value * 31) ^ hash(self.owner)
    value = (value * 31) ^ hash(self.debug_options)
    value = (value * 31) ^ hash(self.replication_count)
    value = (value * 31) ^ hash(self.workers)
    value = (value * 31) ^ hash(self.requested_memonheap)
    value = (value * 31) ^ hash(self.requested_memoffheap)
    value = (value * 31) ^ hash(self.requested_cpu)
    value = (value * 31) ^ hash(self.assigned_memonheap)
    value = (value * 31) ^ hash(self.assigned_memoffheap)
    value = (value * 31) ^ hash(self.assigned_cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ExecutorAggregateStats:
  """
  Attributes:
   - exec_summary
   - stats
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'exec_summary', (ExecutorSummary, ExecutorSummary.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'stats', (ComponentAggregateStats, ComponentAggregateStats.thrift_spec), None, ), # 2
  )

  def __init__(self, exec_summary=None, stats=None,):
    self.exec_summary = exec_summary
    self.stats = stats

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.exec_summary = ExecutorSummary()
          self.exec_summary.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.stats = ComponentAggregateStats()
          self.stats.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ExecutorAggregateStats')
    if self.exec_summary is not None:
      oprot.writeFieldBegin('exec_summary', TType.STRUCT, 1)
      self.exec_summary.write(oprot)
      oprot.writeFieldEnd()
    if self.stats is not None:
      oprot.writeFieldBegin('stats', TType.STRUCT, 2)
      self.stats.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.exec_summary)
    value = (value * 31) ^ hash(self.stats)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ComponentPageInfo:
  """
  Attributes:
   - component_id
   - component_type
   - topology_id
   - topology_name
   - num_executors
   - num_tasks
   - window_to_stats
   - gsid_to_input_stats
   - sid_to_output_stats
   - exec_stats
   - errors
   - eventlog_host
   - eventlog_port
   - debug_options
   - topology_status
   - resources_map
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'component_id', None, None, ), # 1
    (2, TType.I32, 'component_type', None, None, ), # 2
    (3, TType.STRING, 'topology_id', None, None, ), # 3
    (4, TType.STRING, 'topology_name', None, None, ), # 4
    (5, TType.I32, 'num_executors', None, None, ), # 5
    (6, TType.I32, 'num_tasks', None, None, ), # 6
    (7, TType.MAP, 'window_to_stats', (TType.STRING,None,TType.STRUCT,(ComponentAggregateStats, ComponentAggregateStats.thrift_spec)), None, ), # 7
    (8, TType.MAP, 'gsid_to_input_stats', (TType.STRUCT,(GlobalStreamId, GlobalStreamId.thrift_spec),TType.STRUCT,(ComponentAggregateStats, ComponentAggregateStats.thrift_spec)), None, ), # 8
    (9, TType.MAP, 'sid_to_output_stats', (TType.STRING,None,TType.STRUCT,(ComponentAggregateStats, ComponentAggregateStats.thrift_spec)), None, ), # 9
    (10, TType.LIST, 'exec_stats', (TType.STRUCT,(ExecutorAggregateStats, ExecutorAggregateStats.thrift_spec)), None, ), # 10
    (11, TType.LIST, 'errors', (TType.STRUCT,(ErrorInfo, ErrorInfo.thrift_spec)), None, ), # 11
    (12, TType.STRING, 'eventlog_host', None, None, ), # 12
    (13, TType.I32, 'eventlog_port', None, None, ), # 13
    (14, TType.STRUCT, 'debug_options', (DebugOptions, DebugOptions.thrift_spec), None, ), # 14
    (15, TType.STRING, 'topology_status', None, None, ), # 15
    (16, TType.MAP, 'resources_map', (TType.STRING,None,TType.DOUBLE,None), None, ), # 16
  )

  def __init__(self, component_id=None, component_type=None, topology_id=None, topology_name=None, num_executors=None, num_tasks=None, window_to_stats=None, gsid_to_input_stats=None, sid_to_output_stats=None, exec_stats=None, errors=None, eventlog_host=None, eventlog_port=None, debug_options=None, topology_status=None, resources_map=None,):
    self.component_id = component_id
    self.component_type = component_type
    self.topology_id = topology_id
    self.topology_name = topology_name
    self.num_executors = num_executors
    self.num_tasks = num_tasks
    self.window_to_stats = window_to_stats
    self.gsid_to_input_stats = gsid_to_input_stats
    self.sid_to_output_stats = sid_to_output_stats
    self.exec_stats = exec_stats
    self.errors = errors
    self.eventlog_host = eventlog_host
    self.eventlog_port = eventlog_port
    self.debug_options = debug_options
    self.topology_status = topology_status
    self.resources_map = resources_map

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.component_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.component_type = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.topology_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.topology_name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.num_executors = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.I32:
          self.num_tasks = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.window_to_stats = {}
          (_ktype432, _vtype433, _size431 ) = iprot.readMapBegin()
          for _i435 in xrange(_size431):
            _key436 = iprot.readString().decode('utf-8')
            _val437 = ComponentAggregateStats()
            _val437.read(iprot)
            self.window_to_stats[_key436] = _val437
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.MAP:
          self.gsid_to_input_stats = {}
          (_ktype439, _vtype440, _size438 ) = iprot.readMapBegin()
          for _i442 in xrange(_size438):
            _key443 = GlobalStreamId()
            _key443.read(iprot)
            _val444 = ComponentAggregateStats()
            _val444.read(iprot)
            self.gsid_to_input_stats[_key443] = _val444
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.MAP:
          self.sid_to_output_stats = {}
          (_ktype446, _vtype447, _size445 ) = iprot.readMapBegin()
          for _i449 in xrange(_size445):
            _key450 = iprot.readString().decode('utf-8')
            _val451 = ComponentAggregateStats()
            _val451.read(iprot)
            self.sid_to_output_stats[_key450] = _val451
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.LIST:
          self.exec_stats = []
          (_etype455, _size452) = iprot.readListBegin()
          for _i456 in xrange(_size452):
            _elem457 = ExecutorAggregateStats()
            _elem457.read(iprot)
            self.exec_stats.append(_elem457)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.LIST:
          self.errors = []
          (_etype461, _size458) = iprot.readListBegin()
          for _i462 in xrange(_size458):
            _elem463 = ErrorInfo()
            _elem463.read(iprot)
            self.errors.append(_elem463)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.STRING:
          self.eventlog_host = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 13:
        if ftype == TType.I32:
          self.eventlog_port = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 14:
        if ftype == TType.STRUCT:
          self.debug_options = DebugOptions()
          self.debug_options.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 15:
        if ftype == TType.STRING:
          self.topology_status = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 16:
        if ftype == TType.MAP:
          self.resources_map = {}
          (_ktype465, _vtype466, _size464 ) = iprot.readMapBegin()
          for _i468 in xrange(_size464):
            _key469 = iprot.readString().decode('utf-8')
            _val470 = iprot.readDouble()
            self.resources_map[_key469] = _val470
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ComponentPageInfo')
    if self.component_id is not None:
      oprot.writeFieldBegin('component_id', TType.STRING, 1)
      oprot.writeString(self.component_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.component_type is not None:
      oprot.writeFieldBegin('component_type', TType.I32, 2)
      oprot.writeI32(self.component_type)
      oprot.writeFieldEnd()
    if self.topology_id is not None:
      oprot.writeFieldBegin('topology_id', TType.STRING, 3)
      oprot.writeString(self.topology_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.topology_name is not None:
      oprot.writeFieldBegin('topology_name', TType.STRING, 4)
      oprot.writeString(self.topology_name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.I32, 5)
      oprot.writeI32(self.num_executors)
      oprot.writeFieldEnd()
    if self.num_tasks is not None:
      oprot.writeFieldBegin('num_tasks', TType.I32, 6)
      oprot.writeI32(self.num_tasks)
      oprot.writeFieldEnd()
    if self.window_to_stats is not None:
      oprot.writeFieldBegin('window_to_stats', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.window_to_stats))
      for kiter471,viter472 in self.window_to_stats.items():
        oprot.writeString(kiter471.encode('utf-8'))
        viter472.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.gsid_to_input_stats is not None:
      oprot.writeFieldBegin('gsid_to_input_stats', TType.MAP, 8)
      oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.gsid_to_input_stats))
      for kiter473,viter474 in self.gsid_to_input_stats.items():
        kiter473.write(oprot)
        viter474.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sid_to_output_stats is not None:
      oprot.writeFieldBegin('sid_to_output_stats', TType.MAP, 9)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.sid_to_output_stats))
      for kiter475,viter476 in self.sid_to_output_stats.items():
        oprot.writeString(kiter475.encode('utf-8'))
        viter476.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.exec_stats is not None:
      oprot.writeFieldBegin('exec_stats', TType.LIST, 10)
      oprot.writeListBegin(TType.STRUCT, len(self.exec_stats))
      for iter477 in self.exec_stats:
        iter477.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.errors is not None:
      oprot.writeFieldBegin('errors', TType.LIST, 11)
      oprot.writeListBegin(TType.STRUCT, len(self.errors))
      for iter478 in self.errors:
        iter478.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.eventlog_host is not None:
      oprot.writeFieldBegin('eventlog_host', TType.STRING, 12)
      oprot.writeString(self.eventlog_host.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.eventlog_port is not None:
      oprot.writeFieldBegin('eventlog_port', TType.I32, 13)
      oprot.writeI32(self.eventlog_port)
      oprot.writeFieldEnd()
    if self.debug_options is not None:
      oprot.writeFieldBegin('debug_options', TType.STRUCT, 14)
      self.debug_options.write(oprot)
      oprot.writeFieldEnd()
    if self.topology_status is not None:
      oprot.writeFieldBegin('topology_status', TType.STRING, 15)
      oprot.writeString(self.topology_status.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.resources_map is not None:
      oprot.writeFieldBegin('resources_map', TType.MAP, 16)
      oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
      for kiter479,viter480 in self.resources_map.items():
        oprot.writeString(kiter479.encode('utf-8'))
        oprot.writeDouble(viter480)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.component_id is None:
      raise TProtocol.TProtocolException(message='Required field component_id is unset!')
    if self.component_type is None:
      raise TProtocol.TProtocolException(message='Required field component_type is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.component_id)
    value = (value * 31) ^ hash(self.component_type)
    value = (value * 31) ^ hash(self.topology_id)
    value = (value * 31) ^ hash(self.topology_name)
    value = (value * 31) ^ hash(self.num_executors)
    value = (value * 31) ^ hash(self.num_tasks)
    value = (value * 31) ^ hash(self.window_to_stats)
    value = (value * 31) ^ hash(self.gsid_to_input_stats)
    value = (value * 31) ^ hash(self.sid_to_output_stats)
    value = (value * 31) ^ hash(self.exec_stats)
    value = (value * 31) ^ hash(self.errors)
    value = (value * 31) ^ hash(self.eventlog_host)
    value = (value * 31) ^ hash(self.eventlog_port)
    value = (value * 31) ^ hash(self.debug_options)
    value = (value * 31) ^ hash(self.topology_status)
    value = (value * 31) ^ hash(self.resources_map)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class KillOptions:
  """
  Attributes:
   - wait_secs
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'wait_secs', None, None, ), # 1
  )

  def __init__(self, wait_secs=None,):
    self.wait_secs = wait_secs

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.wait_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('KillOptions')
    if self.wait_secs is not None:
      oprot.writeFieldBegin('wait_secs', TType.I32, 1)
      oprot.writeI32(self.wait_secs)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.wait_secs)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class RebalanceOptions:
  """
  Attributes:
   - wait_secs
   - num_workers
   - num_executors
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'wait_secs', None, None, ), # 1
    (2, TType.I32, 'num_workers', None, None, ), # 2
    (3, TType.MAP, 'num_executors', (TType.STRING,None,TType.I32,None), None, ), # 3
  )

  def __init__(self, wait_secs=None, num_workers=None, num_executors=None,):
    self.wait_secs = wait_secs
    self.num_workers = num_workers
    self.num_executors = num_executors

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.wait_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.num_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.num_executors = {}
          (_ktype482, _vtype483, _size481 ) = iprot.readMapBegin()
          for _i485 in xrange(_size481):
            _key486 = iprot.readString().decode('utf-8')
            _val487 = iprot.readI32()
            self.num_executors[_key486] = _val487
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('RebalanceOptions')
    if self.wait_secs is not None:
      oprot.writeFieldBegin('wait_secs', TType.I32, 1)
      oprot.writeI32(self.wait_secs)
      oprot.writeFieldEnd()
    if self.num_workers is not None:
      oprot.writeFieldBegin('num_workers', TType.I32, 2)
      oprot.writeI32(self.num_workers)
      oprot.writeFieldEnd()
    if self.num_executors is not None:
      oprot.writeFieldBegin('num_executors', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.I32, len(self.num_executors))
      for kiter488,viter489 in self.num_executors.items():
        oprot.writeString(kiter488.encode('utf-8'))
        oprot.writeI32(viter489)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.wait_secs)
    value = (value * 31) ^ hash(self.num_workers)
    value = (value * 31) ^ hash(self.num_executors)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Credentials:
  """
  Attributes:
   - creds
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'creds', (TType.STRING,None,TType.STRING,None), None, ), # 1
  )

  def __init__(self, creds=None,):
    self.creds = creds

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.creds = {}
          (_ktype491, _vtype492, _size490 ) = iprot.readMapBegin()
          for _i494 in xrange(_size490):
            _key495 = iprot.readString().decode('utf-8')
            _val496 = iprot.readString().decode('utf-8')
            self.creds[_key495] = _val496
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Credentials')
    if self.creds is not None:
      oprot.writeFieldBegin('creds', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.creds))
      for kiter497,viter498 in self.creds.items():
        oprot.writeString(kiter497.encode('utf-8'))
        oprot.writeString(viter498.encode('utf-8'))
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.creds is None:
      raise TProtocol.TProtocolException(message='Required field creds is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.creds)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SubmitOptions:
  """
  Attributes:
   - initial_status
   - creds
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'initial_status', None, None, ), # 1
    (2, TType.STRUCT, 'creds', (Credentials, Credentials.thrift_spec), None, ), # 2
  )

  def __init__(self, initial_status=None, creds=None,):
    self.initial_status = initial_status
    self.creds = creds

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.initial_status = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.creds = Credentials()
          self.creds.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SubmitOptions')
    if self.initial_status is not None:
      oprot.writeFieldBegin('initial_status', TType.I32, 1)
      oprot.writeI32(self.initial_status)
      oprot.writeFieldEnd()
    if self.creds is not None:
      oprot.writeFieldBegin('creds', TType.STRUCT, 2)
      self.creds.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.initial_status is None:
      raise TProtocol.TProtocolException(message='Required field initial_status is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.initial_status)
    value = (value * 31) ^ hash(self.creds)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class AccessControl:
  """
  Attributes:
   - type
   - name
   - access
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'type', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
    (3, TType.I32, 'access', None, None, ), # 3
  )

  def __init__(self, type=None, name=None, access=None,):
    self.type = type
    self.name = name
    self.access = access

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.type = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.access = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('AccessControl')
    if self.type is not None:
      oprot.writeFieldBegin('type', TType.I32, 1)
      oprot.writeI32(self.type)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.access is not None:
      oprot.writeFieldBegin('access', TType.I32, 3)
      oprot.writeI32(self.access)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.type is None:
      raise TProtocol.TProtocolException(message='Required field type is unset!')
    if self.access is None:
      raise TProtocol.TProtocolException(message='Required field access is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.type)
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.access)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SettableBlobMeta:
  """
  Attributes:
   - acl
   - replication_factor
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'acl', (TType.STRUCT,(AccessControl, AccessControl.thrift_spec)), None, ), # 1
    (2, TType.I32, 'replication_factor', None, None, ), # 2
  )

  def __init__(self, acl=None, replication_factor=None,):
    self.acl = acl
    self.replication_factor = replication_factor

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.acl = []
          (_etype502, _size499) = iprot.readListBegin()
          for _i503 in xrange(_size499):
            _elem504 = AccessControl()
            _elem504.read(iprot)
            self.acl.append(_elem504)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.replication_factor = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SettableBlobMeta')
    if self.acl is not None:
      oprot.writeFieldBegin('acl', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.acl))
      for iter505 in self.acl:
        iter505.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.replication_factor is not None:
      oprot.writeFieldBegin('replication_factor', TType.I32, 2)
      oprot.writeI32(self.replication_factor)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.acl is None:
      raise TProtocol.TProtocolException(message='Required field acl is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.acl)
    value = (value * 31) ^ hash(self.replication_factor)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ReadableBlobMeta:
  """
  Attributes:
   - settable
   - version
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'settable', (SettableBlobMeta, SettableBlobMeta.thrift_spec), None, ), # 1
    (2, TType.I64, 'version', None, None, ), # 2
  )

  def __init__(self, settable=None, version=None,):
    self.settable = settable
    self.version = version

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.settable = SettableBlobMeta()
          self.settable.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.version = iprot.readI64()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ReadableBlobMeta')
    if self.settable is not None:
      oprot.writeFieldBegin('settable', TType.STRUCT, 1)
      self.settable.write(oprot)
      oprot.writeFieldEnd()
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.I64, 2)
      oprot.writeI64(self.version)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.settable is None:
      raise TProtocol.TProtocolException(message='Required field settable is unset!')
    if self.version is None:
      raise TProtocol.TProtocolException(message='Required field version is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.settable)
    value = (value * 31) ^ hash(self.version)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ListBlobsResult:
  """
  Attributes:
   - keys
   - session
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'keys', (TType.STRING,None), None, ), # 1
    (2, TType.STRING, 'session', None, None, ), # 2
  )

  def __init__(self, keys=None, session=None,):
    self.keys = keys
    self.session = session

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.keys = []
          (_etype509, _size506) = iprot.readListBegin()
          for _i510 in xrange(_size506):
            _elem511 = iprot.readString().decode('utf-8')
            self.keys.append(_elem511)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.session = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ListBlobsResult')
    if self.keys is not None:
      oprot.writeFieldBegin('keys', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.keys))
      for iter512 in self.keys:
        oprot.writeString(iter512.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.session is not None:
      oprot.writeFieldBegin('session', TType.STRING, 2)
      oprot.writeString(self.session.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.keys is None:
      raise TProtocol.TProtocolException(message='Required field keys is unset!')
    if self.session is None:
      raise TProtocol.TProtocolException(message='Required field session is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.keys)
    value = (value * 31) ^ hash(self.session)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class BeginDownloadResult:
  """
  Attributes:
   - version
   - session
   - data_size
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'version', None, None, ), # 1
    (2, TType.STRING, 'session', None, None, ), # 2
    (3, TType.I64, 'data_size', None, None, ), # 3
  )

  def __init__(self, version=None, session=None, data_size=None,):
    self.version = version
    self.session = session
    self.data_size = data_size

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.version = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.session = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.data_size = iprot.readI64()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('BeginDownloadResult')
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.I64, 1)
      oprot.writeI64(self.version)
      oprot.writeFieldEnd()
    if self.session is not None:
      oprot.writeFieldBegin('session', TType.STRING, 2)
      oprot.writeString(self.session.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.data_size is not None:
      oprot.writeFieldBegin('data_size', TType.I64, 3)
      oprot.writeI64(self.data_size)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.version is None:
      raise TProtocol.TProtocolException(message='Required field version is unset!')
    if self.session is None:
      raise TProtocol.TProtocolException(message='Required field session is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.version)
    value = (value * 31) ^ hash(self.session)
    value = (value * 31) ^ hash(self.data_size)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class SupervisorInfo:
  """
  Attributes:
   - time_secs
   - hostname
   - assignment_id
   - used_ports
   - meta
   - scheduler_meta
   - uptime_secs
   - version
   - resources_map
  """

  thrift_spec = (
    None, # 0
    (1, TType.I64, 'time_secs', None, None, ), # 1
    (2, TType.STRING, 'hostname', None, None, ), # 2
    (3, TType.STRING, 'assignment_id', None, None, ), # 3
    (4, TType.LIST, 'used_ports', (TType.I64,None), None, ), # 4
    (5, TType.LIST, 'meta', (TType.I64,None), None, ), # 5
    (6, TType.MAP, 'scheduler_meta', (TType.STRING,None,TType.STRING,None), None, ), # 6
    (7, TType.I64, 'uptime_secs', None, None, ), # 7
    (8, TType.STRING, 'version', None, None, ), # 8
    (9, TType.MAP, 'resources_map', (TType.STRING,None,TType.DOUBLE,None), None, ), # 9
  )

  def __init__(self, time_secs=None, hostname=None, assignment_id=None, used_ports=None, meta=None, scheduler_meta=None, uptime_secs=None, version=None, resources_map=None,):
    self.time_secs = time_secs
    self.hostname = hostname
    self.assignment_id = assignment_id
    self.used_ports = used_ports
    self.meta = meta
    self.scheduler_meta = scheduler_meta
    self.uptime_secs = uptime_secs
    self.version = version
    self.resources_map = resources_map

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I64:
          self.time_secs = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.hostname = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.assignment_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.used_ports = []
          (_etype516, _size513) = iprot.readListBegin()
          for _i517 in xrange(_size513):
            _elem518 = iprot.readI64()
            self.used_ports.append(_elem518)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.LIST:
          self.meta = []
          (_etype522, _size519) = iprot.readListBegin()
          for _i523 in xrange(_size519):
            _elem524 = iprot.readI64()
            self.meta.append(_elem524)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.scheduler_meta = {}
          (_ktype526, _vtype527, _size525 ) = iprot.readMapBegin()
          for _i529 in xrange(_size525):
            _key530 = iprot.readString().decode('utf-8')
            _val531 = iprot.readString().decode('utf-8')
            self.scheduler_meta[_key530] = _val531
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I64:
          self.uptime_secs = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.STRING:
          self.version = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.MAP:
          self.resources_map = {}
          (_ktype533, _vtype534, _size532 ) = iprot.readMapBegin()
          for _i536 in xrange(_size532):
            _key537 = iprot.readString().decode('utf-8')
            _val538 = iprot.readDouble()
            self.resources_map[_key537] = _val538
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('SupervisorInfo')
    if self.time_secs is not None:
      oprot.writeFieldBegin('time_secs', TType.I64, 1)
      oprot.writeI64(self.time_secs)
      oprot.writeFieldEnd()
    if self.hostname is not None:
      oprot.writeFieldBegin('hostname', TType.STRING, 2)
      oprot.writeString(self.hostname.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.assignment_id is not None:
      oprot.writeFieldBegin('assignment_id', TType.STRING, 3)
      oprot.writeString(self.assignment_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.used_ports is not None:
      oprot.writeFieldBegin('used_ports', TType.LIST, 4)
      oprot.writeListBegin(TType.I64, len(self.used_ports))
      for iter539 in self.used_ports:
        oprot.writeI64(iter539)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.meta is not None:
      oprot.writeFieldBegin('meta', TType.LIST, 5)
      oprot.writeListBegin(TType.I64, len(self.meta))
      for iter540 in self.meta:
        oprot.writeI64(iter540)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.scheduler_meta is not None:
      oprot.writeFieldBegin('scheduler_meta', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.scheduler_meta))
      for kiter541,viter542 in self.scheduler_meta.items():
        oprot.writeString(kiter541.encode('utf-8'))
        oprot.writeString(viter542.encode('utf-8'))
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I64, 7)
      oprot.writeI64(self.uptime_secs)
      oprot.writeFieldEnd()
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.STRING, 8)
      oprot.writeString(self.version.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.resources_map is not None:
      oprot.writeFieldBegin('resources_map', TType.MAP, 9)
      oprot.writeMapBegin(TType.STRING, TType.DOUBLE, len(self.resources_map))
      for kiter543,viter544 in self.resources_map.items():
        oprot.writeString(kiter543.encode('utf-8'))
        oprot.writeDouble(viter544)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.time_secs is None:
      raise TProtocol.TProtocolException(message='Required field time_secs is unset!')
    if self.hostname is None:
      raise TProtocol.TProtocolException(message='Required field hostname is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.time_secs)
    value = (value * 31) ^ hash(self.hostname)
    value = (value * 31) ^ hash(self.assignment_id)
    value = (value * 31) ^ hash(self.used_ports)
    value = (value * 31) ^ hash(self.meta)
    value = (value * 31) ^ hash(self.scheduler_meta)
    value = (value * 31) ^ hash(self.uptime_secs)
    value = (value * 31) ^ hash(self.version)
    value = (value * 31) ^ hash(self.resources_map)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class NodeInfo:
  """
  Attributes:
   - node
   - port
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'node', None, None, ), # 1
    (2, TType.SET, 'port', (TType.I64,None), None, ), # 2
  )

  def __init__(self, node=None, port=None,):
    self.node = node
    self.port = port

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.node = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.SET:
          self.port = set()
          (_etype548, _size545) = iprot.readSetBegin()
          for _i549 in xrange(_size545):
            _elem550 = iprot.readI64()
            self.port.add(_elem550)
          iprot.readSetEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('NodeInfo')
    if self.node is not None:
      oprot.writeFieldBegin('node', TType.STRING, 1)
      oprot.writeString(self.node.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.SET, 2)
      oprot.writeSetBegin(TType.I64, len(self.port))
      for iter551 in self.port:
        oprot.writeI64(iter551)
      oprot.writeSetEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.node is None:
      raise TProtocol.TProtocolException(message='Required field node is unset!')
    if self.port is None:
      raise TProtocol.TProtocolException(message='Required field port is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.node)
    value = (value * 31) ^ hash(self.port)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class WorkerResources:
  """
  Attributes:
   - mem_on_heap
   - mem_off_heap
   - cpu
  """

  thrift_spec = (
    None, # 0
    (1, TType.DOUBLE, 'mem_on_heap', None, None, ), # 1
    (2, TType.DOUBLE, 'mem_off_heap', None, None, ), # 2
    (3, TType.DOUBLE, 'cpu', None, None, ), # 3
  )

  def __init__(self, mem_on_heap=None, mem_off_heap=None, cpu=None,):
    self.mem_on_heap = mem_on_heap
    self.mem_off_heap = mem_off_heap
    self.cpu = cpu

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.DOUBLE:
          self.mem_on_heap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.DOUBLE:
          self.mem_off_heap = iprot.readDouble()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.DOUBLE:
          self.cpu = iprot.readDouble()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('WorkerResources')
    if self.mem_on_heap is not None:
      oprot.writeFieldBegin('mem_on_heap', TType.DOUBLE, 1)
      oprot.writeDouble(self.mem_on_heap)
      oprot.writeFieldEnd()
    if self.mem_off_heap is not None:
      oprot.writeFieldBegin('mem_off_heap', TType.DOUBLE, 2)
      oprot.writeDouble(self.mem_off_heap)
      oprot.writeFieldEnd()
    if self.cpu is not None:
      oprot.writeFieldBegin('cpu', TType.DOUBLE, 3)
      oprot.writeDouble(self.cpu)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.mem_on_heap)
    value = (value * 31) ^ hash(self.mem_off_heap)
    value = (value * 31) ^ hash(self.cpu)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class Assignment:
  """
  Attributes:
   - master_code_dir
   - node_host
   - executor_node_port
   - executor_start_time_secs
   - worker_resources
   - owner
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'master_code_dir', None, None, ), # 1
    (2, TType.MAP, 'node_host', (TType.STRING,None,TType.STRING,None), {
    }, ), # 2
    (3, TType.MAP, 'executor_node_port', (TType.LIST,(TType.I64,None),TType.STRUCT,(NodeInfo, NodeInfo.thrift_spec)), {
    }, ), # 3
    (4, TType.MAP, 'executor_start_time_secs', (TType.LIST,(TType.I64,None),TType.I64,None), {
    }, ), # 4
    (5, TType.MAP, 'worker_resources', (TType.STRUCT,(NodeInfo, NodeInfo.thrift_spec),TType.STRUCT,(WorkerResources, WorkerResources.thrift_spec)), {
    }, ), # 5
    None, # 6
    (7, TType.STRING, 'owner', None, None, ), # 7
  )

  def __init__(self, master_code_dir=None, node_host=thrift_spec[2][4], executor_node_port=thrift_spec[3][4], executor_start_time_secs=thrift_spec[4][4], worker_resources=thrift_spec[5][4], owner=None,):
    self.master_code_dir = master_code_dir
    if node_host is self.thrift_spec[2][4]:
      node_host = {
    }
    self.node_host = node_host
    if executor_node_port is self.thrift_spec[3][4]:
      executor_node_port = {
    }
    self.executor_node_port = executor_node_port
    if executor_start_time_secs is self.thrift_spec[4][4]:
      executor_start_time_secs = {
    }
    self.executor_start_time_secs = executor_start_time_secs
    if worker_resources is self.thrift_spec[5][4]:
      worker_resources = {
    }
    self.worker_resources = worker_resources
    self.owner = owner

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.master_code_dir = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.node_host = {}
          (_ktype553, _vtype554, _size552 ) = iprot.readMapBegin()
          for _i556 in xrange(_size552):
            _key557 = iprot.readString().decode('utf-8')
            _val558 = iprot.readString().decode('utf-8')
            self.node_host[_key557] = _val558
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.executor_node_port = {}
          (_ktype560, _vtype561, _size559 ) = iprot.readMapBegin()
          for _i563 in xrange(_size559):
            _key564 = []
            (_etype569, _size566) = iprot.readListBegin()
            for _i570 in xrange(_size566):
              _elem571 = iprot.readI64()
              _key564.append(_elem571)
            iprot.readListEnd()
            _val565 = NodeInfo()
            _val565.read(iprot)
            self.executor_node_port[_key564] = _val565
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.executor_start_time_secs = {}
          (_ktype573, _vtype574, _size572 ) = iprot.readMapBegin()
          for _i576 in xrange(_size572):
            _key577 = []
            (_etype582, _size579) = iprot.readListBegin()
            for _i583 in xrange(_size579):
              _elem584 = iprot.readI64()
              _key577.append(_elem584)
            iprot.readListEnd()
            _val578 = iprot.readI64()
            self.executor_start_time_secs[_key577] = _val578
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.worker_resources = {}
          (_ktype586, _vtype587, _size585 ) = iprot.readMapBegin()
          for _i589 in xrange(_size585):
            _key590 = NodeInfo()
            _key590.read(iprot)
            _val591 = WorkerResources()
            _val591.read(iprot)
            self.worker_resources[_key590] = _val591
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Assignment')
    if self.master_code_dir is not None:
      oprot.writeFieldBegin('master_code_dir', TType.STRING, 1)
      oprot.writeString(self.master_code_dir.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.node_host is not None:
      oprot.writeFieldBegin('node_host', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.node_host))
      for kiter592,viter593 in self.node_host.items():
        oprot.writeString(kiter592.encode('utf-8'))
        oprot.writeString(viter593.encode('utf-8'))
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.executor_node_port is not None:
      oprot.writeFieldBegin('executor_node_port', TType.MAP, 3)
      oprot.writeMapBegin(TType.LIST, TType.STRUCT, len(self.executor_node_port))
      for kiter594,viter595 in self.executor_node_port.items():
        oprot.writeListBegin(TType.I64, len(kiter594))
        for iter596 in kiter594:
          oprot.writeI64(iter596)
        oprot.writeListEnd()
        viter595.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.executor_start_time_secs is not None:
      oprot.writeFieldBegin('executor_start_time_secs', TType.MAP, 4)
      oprot.writeMapBegin(TType.LIST, TType.I64, len(self.executor_start_time_secs))
      for kiter597,viter598 in self.executor_start_time_secs.items():
        oprot.writeListBegin(TType.I64, len(kiter597))
        for iter599 in kiter597:
          oprot.writeI64(iter599)
        oprot.writeListEnd()
        oprot.writeI64(viter598)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.worker_resources is not None:
      oprot.writeFieldBegin('worker_resources', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.worker_resources))
      for kiter600,viter601 in self.worker_resources.items():
        kiter600.write(oprot)
        viter601.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 7)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.master_code_dir is None:
      raise TProtocol.TProtocolException(message='Required field master_code_dir is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.master_code_dir)
    value = (value * 31) ^ hash(self.node_host)
    value = (value * 31) ^ hash(self.executor_node_port)
    value = (value * 31) ^ hash(self.executor_start_time_secs)
    value = (value * 31) ^ hash(self.worker_resources)
    value = (value * 31) ^ hash(self.owner)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologyActionOptions:
  """
  Attributes:
   - kill_options
   - rebalance_options
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'kill_options', (KillOptions, KillOptions.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'rebalance_options', (RebalanceOptions, RebalanceOptions.thrift_spec), None, ), # 2
  )

  def __init__(self, kill_options=None, rebalance_options=None,):
    self.kill_options = kill_options
    self.rebalance_options = rebalance_options

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.kill_options = KillOptions()
          self.kill_options.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.rebalance_options = RebalanceOptions()
          self.rebalance_options.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologyActionOptions')
    if self.kill_options is not None:
      oprot.writeFieldBegin('kill_options', TType.STRUCT, 1)
      self.kill_options.write(oprot)
      oprot.writeFieldEnd()
    if self.rebalance_options is not None:
      oprot.writeFieldBegin('rebalance_options', TType.STRUCT, 2)
      self.rebalance_options.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.kill_options)
    value = (value * 31) ^ hash(self.rebalance_options)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class StormBase:
  """
  Attributes:
   - name
   - status
   - num_workers
   - component_executors
   - launch_time_secs
   - owner
   - topology_action_options
   - prev_status
   - component_debug
   - principal
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'name', None, None, ), # 1
    (2, TType.I32, 'status', None, None, ), # 2
    (3, TType.I32, 'num_workers', None, None, ), # 3
    (4, TType.MAP, 'component_executors', (TType.STRING,None,TType.I32,None), None, ), # 4
    (5, TType.I32, 'launch_time_secs', None, None, ), # 5
    (6, TType.STRING, 'owner', None, None, ), # 6
    (7, TType.STRUCT, 'topology_action_options', (TopologyActionOptions, TopologyActionOptions.thrift_spec), None, ), # 7
    (8, TType.I32, 'prev_status', None, None, ), # 8
    (9, TType.MAP, 'component_debug', (TType.STRING,None,TType.STRUCT,(DebugOptions, DebugOptions.thrift_spec)), None, ), # 9
    (10, TType.STRING, 'principal', None, None, ), # 10
  )

  def __init__(self, name=None, status=None, num_workers=None, component_executors=None, launch_time_secs=None, owner=None, topology_action_options=None, prev_status=None, component_debug=None, principal=None,):
    self.name = name
    self.status = status
    self.num_workers = num_workers
    self.component_executors = component_executors
    self.launch_time_secs = launch_time_secs
    self.owner = owner
    self.topology_action_options = topology_action_options
    self.prev_status = prev_status
    self.component_debug = component_debug
    self.principal = principal

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.status = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.num_workers = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.component_executors = {}
          (_ktype603, _vtype604, _size602 ) = iprot.readMapBegin()
          for _i606 in xrange(_size602):
            _key607 = iprot.readString().decode('utf-8')
            _val608 = iprot.readI32()
            self.component_executors[_key607] = _val608
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.launch_time_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRUCT:
          self.topology_action_options = TopologyActionOptions()
          self.topology_action_options.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I32:
          self.prev_status = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.MAP:
          self.component_debug = {}
          (_ktype610, _vtype611, _size609 ) = iprot.readMapBegin()
          for _i613 in xrange(_size609):
            _key614 = iprot.readString().decode('utf-8')
            _val615 = DebugOptions()
            _val615.read(iprot)
            self.component_debug[_key614] = _val615
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRING:
          self.principal = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StormBase')
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 1)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.status is not None:
      oprot.writeFieldBegin('status', TType.I32, 2)
      oprot.writeI32(self.status)
      oprot.writeFieldEnd()
    if self.num_workers is not None:
      oprot.writeFieldBegin('num_workers', TType.I32, 3)
      oprot.writeI32(self.num_workers)
      oprot.writeFieldEnd()
    if self.component_executors is not None:
      oprot.writeFieldBegin('component_executors', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.I32, len(self.component_executors))
      for kiter616,viter617 in self.component_executors.items():
        oprot.writeString(kiter616.encode('utf-8'))
        oprot.writeI32(viter617)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.launch_time_secs is not None:
      oprot.writeFieldBegin('launch_time_secs', TType.I32, 5)
      oprot.writeI32(self.launch_time_secs)
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 6)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.topology_action_options is not None:
      oprot.writeFieldBegin('topology_action_options', TType.STRUCT, 7)
      self.topology_action_options.write(oprot)
      oprot.writeFieldEnd()
    if self.prev_status is not None:
      oprot.writeFieldBegin('prev_status', TType.I32, 8)
      oprot.writeI32(self.prev_status)
      oprot.writeFieldEnd()
    if self.component_debug is not None:
      oprot.writeFieldBegin('component_debug', TType.MAP, 9)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.component_debug))
      for kiter618,viter619 in self.component_debug.items():
        oprot.writeString(kiter618.encode('utf-8'))
        viter619.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.principal is not None:
      oprot.writeFieldBegin('principal', TType.STRING, 10)
      oprot.writeString(self.principal.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.name is None:
      raise TProtocol.TProtocolException(message='Required field name is unset!')
    if self.status is None:
      raise TProtocol.TProtocolException(message='Required field status is unset!')
    if self.num_workers is None:
      raise TProtocol.TProtocolException(message='Required field num_workers is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.status)
    value = (value * 31) ^ hash(self.num_workers)
    value = (value * 31) ^ hash(self.component_executors)
    value = (value * 31) ^ hash(self.launch_time_secs)
    value = (value * 31) ^ hash(self.owner)
    value = (value * 31) ^ hash(self.topology_action_options)
    value = (value * 31) ^ hash(self.prev_status)
    value = (value * 31) ^ hash(self.component_debug)
    value = (value * 31) ^ hash(self.principal)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ClusterWorkerHeartbeat:
  """
  Attributes:
   - storm_id
   - executor_stats
   - time_secs
   - uptime_secs
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'storm_id', None, None, ), # 1
    (2, TType.MAP, 'executor_stats', (TType.STRUCT,(ExecutorInfo, ExecutorInfo.thrift_spec),TType.STRUCT,(ExecutorStats, ExecutorStats.thrift_spec)), None, ), # 2
    (3, TType.I32, 'time_secs', None, None, ), # 3
    (4, TType.I32, 'uptime_secs', None, None, ), # 4
  )

  def __init__(self, storm_id=None, executor_stats=None, time_secs=None, uptime_secs=None,):
    self.storm_id = storm_id
    self.executor_stats = executor_stats
    self.time_secs = time_secs
    self.uptime_secs = uptime_secs

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.storm_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.executor_stats = {}
          (_ktype621, _vtype622, _size620 ) = iprot.readMapBegin()
          for _i624 in xrange(_size620):
            _key625 = ExecutorInfo()
            _key625.read(iprot)
            _val626 = ExecutorStats()
            _val626.read(iprot)
            self.executor_stats[_key625] = _val626
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.time_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.uptime_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ClusterWorkerHeartbeat')
    if self.storm_id is not None:
      oprot.writeFieldBegin('storm_id', TType.STRING, 1)
      oprot.writeString(self.storm_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.executor_stats is not None:
      oprot.writeFieldBegin('executor_stats', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRUCT, TType.STRUCT, len(self.executor_stats))
      for kiter627,viter628 in self.executor_stats.items():
        kiter627.write(oprot)
        viter628.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.time_secs is not None:
      oprot.writeFieldBegin('time_secs', TType.I32, 3)
      oprot.writeI32(self.time_secs)
      oprot.writeFieldEnd()
    if self.uptime_secs is not None:
      oprot.writeFieldBegin('uptime_secs', TType.I32, 4)
      oprot.writeI32(self.uptime_secs)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.storm_id is None:
      raise TProtocol.TProtocolException(message='Required field storm_id is unset!')
    if self.executor_stats is None:
      raise TProtocol.TProtocolException(message='Required field executor_stats is unset!')
    if self.time_secs is None:
      raise TProtocol.TProtocolException(message='Required field time_secs is unset!')
    if self.uptime_secs is None:
      raise TProtocol.TProtocolException(message='Required field uptime_secs is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.storm_id)
    value = (value * 31) ^ hash(self.executor_stats)
    value = (value * 31) ^ hash(self.time_secs)
    value = (value * 31) ^ hash(self.uptime_secs)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ThriftSerializedObject:
  """
  Attributes:
   - name
   - bits
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'name', None, None, ), # 1
    (2, TType.STRING, 'bits', None, None, ), # 2
  )

  def __init__(self, name=None, bits=None,):
    self.name = name
    self.bits = bits

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.name = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.bits = iprot.readString()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ThriftSerializedObject')
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 1)
      oprot.writeString(self.name.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.bits is not None:
      oprot.writeFieldBegin('bits', TType.STRING, 2)
      oprot.writeString(self.bits)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.name is None:
      raise TProtocol.TProtocolException(message='Required field name is unset!')
    if self.bits is None:
      raise TProtocol.TProtocolException(message='Required field bits is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.name)
    value = (value * 31) ^ hash(self.bits)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LocalStateData:
  """
  Attributes:
   - serialized_parts
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'serialized_parts', (TType.STRING,None,TType.STRUCT,(ThriftSerializedObject, ThriftSerializedObject.thrift_spec)), None, ), # 1
  )

  def __init__(self, serialized_parts=None,):
    self.serialized_parts = serialized_parts

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.serialized_parts = {}
          (_ktype630, _vtype631, _size629 ) = iprot.readMapBegin()
          for _i633 in xrange(_size629):
            _key634 = iprot.readString().decode('utf-8')
            _val635 = ThriftSerializedObject()
            _val635.read(iprot)
            self.serialized_parts[_key634] = _val635
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LocalStateData')
    if self.serialized_parts is not None:
      oprot.writeFieldBegin('serialized_parts', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.serialized_parts))
      for kiter636,viter637 in self.serialized_parts.items():
        oprot.writeString(kiter636.encode('utf-8'))
        viter637.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.serialized_parts is None:
      raise TProtocol.TProtocolException(message='Required field serialized_parts is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.serialized_parts)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LocalAssignment:
  """
  Attributes:
   - topology_id
   - executors
   - resources
   - owner
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'topology_id', None, None, ), # 1
    (2, TType.LIST, 'executors', (TType.STRUCT,(ExecutorInfo, ExecutorInfo.thrift_spec)), None, ), # 2
    (3, TType.STRUCT, 'resources', (WorkerResources, WorkerResources.thrift_spec), None, ), # 3
    None, # 4
    (5, TType.STRING, 'owner', None, None, ), # 5
  )

  def __init__(self, topology_id=None, executors=None, resources=None, owner=None,):
    self.topology_id = topology_id
    self.executors = executors
    self.resources = resources
    self.owner = owner

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.topology_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.executors = []
          (_etype641, _size638) = iprot.readListBegin()
          for _i642 in xrange(_size638):
            _elem643 = ExecutorInfo()
            _elem643.read(iprot)
            self.executors.append(_elem643)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.resources = WorkerResources()
          self.resources.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.owner = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LocalAssignment')
    if self.topology_id is not None:
      oprot.writeFieldBegin('topology_id', TType.STRING, 1)
      oprot.writeString(self.topology_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.executors is not None:
      oprot.writeFieldBegin('executors', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.executors))
      for iter644 in self.executors:
        iter644.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.resources is not None:
      oprot.writeFieldBegin('resources', TType.STRUCT, 3)
      self.resources.write(oprot)
      oprot.writeFieldEnd()
    if self.owner is not None:
      oprot.writeFieldBegin('owner', TType.STRING, 5)
      oprot.writeString(self.owner.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.topology_id is None:
      raise TProtocol.TProtocolException(message='Required field topology_id is unset!')
    if self.executors is None:
      raise TProtocol.TProtocolException(message='Required field executors is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.topology_id)
    value = (value * 31) ^ hash(self.executors)
    value = (value * 31) ^ hash(self.resources)
    value = (value * 31) ^ hash(self.owner)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSSupervisorId:
  """
  Attributes:
   - supervisor_id
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'supervisor_id', None, None, ), # 1
  )

  def __init__(self, supervisor_id=None,):
    self.supervisor_id = supervisor_id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.supervisor_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSSupervisorId')
    if self.supervisor_id is not None:
      oprot.writeFieldBegin('supervisor_id', TType.STRING, 1)
      oprot.writeString(self.supervisor_id.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.supervisor_id is None:
      raise TProtocol.TProtocolException(message='Required field supervisor_id is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.supervisor_id)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSApprovedWorkers:
  """
  Attributes:
   - approved_workers
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'approved_workers', (TType.STRING,None,TType.I32,None), None, ), # 1
  )

  def __init__(self, approved_workers=None,):
    self.approved_workers = approved_workers

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.approved_workers = {}
          (_ktype646, _vtype647, _size645 ) = iprot.readMapBegin()
          for _i649 in xrange(_size645):
            _key650 = iprot.readString().decode('utf-8')
            _val651 = iprot.readI32()
            self.approved_workers[_key650] = _val651
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSApprovedWorkers')
    if self.approved_workers is not None:
      oprot.writeFieldBegin('approved_workers', TType.MAP, 1)
      oprot.writeMapBegin(TType.STRING, TType.I32, len(self.approved_workers))
      for kiter652,viter653 in self.approved_workers.items():
        oprot.writeString(kiter652.encode('utf-8'))
        oprot.writeI32(viter653)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.approved_workers is None:
      raise TProtocol.TProtocolException(message='Required field approved_workers is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.approved_workers)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSSupervisorAssignments:
  """
  Attributes:
   - assignments
  """

  thrift_spec = (
    None, # 0
    (1, TType.MAP, 'assignments', (TType.I32,None,TType.STRUCT,(LocalAssignment, LocalAssignment.thrift_spec)), None, ), # 1
  )

  def __init__(self, assignments=None,):
    self.assignments = assignments

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.MAP:
          self.assignments = {}
          (_ktype655, _vtype656, _size654 ) = iprot.readMapBegin()
          for _i658 in xrange(_size654):
            _key659 = iprot.readI32()
            _val660 = LocalAssignment()
            _val660.read(iprot)
            self.assignments[_key659] = _val660
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSSupervisorAssignments')
    if self.assignments is not None:
      oprot.writeFieldBegin('assignments', TType.MAP, 1)
      oprot.writeMapBegin(TType.I32, TType.STRUCT, len(self.assignments))
      for kiter661,viter662 in self.assignments.items():
        oprot.writeI32(kiter661)
        viter662.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.assignments is None:
      raise TProtocol.TProtocolException(message='Required field assignments is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.assignments)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSWorkerHeartbeat:
  """
  Attributes:
   - time_secs
   - topology_id
   - executors
   - port
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'time_secs', None, None, ), # 1
    (2, TType.STRING, 'topology_id', None, None, ), # 2
    (3, TType.LIST, 'executors', (TType.STRUCT,(ExecutorInfo, ExecutorInfo.thrift_spec)), None, ), # 3
    (4, TType.I32, 'port', None, None, ), # 4
  )

  def __init__(self, time_secs=None, topology_id=None, executors=None, port=None,):
    self.time_secs = time_secs
    self.topology_id = topology_id
    self.executors = executors
    self.port = port

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.time_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.topology_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.executors = []
          (_etype666, _size663) = iprot.readListBegin()
          for _i667 in xrange(_size663):
            _elem668 = ExecutorInfo()
            _elem668.read(iprot)
            self.executors.append(_elem668)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.port = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSWorkerHeartbeat')
    if self.time_secs is not None:
      oprot.writeFieldBegin('time_secs', TType.I32, 1)
      oprot.writeI32(self.time_secs)
      oprot.writeFieldEnd()
    if self.topology_id is not None:
      oprot.writeFieldBegin('topology_id', TType.STRING, 2)
      oprot.writeString(self.topology_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.executors is not None:
      oprot.writeFieldBegin('executors', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.executors))
      for iter669 in self.executors:
        iter669.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.port is not None:
      oprot.writeFieldBegin('port', TType.I32, 4)
      oprot.writeI32(self.port)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.time_secs is None:
      raise TProtocol.TProtocolException(message='Required field time_secs is unset!')
    if self.topology_id is None:
      raise TProtocol.TProtocolException(message='Required field topology_id is unset!')
    if self.executors is None:
      raise TProtocol.TProtocolException(message='Required field executors is unset!')
    if self.port is None:
      raise TProtocol.TProtocolException(message='Required field port is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.time_secs)
    value = (value * 31) ^ hash(self.topology_id)
    value = (value * 31) ^ hash(self.executors)
    value = (value * 31) ^ hash(self.port)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSTopoHistory:
  """
  Attributes:
   - topology_id
   - time_stamp
   - users
   - groups
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'topology_id', None, None, ), # 1
    (2, TType.I64, 'time_stamp', None, None, ), # 2
    (3, TType.LIST, 'users', (TType.STRING,None), None, ), # 3
    (4, TType.LIST, 'groups', (TType.STRING,None), None, ), # 4
  )

  def __init__(self, topology_id=None, time_stamp=None, users=None, groups=None,):
    self.topology_id = topology_id
    self.time_stamp = time_stamp
    self.users = users
    self.groups = groups

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.topology_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.time_stamp = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.users = []
          (_etype673, _size670) = iprot.readListBegin()
          for _i674 in xrange(_size670):
            _elem675 = iprot.readString().decode('utf-8')
            self.users.append(_elem675)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.groups = []
          (_etype679, _size676) = iprot.readListBegin()
          for _i680 in xrange(_size676):
            _elem681 = iprot.readString().decode('utf-8')
            self.groups.append(_elem681)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSTopoHistory')
    if self.topology_id is not None:
      oprot.writeFieldBegin('topology_id', TType.STRING, 1)
      oprot.writeString(self.topology_id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.time_stamp is not None:
      oprot.writeFieldBegin('time_stamp', TType.I64, 2)
      oprot.writeI64(self.time_stamp)
      oprot.writeFieldEnd()
    if self.users is not None:
      oprot.writeFieldBegin('users', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.users))
      for iter682 in self.users:
        oprot.writeString(iter682.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.groups is not None:
      oprot.writeFieldBegin('groups', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.groups))
      for iter683 in self.groups:
        oprot.writeString(iter683.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.topology_id is None:
      raise TProtocol.TProtocolException(message='Required field topology_id is unset!')
    if self.time_stamp is None:
      raise TProtocol.TProtocolException(message='Required field time_stamp is unset!')
    if self.users is None:
      raise TProtocol.TProtocolException(message='Required field users is unset!')
    if self.groups is None:
      raise TProtocol.TProtocolException(message='Required field groups is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.topology_id)
    value = (value * 31) ^ hash(self.time_stamp)
    value = (value * 31) ^ hash(self.users)
    value = (value * 31) ^ hash(self.groups)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LSTopoHistoryList:
  """
  Attributes:
   - topo_history
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'topo_history', (TType.STRUCT,(LSTopoHistory, LSTopoHistory.thrift_spec)), None, ), # 1
  )

  def __init__(self, topo_history=None,):
    self.topo_history = topo_history

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.topo_history = []
          (_etype687, _size684) = iprot.readListBegin()
          for _i688 in xrange(_size684):
            _elem689 = LSTopoHistory()
            _elem689.read(iprot)
            self.topo_history.append(_elem689)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LSTopoHistoryList')
    if self.topo_history is not None:
      oprot.writeFieldBegin('topo_history', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.topo_history))
      for iter690 in self.topo_history:
        iter690.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.topo_history is None:
      raise TProtocol.TProtocolException(message='Required field topo_history is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.topo_history)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class ProfileRequest:
  """
  Attributes:
   - nodeInfo
   - action
   - time_stamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'nodeInfo', (NodeInfo, NodeInfo.thrift_spec), None, ), # 1
    (2, TType.I32, 'action', None, None, ), # 2
    (3, TType.I64, 'time_stamp', None, None, ), # 3
  )

  def __init__(self, nodeInfo=None, action=None, time_stamp=None,):
    self.nodeInfo = nodeInfo
    self.action = action
    self.time_stamp = time_stamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.nodeInfo = NodeInfo()
          self.nodeInfo.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.action = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.time_stamp = iprot.readI64()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ProfileRequest')
    if self.nodeInfo is not None:
      oprot.writeFieldBegin('nodeInfo', TType.STRUCT, 1)
      self.nodeInfo.write(oprot)
      oprot.writeFieldEnd()
    if self.action is not None:
      oprot.writeFieldBegin('action', TType.I32, 2)
      oprot.writeI32(self.action)
      oprot.writeFieldEnd()
    if self.time_stamp is not None:
      oprot.writeFieldBegin('time_stamp', TType.I64, 3)
      oprot.writeI64(self.time_stamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.nodeInfo is None:
      raise TProtocol.TProtocolException(message='Required field nodeInfo is unset!')
    if self.action is None:
      raise TProtocol.TProtocolException(message='Required field action is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.nodeInfo)
    value = (value * 31) ^ hash(self.action)
    value = (value * 31) ^ hash(self.time_stamp)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class GetInfoOptions:
  """
  Attributes:
   - num_err_choice
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'num_err_choice', None, None, ), # 1
  )

  def __init__(self, num_err_choice=None,):
    self.num_err_choice = num_err_choice

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.num_err_choice = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('GetInfoOptions')
    if self.num_err_choice is not None:
      oprot.writeFieldBegin('num_err_choice', TType.I32, 1)
      oprot.writeI32(self.num_err_choice)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.num_err_choice)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LogLevel:
  """
  Attributes:
   - action
   - target_log_level
   - reset_log_level_timeout_secs
   - reset_log_level_timeout_epoch
   - reset_log_level
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'action', None, None, ), # 1
    (2, TType.STRING, 'target_log_level', None, None, ), # 2
    (3, TType.I32, 'reset_log_level_timeout_secs', None, None, ), # 3
    (4, TType.I64, 'reset_log_level_timeout_epoch', None, None, ), # 4
    (5, TType.STRING, 'reset_log_level', None, None, ), # 5
  )

  def __init__(self, action=None, target_log_level=None, reset_log_level_timeout_secs=None, reset_log_level_timeout_epoch=None, reset_log_level=None,):
    self.action = action
    self.target_log_level = target_log_level
    self.reset_log_level_timeout_secs = reset_log_level_timeout_secs
    self.reset_log_level_timeout_epoch = reset_log_level_timeout_epoch
    self.reset_log_level = reset_log_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.action = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.target_log_level = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.reset_log_level_timeout_secs = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.reset_log_level_timeout_epoch = iprot.readI64()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.reset_log_level = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LogLevel')
    if self.action is not None:
      oprot.writeFieldBegin('action', TType.I32, 1)
      oprot.writeI32(self.action)
      oprot.writeFieldEnd()
    if self.target_log_level is not None:
      oprot.writeFieldBegin('target_log_level', TType.STRING, 2)
      oprot.writeString(self.target_log_level.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.reset_log_level_timeout_secs is not None:
      oprot.writeFieldBegin('reset_log_level_timeout_secs', TType.I32, 3)
      oprot.writeI32(self.reset_log_level_timeout_secs)
      oprot.writeFieldEnd()
    if self.reset_log_level_timeout_epoch is not None:
      oprot.writeFieldBegin('reset_log_level_timeout_epoch', TType.I64, 4)
      oprot.writeI64(self.reset_log_level_timeout_epoch)
      oprot.writeFieldEnd()
    if self.reset_log_level is not None:
      oprot.writeFieldBegin('reset_log_level', TType.STRING, 5)
      oprot.writeString(self.reset_log_level.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.action is None:
      raise TProtocol.TProtocolException(message='Required field action is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.action)
    value = (value * 31) ^ hash(self.target_log_level)
    value = (value * 31) ^ hash(self.reset_log_level_timeout_secs)
    value = (value * 31) ^ hash(self.reset_log_level_timeout_epoch)
    value = (value * 31) ^ hash(self.reset_log_level)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class LogConfig:
  """
  Attributes:
   - named_logger_level
  """

  thrift_spec = (
    None, # 0
    None, # 1
    (2, TType.MAP, 'named_logger_level', (TType.STRING,None,TType.STRUCT,(LogLevel, LogLevel.thrift_spec)), None, ), # 2
  )

  def __init__(self, named_logger_level=None,):
    self.named_logger_level = named_logger_level

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 2:
        if ftype == TType.MAP:
          self.named_logger_level = {}
          (_ktype692, _vtype693, _size691 ) = iprot.readMapBegin()
          for _i695 in xrange(_size691):
            _key696 = iprot.readString().decode('utf-8')
            _val697 = LogLevel()
            _val697.read(iprot)
            self.named_logger_level[_key696] = _val697
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('LogConfig')
    if self.named_logger_level is not None:
      oprot.writeFieldBegin('named_logger_level', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.named_logger_level))
      for kiter698,viter699 in self.named_logger_level.items():
        oprot.writeString(kiter698.encode('utf-8'))
        viter699.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.named_logger_level)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class TopologyHistoryInfo:
  """
  Attributes:
   - topo_ids
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'topo_ids', (TType.STRING,None), None, ), # 1
  )

  def __init__(self, topo_ids=None,):
    self.topo_ids = topo_ids

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.topo_ids = []
          (_etype703, _size700) = iprot.readListBegin()
          for _i704 in xrange(_size700):
            _elem705 = iprot.readString().decode('utf-8')
            self.topo_ids.append(_elem705)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('TopologyHistoryInfo')
    if self.topo_ids is not None:
      oprot.writeFieldBegin('topo_ids', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.topo_ids))
      for iter706 in self.topo_ids:
        oprot.writeString(iter706.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.topo_ids)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class DRPCRequest:
  """
  Attributes:
   - func_args
   - request_id
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'func_args', None, None, ), # 1
    (2, TType.STRING, 'request_id', None, None, ), # 2
  )

  def __init__(self, func_args=None, request_id=None,):
    self.func_args = func_args
    self.request_id = request_id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.func_args = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.request_id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('DRPCRequest')
    if self.func_args is not None:
      oprot.writeFieldBegin('func_args', TType.STRING, 1)
      oprot.writeString(self.func_args.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.request_id is not None:
      oprot.writeFieldBegin('request_id', TType.STRING, 2)
      oprot.writeString(self.request_id.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.func_args is None:
      raise TProtocol.TProtocolException(message='Required field func_args is unset!')
    if self.request_id is None:
      raise TProtocol.TProtocolException(message='Required field request_id is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.func_args)
    value = (value * 31) ^ hash(self.request_id)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class DRPCExecutionException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('DRPCExecutionException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBPulse:
  """
  Attributes:
   - id
   - details
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'id', None, None, ), # 1
    (2, TType.STRING, 'details', None, None, ), # 2
  )

  def __init__(self, id=None, details=None,):
    self.id = id
    self.details = details

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.id = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.details = iprot.readString()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBPulse')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.STRING, 1)
      oprot.writeString(self.id.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.details is not None:
      oprot.writeFieldBegin('details', TType.STRING, 2)
      oprot.writeString(self.details)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.id is None:
      raise TProtocol.TProtocolException(message='Required field id is unset!')
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.id)
    value = (value * 31) ^ hash(self.details)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBRecords:
  """
  Attributes:
   - pulses
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'pulses', (TType.STRUCT,(HBPulse, HBPulse.thrift_spec)), None, ), # 1
  )

  def __init__(self, pulses=None,):
    self.pulses = pulses

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.pulses = []
          (_etype710, _size707) = iprot.readListBegin()
          for _i711 in xrange(_size707):
            _elem712 = HBPulse()
            _elem712.read(iprot)
            self.pulses.append(_elem712)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBRecords')
    if self.pulses is not None:
      oprot.writeFieldBegin('pulses', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.pulses))
      for iter713 in self.pulses:
        iter713.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.pulses)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBNodes:
  """
  Attributes:
   - pulseIds
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'pulseIds', (TType.STRING,None), None, ), # 1
  )

  def __init__(self, pulseIds=None,):
    self.pulseIds = pulseIds

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.pulseIds = []
          (_etype717, _size714) = iprot.readListBegin()
          for _i718 in xrange(_size714):
            _elem719 = iprot.readString().decode('utf-8')
            self.pulseIds.append(_elem719)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBNodes')
    if self.pulseIds is not None:
      oprot.writeFieldBegin('pulseIds', TType.LIST, 1)
      oprot.writeListBegin(TType.STRING, len(self.pulseIds))
      for iter720 in self.pulseIds:
        oprot.writeString(iter720.encode('utf-8'))
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.pulseIds)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBMessageData:
  """
  Attributes:
   - path
   - pulse
   - boolval
   - records
   - nodes
   - message_blob
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'path', None, None, ), # 1
    (2, TType.STRUCT, 'pulse', (HBPulse, HBPulse.thrift_spec), None, ), # 2
    (3, TType.BOOL, 'boolval', None, None, ), # 3
    (4, TType.STRUCT, 'records', (HBRecords, HBRecords.thrift_spec), None, ), # 4
    (5, TType.STRUCT, 'nodes', (HBNodes, HBNodes.thrift_spec), None, ), # 5
    None, # 6
    (7, TType.STRING, 'message_blob', None, None, ), # 7
  )

  def __init__(self, path=None, pulse=None, boolval=None, records=None, nodes=None, message_blob=None,):
    self.path = path
    self.pulse = pulse
    self.boolval = boolval
    self.records = records
    self.nodes = nodes
    self.message_blob = message_blob

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.path = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.pulse = HBPulse()
          self.pulse.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.BOOL:
          self.boolval = iprot.readBool()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRUCT:
          self.records = HBRecords()
          self.records.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.nodes = HBNodes()
          self.nodes.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRING:
          self.message_blob = iprot.readString()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBMessageData')
    if self.path is not None:
      oprot.writeFieldBegin('path', TType.STRING, 1)
      oprot.writeString(self.path.encode('utf-8'))
      oprot.writeFieldEnd()
    if self.pulse is not None:
      oprot.writeFieldBegin('pulse', TType.STRUCT, 2)
      self.pulse.write(oprot)
      oprot.writeFieldEnd()
    if self.boolval is not None:
      oprot.writeFieldBegin('boolval', TType.BOOL, 3)
      oprot.writeBool(self.boolval)
      oprot.writeFieldEnd()
    if self.records is not None:
      oprot.writeFieldBegin('records', TType.STRUCT, 4)
      self.records.write(oprot)
      oprot.writeFieldEnd()
    if self.nodes is not None:
      oprot.writeFieldBegin('nodes', TType.STRUCT, 5)
      self.nodes.write(oprot)
      oprot.writeFieldEnd()
    if self.message_blob is not None:
      oprot.writeFieldBegin('message_blob', TType.STRING, 7)
      oprot.writeString(self.message_blob)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.path)
    value = (value * 31) ^ hash(self.pulse)
    value = (value * 31) ^ hash(self.boolval)
    value = (value * 31) ^ hash(self.records)
    value = (value * 31) ^ hash(self.nodes)
    value = (value * 31) ^ hash(self.message_blob)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBMessage:
  """
  Attributes:
   - type
   - data
   - message_id
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'type', None, None, ), # 1
    (2, TType.STRUCT, 'data', (HBMessageData, HBMessageData.thrift_spec), None, ), # 2
    (3, TType.I32, 'message_id', None, -1, ), # 3
  )

  def __init__(self, type=None, data=None, message_id=thrift_spec[3][4],):
    self.type = type
    self.data = data
    self.message_id = message_id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.type = iprot.readI32()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.data = HBMessageData()
          self.data.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.message_id = iprot.readI32()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBMessage')
    if self.type is not None:
      oprot.writeFieldBegin('type', TType.I32, 1)
      oprot.writeI32(self.type)
      oprot.writeFieldEnd()
    if self.data is not None:
      oprot.writeFieldBegin('data', TType.STRUCT, 2)
      self.data.write(oprot)
      oprot.writeFieldEnd()
    if self.message_id is not None:
      oprot.writeFieldBegin('message_id', TType.I32, 3)
      oprot.writeI32(self.message_id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.type)
    value = (value * 31) ^ hash(self.data)
    value = (value * 31) ^ hash(self.message_id)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBAuthorizationException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBAuthorizationException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class HBExecutionException(TException):
  """
  Attributes:
   - msg
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'msg', None, None, ), # 1
  )

  def __init__(self, msg=None,):
    self.msg = msg

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.msg = iprot.readString().decode('utf-8')
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('HBExecutionException')
    if self.msg is not None:
      oprot.writeFieldBegin('msg', TType.STRING, 1)
      oprot.writeString(self.msg.encode('utf-8'))
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.msg is None:
      raise TProtocol.TProtocolException(message='Required field msg is unset!')
    return


  def __str__(self):
    return repr(self)

  def __hash__(self):
    value = 17
    value = (value * 31) ^ hash(self.msg)
    return value

  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
